/*
 * Decompiled with CFR 0.152.
 */
package com.iitr.kaishu.nsidedprogressbar;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.iitr.kaishu.nsidedprogressbar.R;
import java.util.Timer;
import java.util.TimerTask;

public class NSidedProgressBar
extends View {
    private Context context;
    private Paint primaryPaint;
    private Paint secondaryPaint;
    private Path basePath;
    private Path secPath;
    private PathMeasure pathMeasure;
    private float[] xVertiCoord;
    private float[] yVertiCoord;
    private float[] x1VertiCoord;
    private float[] x2VertiCoord;
    private float[] y1VertiCoord;
    private float[] y2VertiCoord;
    private float[] xMidPoints;
    private float[] yMidPoints;
    private float xCenter;
    private float yCenter;
    private float tempDiffValue;
    private boolean tempState1 = false;
    private boolean tempState2 = true;
    private float tempStartPoint = 0.0f;
    private boolean exit = false;
    private int sideCount = 3;
    private int refreshRate = 60;
    private float progress = 0.0f;
    private float baseSpeed = 5.0f;
    private float minDistance = 70.0f;
    private float minDistanceSec = 40.0f;
    private boolean isClockWise = true;
    private int primaryColor = Color.parseColor((String)"#6499fa");
    private int secondaryColor = Color.parseColor((String)"#E0E0E0");
    private float primaryRimWidth = 8.0f;
    private float secondaryRimWidth = 9.0f;
    private int startSide = 1;
    private boolean isDeterminate = false;
    private float sideLength;
    private int preSetHeight = 150;
    private int preSetWidth = 150;
    private float withoutAcceleration = 0.0f;
    private float withAcceleration = 0.0f;
    private float akinTime = 0.0f;
    private float startPoint = this.minDistanceSec;
    private float endPoint = 0.0f;
    private int whereToGo = 1;
    private float times = 0.0f;
    private float totalDisStartPoint;
    private float sideProgress = 0.0f;
    private float initialPosition = 0.0f;
    private float radius = 0.0f;
    private Timer timer;

    public NSidedProgressBar(Context context, int sideCount) {
        super(context);
        this.context = context;
        this.sideCount = sideCount;
        if (sideCount <= 2) {
            throw new RuntimeException("sideCount should be greater than 2");
        }
        this.initProgressBar();
    }

    public NSidedProgressBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.xmlAttributes(context.obtainStyledAttributes(attrs, R.styleable.NSidedProgressBar));
        if (this.sideCount <= 2) {
            throw new RuntimeException("sideCount should be greater than 2");
        }
        this.initProgressBar();
    }

    public NSidedProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.xmlAttributes(context.obtainStyledAttributes(attrs, R.styleable.NSidedProgressBar));
        if (this.sideCount <= 2) {
            throw new RuntimeException("sideCount should be greater than 2");
        }
        this.initProgressBar();
    }

    private void initProgressBar() {
        this.basePath = new Path();
        this.secPath = new Path();
        this.pathMeasure = new PathMeasure();
        this.setPaints();
        this.xVertiCoord = new float[this.sideCount];
        this.yVertiCoord = new float[this.sideCount];
        this.x1VertiCoord = new float[this.sideCount];
        this.y1VertiCoord = new float[this.sideCount];
        this.x2VertiCoord = new float[this.sideCount];
        this.y2VertiCoord = new float[this.sideCount];
        this.xMidPoints = new float[this.sideCount];
        this.yMidPoints = new float[this.sideCount];
    }

    private void setPaints() {
        this.primaryPaint = new Paint();
        this.primaryPaint.setStrokeWidth(this.primaryRimWidth);
        this.primaryPaint.setStyle(Paint.Style.STROKE);
        this.secondaryPaint = new Paint();
        this.secondaryPaint.setStrokeWidth(this.secondaryRimWidth);
        this.secondaryPaint.setStyle(Paint.Style.STROKE);
        this.primaryPaint.setColor(this.primaryColor);
        this.secondaryPaint.setColor(this.secondaryColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int viewWidth = this.preSetWidth + this.getPaddingLeft() + this.getPaddingRight();
        int viewHeight = this.preSetWidth + this.getPaddingTop() + this.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(viewWidth, widthSize) : viewWidth);
        int height = heightMode == 0x40000000 || widthMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(viewHeight, heightSize) : viewHeight);
        this.xCenter = width / 2;
        this.yCenter = height / 2;
        this.radius = this.xCenter - (float)Math.max(this.getPaddingLeft() + this.getPaddingRight(), this.getPaddingTop() + this.getPaddingBottom()) - 10.0f;
        this.initiateDraw();
        this.setMeasuredDimension(width, height);
    }

    private void initiateDraw() {
        this.setCoordinates();
        this.basePath.reset();
        this.basePath.moveTo(this.x1VertiCoord[0], this.y1VertiCoord[0]);
        for (int i = 0; i < this.sideCount; ++i) {
            this.basePath.cubicTo(this.x1VertiCoord[i], this.y1VertiCoord[i], this.xVertiCoord[i], this.yVertiCoord[i], this.x2VertiCoord[i], this.y2VertiCoord[i]);
            this.basePath.lineTo(this.x1VertiCoord[(i + 1) % this.sideCount], this.y1VertiCoord[(i + 1) % this.sideCount]);
        }
        this.basePath.close();
        this.sideLength = this.pathMeasure.getLength() / (float)this.sideCount;
        this.pathMeasure.setPath(this.basePath, false);
        this.totalDisStartPoint = this.pathMeasure.getLength() + this.minDistance + this.baseSpeed * (float)this.refreshRate + 250.0f;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.basePath, this.primaryPaint);
        if (this.isDeterminate) {
            this.determinate(canvas, this.startSide);
        } else {
            this.withoutAcceleration = this.baseSpeed;
            this.withAcceleration = this.akinTime >= 0.0f ? this.baseSpeed + this.akinTime : this.baseSpeed + 0.5f;
            if (this.whereToGo == 1) {
                this.firstPath(canvas);
            } else if (this.whereToGo == 2) {
                this.secondPath(canvas);
            }
        }
    }

    private void setCoordinates() {
        int i;
        float diffAngle = this.isClockWise ? (float)(Math.PI * -2 / (double)this.sideCount) : (float)(Math.PI * 2 / (double)this.sideCount);
        for (i = 0; i < this.sideCount; ++i) {
            this.xVertiCoord[i] = this.xCenter - (float)((double)this.radius * Math.sin((double)(i + 1) * (double)diffAngle));
            this.yVertiCoord[i] = this.yCenter - (float)((double)this.radius * Math.cos((double)(i + 1) * (double)diffAngle));
        }
        for (i = 0; i < this.sideCount; ++i) {
            this.x1VertiCoord[i] = (1.0f * this.xVertiCoord[(this.sideCount + i - 1) % this.sideCount] + 9.0f * this.xVertiCoord[i]) / 10.0f;
            this.y1VertiCoord[i] = (1.0f * this.yVertiCoord[(this.sideCount + i - 1) % this.sideCount] + 9.0f * this.yVertiCoord[i]) / 10.0f;
            this.x2VertiCoord[i] = (1.0f * this.xVertiCoord[(i + 1) % this.sideCount] + 9.0f * this.xVertiCoord[i]) / 10.0f;
            this.y2VertiCoord[i] = (1.0f * this.yVertiCoord[(i + 1) % this.sideCount] + 9.0f * this.yVertiCoord[i]) / 10.0f;
        }
        for (i = 0; i < this.sideCount; ++i) {
            this.xMidPoints[i] = (this.xVertiCoord[i] + this.xVertiCoord[(i + 1) % this.sideCount]) / 2.0f;
            this.yMidPoints[i] = (this.yVertiCoord[i] + this.yVertiCoord[(i + 1) % this.sideCount]) / 2.0f;
        }
    }

    private void xmlAttributes(TypedArray array) {
        this.sideCount = array.getInt(R.styleable.NSidedProgressBar_nsidedProg_sideCount, 3);
        this.primaryColor = array.getColor(R.styleable.NSidedProgressBar_nsidedProg_primaryColor, Color.parseColor((String)"#E0E0E0"));
        this.secondaryColor = array.getColor(R.styleable.NSidedProgressBar_nsidedProg_secondaryColor, Color.parseColor((String)"#6499fa"));
        this.baseSpeed = array.getFloat(R.styleable.NSidedProgressBar_nsidedProg_baseSpeed, 5.0f);
        this.refreshRate = array.getInt(R.styleable.NSidedProgressBar_nsidedProg_refreshRate, 60);
        this.primaryRimWidth = array.getInt(R.styleable.NSidedProgressBar_nsidedProg_primaryRimWidth, 8);
        this.secondaryRimWidth = array.getInt(R.styleable.NSidedProgressBar_nsidedProg_secondaryRimWidth, 9);
        this.isClockWise = array.getBoolean(R.styleable.NSidedProgressBar_nsidedProg_clockwise, true);
        this.isDeterminate = array.getBoolean(R.styleable.NSidedProgressBar_nsidedProg_determinate, false);
        this.startSide = array.getInt(R.styleable.NSidedProgressBar_nsidedProg_startSide, 1);
    }

    private void firstPath(Canvas canvas) {
        if (this.tempState2) {
            this.tempState2 = false;
            this.totalDisStartPoint = this.baseSpeed * (float)this.refreshRate - this.minDistance >= this.startPoint ? this.pathMeasure.getLength() + this.baseSpeed * (float)this.refreshRate - this.minDistance - this.minDistanceSec : this.pathMeasure.getLength() - (this.minDistanceSec - (this.baseSpeed * (float)this.refreshRate - this.minDistance));
            this.times = 8.0f * (this.totalDisStartPoint / 2.0f - this.baseSpeed * (float)this.refreshRate / 2.0f) / (float)(this.refreshRate * this.refreshRate);
        }
        if (this.tempStartPoint <= this.totalDisStartPoint / 2.0f) {
            this.akinTime += this.times;
        } else {
            this.akinTime -= this.times;
            if (this.akinTime <= 0.0f) {
                this.exit = true;
                this.tempStartPoint = 0.0f;
                this.akinTime = 0.0f;
            }
        }
        this.startPoint += this.withAcceleration;
        this.endPoint += this.withoutAcceleration;
        this.secPath.reset();
        this.tempStartPoint += this.withAcceleration;
        this.tempDiffValue = this.endPoint - this.startPoint;
        if (this.tempDiffValue >= 0.0f) {
            if (this.tempDiffValue <= this.minDistance) {
                this.exit = true;
            }
        } else if (this.pathMeasure.getLength() - this.startPoint + this.endPoint <= this.minDistance) {
            this.exit = true;
        }
        if (this.endPoint >= this.pathMeasure.getLength()) {
            this.tempState1 = false;
            this.endPoint = 0.0f;
        }
        if (this.startPoint >= this.pathMeasure.getLength()) {
            this.startPoint = 0.0f;
            this.tempState1 = true;
        }
        if (this.tempState1) {
            this.pathMeasure.getSegment(0.0f, this.startPoint % this.pathMeasure.getLength(), this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
            this.pathMeasure.getSegment(this.endPoint, this.pathMeasure.getLength(), this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        } else {
            this.pathMeasure.getSegment(this.endPoint, this.startPoint, this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        }
        if (this.exit) {
            this.exit = false;
            this.whereToGo = 2;
            this.akinTime = 0.0f;
        }
    }

    private void secondPath(Canvas canvas) {
        if (this.tempState2) {
            this.tempState2 = false;
            this.tempStartPoint = 0.0f;
            this.totalDisStartPoint = this.baseSpeed * (float)this.refreshRate - this.minDistanceSec >= this.endPoint ? this.pathMeasure.getLength() + this.baseSpeed * (float)this.refreshRate - this.minDistance - this.minDistanceSec : this.pathMeasure.getLength() - (this.minDistanceSec - (this.baseSpeed * (float)this.refreshRate - this.minDistance));
            this.times = 8.0f * (this.totalDisStartPoint / 2.0f - this.baseSpeed * (float)this.refreshRate / 2.0f) / (float)(this.refreshRate * this.refreshRate);
        }
        this.secPath.reset();
        if (this.tempStartPoint <= this.totalDisStartPoint / 2.0f) {
            this.akinTime += this.times;
        } else {
            this.akinTime -= this.times;
            if (this.akinTime <= 0.0f) {
                this.exit = true;
            }
        }
        this.startPoint += this.withoutAcceleration;
        this.endPoint += this.withAcceleration;
        this.tempStartPoint += this.withAcceleration;
        if (this.endPoint >= this.pathMeasure.getLength()) {
            this.endPoint = 0.0f;
            this.tempState1 = false;
        }
        if (this.startPoint >= this.pathMeasure.getLength()) {
            this.startPoint = 0.0f;
            this.tempState1 = true;
        }
        if (this.tempState1) {
            this.pathMeasure.getSegment(0.0f, this.startPoint, this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
            this.pathMeasure.getSegment(this.endPoint, this.pathMeasure.getLength(), this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        } else {
            this.pathMeasure.getSegment(this.endPoint, this.startPoint, this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        }
        this.tempDiffValue = this.startPoint - this.endPoint;
        if (this.tempDiffValue >= 0.0f) {
            if (this.tempDiffValue <= this.minDistanceSec) {
                this.exit = true;
            }
        } else if (this.pathMeasure.getLength() + this.startPoint - this.endPoint <= this.minDistanceSec) {
            this.exit = true;
        }
        if (this.exit) {
            this.exit = false;
            this.akinTime = 0.0f;
            this.whereToGo = 1;
        }
    }

    private void determinate(Canvas canvas, int startSide) {
        this.secPath.reset();
        if (startSide <= this.sideCount && startSide > 0) {
            canvas.rotate((float)(startSide * 360 / this.sideCount), this.xCenter, this.yCenter);
        }
        this.initialPosition = (float)Math.hypot(this.x1VertiCoord[0] - this.xMidPoints[0], this.y1VertiCoord[0] - this.yMidPoints[0]);
        this.sideProgress = this.pathMeasure.getLength() * this.progress / 100.0f;
        if (this.sideProgress + this.initialPosition > this.pathMeasure.getLength()) {
            this.pathMeasure.getSegment(this.initialPosition, this.pathMeasure.getLength(), this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
            this.pathMeasure.getSegment(0.0f, this.sideProgress - this.pathMeasure.getLength() + this.initialPosition, this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        } else {
            this.pathMeasure.getSegment(this.initialPosition, this.sideProgress + this.initialPosition, this.secPath, true);
            canvas.drawPath(this.secPath, this.secondaryPaint);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 4) {
            if (this.timer != null) {
                this.timer.cancel();
            }
        } else {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ((Activity)NSidedProgressBar.this.context).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            NSidedProgressBar.this.invalidate();
                        }
                    });
                }
            }, 0L, (long)(1000 / this.refreshRate));
        }
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void setPrimaryPaint(Paint primaryPaint) {
        this.primaryPaint = primaryPaint;
    }

    public void setPrimaryPaintColors(int color) {
        this.primaryColor = color;
        this.primaryPaint.setColor(color);
    }

    public void setSecondaryPaint(Paint secondaryPaint) {
        this.secondaryPaint = secondaryPaint;
    }

    public void setSecondaryPaintColors(int color) {
        this.secondaryColor = color;
        this.secondaryPaint.setColor(color);
    }

    public void setSideCount(int sideCount) {
        this.sideCount = sideCount;
    }

    public void setBaseSpeed(float baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    public Paint getPrimaryPaint() {
        return this.primaryPaint;
    }

    public Paint getSecondaryPaint() {
        return this.secondaryPaint;
    }

    public int getSideCount() {
        return this.sideCount;
    }

    public float getBaseSpeed() {
        return this.baseSpeed;
    }

    public void update() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.initiateDraw();
    }

    public int getStartSide() {
        return this.startSide;
    }

    public void setStartSide(int startSide) {
        this.startSide = startSide;
    }

    public boolean isDeterminate() {
        return this.isDeterminate;
    }

    public void setDeterminate(boolean determinate) {
        this.isDeterminate = determinate;
    }
}

