/*
 * Decompiled with CFR 0.152.
 */
package com.jzj.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;

public class ObservableScrollView
extends ScrollView {
    private static final boolean DEBUG = false;
    private static final int CHECK_SCROLL_STOP_DELAY_MILLIS = 80;
    private static final int MSG_SCROLL = 1;
    private boolean mIsTouched = false;
    private int mScrollState = 0;
    private OnScrollListener mOnScrollListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){
        private int mLastY = Integer.MIN_VALUE;

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                int scrollY = ObservableScrollView.this.getScrollY();
                ObservableScrollView.this.log("handleMessage, lastY = " + this.mLastY + ", y = " + scrollY);
                if (!ObservableScrollView.this.mIsTouched && this.mLastY == scrollY) {
                    this.mLastY = Integer.MIN_VALUE;
                    ObservableScrollView.this.setScrollState(0);
                } else {
                    this.mLastY = scrollY;
                    ObservableScrollView.this.restartCheckStopTiming();
                }
                return true;
            }
            return false;
        }
    });

    private void restartCheckStopTiming() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 80L);
    }

    public ObservableScrollView(Context context) {
        super(context);
    }

    public ObservableScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ObservableScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.handleDownEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.handleUpEvent(ev);
        return super.onTouchEvent(ev);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.log(String.format("onScrollChanged, isTouched = %s, l: %d --> %d, t: %d --> %d", this.mIsTouched, oldl, l, oldt, t));
        if (this.mIsTouched) {
            this.setScrollState(1);
        } else {
            this.setScrollState(2);
            this.restartCheckStopTiming();
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mIsTouched, l, t, oldl, oldt);
        }
    }

    private void handleDownEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.log("handleEvent, action = " + ev.getAction());
                this.mIsTouched = true;
            }
        }
    }

    private void handleUpEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 1: 
            case 3: {
                this.log("handleEvent, action = " + ev.getAction());
                this.mIsTouched = false;
                this.restartCheckStopTiming();
            }
        }
    }

    private void setScrollState(int state) {
        if (this.mScrollState != state) {
            this.log(String.format("---- onScrollStateChanged, state: %d --> %d", this.mScrollState, state));
            this.mScrollState = state;
            if (this.mOnScrollListener != null) {
                this.mOnScrollListener.onScrollStateChanged(this, state);
            }
        }
    }

    private void log(String obj) {
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(ObservableScrollView var1, int var2);

        public void onScroll(ObservableScrollView var1, boolean var2, int var3, int var4, int var5, int var6);
    }
}

