/*
 * Decompiled with CFR 0.152.
 */
package com.jwenfeng.library.pulltorefresh.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.jwenfeng.library.R;
import com.jwenfeng.library.pulltorefresh.view.HeadView;

public class HeadRefreshView
extends FrameLayout
implements HeadView {
    private TextView tv;
    private ImageView arrow;
    private ProgressBar progressBar;

    public HeadRefreshView(Context context) {
        this(context, null);
    }

    public HeadRefreshView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HeadRefreshView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_header, null);
        this.addView(view);
        this.tv = (TextView)view.findViewById(R.id.header_tv);
        this.arrow = (ImageView)view.findViewById(R.id.header_arrow);
        this.progressBar = (ProgressBar)view.findViewById(R.id.header_progress);
    }

    @Override
    public void begin() {
    }

    @Override
    public void progress(float progress, float all) {
        float s = progress / all;
        if (s >= 0.9f) {
            this.arrow.setRotation(180.0f);
        } else {
            this.arrow.setRotation(0.0f);
        }
        if (progress >= all - 10.0f) {
            this.tv.setText((CharSequence)"\u677e\u5f00\u5237\u65b0");
        } else {
            Log.d((String)"1111", (String)("progress" + progress + "all" + all));
            this.tv.setText((CharSequence)"\u4e0b\u62c9\u52a0\u8f7d");
        }
    }

    @Override
    public void finishing(float progress, float all) {
    }

    @Override
    public void loading() {
        this.arrow.setVisibility(8);
        this.progressBar.setVisibility(0);
        this.tv.setText((CharSequence)"\u5237\u65b0\u4e2d...");
    }

    @Override
    public void normal() {
        this.arrow.setVisibility(0);
        this.progressBar.setVisibility(8);
        this.tv.setText((CharSequence)"\u4e0b\u62c9\u5237\u65b0");
    }

    @Override
    public View getView() {
        return this;
    }
}

