/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.toastr;

import com.jwebmp.core.Feature;
import com.jwebmp.plugins.toastr.ToastrOptions;
import com.jwebmp.plugins.toastr.ToastrType;
import jakarta.validation.constraints.NotNull;

public class ToastrFeature<J extends ToastrFeature<J>>
extends Feature<J, ToastrOptions<?>, J> {
    private ToastrType type;
    private String title;
    private String message;

    public ToastrFeature(String message) {
        this();
        this.message = message;
    }

    public ToastrFeature() {
        super("ToastrFeature");
    }

    public ToastrFeature(String title, String message) {
        this();
        this.title = title;
        this.message = message;
    }

    public ToastrFeature(ToastrType type, String title, String message) {
        this();
        this.type = type;
        this.title = title;
        this.message = message;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return false;
    }

    @NotNull
    public ToastrOptions getOptions() {
        if (super.getOptions() == null) {
            this.setOptions(new ToastrOptions());
        }
        return (ToastrOptions)super.getOptions();
    }

    protected void assignFunctionsToComponent() {
        this.addQuery("toastr.options = " + this.getOptions() + ";");
        this.addQuery("toastr['" + this.getType() + "']('" + this.getMessage().replaceAll("'", "\\'") + "'" + (String)(this.getTitle() == null ? "" : ",'" + this.getTitle().replaceAll("'", "\\'") + "'") + ");");
    }

    @NotNull
    public ToastrType getType() {
        if (this.type == null) {
            return ToastrType.Info;
        }
        return this.type;
    }

    @NotNull
    public J setType(ToastrType type) {
        this.type = type;
        return (J)((Object)this);
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    @NotNull
    public J setTitle(String title) {
        this.title = title;
        return (J)((Object)this);
    }

    @NotNull
    public J setMessage(String message) {
        this.message = message.replaceAll("'", "\\'");
        return (J)((Object)this);
    }
}

