/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebView;
import com.download.library.DownloadImpl;
import com.download.library.DownloadListenerAdapter;
import com.download.library.DownloadTask;
import com.download.library.Runtime;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.Action;
import com.just.agentweb.ActionActivity;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebPermissions;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.download.DownloadListener;
import com.just.agentweb.download.Extra;
import com.just.agentweb.download.R;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultDownloadImpl
implements android.webkit.DownloadListener {
    private Context mContext;
    private ConcurrentHashMap<String, DownloadListener> mDownloadListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Extra> mExtraServiceImpls = new ConcurrentHashMap();
    private WeakReference<Activity> mActivityWeakReference = null;
    private static final String TAG = DefaultDownloadImpl.class.getSimpleName();
    private PermissionInterceptor mPermissionListener = null;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController;
    private Extra mExtra;
    private static Handler mHandler = new Handler(Looper.getMainLooper());
    private DownloadListenerAdapter mDownloadAdapter = new DownloadListenerAdapter(){

        public void onStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength, com.download.library.Extra extra) {
        }

        public void onProgress(String url, long downloaded, long length, long useTime) {
            LogUtils.e((String)TAG, (String)(" downloaded:" + downloaded + " length:" + length + " url:" + url));
            DownloadListener downloadingListener = (DownloadListener)DefaultDownloadImpl.this.mDownloadListeners.get(url);
            if (null != downloadingListener) {
                downloadingListener.onProgress(url, downloaded, length, useTime);
            }
        }

        public boolean onResult(Throwable throwable, Uri path, String url, com.download.library.Extra extra) {
            DownloadListener downloadListener = (DownloadListener)DefaultDownloadImpl.this.mDownloadListeners.remove(url);
            Extra wraper = (Extra)DefaultDownloadImpl.this.mExtraServiceImpls.remove(url);
            return null != downloadListener && downloadListener.onResult(throwable, path, url, wraper);
        }
    };

    DefaultDownloadImpl(Extra extra) {
        DownloadImpl.getInstance().with((Context)extra.mActivity.getApplication());
        if (!extra.mIsCloneObject) {
            this.bind(extra);
            this.mExtra = extra;
        }
    }

    private void bind(Extra extra) {
        this.mActivityWeakReference = new WeakReference<Activity>(extra.mActivity);
        this.mContext = extra.mActivity.getApplicationContext();
        if (extra.getDownloadListener() != null && !TextUtils.isEmpty((CharSequence)extra.getUrl())) {
            this.mDownloadListeners.put(extra.getUrl(), extra.getDownloadListener());
        }
        this.mPermissionListener = extra.mPermissionInterceptor;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView((WebView)extra.mWebView));
    }

    public void onDownloadStart(final String url, final String userAgent, final String contentDisposition, final String mimetype, final long contentLength) {
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                DefaultDownloadImpl.this.onDownloadStartInternal(url, userAgent, contentDisposition, mimetype, contentLength, null);
            }
        });
    }

    private void onDownloadStartInternal(String url, String userAgent, String contentDisposition, String mimetype, long contentLength, Extra extra) {
        if (null == this.mActivityWeakReference.get() || ((Activity)this.mActivityWeakReference.get()).isFinishing()) {
            return;
        }
        if (null != this.mPermissionListener && this.mPermissionListener.intercept(url, AgentWebPermissions.STORAGE, "download")) {
            return;
        }
        Extra mCloneExtra = null;
        mCloneExtra = null == extra ? this.mExtra.clone() : extra;
        mCloneExtra.setUrl(url).setMimetype(mimetype).setContentDisposition(contentDisposition).setContentLength(contentLength).setUserAgent(userAgent);
        this.mExtraServiceImpls.put(url, mCloneExtra);
        if (mCloneExtra.getDownloadListener() != null && !TextUtils.isEmpty((CharSequence)mCloneExtra.getUrl())) {
            this.mDownloadListeners.put(mCloneExtra.getUrl(), mCloneExtra.getDownloadListener());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> mList = null;
            mList = this.checkNeedPermission();
            if (mList.isEmpty()) {
                this.preDownload(url);
            } else {
                Action mAction = Action.createPermissionsAction((String[])mList.toArray(new String[0]));
                ActionActivity.setPermissionListener((ActionActivity.PermissionListener)this.getPermissionListener(url));
                ActionActivity.start((Activity)((Activity)this.mActivityWeakReference.get()), (Action)mAction);
            }
        } else {
            this.preDownload(url);
        }
    }

    private ActionActivity.PermissionListener getPermissionListener(final String url) {
        return new ActionActivity.PermissionListener(){

            public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
                if (DefaultDownloadImpl.this.checkNeedPermission().isEmpty()) {
                    DefaultDownloadImpl.this.preDownload(url);
                } else {
                    if (null != DefaultDownloadImpl.this.mAgentWebUIController.get()) {
                        ((AbsAgentWebUIController)DefaultDownloadImpl.this.mAgentWebUIController.get()).onPermissionsDeny(DefaultDownloadImpl.this.checkNeedPermission().toArray(new String[0]), "Storage", "Download");
                    }
                    LogUtils.e((String)TAG, (String)"\u50a8\u5b58\u6743\u9650\u83b7\u53d6\u5931\u8d25~");
                }
            }
        };
    }

    private List<String> checkNeedPermission() {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (!AgentWebUtils.hasPermission((Context)((Context)this.mActivityWeakReference.get()), (String[])AgentWebPermissions.STORAGE)) {
            deniedPermissions.addAll(Arrays.asList(AgentWebPermissions.STORAGE));
        }
        return deniedPermissions;
    }

    private void preDownload(String url) {
        Extra extraService = this.mExtraServiceImpls.get(url);
        DownloadTask downloadTask = extraService.getDownloadTask();
        DownloadListener downloadListener = this.mDownloadListeners.get(extraService.getUrl());
        if (null != downloadListener && downloadListener.onStart(extraService.getUrl(), downloadTask.getUserAgent(), downloadTask.getContentDisposition(), downloadTask.getMimetype(), downloadTask.getContentLength(), extraService)) {
            return;
        }
        File file = Runtime.getInstance().uniqueFile(extraService.getDownloadTask(), new File(AgentWebUtils.getAgentWebFilePath((Context)this.mContext)));
        if (null == file) {
            LogUtils.e((String)TAG, (String)"\u65b0\u5efa\u6587\u4ef6\u5931\u8d25");
            return;
        }
        if (file.exists() && file.length() >= downloadTask.getContentLength() && downloadTask.getContentLength() > 0L) {
            if (null != downloadListener && downloadListener.onResult(null, Uri.fromFile((File)file), extraService.getUrl(), extraService)) {
                return;
            }
            Intent mIntent = AgentWebUtils.getCommonFileIntentCompat((Context)this.mContext, (File)file);
            try {
                if (null != mIntent) {
                    if (!(this.mContext instanceof Activity)) {
                        mIntent.addFlags(0x10000000);
                    }
                    this.mContext.startActivity(mIntent);
                }
                return;
            }
            catch (Throwable throwable) {
                if (LogUtils.isDebug()) {
                    throwable.printStackTrace();
                }
                return;
            }
        }
        downloadTask.setFile(file, downloadTask.getContext().getPackageName() + ".AgentWebFileProvider");
        if (!downloadTask.isForceDownload() && AgentWebUtils.checkNetworkType((Context)this.mContext) > 1) {
            this.showDialog(url);
            return;
        }
        this.performDownload(url);
    }

    private void forceDownload(String url) {
        Extra extraService = this.mExtraServiceImpls.get(url);
        extraService.setForceDownload(true);
        this.performDownload(url);
    }

    private void showDialog(String url) {
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (null == mActivity || mActivity.isFinishing()) {
            return;
        }
        Extra extraService = this.mExtraServiceImpls.get(url);
        AbsAgentWebUIController mAgentWebUIController = (AbsAgentWebUIController)this.mAgentWebUIController.get();
        if (null != mAgentWebUIController) {
            mAgentWebUIController.onForceDownloadAlert(extraService.getUrl(), this.createCallback(extraService.getUrl()));
        }
    }

    private Handler.Callback createCallback(final String url) {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                DefaultDownloadImpl.this.forceDownload(url);
                return true;
            }
        };
    }

    private void performDownload(String url) {
        block5: {
            try {
                if (DownloadImpl.getInstance().exist(url)) {
                    if (null != this.mAgentWebUIController.get()) {
                        ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_download_task_has_been_exist), TAG.concat("|preDownload"));
                    }
                    return;
                }
                Extra extraService = this.mExtraServiceImpls.get(url);
                DownloadTask downloadTask = extraService.getDownloadTask();
                if (null != this.mAgentWebUIController.get()) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_coming_soon_download) + ":" + downloadTask.getFile().getName(), TAG.concat("|performDownload"));
                }
                downloadTask.addHeader("Cookie", AgentWebConfig.getCookiesByUrl((String)url.toString()));
                downloadTask.setDownloadListenerAdapter((DownloadListenerAdapter)new WeakDownloadListener(this.mDownloadAdapter));
                DownloadImpl.getInstance().enqueue(downloadTask);
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block5;
                ignore.printStackTrace();
            }
        }
    }

    private DownloadTask swrap(Extra extraService) {
        return extraService.getDownloadTask();
    }

    public static DefaultDownloadImpl create(@NonNull Activity activity, @NonNull WebView webView, @Nullable DownloadListener downloadListener, @Nullable PermissionInterceptor permissionInterceptor) {
        Extra extraService = new Extra().setActivity(activity).setWebView(webView).setPermissionInterceptor(permissionInterceptor);
        extraService.setDownloadListener(downloadListener);
        return extraService.create();
    }

    private static class WeakDownloadListener
    extends DownloadListenerAdapter {
        private WeakReference<DownloadListenerAdapter> mDownloadListenerWeakReference;

        private WeakDownloadListener(DownloadListenerAdapter delegate) {
            this.mDownloadListenerWeakReference = new WeakReference<DownloadListenerAdapter>(delegate);
        }

        @SuppressLint(value={"WrongThread"})
        public void onStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength, com.download.library.Extra extra) {
            if (this.mDownloadListenerWeakReference.get() != null) {
                ((DownloadListenerAdapter)this.mDownloadListenerWeakReference.get()).onStart(url, userAgent, contentDisposition, mimetype, contentLength, extra);
            }
        }

        public void onProgress(String url, long downloaded, long length, long usedTime) {
            if (this.mDownloadListenerWeakReference.get() != null) {
                ((DownloadListenerAdapter)this.mDownloadListenerWeakReference.get()).onProgress(url, downloaded, length, usedTime);
            }
        }

        public boolean onResult(Throwable throwable, Uri path, String url, com.download.library.Extra extra) {
            if (this.mDownloadListenerWeakReference.get() != null) {
                return ((DownloadListenerAdapter)this.mDownloadListenerWeakReference.get()).onResult(throwable, path, url, extra);
            }
            return false;
        }
    }
}

