/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import com.just.agentweb.Provider;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorProvider
implements Provider<Executor> {
    private final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private final int CORE_POOL_SIZE = Math.max(2, Math.min(this.CPU_COUNT - 1, 4));
    private final int MAXIMUM_POOL_SIZE = this.CPU_COUNT * 2 + 1;
    private final int KEEP_ALIVE_SECONDS = 15;
    public String TAG = this.getClass().getSimpleName();
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
    private ThreadPoolExecutor mThreadPoolExecutor;
    private final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);
        private SecurityManager securityManager = System.getSecurityManager();
        private ThreadGroup group = this.securityManager != null ? this.securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();

        @Override
        public Thread newThread(Runnable r) {
            Thread mThread = new Thread(this.group, r, "pool-agentweb-thread-" + this.mCount.getAndIncrement());
            if (mThread.isDaemon()) {
                mThread.setDaemon(false);
            }
            mThread.setPriority(1);
            return mThread;
        }
    };

    private ExecutorProvider() {
        this.internalInit();
    }

    private void internalInit() {
        if (this.mThreadPoolExecutor != null && !this.mThreadPoolExecutor.isShutdown()) {
            this.mThreadPoolExecutor.shutdownNow();
        }
        this.mThreadPoolExecutor = new ThreadPoolExecutor(this.CORE_POOL_SIZE, this.MAXIMUM_POOL_SIZE, 15L, TimeUnit.SECONDS, sPoolWorkQueue, this.sThreadFactory);
        this.mThreadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    static ExecutorProvider getInstance() {
        return InnerHolder.M_EXECUTOR_PROVIDER;
    }

    public Executor provide() {
        return this.mThreadPoolExecutor;
    }

    static class InnerHolder {
        private static final ExecutorProvider M_EXECUTOR_PROVIDER = new ExecutorProvider();

        InnerHolder() {
        }
    }
}

