/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.download.AgentWebDownloader;
import com.just.agentweb.download.CancelDownloadInformer;
import com.just.agentweb.download.CancelDownloadRecipient;
import com.just.agentweb.download.DefaultDownloadImpl;
import com.just.agentweb.download.DownloadListenerAdapter;
import com.just.agentweb.download.DownloadNotifier;
import com.just.agentweb.download.DownloadTask;
import com.just.agentweb.download.ExecutorProvider;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Downloader
extends AsyncTask<Void, Integer, Integer>
implements AgentWebDownloader<DownloadTask>,
CancelDownloadRecipient {
    private volatile DownloadTask mDownloadTask;
    private volatile long mLoaded = 0L;
    private long mTotals = -1L;
    private long mLastLoaded = 0L;
    private long mUsedTime = 0L;
    private long mLastTime = 0L;
    private volatile long mBeginTime = 0L;
    private volatile long mAverageSpeed = 0L;
    private volatile Throwable mThrowable;
    private long mDownloadTimeOut = Long.MAX_VALUE;
    private int mConnectTimeOut = 10000;
    private DownloadNotifier mDownloadNotifier;
    private static final int ERROR_LOAD = 1030;
    private static final String TAG = Downloader.class.getSimpleName();
    private AtomicBoolean mIsCanceled = new AtomicBoolean(false);
    private AtomicBoolean mIsShutdown = new AtomicBoolean(false);
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_REDIRECTS = 7;
    private static final int HTTP_TEMP_REDIRECT = 307;
    public static final int ERROR_NETWORK_CONNECTION = 1024;
    public static final int ERROR_RESPONSE_STATUS = 1025;
    public static final int ERROR_STORAGE = 1026;
    public static final int ERROR_TIME_OUT = 1027;
    public static final int ERROR_USER_CANCEL = 1028;
    public static final int ERROR_SHUTDOWN = 1029;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1030;
    public static final int ERROR_SERVICE = 1283;
    public static final int SUCCESSFUL = 512;
    private static final SparseArray<String> DOWNLOAD_MESSAGE = new SparseArray();

    Downloader() {
    }

    private void checkIsNullTask(DownloadTask downloadTask) {
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (null != this.mDownloadTask.getDownloadListener()) {
            this.mDownloadTask.getDownloadListener().onBindService(this.mDownloadTask.getUrl(), this);
        }
        CancelDownloadInformer.getInformer().addRecipient(this.mDownloadTask.getUrl(), this);
        this.createNotifier();
        if (null != this.mDownloadNotifier) {
            this.mDownloadNotifier.onPreDownload();
        }
    }

    private boolean checkSpace() {
        if (this.mDownloadTask.getLength() - this.mDownloadTask.getFile().length() > AgentWebUtils.getAvailableStorage()) {
            LogUtils.e((String)TAG, (String)" \u7a7a\u95f4\u4e0d\u8db3");
            return false;
        }
        return true;
    }

    private boolean checkNet() {
        if (!this.mDownloadTask.isForce()) {
            return AgentWebUtils.checkWifi((Context)this.mDownloadTask.getContext());
        }
        return AgentWebUtils.checkNetwork((Context)this.mDownloadTask.getContext());
    }

    protected Integer doInBackground(Void ... params) {
        int result;
        block4: {
            result = 1030;
            try {
                this.mBeginTime = SystemClock.elapsedRealtime();
                if (!this.checkSpace()) {
                    return 1026;
                }
                if (!this.checkNet()) {
                    return 1024;
                }
                result = this.doDownload();
            }
            catch (IOException e) {
                this.mThrowable = e;
                if (!LogUtils.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload() throws IOException {
        int redirectionCount = 1;
        URL url = new URL(this.mDownloadTask.getUrl());
        HttpURLConnection mHttpURLConnection = null;
        try {
            block14: while (redirectionCount++ < 7) {
                boolean finishKnown;
                if (null != mHttpURLConnection) {
                    mHttpURLConnection.disconnect();
                }
                mHttpURLConnection = this.createUrlConnectionAndSettingHeaders(url);
                mHttpURLConnection.connect();
                boolean isConnectionClose = "close".equalsIgnoreCase(mHttpURLConnection.getHeaderField("Connection"));
                boolean isEncodingChunked = "chunked".equalsIgnoreCase(mHttpURLConnection.getHeaderField("Transfer-Encoding"));
                boolean isZero = this.getHeaderFieldLong(mHttpURLConnection, "Content-Length") == -1L;
                boolean bl = finishKnown = isConnectionClose || isEncodingChunked || isZero;
                if (!finishKnown) {
                    LogUtils.e((String)TAG, (String)("can't know size of download, giving up , Connection close:" + isConnectionClose + "EncodingChunked:" + isEncodingChunked + " isZero:" + isZero));
                    int n = 1030;
                    return n;
                }
                int responseCode = mHttpURLConnection.getResponseCode();
                switch (responseCode) {
                    case 200: {
                        this.saveEtag(mHttpURLConnection);
                        int n = this.transferData(mHttpURLConnection.getInputStream(), new LoadingRandomAccessFile(this.mDownloadTask.getFile()), false);
                        return n;
                    }
                    case 206: {
                        int n = this.transferData(mHttpURLConnection.getInputStream(), new LoadingRandomAccessFile(this.mDownloadTask.getFile()), true);
                        return n;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = mHttpURLConnection.getHeaderField("Location");
                        url = new URL(url, location);
                        continue block14;
                    }
                    case 500: 
                    case 503: {
                        int n = 1283;
                        return n;
                    }
                }
                int n = 1025;
                return n;
            }
            int n = 1030;
            return n;
        }
        finally {
            if (null != mHttpURLConnection) {
                mHttpURLConnection.disconnect();
            }
        }
    }

    private long getHeaderFieldLong(HttpURLConnection httpURLConnection, String name) {
        String field = httpURLConnection.getHeaderField(name);
        try {
            return field == null ? -1L : Long.parseLong(field);
        }
        catch (NumberFormatException e) {
            if (LogUtils.isDebug()) {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    private void saveEtag(HttpURLConnection httpURLConnection) {
        String etag = httpURLConnection.getHeaderField("ETag");
        if (TextUtils.isEmpty((CharSequence)etag)) {
            return;
        }
        LogUtils.i((String)TAG, (String)("save etag:" + etag));
        SharedPreferences mSharedPreferences = this.mDownloadTask.getContext().getSharedPreferences("AgentWeb", 0);
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putString(this.mDownloadTask.getFile().getName(), etag);
        editor.apply();
    }

    private String getEtag() {
        SharedPreferences mSharedPreferences = this.mDownloadTask.getContext().getSharedPreferences("AgentWeb", 0);
        String mEtag = mSharedPreferences.getString(this.mDownloadTask.getFile().getName(), "-1");
        if (!TextUtils.isEmpty((CharSequence)mEtag) && !"-1".equals(mEtag)) {
            return mEtag;
        }
        return null;
    }

    private HttpURLConnection createUrlConnectionAndSettingHeaders(URL url) throws IOException {
        HttpURLConnection mHttpURLConnection = (HttpURLConnection)url.openConnection();
        mHttpURLConnection.setConnectTimeout(this.mConnectTimeOut);
        mHttpURLConnection.setInstanceFollowRedirects(false);
        mHttpURLConnection.setReadTimeout(this.mDownloadTask.getBlockMaxTime());
        mHttpURLConnection.setRequestProperty("Accept", "application/*");
        mHttpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        mHttpURLConnection.setRequestProperty("Connection", "close");
        mHttpURLConnection.setRequestProperty("Cookie", AgentWebConfig.getCookiesByUrl((String)url.toString()));
        Map<String, String> mHeaders = null;
        mHeaders = this.mDownloadTask.getExtraServiceImpl().getHeaders();
        if (null != mHeaders && !mHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : mHeaders.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                mHttpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.mDownloadTask.getFile().length() > 0L) {
            String mEtag = "";
            mEtag = this.getEtag();
            if (!TextUtils.isEmpty((CharSequence)mEtag)) {
                LogUtils.i((String)TAG, (String)("Etag:" + mEtag));
                mHttpURLConnection.setRequestProperty("If-Match", this.getEtag());
            }
            this.mLastLoaded = this.mDownloadTask.getFile().length();
            mHttpURLConnection.setRequestProperty("Range", "bytes=" + this.mLastLoaded + "-");
        }
        return mHttpURLConnection;
    }

    protected synchronized void onProgressUpdate(Integer ... values) {
        try {
            long currentTime = SystemClock.elapsedRealtime();
            this.mUsedTime = currentTime - this.mBeginTime;
            this.mAverageSpeed = this.mUsedTime == 0L ? 0L : this.mLoaded * 1000L / this.mUsedTime;
            if (currentTime - this.mLastTime < 800L) {
                return;
            }
            this.mLastTime = currentTime;
            if (null != this.mDownloadNotifier) {
                int mProgress = (int)((float)(this.mLastLoaded + this.mLoaded) / Float.valueOf(this.mTotals).floatValue() * 100.0f);
                this.mDownloadNotifier.onDownloading(mProgress);
            }
            if (this.mDownloadTask.getDownloadListener() != null) {
                this.mDownloadTask.getDownloadListener().onProgress(this.mDownloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, this.mUsedTime);
            }
        }
        catch (UnknownFormatConversionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Integer integer) {
        try {
            CancelDownloadInformer.getInformer().removeRecipient(this.mDownloadTask.getUrl());
            if (this.mDownloadTask.getDownloadListener() != null) {
                this.mDownloadTask.getDownloadListener().onProgress(this.mDownloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, this.mUsedTime);
            }
            if (this.mDownloadTask.getDownloadListener() != null) {
                this.mDownloadTask.getDownloadListener().onUnbindService(this.mDownloadTask.getUrl(), this);
            }
            boolean isCancelDispose = this.doCallback(integer);
            if (integer > 512) {
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.cancel();
                }
                return;
            }
            if (this.mDownloadTask.isEnableIndicator()) {
                if (isCancelDispose) {
                    this.mDownloadNotifier.cancel();
                    return;
                }
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.onDownloadFinished();
                }
            }
        }
        catch (Throwable throwable) {
            if (LogUtils.isDebug()) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (this.mDownloadTask != null) {
                this.mDownloadTask.destroy();
            }
        }
    }

    private boolean doCallback(Integer code) {
        DownloadListenerAdapter mDownloadListener = null;
        mDownloadListener = this.mDownloadTask.getDownloadListener();
        if (null == mDownloadListener) {
            LogUtils.e((String)TAG, (String)"DownloadListener has been death");
            DefaultDownloadImpl.ExecuteTasksMap.getInstance().removeTask(this.mDownloadTask.getFile().getPath());
            return false;
        }
        return mDownloadListener.onResult(this.mDownloadTask.getFile().getAbsolutePath(), this.mDownloadTask.getUrl(), code <= 200 ? null : (this.mThrowable == null ? new RuntimeException("Download failed \uff0c cause:" + (String)DOWNLOAD_MESSAGE.get(code.intValue())) : this.mThrowable));
    }

    private void createNotifier() {
        Context mContext = this.mDownloadTask.getContext().getApplicationContext();
        if (null != mContext && this.mDownloadTask.isEnableIndicator()) {
            this.mDownloadNotifier = new DownloadNotifier(mContext, this.mDownloadTask.getId());
            this.mDownloadNotifier.initBuilder(this.mDownloadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferData(InputStream inputStream, RandomAccessFile randomAccessFile, boolean isSeek) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
        RandomAccessFile out = randomAccessFile;
        try {
            int n;
            int n2;
            if (isSeek) {
                out.seek(out.length());
            } else {
                out.seek(0L);
                this.mLastLoaded = 0L;
            }
            int bytes = 0;
            while (!this.mIsCanceled.get() && !this.mIsShutdown.get() && (n2 = bis.read(buffer, 0, 8192)) != -1) {
                out.write(buffer, 0, n2);
                bytes += n2;
                if (SystemClock.elapsedRealtime() - this.mBeginTime <= this.mDownloadTimeOut) continue;
                int n3 = 1027;
                return n3;
            }
            if (this.mIsCanceled.get()) {
                n = 1028;
                return n;
            }
            if (this.mIsShutdown.get()) {
                n = 1029;
                return n;
            }
            n = 512;
            return n;
        }
        finally {
            AgentWebUtils.closeIO((Closeable)out);
            AgentWebUtils.closeIO((Closeable)bis);
            AgentWebUtils.closeIO((Closeable)inputStream);
        }
    }

    private final void cancel() {
        this.mIsCanceled.set(true);
    }

    @Override
    public synchronized boolean isShutdown() {
        LogUtils.i((String)TAG, (String)("" + this.mIsShutdown.get() + "  " + this.mIsCanceled.get() + "  :" + (this.getStatus() == AsyncTask.Status.FINISHED)));
        return this.mIsShutdown.get() || this.mIsCanceled.get() || this.getStatus() == AsyncTask.Status.FINISHED;
    }

    @Override
    public synchronized AgentWebDownloader.ExtraService shutdownNow() {
        if (this.getStatus() == AsyncTask.Status.FINISHED) {
            LogUtils.e((String)TAG, (String)"  Termination failed , becauce the downloader already dead !!! ");
            return null;
        }
        try {
            DefaultDownloadImpl.ExtraServiceImpl mExtraService;
            DefaultDownloadImpl.ExtraServiceImpl extraServiceImpl = mExtraService = this.mDownloadTask.getExtraServiceImpl();
            return extraServiceImpl;
        }
        finally {
            this.mIsShutdown.set(true);
        }
    }

    @Override
    public void download(DownloadTask downloadTask) {
        this.downloadInternal(downloadTask);
    }

    private final void downloadInternal(DownloadTask downloadTask) {
        this.checkIsNullTask(downloadTask);
        this.mDownloadTask = downloadTask;
        this.mTotals = this.mDownloadTask.getLength();
        this.mDownloadTimeOut = this.mDownloadTask.getDownloadTimeOut();
        this.mConnectTimeOut = this.mDownloadTask.getConnectTimeOut();
        if (downloadTask.isParallelDownload()) {
            this.executeOnExecutor(ExecutorProvider.getInstance().provide(), null);
        } else {
            this.execute(new Void[0]);
        }
    }

    @Override
    public void cancelDownload() {
        this.cancel();
    }

    static {
        DOWNLOAD_MESSAGE.append(1024, (Object)"Network connection error . ");
        DOWNLOAD_MESSAGE.append(1025, (Object)"Response code non-200 and non-206 . ");
        DOWNLOAD_MESSAGE.append(1026, (Object)"Insufficient memory space . ");
        DOWNLOAD_MESSAGE.append(1029, (Object)"Shutdown . ");
        DOWNLOAD_MESSAGE.append(1027, (Object)"Download time is overtime . ");
        DOWNLOAD_MESSAGE.append(1028, (Object)"The user canceled the download . ");
        DOWNLOAD_MESSAGE.append(1030, (Object)"IO Error . ");
        DOWNLOAD_MESSAGE.append(1283, (Object)"Service Unavailable . ");
        DOWNLOAD_MESSAGE.append(1030, (Object)"Too many redirects . ");
        DOWNLOAD_MESSAGE.append(512, (Object)"Download successful . ");
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            Downloader.this.mLoaded = Downloader.this.mLoaded + (long)count;
            Downloader.this.publishProgress(new Integer[]{0});
        }
    }
}

