/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebView;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.Action;
import com.just.agentweb.ActionActivity;
import com.just.agentweb.AgentWebPermissions;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.download.AgentWebDownloader;
import com.just.agentweb.download.DownloadListener;
import com.just.agentweb.download.DownloadListenerAdapter;
import com.just.agentweb.download.DownloadTask;
import com.just.agentweb.download.Downloader;
import com.just.agentweb.download.DownloadingListener;
import com.just.agentweb.download.DownloadingService;
import com.just.agentweb.download.R;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDownloadImpl
implements android.webkit.DownloadListener {
    private Context mContext;
    private static volatile AtomicInteger NOTICATION_ID = new AtomicInteger(1);
    private DownloadListener mDownloadListener;
    private WeakReference<Activity> mActivityWeakReference = null;
    private static final String TAG = DefaultDownloadImpl.class.getSimpleName();
    private PermissionInterceptor mPermissionListener = null;
    private String mUrl;
    private String mContentDisposition;
    private long mContentLength;
    private String mMimetype;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController;
    private ExtraServiceImpl mExtraServiceImpl;
    private String mUserAgent;
    private ExtraServiceImpl mCloneExtraServiceImpl = null;
    private volatile DownloadingListener mDownloadingListener;
    private Pattern mPattern = Pattern.compile(".*filename=(.*)");
    private DownloadListenerAdapter mDownloadListenerAdapter = new DownloadListenerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProgress(String url, long downloaded, long length, long useTime) {
            if (null != DefaultDownloadImpl.this.mDownloadingListener) {
                DownloadingListener downloadingListener = DefaultDownloadImpl.this.mDownloadingListener;
                synchronized (downloadingListener) {
                    if (null != DefaultDownloadImpl.this.mDownloadingListener) {
                        DefaultDownloadImpl.this.mDownloadingListener.onProgress(url, downloaded, length, useTime);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindService(String url, DownloadingService downloadingService) {
            if (null != DefaultDownloadImpl.this.mDownloadingListener) {
                DownloadingListener downloadingListener = DefaultDownloadImpl.this.mDownloadingListener;
                synchronized (downloadingListener) {
                    DefaultDownloadImpl.this.mDownloadingListener.onBindService(url, downloadingService);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnbindService(String url, DownloadingService downloadingService) {
            if (null != DefaultDownloadImpl.this.mDownloadingListener) {
                DownloadingListener downloadingListener = DefaultDownloadImpl.this.mDownloadingListener;
                synchronized (downloadingListener) {
                    DefaultDownloadImpl.this.mDownloadingListener.onUnbindService(url, downloadingService);
                }
            }
        }

        @Override
        public boolean onResult(String path, String url, Throwable e) {
            ExecuteTasksMap.getInstance().removeTask(path);
            return null != DefaultDownloadImpl.this.mDownloadListener && DefaultDownloadImpl.this.mDownloadListener.onResult(path, url, e);
        }
    };

    DefaultDownloadImpl(ExtraServiceImpl extraServiceImpl) {
        if (!extraServiceImpl.mIsCloneObject) {
            this.bind(extraServiceImpl);
            this.mExtraServiceImpl = extraServiceImpl;
        } else {
            this.mCloneExtraServiceImpl = extraServiceImpl;
        }
    }

    private void bind(ExtraServiceImpl extraServiceImpl) {
        this.mActivityWeakReference = new WeakReference<Activity>(extraServiceImpl.mActivity);
        this.mContext = extraServiceImpl.mActivity.getApplicationContext();
        this.mDownloadListener = extraServiceImpl.mDownloadListener;
        this.mDownloadingListener = extraServiceImpl.mDownloadingListener;
        this.mPermissionListener = extraServiceImpl.mPermissionInterceptor;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView((WebView)extraServiceImpl.mWebView));
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        this.onDownloadStartInternal(url, userAgent, contentDisposition, mimetype, contentLength, null);
    }

    private synchronized void onDownloadStartInternal(String url, String userAgent, String contentDisposition, String mimetype, long contentLength, ExtraServiceImpl extraServiceImpl) {
        if (null == this.mActivityWeakReference.get() || ((Activity)this.mActivityWeakReference.get()).isFinishing()) {
            return;
        }
        if (null != this.mPermissionListener && this.mPermissionListener.intercept(url, AgentWebPermissions.STORAGE, "download")) {
            return;
        }
        ExtraServiceImpl mCloneExtraServiceImpl = null;
        if (null == extraServiceImpl) {
            try {
                mCloneExtraServiceImpl = this.mExtraServiceImpl.clone();
            }
            catch (CloneNotSupportedException ignore) {
                if (LogUtils.isDebug()) {
                    ignore.printStackTrace();
                }
                LogUtils.i((String)TAG, (String)" clone object failure !!! ");
                return;
            }
        } else {
            mCloneExtraServiceImpl = extraServiceImpl;
        }
        this.mUrl = url;
        this.mMimetype = mimetype;
        this.mContentDisposition = contentDisposition;
        this.mContentLength = contentLength;
        this.mUserAgent = userAgent;
        mCloneExtraServiceImpl.setUrl(this.mUrl).setMimetype(this.mMimetype).setContentDisposition(this.mContentDisposition).setContentLength(this.mContentLength).setUserAgent(this.mUserAgent);
        this.mCloneExtraServiceImpl = mCloneExtraServiceImpl;
        LogUtils.i((String)TAG, (String)(" clone a extraServiceImpl : " + this.mCloneExtraServiceImpl.mWebView + "  aty:" + this.mCloneExtraServiceImpl.mActivity + "  getMimetype:" + this.mCloneExtraServiceImpl.getMimetype()));
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> mList = null;
            mList = this.checkNeedPermission();
            if (mList.isEmpty()) {
                this.preDownload();
            } else {
                Action mAction = Action.createPermissionsAction((String[])mList.toArray(new String[0]));
                ActionActivity.setPermissionListener((ActionActivity.PermissionListener)this.getPermissionListener());
                ActionActivity.start((Activity)((Activity)this.mActivityWeakReference.get()), (Action)mAction);
            }
        } else {
            this.preDownload();
        }
    }

    private ActionActivity.PermissionListener getPermissionListener() {
        return new ActionActivity.PermissionListener(){

            public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
                if (DefaultDownloadImpl.this.checkNeedPermission().isEmpty()) {
                    DefaultDownloadImpl.this.preDownload();
                } else {
                    if (null != DefaultDownloadImpl.this.mAgentWebUIController.get()) {
                        ((AbsAgentWebUIController)DefaultDownloadImpl.this.mAgentWebUIController.get()).onPermissionsDeny(DefaultDownloadImpl.this.checkNeedPermission().toArray(new String[0]), "Storage", "Download");
                    }
                    LogUtils.e((String)TAG, (String)"\u50a8\u5b58\u6743\u9650\u83b7\u53d6\u5931\u8d25~");
                }
            }
        };
    }

    private List<String> checkNeedPermission() {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (!AgentWebUtils.hasPermission((Context)((Context)this.mActivityWeakReference.get()), (String[])AgentWebPermissions.STORAGE)) {
            deniedPermissions.addAll(Arrays.asList(AgentWebPermissions.STORAGE));
        }
        return deniedPermissions;
    }

    private void preDownload() {
        File mFile;
        block11: {
            if (null != this.mDownloadListener && this.mDownloadListener.onStart(this.mUrl, this.mUserAgent, this.mContentDisposition, this.mMimetype, this.mContentLength, this.mCloneExtraServiceImpl)) {
                return;
            }
            mFile = this.getFile(this.mContentDisposition, this.mUrl);
            if (null == mFile) {
                LogUtils.e((String)TAG, (String)"\u65b0\u5efa\u6587\u4ef6\u5931\u8d25");
                return;
            }
            if (mFile.exists() && mFile.length() >= this.mContentLength) {
                if (null != this.mDownloadListener && this.mDownloadListener.onResult(mFile.getAbsolutePath(), this.mUrl, null)) {
                    return;
                }
                Intent mIntent = AgentWebUtils.getCommonFileIntentCompat((Context)this.mContext, (File)mFile);
                try {
                    if (null != mIntent) {
                        if (!(this.mContext instanceof Activity)) {
                            mIntent.addFlags(0x10000000);
                        }
                        this.mContext.startActivity(mIntent);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (!LogUtils.isDebug()) break block11;
                    throwable.printStackTrace();
                }
            }
        }
        if (ExecuteTasksMap.getInstance().contains(this.mUrl) || ExecuteTasksMap.getInstance().contains(mFile.getAbsolutePath())) {
            if (this.mAgentWebUIController.get() != null) {
                ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_download_task_has_been_exist), TAG.concat("|preDownload"));
            }
            return;
        }
        if (!this.mCloneExtraServiceImpl.isForceDownload() && AgentWebUtils.checkNetworkType((Context)this.mContext) > 1) {
            this.showDialog(mFile);
            return;
        }
        this.performDownload(mFile);
    }

    private void forceDownload(File file) {
        this.mCloneExtraServiceImpl.setForceDownload(true);
        this.performDownload(file);
    }

    private void showDialog(File file) {
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (null == mActivity || mActivity.isFinishing()) {
            return;
        }
        AbsAgentWebUIController mAgentWebUIController = (AbsAgentWebUIController)this.mAgentWebUIController.get();
        if (mAgentWebUIController != null) {
            mAgentWebUIController.onForceDownloadAlert(this.mUrl, this.createCallback(file));
        }
    }

    private Handler.Callback createCallback(final File file) {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                DefaultDownloadImpl.this.forceDownload(file);
                return true;
            }
        };
    }

    private void performDownload(File file) {
        block3: {
            try {
                ExecuteTasksMap.getInstance().addTask(this.mUrl, file.getAbsolutePath());
                if (null != this.mAgentWebUIController.get()) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_coming_soon_download) + ":" + file.getName(), TAG.concat("|performDownload"));
                }
                DownloadTask mDownloadTask = new DownloadTask(NOTICATION_ID.incrementAndGet(), this.mDownloadListenerAdapter, this.mContext, file, this.mCloneExtraServiceImpl);
                new Downloader().download(mDownloadTask);
                this.mUrl = null;
                this.mContentDisposition = null;
                this.mContentLength = -1L;
                this.mMimetype = null;
                this.mUserAgent = null;
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block3;
                ignore.printStackTrace();
            }
        }
    }

    private File getFile(String contentDisposition, String url) {
        String fileName = "";
        try {
            fileName = this.getFileNameByContentDisposition(contentDisposition);
            if (TextUtils.isEmpty((CharSequence)fileName) && !TextUtils.isEmpty((CharSequence)url)) {
                Uri mUri = Uri.parse((String)url);
                fileName = mUri.getPath().substring(mUri.getPath().lastIndexOf(47) + 1);
            }
            if (!TextUtils.isEmpty((CharSequence)fileName) && fileName.length() > 64) {
                fileName = fileName.substring(fileName.length() - 64, fileName.length());
            }
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = AgentWebUtils.md5((String)url);
            }
            if (fileName.contains("\"")) {
                fileName = fileName.replace("\"", "");
            }
            return AgentWebUtils.createFileByName((Context)this.mContext, (String)fileName, (!this.mCloneExtraServiceImpl.isOpenBreakPointDownload() ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            if (LogUtils.isDebug()) {
                LogUtils.i((String)TAG, (String)("fileName:" + fileName));
                e.printStackTrace();
            }
            return null;
        }
    }

    private String getFileNameByContentDisposition(String contentDisposition) {
        if (TextUtils.isEmpty((CharSequence)contentDisposition)) {
            return "";
        }
        Matcher m = this.mPattern.matcher(contentDisposition.toLowerCase());
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static DefaultDownloadImpl create(@NonNull Activity activity, @NonNull WebView webView, @Nullable DownloadListener downloadListener, @NonNull DownloadingListener downloadingListener, @Nullable PermissionInterceptor permissionInterceptor) {
        return new ExtraServiceImpl().setActivity(activity).setWebView(webView).setDownloadListener(downloadListener).setPermissionInterceptor(permissionInterceptor).setDownloadingListener(downloadingListener).create();
    }

    public static class ExtraServiceImpl
    extends AgentWebDownloader.ExtraService
    implements Cloneable,
    Serializable {
        private transient Activity mActivity;
        private boolean mIsForceDownload = false;
        private boolean mEnableIndicator = true;
        private transient DownloadListener mDownloadListener;
        private transient PermissionInterceptor mPermissionInterceptor;
        private boolean mIsParallelDownload = true;
        private transient WebView mWebView;
        protected int mIcon = R.drawable.ic_file_download_black_24dp;
        private DefaultDownloadImpl mDefaultDownload;
        protected String mUrl;
        protected String mUserAgent;
        protected String mContentDisposition;
        protected String mMimetype;
        protected long mContentLength;
        private boolean mIsCloneObject = false;
        private transient DownloadingListener mDownloadingListener;

        public ExtraServiceImpl setDownloadingListener(DownloadingListener downloadingListener) {
            this.mDownloadingListener = downloadingListener;
            return this;
        }

        @Override
        public boolean isForceDownload() {
            return this.mIsForceDownload;
        }

        @Override
        public String getUrl() {
            return this.mUrl;
        }

        @Override
        protected ExtraServiceImpl setUrl(String url) {
            this.mUrl = url;
            return this;
        }

        @Override
        public String getUserAgent() {
            return this.mUserAgent;
        }

        @Override
        protected ExtraServiceImpl setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        @Override
        public String getContentDisposition() {
            return this.mContentDisposition;
        }

        @Override
        protected ExtraServiceImpl setContentDisposition(String contentDisposition) {
            this.mContentDisposition = contentDisposition;
            return this;
        }

        @Override
        @DrawableRes
        public int getIcon() {
            return this.mIcon;
        }

        @Override
        public String getMimetype() {
            return this.mMimetype;
        }

        @Override
        protected ExtraServiceImpl setMimetype(String mimetype) {
            this.mMimetype = mimetype;
            return this;
        }

        @Override
        public long getContentLength() {
            return this.mContentLength;
        }

        @Override
        protected ExtraServiceImpl setContentLength(long contentLength) {
            this.mContentLength = contentLength;
            return this;
        }

        ExtraServiceImpl setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        @Override
        public ExtraServiceImpl setForceDownload(boolean force) {
            this.mIsForceDownload = force;
            return this;
        }

        @Override
        public ExtraServiceImpl setEnableIndicator(boolean enableIndicator) {
            this.mEnableIndicator = enableIndicator;
            return this;
        }

        ExtraServiceImpl setDownloadListener(DownloadListener downloadListeners) {
            this.mDownloadListener = downloadListeners;
            return this;
        }

        ExtraServiceImpl setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            this.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        @Override
        public ExtraServiceImpl setIcon(@DrawableRes int icon) {
            this.mIcon = icon;
            return this;
        }

        @Override
        public ExtraServiceImpl setParallelDownload(boolean parallelDownload) {
            this.mIsParallelDownload = parallelDownload;
            return this;
        }

        @Override
        public ExtraServiceImpl setOpenBreakPointDownload(boolean openBreakPointDownload) {
            this.mIsOpenBreakPointDownload = openBreakPointDownload;
            return this;
        }

        ExtraServiceImpl setWebView(WebView webView) {
            this.mWebView = webView;
            return this;
        }

        protected ExtraServiceImpl clone() throws CloneNotSupportedException {
            ExtraServiceImpl mExtraServiceImpl = (ExtraServiceImpl)super.clone();
            mExtraServiceImpl.mIsCloneObject = true;
            mExtraServiceImpl.mActivity = null;
            mExtraServiceImpl.mDownloadListener = null;
            mExtraServiceImpl.mPermissionInterceptor = null;
            mExtraServiceImpl.mWebView = null;
            return mExtraServiceImpl;
        }

        DefaultDownloadImpl create() {
            this.mDefaultDownload = new DefaultDownloadImpl(this);
            return this.mDefaultDownload;
        }

        @Override
        public synchronized void performReDownload() {
            LogUtils.i((String)TAG, (String)("performReDownload:" + this.mDefaultDownload));
            if (null != this.mDefaultDownload) {
                this.mDefaultDownload.onDownloadStartInternal(this.getUrl(), this.getUserAgent(), this.getContentDisposition(), this.getMimetype(), this.getContentLength(), this);
            }
        }
    }

    static class ExecuteTasksMap
    extends ReentrantReadWriteLock {
        private LinkedList<String> mTasks = new LinkedList();
        private static volatile ExecuteTasksMap sInstance = null;

        private ExecuteTasksMap() {
            super(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ExecuteTasksMap getInstance() {
            if (null != sInstance) return sInstance;
            Class<ExecuteTasksMap> clazz = ExecuteTasksMap.class;
            synchronized (ExecuteTasksMap.class) {
                if (null != sInstance) return sInstance;
                sInstance = new ExecuteTasksMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }

        void removeTask(String path) {
            try {
                this.writeLock().lock();
                int position = -1;
                position = this.mTasks.indexOf(path);
                if (position == -1) {
                    return;
                }
                this.mTasks.remove(position);
                this.mTasks.remove(position - 1);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        void addTask(String url, String path) {
            try {
                this.writeLock().lock();
                this.mTasks.add(url);
                this.mTasks.add(path);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        boolean contains(String url) {
            try {
                this.readLock().lock();
                boolean bl = this.mTasks.contains(url);
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }
    }
}

