/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.download.DownloadTask;
import com.just.agentweb.download.NotificationCancelReceiver;
import com.just.agentweb.download.R;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class DownloadNotifier {
    private static final int FLAG = 4;
    int requestCode = (int)SystemClock.uptimeMillis();
    private int mNotificationId;
    private NotificationManager mNotificationManager;
    private Notification mNotification;
    private NotificationCompat.Builder mBuilder;
    private Context mContext;
    private String mChannelId = "";
    private volatile boolean mAddedCancelAction = false;
    private String mUrl;
    private File mFile;
    private static final String TAG = DownloadNotifier.class.getSimpleName();
    private NotificationCompat.Action mAction;

    DownloadNotifier(Context context, int id) {
        this.mNotificationId = id;
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mChannelId = this.mContext.getPackageName().concat("agentweb/4.0.0");
                this.mBuilder = new NotificationCompat.Builder(this.mContext, this.mChannelId);
                NotificationChannel mNotificationChannel = new NotificationChannel(this.mChannelId, (CharSequence)AgentWebUtils.getApplicationName((Context)context), 3);
                NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                mNotificationManager.createNotificationChannel(mNotificationChannel);
            } else {
                this.mBuilder = new NotificationCompat.Builder(this.mContext);
            }
        }
        catch (Throwable ignore) {
            if (LogUtils.isDebug()) {
                ignore.printStackTrace();
            }
            throw ignore;
        }
    }

    void initBuilder(DownloadTask downloadTask) {
        String title;
        String string2 = title = TextUtils.isEmpty((CharSequence)downloadTask.getFile().getName()) ? this.mContext.getString(R.string.agentweb_file_download) : downloadTask.getFile().getName();
        if (title.length() > 20) {
            title = "..." + title.substring(title.length() - 20, title.length());
        }
        this.mBuilder.setContentIntent(PendingIntent.getActivity((Context)this.mContext, (int)200, (Intent)new Intent(), (int)0x8000000));
        this.mBuilder.setSmallIcon(downloadTask.getDrawableRes());
        this.mBuilder.setTicker((CharSequence)this.mContext.getString(R.string.agentweb_trickter));
        this.mBuilder.setContentTitle((CharSequence)title);
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.agentweb_coming_soon_download));
        this.mBuilder.setWhen(System.currentTimeMillis());
        this.mBuilder.setAutoCancel(true);
        this.mBuilder.setPriority(2);
        int defaults = 0;
        this.mUrl = downloadTask.getUrl();
        this.mFile = downloadTask.getFile();
        this.mBuilder.setDeleteIntent(this.buildCancelContent(this.mContext, downloadTask.getId(), downloadTask.getUrl()));
        this.mBuilder.setDefaults(defaults);
    }

    private PendingIntent buildCancelContent(Context context, int id, String url) {
        Intent intentCancel = new Intent(context, NotificationCancelReceiver.class);
        intentCancel.setAction("com.agentweb.cancelled");
        intentCancel.putExtra("TAG", url);
        PendingIntent pendingIntentCancel = PendingIntent.getBroadcast((Context)context, (int)(id << 3), (Intent)intentCancel, (int)0x8000000);
        LogUtils.i((String)TAG, (String)("id<<3:" + (id << 3)));
        return pendingIntentCancel;
    }

    private void setProgress(int maxprogress, int currentprogress, boolean exc) {
        this.mBuilder.setProgress(maxprogress, currentprogress, exc);
        this.sent();
    }

    private boolean hasDeleteContent() {
        return this.mBuilder.getNotification().deleteIntent != null;
    }

    private void setDelecte(PendingIntent intent) {
        this.mBuilder.getNotification().deleteIntent = intent;
    }

    private void sent() {
        this.mNotification = this.mBuilder.build();
        this.mNotificationManager.notify(this.mNotificationId, this.mNotification);
    }

    void onPreDownload() {
        this.sent();
    }

    void onDownloading(int progress) {
        if (!this.hasDeleteContent()) {
            this.setDelecte(this.buildCancelContent(this.mContext, this.mNotificationId, this.mUrl));
        }
        if (!this.mAddedCancelAction) {
            this.mAddedCancelAction = true;
            this.mAction = new NotificationCompat.Action(R.drawable.ic_cancel_transparent_2dp, (CharSequence)this.mContext.getString(0x1040000), this.buildCancelContent(this.mContext, this.mNotificationId, this.mUrl));
            this.mBuilder.addAction(this.mAction);
        }
        this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.agentweb_current_downloading_progress, new Object[]{progress + "%"}));
        this.setProgress(100, progress, false);
        this.sent();
    }

    void onDownloadFinished() {
        block6: {
            try {
                Class<?> clazz = this.mBuilder.getClass();
                Field mField = clazz.getDeclaredField("mActions");
                ArrayList mActions = null;
                if (null != mField) {
                    mActions = (ArrayList)mField.get(this.mBuilder);
                }
                int index = -1;
                if (null != mActions && (index = mActions.indexOf(this.mAction)) != -1) {
                    mActions.remove(index);
                }
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block6;
                ignore.printStackTrace();
            }
        }
        Intent mIntent = AgentWebUtils.getCommonFileIntentCompat((Context)this.mContext, (File)this.mFile);
        this.setDelecte(null);
        if (null != mIntent) {
            if (!(this.mContext instanceof Activity)) {
                mIntent.addFlags(0x10000000);
            }
            PendingIntent rightPendIntent = PendingIntent.getActivity((Context)this.mContext, (int)(this.mNotificationId << 4), (Intent)mIntent, (int)0x8000000);
            this.mBuilder.setContentText((CharSequence)this.mContext.getString(R.string.agentweb_click_open));
            this.mBuilder.setProgress(100, 100, false);
            this.mBuilder.setContentIntent(rightPendIntent);
            this.sent();
        }
    }

    void cancel() {
        this.mNotificationManager.cancel(this.mNotificationId);
    }
}

