/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.support.annotation.DrawableRes;
import android.util.ArrayMap;
import com.just.agentweb.download.DownloadingService;
import java.io.Serializable;
import java.util.Map;

public interface AgentWebDownloader<T extends Extra>
extends DownloadingService {
    public void download(T var1);

    public static abstract class ExtraService
    extends Extra {
        public abstract void performReDownload();
    }

    public static abstract class Extra
    implements Serializable {
        protected boolean mIsForceDownload = false;
        protected boolean mEnableIndicator = true;
        @DrawableRes
        protected int mIcon = -1;
        protected boolean mIsParallelDownload = true;
        protected boolean mIsOpenBreakPointDownload = true;
        protected String mUrl;
        protected String mUserAgent;
        protected String mContentDisposition;
        protected String mMimetype;
        protected long mContentLength;
        protected Map<String, String> mHeaders;
        protected boolean mAutoOpen = false;
        protected long downloadTimeOut = Long.MAX_VALUE;
        protected int connectTimeOut = 10000;
        protected int blockMaxTime = 600000;

        public Map<String, String> getHeaders() {
            return this.mHeaders;
        }

        public Extra setHeaders(Map<String, String> headers) {
            this.mHeaders = headers;
            return this;
        }

        protected Extra() {
        }

        public int getBlockMaxTime() {
            return this.blockMaxTime;
        }

        public Extra setBlockMaxTime(int blockMaxTime) {
            this.blockMaxTime = blockMaxTime;
            return this;
        }

        public String getUrl() {
            return this.mUrl;
        }

        protected Extra setUrl(String url) {
            this.mUrl = url;
            return this;
        }

        public String getUserAgent() {
            return this.mUserAgent;
        }

        protected Extra setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public String getContentDisposition() {
            return this.mContentDisposition;
        }

        protected Extra setContentDisposition(String contentDisposition) {
            this.mContentDisposition = contentDisposition;
            return this;
        }

        public String getMimetype() {
            return this.mMimetype;
        }

        protected Extra setMimetype(String mimetype) {
            this.mMimetype = mimetype;
            return this;
        }

        public long getContentLength() {
            return this.mContentLength;
        }

        protected Extra setContentLength(long contentLength) {
            this.mContentLength = contentLength;
            return this;
        }

        public boolean isForceDownload() {
            return this.mIsForceDownload;
        }

        public boolean isEnableIndicator() {
            return this.mEnableIndicator;
        }

        public long getDownloadTimeOut() {
            return this.downloadTimeOut;
        }

        public Extra setDownloadTimeOut(long downloadTimeOut) {
            this.downloadTimeOut = downloadTimeOut;
            return this;
        }

        public int getConnectTimeOut() {
            return this.connectTimeOut;
        }

        public Extra setConnectTimeOut(int connectTimeOut) {
            this.connectTimeOut = connectTimeOut;
            return this;
        }

        public int getIcon() {
            return this.mIcon;
        }

        public boolean isParallelDownload() {
            return this.mIsParallelDownload;
        }

        public boolean isOpenBreakPointDownload() {
            return this.mIsOpenBreakPointDownload;
        }

        public Extra setOpenBreakPointDownload(boolean openBreakPointDownload) {
            this.mIsOpenBreakPointDownload = openBreakPointDownload;
            return this;
        }

        public Extra setForceDownload(boolean force) {
            this.mIsForceDownload = force;
            return this;
        }

        public Extra setEnableIndicator(boolean enableIndicator) {
            this.mEnableIndicator = enableIndicator;
            return this;
        }

        public Extra setIcon(@DrawableRes int icon) {
            this.mIcon = icon;
            return this;
        }

        public Extra setParallelDownload(boolean parallelDownload) {
            this.mIsParallelDownload = parallelDownload;
            return this;
        }

        public Extra addHeader(String key, String value) {
            if (this.mHeaders == null) {
                this.mHeaders = new ArrayMap();
            }
            this.mHeaders.put(key, value);
            return this;
        }

        public Extra setAutoOpen(boolean autoOpen) {
            this.mAutoOpen = autoOpen;
            return this;
        }

        public boolean isAutoOpen() {
            return this.mAutoOpen;
        }
    }
}

