/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.SparseArray;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.download.AgentWebDownloader;
import com.just.agentweb.download.AgentWebNotification;
import com.just.agentweb.download.CancelDownloadInformer;
import com.just.agentweb.download.CancelDownloadRecipient;
import com.just.agentweb.download.DefaultDownloadImpl;
import com.just.agentweb.download.DownloadListenerAdapter;
import com.just.agentweb.download.DownloadTask;
import com.just.agentweb.download.ExecutorProvider;
import com.just.agentweb.download.NotificationCancelReceiver;
import com.just.agentweb.download.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Downloader
extends AsyncTask<Void, Integer, Integer>
implements AgentWebDownloader<DownloadTask>,
CancelDownloadRecipient {
    private volatile DownloadTask mDownloadTask;
    private volatile long loaded = 0L;
    private long totals = -1L;
    private long tmp = 0L;
    private long mUsedTime = 0L;
    private long mLastTime = 0L;
    private volatile long mBeginTime = 0L;
    private volatile long mAverageSpeed = 0L;
    private Exception e;
    private long downloadTimeOut = Long.MAX_VALUE;
    private int connectTimeOut = 10000;
    private AgentWebNotification mAgentWebNotification;
    private static final int ERROR_LOAD = 1030;
    private static final String TAG = Downloader.class.getSimpleName();
    private AtomicBoolean isCancel = new AtomicBoolean(false);
    private AtomicBoolean isShutdown = new AtomicBoolean(false);
    public static final int ERROR_NETWORK_CONNECTION = 1024;
    public static final int ERROR_NETWORK_STATUS = 1025;
    public static final int ERROR_STORAGE = 1026;
    public static final int ERROR_SHUTDOWN = 1029;
    public static final int ERROR_TIME_OUT = 1027;
    public static final int ERROR_USER_CANCEL = 1028;
    public static final int SUCCESSFUL = 512;
    private static final SparseArray<String> DOWNLOAD_MESSAGE = new SparseArray();

    Downloader() {
    }

    private void checkNullTask(DownloadTask downloadTask) {
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.mDownloadTask.getDownloadListener() != null) {
            this.mDownloadTask.getDownloadListener().onBindService(this.mDownloadTask.getUrl(), this);
        }
        CancelDownloadInformer.getInformer().addRecipient(this.mDownloadTask.getUrl(), this);
        this.buildNotify(new Intent(), this.mDownloadTask.getId(), this.mDownloadTask.getContext().getString(R.string.agentweb_coming_soon_download));
    }

    private boolean checkSpace() {
        if (this.mDownloadTask.getLength() - this.mDownloadTask.getFile().length() > AgentWebUtils.getAvailableStorage()) {
            LogUtils.i((String)TAG, (String)" \u7a7a\u95f4\u4e0d\u8db3");
            return false;
        }
        return true;
    }

    private boolean checkNet() {
        if (!this.mDownloadTask.isForce()) {
            return AgentWebUtils.checkWifi((Context)this.mDownloadTask.getContext());
        }
        return AgentWebUtils.checkNetwork((Context)this.mDownloadTask.getContext());
    }

    protected Integer doInBackground(Void ... params) {
        int result;
        block4: {
            result = 1030;
            try {
                this.mBeginTime = System.currentTimeMillis();
                if (!this.checkSpace()) {
                    return 1026;
                }
                if (!this.checkNet()) {
                    return 1024;
                }
                result = this.doDownload();
            }
            catch (Exception e) {
                this.e = e;
                if (!LogUtils.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload() throws IOException {
        HttpURLConnection mHttpURLConnection = this.createUrlConnection(this.mDownloadTask.getUrl());
        if (this.mDownloadTask.getFile().length() > 0L) {
            this.tmp = this.mDownloadTask.getFile().length();
            mHttpURLConnection.addRequestProperty("Range", "bytes=" + this.tmp + "-");
        }
        try {
            mHttpURLConnection.connect();
            boolean isSeek = false;
            int resCode = mHttpURLConnection.getResponseCode();
            if (resCode != 200 && resCode != 206) {
                int n = 1025;
                return n;
            }
            isSeek = resCode == 206;
            LogUtils.i((String)TAG, (String)("response code:" + mHttpURLConnection.getResponseCode()));
            int n = this.doDownload(mHttpURLConnection.getInputStream(), new LoadingRandomAccessFile(this.mDownloadTask.getFile()), isSeek);
            return n;
        }
        finally {
            if (mHttpURLConnection != null) {
                mHttpURLConnection.disconnect();
            }
        }
    }

    private HttpURLConnection createUrlConnection(String url) throws IOException {
        HttpURLConnection mHttpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        mHttpURLConnection.setRequestProperty("Accept", "application/*");
        mHttpURLConnection.setConnectTimeout(this.connectTimeOut);
        LogUtils.i((String)TAG, (String)("getDownloadTimeOut:" + this.mDownloadTask.getDownloadTimeOut()));
        mHttpURLConnection.setReadTimeout(this.mDownloadTask.getBlockMaxTime());
        return mHttpURLConnection;
    }

    protected synchronized void onProgressUpdate(Integer ... values) {
        try {
            long currentTime = System.currentTimeMillis();
            this.mUsedTime = currentTime - this.mBeginTime;
            this.mAverageSpeed = this.mUsedTime == 0L ? 0L : this.loaded * 1000L / this.mUsedTime;
            if (currentTime - this.mLastTime < 800L) {
                return;
            }
            this.mLastTime = currentTime;
            if (null != this.mAgentWebNotification) {
                if (!this.mAgentWebNotification.hasDeleteContent()) {
                    this.mAgentWebNotification.setDelecte(this.buildCancelContent(this.mDownloadTask.getContext().getApplicationContext(), this.mDownloadTask.getId()));
                }
                int mProgress = (int)((float)(this.tmp + this.loaded) / Float.valueOf(this.totals).floatValue() * 100.0f);
                this.mAgentWebNotification.setContentText(this.mDownloadTask.getContext().getString(R.string.agentweb_current_downloading_progress, new Object[]{mProgress + "%"}));
                this.mAgentWebNotification.setProgress(100, mProgress, false);
            }
            if (this.mDownloadTask.getDownloadListener() != null) {
                this.mDownloadTask.getDownloadListener().progress(this.mDownloadTask.getUrl(), this.tmp + this.loaded, this.totals, this.mUsedTime);
            }
        }
        catch (UnknownFormatConversionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Integer integer) {
        block21: {
            try {
                LogUtils.i((String)TAG, (String)("onPostExecute:" + integer));
                CancelDownloadInformer.getInformer().removeRecipient(this.mDownloadTask.getUrl());
                if (this.mDownloadTask.getDownloadListener() != null) {
                    this.mDownloadTask.getDownloadListener().progress(this.mDownloadTask.getUrl(), this.tmp + this.loaded, this.totals, this.mUsedTime);
                }
                if (this.mDownloadTask.getDownloadListener() != null) {
                    this.mDownloadTask.getDownloadListener().onUnbindService(this.mDownloadTask.getUrl(), this);
                }
                boolean isCancelDispose = this.doCallback(integer);
                if (integer > 512) {
                    if (this.mAgentWebNotification != null) {
                        this.mAgentWebNotification.cancel(this.mDownloadTask.getId());
                    }
                    return;
                }
                if (!this.mDownloadTask.isEnableIndicator()) break block21;
                if (this.mAgentWebNotification != null) {
                    this.mAgentWebNotification.cancel(this.mDownloadTask.getId());
                }
                if (isCancelDispose) {
                    return;
                }
                Intent mIntent = AgentWebUtils.getCommonFileIntentCompat((Context)this.mDownloadTask.getContext(), (File)this.mDownloadTask.getFile());
                try {
                    if (mIntent != null) {
                        if (!(this.mDownloadTask.getContext() instanceof Activity)) {
                            mIntent.addFlags(0x10000000);
                        }
                        PendingIntent rightPendIntent = PendingIntent.getActivity((Context)this.mDownloadTask.getContext(), (int)(this.mDownloadTask.getId() << 4), (Intent)mIntent, (int)0x8000000);
                        this.mAgentWebNotification.setProgressFinish(this.mDownloadTask.getContext().getString(R.string.agentweb_click_open), rightPendIntent);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        if (LogUtils.isDebug()) {
                            throwable.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        if (LogUtils.isDebug()) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                if (this.mDownloadTask != null) {
                    this.mDownloadTask.destroy();
                }
            }
        }
    }

    private boolean doCallback(Integer code) {
        DownloadListenerAdapter mDownloadListener = null;
        mDownloadListener = this.mDownloadTask.getDownloadListener();
        if (mDownloadListener == null) {
            LogUtils.e((String)TAG, (String)"DownloadListener has been death");
            DefaultDownloadImpl.ExecuteTasksMap.getInstance().removeTask(this.mDownloadTask.getFile().getPath());
            return false;
        }
        return mDownloadListener.result(this.mDownloadTask.getFile().getAbsolutePath(), this.mDownloadTask.getUrl(), code <= 200 ? null : (this.e == null ? new RuntimeException("Download failed \uff0c cause:" + (String)DOWNLOAD_MESSAGE.get(code.intValue())) : this.e));
    }

    private void buildNotify(Intent intent, int id, String progressHint) {
        Context mContext = this.mDownloadTask.getContext().getApplicationContext();
        if (mContext != null && this.mDownloadTask.isEnableIndicator()) {
            String title;
            intent.setFlags(0x10000000);
            PendingIntent rightPendIntent = PendingIntent.getActivity((Context)mContext, (int)(51 * id), (Intent)intent, (int)0x8000000);
            int smallIcon = this.mDownloadTask.getDrawableRes();
            String ticker = mContext.getString(R.string.agentweb_trickter);
            this.mAgentWebNotification = new AgentWebNotification(mContext, id);
            String string2 = title = TextUtils.isEmpty((CharSequence)this.mDownloadTask.getFile().getName()) ? mContext.getString(R.string.agentweb_file_download) : this.mDownloadTask.getFile().getName();
            if (title.length() > 20) {
                title = "..." + title.substring(title.length() - 20, title.length());
            }
            this.mAgentWebNotification.notifyProgress(rightPendIntent, smallIcon, ticker, title, progressHint, false, false, false, this.buildCancelContent(mContext, id));
            this.mAgentWebNotification.sent();
        }
    }

    private PendingIntent buildCancelContent(Context context, int id) {
        Intent intentCancel = new Intent(context, NotificationCancelReceiver.class);
        intentCancel.setAction("com.agentweb.cancelled");
        intentCancel.putExtra("type", "type");
        intentCancel.putExtra("TAG", this.mDownloadTask.getUrl());
        PendingIntent pendingIntentCancel = PendingIntent.getBroadcast((Context)context, (int)(id << 3), (Intent)intentCancel, (int)0x8000000);
        LogUtils.i((String)TAG, (String)("id<<3:" + (id << 3)));
        return pendingIntentCancel;
    }

    /*
     * Exception decompiling
     */
    private int doDownload(InputStream inputStream, RandomAccessFile randomAccessFile, boolean isSeek) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 43[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void cancel() {
        this.isCancel.set(true);
    }

    @Override
    public synchronized boolean isShutdown() {
        LogUtils.i((String)TAG, (String)("" + this.isShutdown.get() + "  " + this.isCancel.get() + "  :" + (this.getStatus() == AsyncTask.Status.FINISHED)));
        return this.isShutdown.get() || this.isCancel.get() || this.getStatus() == AsyncTask.Status.FINISHED;
    }

    @Override
    public synchronized AgentWebDownloader.ExtraService shutdownNow() {
        if (this.getStatus() == AsyncTask.Status.FINISHED) {
            LogUtils.e((String)TAG, (String)"  Termination failed , becauce the downloader already dead !!! ");
            return null;
        }
        try {
            DefaultDownloadImpl.ExtraServiceImpl mExtraService;
            DefaultDownloadImpl.ExtraServiceImpl extraServiceImpl = mExtraService = this.mDownloadTask.getExtraServiceImpl();
            return extraServiceImpl;
        }
        finally {
            this.isShutdown.set(true);
        }
    }

    @Override
    public void download(DownloadTask downloadTask) {
        this.downloadInternal(downloadTask);
    }

    private final void downloadInternal(DownloadTask downloadTask) {
        this.checkNullTask(downloadTask);
        this.mDownloadTask = downloadTask;
        this.totals = this.mDownloadTask.getLength();
        this.downloadTimeOut = this.mDownloadTask.getDownloadTimeOut();
        this.connectTimeOut = this.mDownloadTask.getConnectTimeOut();
        LogUtils.i((String)TAG, (String)("connectTimeOut:" + this.connectTimeOut + " downloadTimeOut:" + this.downloadTimeOut));
        if (downloadTask.isParallelDownload()) {
            this.executeOnExecutor(ExecutorProvider.getInstance().provide(), null);
        } else {
            this.execute(new Void[0]);
        }
    }

    @Override
    public void cancelDownload() {
        this.cancel();
    }

    static {
        DOWNLOAD_MESSAGE.append(1024, (Object)"Network connection error . ");
        DOWNLOAD_MESSAGE.append(1025, (Object)"Connection status code non-200 and non-206 .");
        DOWNLOAD_MESSAGE.append(1026, (Object)"Insufficient memory space . ");
        DOWNLOAD_MESSAGE.append(1029, (Object)"Shutdown . ");
        DOWNLOAD_MESSAGE.append(1027, (Object)"Download time is overtime . ");
        DOWNLOAD_MESSAGE.append(1028, (Object)"The user canceled the download .");
        DOWNLOAD_MESSAGE.append(1030, (Object)"Unkown Error . ");
        DOWNLOAD_MESSAGE.append(512, (Object)"Download successful . ");
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            Downloader.this.loaded = Downloader.this.loaded + (long)count;
            Downloader.this.publishProgress(new Integer[]{0});
        }
    }
}

