/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.content.Context;
import android.support.annotation.DrawableRes;
import com.just.agentweb.LogUtils;
import com.just.agentweb.download.AgentWebDownloader;
import com.just.agentweb.download.DefaultDownloadImpl;
import com.just.agentweb.download.DownloadListenerAdapter;
import com.just.agentweb.download.R;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadTask
extends AgentWebDownloader.Extra
implements Serializable {
    private int id;
    private Context mContext;
    private File mFile;
    private WeakReference<DownloadListenerAdapter> mDownloadWR = null;
    private AtomicBoolean isDestroy = new AtomicBoolean(false);
    private WeakReference<DefaultDownloadImpl.ExtraServiceImpl> mExtraServiceImpl = null;
    private String TAG = this.getClass().getSimpleName();
    private DefaultDownloadImpl.ExtraServiceImpl mCloneExtraService;

    public DownloadTask(int id, DownloadListenerAdapter downloadListeners, Context context, File file, DefaultDownloadImpl.ExtraServiceImpl extraServiceImpl) {
        this.id = id;
        this.mContext = context;
        this.mFile = file;
        this.mDownloadWR = new WeakReference<DownloadListenerAdapter>(downloadListeners);
        this.isParallelDownload = extraServiceImpl.isParallelDownload();
        try {
            this.mCloneExtraService = extraServiceImpl.clone();
            this.mExtraServiceImpl = new WeakReference<DefaultDownloadImpl.ExtraServiceImpl>(extraServiceImpl);
        }
        catch (CloneNotSupportedException e) {
            if (LogUtils.isDebug()) {
                e.printStackTrace();
            }
            this.mCloneExtraService = extraServiceImpl;
        }
    }

    public DefaultDownloadImpl.ExtraServiceImpl getExtraServiceImpl() {
        return (DefaultDownloadImpl.ExtraServiceImpl)this.mExtraServiceImpl.get();
    }

    @Override
    public boolean isParallelDownload() {
        return this.mCloneExtraService.isParallelDownload();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.mCloneExtraService.getUrl();
    }

    public boolean isForce() {
        return this.mCloneExtraService.isForceDownload();
    }

    @Override
    public boolean isEnableIndicator() {
        return this.mCloneExtraService.isEnableIndicator();
    }

    public WeakReference<DownloadListenerAdapter> getDownloadWR() {
        return this.mDownloadWR;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public File getFile() {
        return this.mFile;
    }

    public void setFile(File file) {
        this.mFile = file;
    }

    public long getLength() {
        return this.mCloneExtraService.getContentLength();
    }

    @DrawableRes
    public int getDrawableRes() {
        return this.mCloneExtraService.getIcon() == -1 ? R.drawable.ic_file_download_black_24dp : this.mCloneExtraService.getIcon();
    }

    public DownloadListenerAdapter getDownloadListener() {
        return (DownloadListenerAdapter)this.mDownloadWR.get();
    }

    @Override
    public int getBlockMaxTime() {
        return this.mCloneExtraService.getBlockMaxTime();
    }

    @Override
    public int getConnectTimeOut() {
        return this.mCloneExtraService.getConnectTimeOut();
    }

    @Override
    public long getDownloadTimeOut() {
        return this.mCloneExtraService.getDownloadTimeOut();
    }

    public boolean isDestroy() {
        return null == this.isDestroy || this.isDestroy.get();
    }

    public void destroy() {
        this.isDestroy.set(true);
        this.id = -1;
        this.url = null;
        this.mContext = null;
        this.mFile = null;
        this.mDownloadWR = null;
        this.isParallelDownload = false;
        if (this.mExtraServiceImpl.get() != null) {
            this.mExtraServiceImpl.clear();
        }
        this.mExtraServiceImpl = null;
        this.isDestroy = null;
        this.mCloneExtraService = null;
    }
}

