/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.WebView;
import com.just.agentweb.Action;
import com.just.agentweb.ActionActivity;
import com.just.agentweb.AgentWebPermissions;
import com.just.agentweb.AgentWebUIController;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.PermissionInterceptor;
import com.just.agentweb.download.AgentWebDownloader;
import com.just.agentweb.download.DownloadListener;
import com.just.agentweb.download.DownloadListenerAdapter;
import com.just.agentweb.download.DownloadTask;
import com.just.agentweb.download.Downloader;
import com.just.agentweb.download.DownloadingListener;
import com.just.agentweb.download.DownloadingService;
import com.just.agentweb.download.R;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDownloadImpl
extends DownloadListenerAdapter
implements android.webkit.DownloadListener {
    private Context mContext;
    private static volatile AtomicInteger NOTICATION_ID = new AtomicInteger(1);
    private DownloadListener mDownloadListener;
    private WeakReference<Activity> mActivityWeakReference = null;
    private static final String TAG = DefaultDownloadImpl.class.getSimpleName();
    private PermissionInterceptor mPermissionListener = null;
    private String url;
    private String contentDisposition;
    private long contentLength;
    private String mimetype;
    private WeakReference<AgentWebUIController> mAgentWebUIController;
    private ExtraServiceImpl mExtraServiceImpl;
    private String userAgent;
    private ExtraServiceImpl mCloneExtraServiceImpl = null;
    private DownloadingListener mDownloadingListener;

    DefaultDownloadImpl(ExtraServiceImpl extraServiceImpl) {
        if (!extraServiceImpl.isCloneObject) {
            this.bind(extraServiceImpl);
            this.mExtraServiceImpl = extraServiceImpl;
        } else {
            this.mCloneExtraServiceImpl = extraServiceImpl;
        }
    }

    private void bind(ExtraServiceImpl extraServiceImpl) {
        this.mActivityWeakReference = new WeakReference<Activity>(extraServiceImpl.mActivity);
        this.mContext = extraServiceImpl.mActivity.getApplicationContext();
        this.mDownloadListener = extraServiceImpl.mDownloadListener;
        this.mDownloadingListener = extraServiceImpl.downloadingListener;
        this.mPermissionListener = extraServiceImpl.mPermissionInterceptor;
        this.mAgentWebUIController = new WeakReference<AgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView((WebView)extraServiceImpl.mWebView));
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        this.onDownloadStartInternal(url, userAgent, contentDisposition, mimetype, contentLength, null);
    }

    private synchronized void onDownloadStartInternal(String url, String userAgent, String contentDisposition, String mimetype, long contentLength, ExtraServiceImpl extraServiceImpl) {
        if (null == this.mActivityWeakReference.get() || ((Activity)this.mActivityWeakReference.get()).isFinishing()) {
            return;
        }
        if (null != this.mPermissionListener && this.mPermissionListener.intercept(url, AgentWebPermissions.STORAGE, "download")) {
            return;
        }
        LogUtils.i((String)TAG, (String)("mimetype:" + mimetype));
        this.url = url;
        this.contentDisposition = contentDisposition;
        this.contentLength = contentLength;
        this.mimetype = mimetype;
        this.userAgent = userAgent;
        ExtraServiceImpl mCloneExtraServiceImpl = null;
        if (null == extraServiceImpl) {
            try {
                mCloneExtraServiceImpl = this.mExtraServiceImpl.clone();
            }
            catch (CloneNotSupportedException ignore) {
                if (LogUtils.isDebug()) {
                    ignore.printStackTrace();
                }
                LogUtils.i((String)TAG, (String)" clone object failure !!! ");
                return;
            }
        } else {
            mCloneExtraServiceImpl = extraServiceImpl;
        }
        mCloneExtraServiceImpl.setUrl(this.url).setMimetype(this.mimetype).setContentDisposition(this.contentDisposition).setContentLength(this.contentLength).setUserAgent(this.userAgent);
        this.mCloneExtraServiceImpl = mCloneExtraServiceImpl;
        LogUtils.i((String)TAG, (String)(" clone a extraServiceImpl : " + this.mCloneExtraServiceImpl.mWebView + "  aty:" + this.mCloneExtraServiceImpl.mActivity + "  :" + this.mCloneExtraServiceImpl.getMimetype()));
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> mList = null;
            mList = this.checkNeedPermission();
            if (mList.isEmpty()) {
                this.preDownload();
            } else {
                Action mAction = Action.createPermissionsAction((String[])mList.toArray(new String[0]));
                ActionActivity.setPermissionListener((ActionActivity.PermissionListener)this.getPermissionListener());
                ActionActivity.start((Activity)((Activity)this.mActivityWeakReference.get()), (Action)mAction);
            }
        } else {
            this.preDownload();
        }
    }

    private ActionActivity.PermissionListener getPermissionListener() {
        return new ActionActivity.PermissionListener(){

            public void onRequestPermissionsResult(@NonNull String[] permissions, @NonNull int[] grantResults, Bundle extras) {
                if (DefaultDownloadImpl.this.checkNeedPermission().isEmpty()) {
                    DefaultDownloadImpl.this.preDownload();
                } else {
                    LogUtils.e((String)TAG, (String)"\u50a8\u5b58\u6743\u9650\u83b7\u53d6\u5931\u8d25~");
                }
            }
        };
    }

    private List<String> checkNeedPermission() {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        if (!AgentWebUtils.hasPermission((Context)((Context)this.mActivityWeakReference.get()), (String[])AgentWebPermissions.STORAGE)) {
            deniedPermissions.addAll(Arrays.asList(AgentWebPermissions.STORAGE));
        }
        return deniedPermissions;
    }

    private void preDownload() {
        File mFile;
        block11: {
            if (null != this.mDownloadListener && this.mDownloadListener.start(this.url, this.userAgent, this.contentDisposition, this.mimetype, this.contentLength, this.mCloneExtraServiceImpl)) {
                return;
            }
            mFile = this.getFile(this.contentDisposition, this.url);
            if (null == mFile) {
                LogUtils.i((String)TAG, (String)"\u65b0\u5efa\u6587\u4ef6\u5931\u8d25");
                return;
            }
            if (mFile.exists() && mFile.length() >= this.contentLength) {
                if (null != this.mDownloadListener && this.mDownloadListener.result(mFile.getAbsolutePath(), this.url, null)) {
                    return;
                }
                Intent mIntent = AgentWebUtils.getCommonFileIntentCompat((Context)this.mContext, (File)mFile);
                try {
                    if (mIntent != null) {
                        if (!(this.mContext instanceof Activity)) {
                            mIntent.addFlags(0x10000000);
                        }
                        this.mContext.startActivity(mIntent);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (!LogUtils.isDebug()) break block11;
                    throwable.printStackTrace();
                }
            }
        }
        if (ExecuteTasksMap.getInstance().contains(this.url) || ExecuteTasksMap.getInstance().contains(mFile.getAbsolutePath())) {
            if (this.mAgentWebUIController.get() != null) {
                ((AgentWebUIController)this.mAgentWebUIController.get()).showMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_download_task_has_been_exist), TAG.concat("|preDownload"));
            }
            return;
        }
        if (!this.mCloneExtraServiceImpl.isForceDownload() && AgentWebUtils.checkNetworkType((Context)this.mContext) > 1) {
            this.showDialog(mFile);
            return;
        }
        this.performDownload(mFile);
    }

    private void forceDownload(File file) {
        this.mCloneExtraServiceImpl.setForceDownload(true);
        this.performDownload(file);
    }

    private void showDialog(File file) {
        Activity mActivity = (Activity)this.mActivityWeakReference.get();
        if (null == mActivity || mActivity.isFinishing()) {
            return;
        }
        AgentWebUIController mAgentWebUIController = (AgentWebUIController)this.mAgentWebUIController.get();
        if (mAgentWebUIController != null) {
            mAgentWebUIController.onForceDownloadAlert(this.url, this.createCallback(file));
        }
    }

    private Handler.Callback createCallback(final File file) {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                DefaultDownloadImpl.this.forceDownload(file);
                return true;
            }
        };
    }

    private void performDownload(File file) {
        block3: {
            try {
                ExecuteTasksMap.getInstance().addTask(this.url, file.getAbsolutePath());
                if (null != this.mAgentWebUIController.get()) {
                    ((AgentWebUIController)this.mAgentWebUIController.get()).showMessage(((Activity)this.mActivityWeakReference.get()).getString(R.string.agentweb_coming_soon_download) + ":" + file.getName(), TAG.concat("|performDownload"));
                }
                DownloadTask mDownloadTask = new DownloadTask(NOTICATION_ID.incrementAndGet(), this, this.mContext, file, this.mCloneExtraServiceImpl);
                new Downloader().download(mDownloadTask);
                this.url = null;
                this.contentDisposition = null;
                this.contentLength = -1L;
                this.mimetype = null;
                this.userAgent = null;
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block3;
                ignore.printStackTrace();
            }
        }
    }

    private File getFile(String contentDisposition, String url) {
        try {
            String fileName = this.getFileNameByContentDisposition(contentDisposition);
            if (TextUtils.isEmpty((CharSequence)fileName) && !TextUtils.isEmpty((CharSequence)url)) {
                Uri mUri = Uri.parse((String)url);
                fileName = mUri.getPath().substring(mUri.getPath().lastIndexOf(47) + 1);
            }
            if (!TextUtils.isEmpty((CharSequence)fileName) && fileName.length() > 64) {
                fileName = fileName.substring(fileName.length() - 64, fileName.length());
            }
            if (TextUtils.isEmpty((CharSequence)fileName)) {
                fileName = AgentWebUtils.md5((String)url);
            }
            if (fileName.contains("\"")) {
                fileName = fileName.replace("\"", "");
            }
            return AgentWebUtils.createFileByName((Context)this.mContext, (String)fileName, (!this.mCloneExtraServiceImpl.isOpenBreakPointDownload() ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            if (LogUtils.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private String getFileNameByContentDisposition(String contentDisposition) {
        if (TextUtils.isEmpty((CharSequence)contentDisposition)) {
            return "";
        }
        Matcher m = Pattern.compile(".*filename=(.*)").matcher(contentDisposition.toLowerCase());
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progress(String url, long downloaded, long length, long useTime) {
        if (null != this.mDownloadingListener) {
            DownloadingListener downloadingListener = this.mDownloadingListener;
            synchronized (downloadingListener) {
                if (null != this.mDownloadingListener) {
                    this.mDownloadingListener.progress(url, downloaded, length, useTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBindService(String url, DownloadingService downloadingService) {
        if (null != this.mDownloadingListener) {
            DownloadingListener downloadingListener = this.mDownloadingListener;
            synchronized (downloadingListener) {
                this.mDownloadingListener.onBindService(url, downloadingService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnbindService(String url, DownloadingService downloadingService) {
        if (null != this.mDownloadingListener) {
            DownloadingListener downloadingListener = this.mDownloadingListener;
            synchronized (downloadingListener) {
                this.mDownloadingListener.onUnbindService(url, downloadingService);
            }
        }
    }

    @Override
    public boolean result(String path, String url, Throwable e) {
        ExecuteTasksMap.getInstance().removeTask(path);
        return null != this.mDownloadListener && this.mDownloadListener.result(path, url, e);
    }

    public static DefaultDownloadImpl create(Activity activity, WebView webView, DownloadListener downloadListener, DownloadingListener downloadingListener, PermissionInterceptor permissionInterceptor) {
        return new ExtraServiceImpl().setActivity(activity).setWebView(webView).setDownloadListener(downloadListener).setPermissionInterceptor(permissionInterceptor).setDownloadingListener(downloadingListener).create();
    }

    public static class ExtraServiceImpl
    extends AgentWebDownloader.ExtraService
    implements Cloneable,
    Serializable {
        private transient Activity mActivity;
        private boolean isForceDownload = false;
        private boolean enableIndicator = true;
        private transient DownloadListener mDownloadListener;
        private transient PermissionInterceptor mPermissionInterceptor;
        private boolean isParallelDownload = true;
        private transient WebView mWebView;
        protected int icon = R.drawable.ic_file_download_black_24dp;
        private DefaultDownloadImpl mDefaultDownload;
        protected String url;
        protected String userAgent;
        protected String contentDisposition;
        protected String mimetype;
        protected long contentLength;
        private boolean isCloneObject = false;
        private DownloadingListener downloadingListener;

        public ExtraServiceImpl setDownloadingListener(DownloadingListener downloadingListener) {
            this.downloadingListener = downloadingListener;
            return this;
        }

        @Override
        public boolean isForceDownload() {
            return this.isForceDownload;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        protected ExtraServiceImpl setUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        protected ExtraServiceImpl setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        protected ExtraServiceImpl setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        @DrawableRes
        public int getIcon() {
            return this.icon;
        }

        @Override
        public String getMimetype() {
            return this.mimetype;
        }

        @Override
        protected ExtraServiceImpl setMimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        protected ExtraServiceImpl setContentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        ExtraServiceImpl setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        @Override
        public ExtraServiceImpl setForceDownload(boolean force) {
            this.isForceDownload = force;
            return this;
        }

        @Override
        public ExtraServiceImpl setEnableIndicator(boolean enableIndicator) {
            this.enableIndicator = enableIndicator;
            return this;
        }

        ExtraServiceImpl setDownloadListener(DownloadListener downloadListeners) {
            this.mDownloadListener = downloadListeners;
            return this;
        }

        ExtraServiceImpl setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            this.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        @Override
        public ExtraServiceImpl setIcon(@DrawableRes int icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public ExtraServiceImpl setParallelDownload(boolean parallelDownload) {
            this.isParallelDownload = parallelDownload;
            return this;
        }

        @Override
        public ExtraServiceImpl setOpenBreakPointDownload(boolean openBreakPointDownload) {
            this.isOpenBreakPointDownload = openBreakPointDownload;
            return this;
        }

        ExtraServiceImpl setWebView(WebView webView) {
            this.mWebView = webView;
            return this;
        }

        protected ExtraServiceImpl clone() throws CloneNotSupportedException {
            ExtraServiceImpl mExtraServiceImpl = (ExtraServiceImpl)super.clone();
            mExtraServiceImpl.isCloneObject = true;
            mExtraServiceImpl.mActivity = null;
            mExtraServiceImpl.mDownloadListener = null;
            mExtraServiceImpl.mPermissionInterceptor = null;
            mExtraServiceImpl.mWebView = null;
            return mExtraServiceImpl;
        }

        DefaultDownloadImpl create() {
            this.mDefaultDownload = new DefaultDownloadImpl(this);
            return this.mDefaultDownload;
        }

        @Override
        public synchronized void performReDownload() {
            LogUtils.i((String)TAG, (String)("performReDownload:" + this.mDefaultDownload));
            if (null != this.mDefaultDownload) {
                this.mDefaultDownload.onDownloadStartInternal(this.getUrl(), this.getUserAgent(), this.getContentDisposition(), this.getMimetype(), this.getContentLength(), this);
            }
        }
    }

    public static class ExecuteTasksMap
    extends ReentrantLock {
        private LinkedList<String> mTasks = new LinkedList();
        private static ExecuteTasksMap sInstance = null;

        private ExecuteTasksMap() {
            super(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ExecuteTasksMap getInstance() {
            if (null != sInstance) return sInstance;
            Class<ExecuteTasksMap> clazz = ExecuteTasksMap.class;
            synchronized (ExecuteTasksMap.class) {
                if (null != sInstance) return sInstance;
                sInstance = new ExecuteTasksMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTask(String path) {
            int index = this.mTasks.indexOf(path);
            if (index == -1) {
                return;
            }
            try {
                this.lock();
                int position = -1;
                position = this.mTasks.indexOf(path);
                if (position == -1) {
                    return;
                }
                this.mTasks.remove(position);
                this.mTasks.remove(position - 1);
            }
            finally {
                this.unlock();
            }
        }

        void addTask(String url, String path) {
            try {
                this.lock();
                this.mTasks.add(url);
                this.mTasks.add(path);
            }
            finally {
                this.unlock();
            }
        }

        boolean contains(String url) {
            try {
                this.lock();
                boolean bl = this.mTasks.contains(url);
                return bl;
            }
            finally {
                this.unlock();
            }
        }
    }
}

