/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb.download;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;

public class AgentWebNotification {
    private static final int FLAG = 4;
    int requestCode;
    private int NOTIFICATION_ID;
    private NotificationManager nm;
    private Notification notification;
    private NotificationCompat.Builder cBuilder;
    private Context mContext;
    private String mChannelId;

    public AgentWebNotification(Context context, int ID) {
        block4: {
            this.requestCode = (int)SystemClock.uptimeMillis();
            this.mChannelId = "";
            this.NOTIFICATION_ID = ID;
            this.mContext = context;
            this.nm = (NotificationManager)this.mContext.getSystemService("notification");
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    this.mChannelId = this.mContext.getPackageName().concat("agentweb/4.0.0");
                    this.cBuilder = new NotificationCompat.Builder(this.mContext, this.mChannelId);
                    NotificationChannel mNotificationChannel = new NotificationChannel(this.mChannelId, (CharSequence)AgentWebUtils.getApplicationName((Context)context), 3);
                    NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                    mNotificationManager.createNotificationChannel(mNotificationChannel);
                } else {
                    this.cBuilder = new NotificationCompat.Builder(this.mContext);
                }
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block4;
                ignore.printStackTrace();
            }
        }
    }

    public void notifyProgress(PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights, PendingIntent pendingIntentCancel) {
        this.setCompatBuilder(pendingIntent, smallIcon, ticker, title, content, sound, vibrate, lights, pendingIntentCancel);
    }

    private void setCompatBuilder(PendingIntent pendingIntent, int smallIcon, String ticker, String title, String content, boolean sound, boolean vibrate, boolean lights, PendingIntent pendingIntentCancel) {
        this.cBuilder.setContentIntent(pendingIntent);
        this.cBuilder.setSmallIcon(smallIcon);
        this.cBuilder.setTicker((CharSequence)ticker);
        this.cBuilder.setContentTitle((CharSequence)title);
        this.cBuilder.setContentText((CharSequence)content);
        this.cBuilder.setWhen(System.currentTimeMillis());
        this.cBuilder.setAutoCancel(true);
        this.cBuilder.setPriority(2);
        int defaults = 0;
        this.cBuilder.setDeleteIntent(pendingIntentCancel);
        if (sound) {
            defaults |= 1;
        }
        if (vibrate) {
            defaults |= 2;
        }
        if (lights) {
            defaults |= 4;
        }
        this.cBuilder.setDefaults(defaults);
    }

    public void setProgress(int maxprogress, int currentprogress, boolean exc) {
        this.cBuilder.setProgress(maxprogress, currentprogress, exc);
        this.sent();
    }

    public void setContentText(String text) {
        this.cBuilder.setContentText((CharSequence)text);
    }

    public boolean hasDeleteContent() {
        return this.cBuilder.getNotification().deleteIntent != null;
    }

    public void setDelecte(PendingIntent intent) {
        this.cBuilder.getNotification().deleteIntent = intent;
    }

    public void setProgressFinish(String content, PendingIntent pendingIntent) {
        this.cBuilder.setContentText((CharSequence)content);
        this.cBuilder.setProgress(100, 100, false);
        this.cBuilder.setContentIntent(pendingIntent);
        this.sent();
    }

    void sent() {
        this.notification = this.cBuilder.build();
        this.nm.notify(this.NOTIFICATION_ID, this.notification);
    }

    public void cancel(int id) {
        this.nm.cancel(id);
    }
}

