/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;

class SimpleBlur
extends EffectFx {
    float[] _offset = new float[2];

    SimpleBlur() {
    }

    @Override
    boolean compile(GLView.Layer layer) {
        String string = "attribute vec4 aPosition;\nuniform mat4 _mvp;\nuniform vec2 singleStepOffset;\nvarying vec2 blurCoordinates[9];\nvoid main(){\n  gl_Position = _mvp*aPosition;\n  blurCoordinates[0] = gl_Position.xy*0.5+0.5;\n  blurCoordinates[1] = blurCoordinates[0]+vec2(-singleStepOffset.x,-singleStepOffset.y);\n  blurCoordinates[2] = blurCoordinates[0]+vec2( 0.0,               -singleStepOffset.y);\n  blurCoordinates[3] = blurCoordinates[0]+vec2( singleStepOffset.x,-singleStepOffset.y);\n  blurCoordinates[4] = blurCoordinates[0]+vec2( singleStepOffset.x, 0.0);\n  blurCoordinates[5] = blurCoordinates[0]+vec2( singleStepOffset.x, singleStepOffset.y);\n  blurCoordinates[6] = blurCoordinates[0]+vec2( 0.0,                singleStepOffset.y);\n  blurCoordinates[7] = blurCoordinates[0]+vec2(-singleStepOffset.x, singleStepOffset.y);\n  blurCoordinates[8] = blurCoordinates[0]+vec2(-singleStepOffset.x, 0.0);\n}\n";
        String string2 = "precision mediump float;\nuniform sampler2D _tex;\nvarying vec2 blurCoordinates[9];\nvoid main(){\n  vec4 sum = vec4(0.0);\n  sum += texture2D(_tex, blurCoordinates[0])/9.0;\n  sum += texture2D(_tex, blurCoordinates[1])/9.0;\n  sum += texture2D(_tex, blurCoordinates[2])/9.0;\n  sum += texture2D(_tex, blurCoordinates[3])/9.0;\n  sum += texture2D(_tex, blurCoordinates[4])/9.0;\n  sum += texture2D(_tex, blurCoordinates[5])/9.0;\n  sum += texture2D(_tex, blurCoordinates[6])/9.0;\n  sum += texture2D(_tex, blurCoordinates[7])/9.0;\n  sum += texture2D(_tex, blurCoordinates[8])/9.0;\n  gl_FragColor = sum;\n}\n";
        boolean bl = this.load(string, string2);
        if (!bl) {
            ZmfVideo.logError("can't load simple blur shader");
        }
        this._offset[0] = 4.0f / (float)layer.texWidth;
        this._offset[1] = 4.0f / (float)layer.texHeight;
        return bl;
    }

    @Override
    boolean upload_param(int n, GLView.Layer layer) {
        EffectParam effectParam = layer.effect_param;
        if (n == 0) {
            for (int i = 0; i < effectParam.argc; ++i) {
                if (effectParam.name[i].equals("hoffset")) {
                    this._offset[0] = effectParam.value[i] / (float)layer.texWidth;
                    continue;
                }
                if (effectParam.name[i].equals("voffset")) {
                    this._offset[1] = effectParam.value[i] / (float)layer.texHeight;
                    continue;
                }
                if (!effectParam.name[i].equals("iterate")) continue;
                this._iterate = (int)effectParam.value[i];
            }
        }
        return true;
    }

    @Override
    float[] manual_ptr(String string) {
        return this._offset;
    }
}

