/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCMediaChannelCallback;
import com.juphoon.cloud.JCMediaChannelImpl;
import com.juphoon.cloud.JCMediaChannelParticipant;
import com.juphoon.cloud.JCMediaDevice;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

public abstract class JCMediaChannel {
    static final String TAG = JCMediaChannel.class.getSimpleName();
    public static final int REGION_CHINA = 0;
    public static final int REGION_OTHER = 100;
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_LOGIN = 1;
    public static final int REASON_TIMEOUT = 2;
    public static final int REASON_NETWORK = 3;
    public static final int REASON_CALL_FUNCTION_ERROR = 4;
    public static final int REASON_ALREADY_JOINED = 5;
    public static final int REASON_KICKED = 6;
    public static final int REASON_OFFLINE = 7;
    public static final int REASON_QUIT = 8;
    public static final int REASON_OVER = 9;
    public static final int REASON_FULL = 10;
    public static final int REASON_INVALID_PASSWORD = 11;
    public static final int REASON_OTHER = 100;
    public static final int PICTURESIZE_NONE = 0;
    public static final int PICTURESIZE_MIN = 1;
    public static final int PICTURESIZE_SMALL = 2;
    public static final int PICTURESIZE_LARGE = 3;
    public static final int PICTURESIZE_MAX = 4;
    public static final int STATE_IDLE = 0;
    public static final int STATE_JOINING = 1;
    public static final int STATE_JOINED = 2;
    public static final int STATE_LEAVING = 3;
    public static final int PARTICIPANT_TYPE_NORMAL = 0;
    public static final int PARTICIPANT_TYPE_PSTN = 1;
    public static final int PARTICIPANT_TYPE_WEBRTC = 2;
    public static final int VOLUME_STATUS_NONE = 0;
    public static final int VOLUME_STATUS_ZERO = 1;
    public static final int VOLUME_STATUS_LOW = 2;
    public static final int VOLUME_STATUS_MID = 3;
    public static final int VOLUME_STATUS_HIGH = 4;
    public static final int RECORD_STATE_NONE = 0;
    public static final int RECORD_STATE_READY = 1;
    public static final int RECORD_STATE_RUNNING = 2;
    public static final int CDN_STATE_NONE = 0;
    public static final int CDN_STATE_READY = 1;
    public static final int CDN_STATE_RUNNING = 2;
    public static final String CONFIG_CAPACITY = "config_capacity";
    public static final String CONFIG_SIP_CALLER_NUMBER = "config_sip_caller_number";
    public static final String CONFIG_SIP_CORE_NETWORK = "config_sip_core_network";
    public static final String CONFIG_NOTIFY_VOLUME_CHANGE = "config_notify_volume_change";
    public static final String JOIN_PARAM_CDN = "cdn";
    public static final String JOIN_PARAM_RECORD = "record";
    public static final String JOIN_PARAM_REGION = "region";
    public static final String JOIN_PARAM_PASSWORD = "password";
    public static final String JOIN_SMOOTH_MODE = "smoothMode";
    public static final String JOIN_PARAM_MAX_RESOLUTION = "maxResolution";
    public static final int MAX_RESOLUTION_360p = 0;
    public static final int MAX_RESOLUTION_720p = 1;
    public static final int MAX_RESOLUTION_1080p = 2;
    private static JCMediaChannel sMediaChannel;

    public static JCMediaChannel create(JCClient client, JCMediaDevice mediaDevice, JCMediaChannelCallback callback) {
        if (sMediaChannel != null) {
            return sMediaChannel;
        }
        sMediaChannel = new JCMediaChannelImpl(client, mediaDevice, callback);
        return sMediaChannel;
    }

    public static void destroy() {
        if (sMediaChannel != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sMediaChannel.destroyObj();
                    sMediaChannel = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract String getChannelId();

    public abstract int getChannelNumber();

    public abstract String getTitle();

    public abstract int getState();

    public abstract List<JCMediaChannelParticipant> getParticipants();

    public abstract boolean getUploadLocalAudio();

    public abstract boolean getUploadLocalVideo();

    public abstract boolean getAudioOutput();

    public abstract String getScreenRenderId();

    public abstract String getScreenUserId();

    public abstract int getRecordState();

    public abstract int getCdnState();

    public abstract boolean setConfig(String var1, String var2);

    public abstract String getConfig(String var1);

    public abstract int query(String var1);

    public abstract boolean join(String var1, Map<String, String> var2);

    public abstract boolean leave();

    public abstract boolean stop();

    public abstract boolean enableUploadAudioStream(boolean var1);

    public abstract boolean enableUploadVideoStream(boolean var1);

    public abstract boolean enableAudioOutput(boolean var1);

    public abstract boolean requestVideo(JCMediaChannelParticipant var1, int var2);

    public abstract boolean requestScreenVideo(String var1, int var2);

    public abstract boolean enableCdn(boolean var1);

    public abstract boolean enableRecord(boolean var1);

    public abstract boolean enableScreenShare(boolean var1);

    public abstract JCMediaChannelParticipant getParticipant(String var1);

    public abstract String getStatistics();

    public abstract boolean setCustomProperty(String var1, String var2);

    public abstract String getCustomProperty(String var1);

    public abstract boolean sendMessage(String var1, String var2, String var3);

    public abstract boolean sendCommand(String var1, String var2);

    public abstract int inviteSipUser(String var1);

    protected abstract void addCallback(JCMediaChannelCallback var1);

    protected abstract void removeCallback(JCMediaChannelCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxResolution {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JoinParam {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CdnState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VolumeStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParticipantType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaChannelState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PictureSize {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaChannelReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Region {
    }
}

