package com.juphoon.cloud;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

/**
 * 账号查询模块
 *
 * @author juphoon
 */
public abstract class JCAccount {

    static final String TAG = JCAccount.class.getSimpleName();

    private static JCAccount sAccount;

    /**
     * 查询异常
     */
    public static final int ACCOUNT_USER_STATUS_ERR = -1;
    /**
     * 用户未注册
     */
    public static final int ACCOUNT_USER_STATUS_NOT_FOUND = 0;
    /**
     * 用户离线
     */
    public static final int ACCOUNT_USER_STATUS_OFFLINE = 1;
    /**
     * 用户推送状态
     */
    public static final int ACCOUNT_USER_STATUS_PUSH = 2;
    /**
     * 用户在线
     */
    public static final int ACCOUNT_USER_STATUS_ONLINE = 3;

    /**
     * 用户状态
     */
    @IntDef({ACCOUNT_USER_STATUS_ERR, ACCOUNT_USER_STATUS_NOT_FOUND, ACCOUNT_USER_STATUS_OFFLINE, ACCOUNT_USER_STATUS_PUSH, ACCOUNT_USER_STATUS_ONLINE})
    @Retention(RetentionPolicy.SOURCE)
    public @interface UserStatus {
    }

    /**
     * 创建 JCAccount 实例
     *
     * @param callback 回调接口，用于接收 JCAccount 相关回调事件
     * @return JCAccount  实例
     */
    public static JCAccount create(JCAccountCallback callback) {
        if (sAccount != null) {
            return sAccount;
        }
        sAccount = new JCAccountImpl(callback);
        return sAccount;
    }

    /**
     * 销毁 JCAccount 实例
     */
    public static void destroy() {
        if (sAccount != null) {
            JCClientThreadImpl.getInstance().post(new Runnable() {
                @Override
                public void run() {
                    sAccount.destroyObj();
                    sAccount = null;
                }
            });
        }
    }

    /**
     * 销毁实例，移除回调
     */
    protected abstract void destroyObj();

    /**
     * 查询账号状态
     *
     * @param userIdList 查询的账号
     * @return 返回操作id
     */
    public abstract int queryUserStatus(List<String> userIdList);

    /**
     * 添加回调
     *
     * @param callback JCAccountCallback 接口对象
     */
    protected abstract void addCallback(JCAccountCallback callback);

    /**
     * 删除回调
     *
     * @param callback JCAccountCallback 接口对象
     */
    protected abstract void removeCallback(JCAccountCallback callback);
}
