package com.juphoon.cloud;

class JCPushImpl extends JCPush {

    static final String TAG = JCPushImpl.class.getSimpleName();

    private JCClient mClient;

    JCPushImpl(JCClient client) {
        if (client == null) {
            throw new RuntimeException("JCPush client cannot be null!");
        }
        mClient = client;
    }

    @Override
    public void destroyObj() {
        mClient = null;
    }

    @Override
    public boolean addPushInfo(JCPushTemplate info) {
        if (mClient.getState() != JCClient.STATE_LOGINED) {
            JCLog.error(TAG, "JCClient Not logged in");
            return false;
        }
        JCParam.Push param = new JCParam.Push();
        param.data = info.getData();
        return MtcEngine.getInstance().addPushInfo(param).succ;
    }

}
