package com.juphoon.cloud;

/**
 * JCCall回调
 *
 * @author juphoon
 */
public interface JCCallCallback {

    /**
     * 新增通话回调
     *
     * @param item JCCallItem 对象
     */
    void onCallItemAdd(JCCallItem item);

    /**
     * 移除通话回调
     *
     * @param item          JCCallItem 对象
     * @param reason        通话结束原因
     * @param description   通话结束原因的描述，只有被动挂断的时候，才会收到这个值，其他情况下则返回空字符串
     */
    void onCallItemRemove(JCCallItem item, @JCCall.CallReason int reason, String description);

    /**
     * 通话状态更新回调（当上层收到此回调时，可以根据 JCCallItem 对象获得该通话的所有信息及状态，从而更新该通话相关UI）
     *
     * @param item JCCallItem 对象，当 item 为 null 时表示全部更新
     */
    void onCallItemUpdate(JCCallItem item);

    /**
     * 通话中收到消息的回调
     *
     * @param type    消息类型
     * @param content 消息内容
     * @param item    JCCallItem 对象
     */
    void onMessageReceive(String type, String content, JCCallItem item);

}
