package com.juphoon.cloud;

/**
 * JCMediaChannel回调
 *
 * @author juphoon
 */
public interface JCMediaChannelCallback {

    /**
     * 自身状态变化回调
     *
     * @param state    当前状态
     * @param oldState 变化前状态
     */
    void onMediaChannelStateChange(@JCMediaChannel.MediaChannelState int state, @JCMediaChannel.MediaChannelState int oldState);

    /**
     * 属性变化回调，目前主要关注屏幕共享状态的更新
     */
    void onMediaChannelPropertyChange();

    /**
     * 加入频道结果回调
     *
     * @param result    true 表示成功，false 表示失败
     * @param reason    加入失败原因，当 result 为 false 时该值有效
     * @param channelId 频道标识符
     */
    void onJoin(boolean result, @JCMediaChannel.MediaChannelReason int reason, String channelId);

    /**
     * 离开频道结果回调
     *
     * @param reason    离开原因
     * @param channelId 频道标识符
     */
    void onLeave(@JCMediaChannel.MediaChannelReason int reason, String channelId);

    /**
     * 解散频道结果回调
     *
     * @param result    true 表示成功，false 表示失败
     * @param reason    解散失败原因，当 result 为 false 时该值有效
     */
    void onStop(boolean result, @JCMediaChannel.MediaChannelReason int reason);

    /**
     * 查询频道信息结果回调
     *
     * @param operationId 操作id，由 query 接口返回
     * @param result      查询结果，true 表示查询成功，false 表示查询失败
     * @param reason      查询失败原因，当 result 为 false 时该值有效
     * @param queryInfo   查询到的频道信息，当失败时只需关注 channelId
     */
    void onQuery(int operationId, boolean result, @JCMediaChannel.MediaChannelReason int reason, JCMediaChannelQueryInfo queryInfo);

    /**
     * 新成员加入回调
     *
     * @param participant 成员对象
     */
    void onParticipantJoin(JCMediaChannelParticipant participant);

    /**
     * 成员离开回调
     *
     * @param participant 成员对象
     */
    void onParticipantLeft(JCMediaChannelParticipant participant);

    /**
     * 成员更新回调
     *
     * @param participant 成员对象
     */
    void onParticipantUpdate(JCMediaChannelParticipant participant);

    /**
     * 接收频道消息的回调
     *
     * @param type          消息类型
     * @param content       消息内容
     * @param fromUserId    消息发送成员的userId
     */
    void onMessageReceive(String type, String content, String fromUserId);

    /**
     * 邀请Sip用户操作结果回调，成功后会触发 onParticipantJoin 回调
     *
     * @param operationId   操作id
     * @param result        操作结果，true表示成功，false表示失败
     * @param reason        失败原因，当result为false时该值有效
     */
    void onInviteSipUserResult(int operationId, boolean result, int reason);
}
