/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCMediaDeviceCallback;
import com.juphoon.cloud.JCMediaDeviceImpl;
import com.juphoon.cloud.JCMediaDeviceVideoCanvas;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class JCMediaDevice {
    public static final int RENDER_FULL_SCREEN = 0;
    public static final int RENDER_FULL_CONTENT = 1;
    public static final int RENDER_FULL_AUTO = 2;
    public static final int CAMERA_NONE = 0;
    public static final int CAMERA_FRONT = 1;
    public static final int CAMERA_BACK = 2;
    public static final int CAMERA_UNKNOWN = 3;
    public static final int AEC_OS = 0;
    public static final int AEC_SDE = 1;
    public static final int AEC_OS_SDE = 2;
    public static final int VIDEO_MODE_S_S = 0;
    public static final int VIDEO_MODE_S_L = 1;
    public static final int VIDEO_MODE_L_S = 2;
    public static final int VIDEO_MODE_L_L = 3;
    public static final int I420 = 1;
    public static final int IYUV = 2;
    public static final int RGB24 = 3;
    public static final int ABGR = 4;
    public static final int ARGB = 5;
    public static final int ARGB444 = 6;
    public static final int RGB565 = 7;
    public static final int ARGB1555 = 8;
    public static final int YUY2 = 9;
    public static final int YV12 = 10;
    public static final int UYVY = 11;
    public static final int MJPG = 12;
    public static final int NV21 = 13;
    public static final int NV12 = 14;
    public static final int BGRA = 15;
    public static final int H264 = 100;
    private static JCMediaDevice sMediaDevice;
    public boolean autoRotate = false;

    public static JCMediaDevice create(JCClient client, JCMediaDeviceCallback callback) {
        if (sMediaDevice != null) {
            return sMediaDevice;
        }
        sMediaDevice = new JCMediaDeviceImpl(client, callback);
        return sMediaDevice;
    }

    public static void destroy() {
        if (sMediaDevice != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sMediaDevice.destroyObj();
                    sMediaDevice = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract boolean isCameraOpen();

    public abstract boolean isSpeakerOn();

    public abstract String getCamera();

    public abstract List<String> getCameras();

    public abstract JCMediaDeviceVideoCanvas startCameraVideo(int var1);

    public abstract JCMediaDeviceVideoCanvas startVideo(String var1, int var2);

    public abstract void stopVideo(JCMediaDeviceVideoCanvas var1);

    public abstract boolean startAudio();

    public abstract boolean stopAudio();

    public abstract boolean startCamera();

    public abstract boolean stopCamera();

    public abstract boolean switchCamera();

    public abstract void specifyCamera(int var1);

    public abstract void setCameraProperty(int var1, int var2, int var3);

    public abstract void setScreenCaptureProperty(int var1, int var2, int var3);

    public abstract int getCameraType(int var1);

    public abstract void enableSpeaker(boolean var1);

    public abstract void setVideoMode(int var1, VideoModeOtherParam var2);

    public abstract int getVideoMode();

    public abstract void setAecMode(int var1);

    public abstract int getAecMode();

    public abstract void setSawtooth(boolean var1);

    public abstract boolean isVideoFileOpen();

    public abstract String getVideoFileId();

    public abstract boolean startVideoFile();

    public abstract void setVideoFileFrame(byte[] var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    public abstract boolean stopVideoFile();

    public abstract void readyForH264();

    protected abstract boolean enableScreenCapture(boolean var1);

    protected abstract void addCallback(JCMediaDeviceCallback var1);

    protected abstract void removeCallback(JCMediaDeviceCallback var1);

    protected abstract void configMeidaParam(VideoModeOtherParam var1);

    public static class VideoModeOtherParam {
        public int agc = -1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoPixelFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AecMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RenderType {
    }
}

