package com.juphoon.cloud;

import android.content.Context;
import android.view.SurfaceView;

import com.justalk.cloud.zmf.ZmfVideo;

/**
 * 视频对象
 *
 * @author juphoon
 */
public class JCMediaDeviceVideoCanvas {

    static final String TAG = JCMediaDeviceVideoCanvas.class.getSimpleName();

    boolean autoRotate = false;
    private String mVideoSource;
    private SurfaceView mSurfaceView;
    private int mRenderType;

    JCMediaDeviceVideoCanvas(Context context, String videoSource, @JCMediaDevice.RenderType int renderType) {
        this.mVideoSource = videoSource;
        mSurfaceView = ZmfEngine.getInstance().createView();
        mRenderType = renderType;
    }

    /**
     * 获取视频渲染视图
     *
     * @return 视频渲染视图
     */
    public SurfaceView getVideoView() {
        return mSurfaceView;
    }

    void switchCamera(String camera) {
        String oldVideoSource = mVideoSource;
        mVideoSource = camera;
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = JCParam.RenderDeal.REPLACE;
        param.view = mSurfaceView;
        param.videoSource = this.mVideoSource;
        param.oldVideoSource = oldVideoSource;
        ZmfEngine.getInstance().dealRender(param);
    }

    /**
     * 暂停视频渲染
     */
    public void pause() {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = JCParam.RenderDeal.STOP;
        param.view = mSurfaceView;
        if (!ZmfEngine.getInstance().dealRender(param).succ) {
            JCLog.error(TAG, "渲染停止失败");
        }
    }

    /**
     * 恢复视频渲染
     */
    public void resume() {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = JCParam.RenderDeal.START;
        param.videoSource = mVideoSource;
        param.view = mSurfaceView;
        param.autoRotate = autoRotate;
        param.renderType = translateRenderTypeToMtc();
        //param.rotateAngleToScreen = rotateAngleToScreen;
        if (!ZmfEngine.getInstance().dealRender(param).succ) {
            JCLog.error(TAG, "渲染失败");
        }
    }

    /**
     * 旋转角度，必须是90的倍数，该角度表示与屏幕正方向旋转后的夹角
     *
     * @param angle 角度值
     */
    public void rotate(int angle) {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = JCParam.RenderDeal.ROTATE;
        param.view = mSurfaceView;
        param.angle = angle;
        ZmfEngine.getInstance().dealRender(param);
    }

    /**
     * 视频通话截图
     *
     * @param width     截屏宽度像素，-1为视频源像素
     * @param height    截屏高度像素，-1为视频源像素
     * @param filePath  文件路径
     */
    public boolean snapshot(int width, int height, String filePath) {
        JCParam.Snapshot param = new JCParam.Snapshot();
        param.videoSource = mVideoSource;
        param.width = width;
        param.height = height;
        param.filePath = filePath;
        if (ZmfEngine.getInstance().videoSnapshot(param).succ) {
            return true;
        } else {
            JCLog.error(TAG, "截屏失败");
            return false;
        }
    }

    /**
     * 返回渲染源标识
     *
     * @return 渲染源标识
     */
    public String getVideoSource() {
        return mVideoSource;
    }

    private int translateRenderTypeToMtc() {
        switch (mRenderType) {
            case JCMediaDevice.RENDER_FULL_CONTENT:
                return ZmfVideo.RENDER_FULL_CONTENT;
            case JCMediaDevice.RENDER_FULL_SCREEN:
                return ZmfVideo.RENDER_FULL_SCREEN;
            default:
                return ZmfVideo.RENDER_AUTO;
        }
    }

}
