package com.juphoon.cloud;

import android.support.annotation.IntDef;

import com.justalk.cloud.lemon.MtcCliCfg;
import com.justalk.cloud.lemon.MtcCliCfgConstants;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

/**
 * JCLog
 *
 * @author juphoon
 */
public class JCLog {
    /**
     * 日志等级
     */
    @IntDef({LOG_LEVEL_DISABLE, LOG_LEVEL_ERROR, LOG_LEVEL_INFO})
    @Retention(RetentionPolicy.SOURCE)
    public @interface LogLevel {
    }

    /**
     * disable日志等级
     */
    public static final int LOG_LEVEL_DISABLE = 1;
    /**
     * error日志等级
     */
    public static final int LOG_LEVEL_ERROR = 2;
    /**
     * info日志等级
     */
    public static final int LOG_LEVEL_INFO = 3;

    private static @LogLevel int sLogLevel = LOG_LEVEL_INFO;

    public static void setLevel(@LogLevel int level) {
        sLogLevel = level;
        switch (sLogLevel) {
            case LOG_LEVEL_DISABLE:
                MtcCliCfg.Mtc_CliCfgSetLogLevel(MtcCliCfgConstants.EN_MTC_LOG_LEVEL_DISABLE);
                break;
            case LOG_LEVEL_ERROR:
                MtcCliCfg.Mtc_CliCfgSetLogLevel(MtcCliCfgConstants.EN_MTC_LOG_LEVEL_ERROR);
                break;
            case LOG_LEVEL_INFO:
                MtcCliCfg.Mtc_CliCfgSetLogLevel(MtcCliCfgConstants.EN_MTC_LOG_LEVEL_DEBUG);
                break;
            default:
                break;
        }
    }

    static void info(String type, String format, Object... args) {
        if (sLogLevel == LOG_LEVEL_INFO) {
            JCParam.Log param = new JCParam.Log();
            param.type = JCParam.Log.INFO;
            param.log = String.format(Locale.getDefault(), "JCLogInfo:%s %s", type, String.format(Locale.getDefault(), format, args));
            MtcEngine.getInstance().log(param);
        }
    }

    static void error(String type, String format, Object... args) {
        if (sLogLevel == LOG_LEVEL_INFO || sLogLevel == LOG_LEVEL_ERROR) {
            JCParam.Log param = new JCParam.Log();
            param.type = JCParam.Log.ERROR;
            param.log = String.format(Locale.getDefault(), "JCLogError:%s %s", type, String.format(Locale.getDefault(), format, args));
            MtcEngine.getInstance().log(param);
        }
    }

}
