package com.juphoon.cloud;

/**
 * JCClient回调
 *
 * @author juphoon
 */
public interface JCClientCallback {

    /**
     * 登陆结果回调
     *
     * @param result true 表示登陆成功，false 表示登陆失败
     * @param reason 当 result 为 false 时该值有效
     */
    void onLogin(boolean result, @JCClient.ClientReason int reason);

    /**
     * 登出回调
     *
     * @param reason 登出原因
     */
    void onLogout(@JCClient.ClientReason int reason);

    /**
     * 登陆状态变化通知
     *
     * @param state    当前状态值
     * @param oldState 之前状态值
     */
    void onClientStateChange(@JCClient.ClientState int state, @JCClient.ClientState int oldState);

}
