/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.WindowManager;
import com.justalk.cloud.zmf.CamDrv;
import com.justalk.cloud.zmf.GLES1View;
import com.justalk.cloud.zmf.GLES2View;
import com.justalk.cloud.zmf.Render;
import com.justalk.cloud.zmf.RenderNative;
import com.justalk.cloud.zmf.ScreenCapture;
import com.justalk.cloud.zmf.UVCCamera;
import com.justalk.cloud.zmf.VideoCapture;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfTextureView;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class ZmfVideo {
    public static final int FACE_FRONT = 1;
    public static final int FACE_BACK = 2;
    public static final int ROTATION_FIXED_SCREEN = -2;
    public static final int ROTATION_AUTO_SCREEN = -1;
    public static final int ROTATION_ANGLE_0 = 0;
    public static final int ROTATION_ANGLE_90 = 90;
    public static final int ROTATION_ANGLE_180 = 180;
    public static final int ROTATION_ANGLE_270 = 270;
    public static final int ROTATION_MASK_0 = 1;
    public static final int ROTATION_MASK_90 = 2;
    public static final int ROTATION_MASK_180 = 4;
    public static final int ROTATION_MASK_270 = 8;
    public static final int ROTATION_MASK_ALL = 15;
    public static final int MIRROR_NONE = 0;
    public static final int MIRROR_HORIZONTAL = 1;
    public static final int MIRROR_VERTICAL = 2;
    public static final int MIRROR_FLIP_FROM_LEFT = 4;
    public static final int MIRROR_FLIP_FROM_TOP = 8;
    public static final int MIRROR_AUTO = 3;
    public static final int SOURCE_PEER = 0;
    public static final int SOURCE_CAPTURE = 1;
    public static final int SOURCE_FILE = 2;
    public static final int RENDER_EFFECT_NONE = 0;
    public static final int RENDER_EFFECT_BLUR = 1;
    public static final int RENDER_EFFECT_GREY = 2;
    public static final int RENDER_EFFECT_MASK = 3;
    public static final int RENDER_EFFECT_MAGNIFIER = 4;
    public static final int RENDER_MATCH_NONE = 0;
    public static final int RENDER_MATCH_TIMESTAMP = 1;
    public static final int CAPTURE_EFFECT_NONE = 0;
    public static final int CAPTURE_EFFECT_SMART_EXPOSURE = 1;
    public static final int CAPTURE_EFFECT_GAMMA_CORRECTION = 2;
    public static final int CAPTURE_EFFECT_CONTRAST_ENHANCE = 4;
    public static final int CAPTURE_EFFECT_FACE_ENHANCE = 8;
    public static final int CAPTURE_EFFECT_VIRTUAL_BACKLOT = 16;
    public static final int CAPTURE_EFFECT_ERT2RECT = 32;
    public static final int CAPTURE_EFFECT_PREFER_H264 = 64;
    public static final int CAPTURE_EFFECT_BRIGHTNESS_NOTIFICATION = 128;
    public static final int RENDER_AUTO = -1;
    public static final int RENDER_FULL_SCREEN = 0;
    public static final int RENDER_FULL_CONTENT = 1;
    public static String CAPTURE_BACK;
    public static String CAPTURE_FRONT;
    public static String CaptureScreen;
    public static final int PIXEL_I420 = 1;
    public static final int PIXEL_IYUV = 2;
    public static final int PIXEL_RGB24 = 3;
    public static final int PIXEL_ABGR = 4;
    public static final int PIXEL_ARGB = 5;
    public static final int PIXEL_ARGB4444 = 6;
    public static final int PIXEL_RGB565 = 7;
    public static final int PIXEL_ARGB1555 = 8;
    public static final int PIXEL_YUY2 = 9;
    public static final int PIXEL_YV12 = 10;
    public static final int PIXEL_UYVY = 11;
    public static final int PIXEL_MJPG = 12;
    public static final int PIXEL_NV21 = 13;
    public static final int PIXEL_NV12 = 14;
    public static final int PIXEL_BGRA = 15;
    public static int sCamAngle;
    private static int _videoCaptureRotationMask;
    private static int _videoCaptureFixedAngle;
    private static int _videoRenderRotationMask;
    private static int _videoRenderFixedAngle;
    private static int _deviceOrientation;
    static int sScreenOrient;
    private static Display sDefaultDisplay;
    private static OrientationEventListener sOrientationListener;
    private static int sOrientCaptureCount;
    private static int sOrientRenderCount;
    private static VideoCapture sCapture;
    private static ScreenCapture sSCapture;
    private static boolean sSupportNativeRender;
    private static Set<Render> sRenders;
    private static Set<Callback> sCallbacks;

    public static synchronized int initialize(Context context) {
        if (context == null) {
            ZmfVideo.logError("android context is null");
            return -1;
        }
        if (sOrientationListener == null) {
            sOrientationListener = new OrientationEventListener(context){

                public void onOrientationChanged(int n) {
                    if (n < 0) {
                        return;
                    }
                    boolean bl = true;
                    n = 360 - n;
                    if (_deviceOrientation == 0 && (n >= 300 || n <= 60)) {
                        bl = false;
                    } else if (n >= _deviceOrientation - 60 && n <= _deviceOrientation + 60) {
                        bl = false;
                    }
                    if (sDefaultDisplay != null) {
                        sScreenOrient = (360 - sDefaultDisplay.getRotation() * 90) % 360;
                    }
                    if (!bl) {
                        return;
                    }
                    int n2 = n / 45;
                    int n3 = n2 % 2;
                    ZmfVideo.onDeviceRotation((n2 + n3) * 45 % 360);
                }
            };
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            sDefaultDisplay = windowManager.getDefaultDisplay();
        }
        if (sCapture == null) {
            if (Zmf.initialize(context) != 0) {
                return -1;
            }
            ZmfVideo.logInfo("initialize Video");
            context = context.getApplicationContext();
            sCapture = VideoCapture.create(context);
            if (sCapture == null) {
                return -1;
            }
            boolean bl = sSupportNativeRender = Zmf.zmfTraits().contains("RenderNative |") && 0 == RenderNative.nlInit(context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT);
        }
        if (sSCapture == null && Build.VERSION.SDK_INT >= 21) {
            sSCapture = new ScreenCapture(context);
            ZmfVideo.logInfo("init screen capture: SDK version " + Build.VERSION.SDK_INT);
        }
        return 0;
    }

    public static synchronized int terminate() {
        ZmfVideo.trace("terminate:");
        if (sSCapture != null) {
            sSCapture.destroyScreenCapture();
            sSCapture = null;
        }
        if (sCapture != null) {
            UVCCamera.uvcCamTerm();
            CamDrv.camdrvTerm();
            sCapture.teminate();
            sCapture = null;
            ZmfVideo.logInfo("terminate Video");
            Zmf.terminate();
        }
        sCallbacks.clear();
        sRenders.clear();
        return 0;
    }

    public static String CaptureBack() {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return null;
        }
        CAPTURE_BACK = sCapture.getCaptureBack();
        return CAPTURE_BACK;
    }

    public static String CaptureFront() {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return null;
        }
        CAPTURE_FRONT = sCapture.getCaptureFront();
        return CAPTURE_FRONT;
    }

    public static void addCallback(Callback callback) {
        sCallbacks.add(callback);
    }

    public static void removeCallback(Callback callback) {
        sCallbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createScreenCapture(MediaProjection mediaProjection) {
        if (sSCapture == null) {
            ZmfVideo.logError("screen capture not initialized: requiried api 21; current " + Build.VERSION.SDK_INT);
            return -1;
        }
        ZmfVideo.trace("createScreenCapture");
        ScreenCapture screenCapture = sSCapture;
        synchronized (screenCapture) {
            return sSCapture.createScreenCapture(mediaProjection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int destroyScreenCapture() {
        if (sSCapture == null) {
            ZmfVideo.logError("screen capture not initialized");
            return -1;
        }
        ZmfVideo.trace("destoryScreenCapture");
        ScreenCapture screenCapture = sSCapture;
        synchronized (screenCapture) {
            return sSCapture.destroyScreenCapture();
        }
    }

    public static int captureGetCount() {
        return ZmfVideo.cameraGetCount();
    }

    public static int cameraGetCount() {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return 0;
        }
        return sCapture.getCount();
    }

    public static int captureGetName(int n, String[] stringArray) {
        return ZmfVideo.cameraGetName(n, stringArray);
    }

    public static int cameraGetName(int n, String[] stringArray) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return sCapture.getName(n, stringArray);
    }

    public static int captureFace(String string, int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        ZmfVideo.trace("captureFace: " + string + "," + n);
        return sCapture.face(string, n);
    }

    public static int captureRotate(String string, int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        if (string == null) {
            ZmfVideo.logError("null capture id");
            return -1;
        }
        ZmfVideo.trace("captureRotate: " + string + "," + n);
        return sCapture.rotate(string, n);
    }

    public static int captureEffect(int n, String string, Object[] objectArray) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        ZmfVideo.trace("captureEffect: " + n + "," + string);
        JSONObject jSONObject = null;
        if (string != null) {
            JSONTokener jSONTokener = new JSONTokener(string);
            try {
                jSONObject = (JSONObject)jSONTokener.nextValue();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                ZmfVideo.logError("invalid:" + string);
                jSONObject = null;
                objectArray = null;
                return -1;
            }
        }
        return sCapture.effect(n, jSONObject, objectArray);
    }

    public static int renderRotate(String string, int n) {
        ZmfVideo.trace("renderRotate: " + string + "," + n);
        if (sSupportNativeRender && string != null) {
            return RenderNative.renderRotate(string, n);
        }
        return -1;
    }

    public static SurfaceHolder setPreviewDisplay(SurfaceHolder surfaceHolder) {
        return VideoCapture.setPreviewDisplay(surfaceHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int captureStart(String string, int n, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        if (string == null) {
            ZmfVideo.logError("null capture id");
            return -1;
        }
        ZmfVideo.trace("captureStart: " + string + "," + n + "," + n2 + "," + n3);
        if (CaptureScreen != null && CaptureScreen.equals(string)) {
            if (sSCapture == null) {
                ZmfVideo.logError("screen capture not initialized: requiried api 21; current " + Build.VERSION.SDK_INT);
                return -1;
            }
            ScreenCapture screenCapture = sSCapture;
            synchronized (screenCapture) {
                return sSCapture.start(n, n2, n3);
            }
        }
        VideoCapture videoCapture = sCapture;
        synchronized (videoCapture) {
            ZmfVideo.enableRotation(true, false, false);
            return sCapture.start(string, n, n2, n3);
        }
    }

    public static int captureListenRotation(int n, int n2) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        ZmfVideo.trace("captureListenRotation: " + n + n2);
        _videoCaptureRotationMask = n;
        _videoCaptureFixedAngle = (360 + n2) % 360;
        ZmfVideo.onDeviceRotation(_deviceOrientation);
        return 0;
    }

    public static int renderListenRotation(int n, int n2) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        ZmfVideo.trace("renderListenRotation: " + n + n2);
        _videoRenderRotationMask = n;
        _videoRenderFixedAngle = (360 + n2) % 360;
        ZmfVideo.onDeviceRotation(_deviceOrientation);
        return 0;
    }

    public static int captureEnableRotation(boolean bl, int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        int n2 = bl ? 15 : 0;
        ZmfVideo.captureListenRotation(n2, n);
        ZmfVideo.renderListenRotation(n2, n);
        return 0;
    }

    public static int screenOrientation(int n) {
        ZmfVideo.trace("screenOrientation: " + n);
        sDefaultDisplay = null;
        sScreenOrient = (n + 360) % 360;
        return 0;
    }

    public static int captureSetScreenOrientation(int n) {
        return ZmfVideo.screenOrientation(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int captureStop(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        if (string == null) {
            ZmfVideo.logError("null capture id");
            return -1;
        }
        ZmfVideo.trace("captureStop: " + string);
        if (CaptureScreen != null && CaptureScreen.equals(string)) {
            if (sSCapture == null) {
                ZmfVideo.logError("screen capture not initialized: requiried api 21; current " + Build.VERSION.SDK_INT);
                return -1;
            }
            ScreenCapture screenCapture = sSCapture;
            synchronized (screenCapture) {
                return sSCapture.stop();
            }
        }
        VideoCapture videoCapture = sCapture;
        synchronized (videoCapture) {
            ZmfVideo.enableRotation(false, false, false);
            return sCapture.stop(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int captureStopAll() {
        Object object;
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        ZmfVideo.trace("captureStopAll");
        ZmfVideo.enableRotation(false, false, true);
        if (sSCapture != null) {
            object = sSCapture;
            synchronized (object) {
                sSCapture.stop();
            }
        }
        object = sCapture;
        synchronized (object) {
            return sCapture.stopAll();
        }
    }

    public static SurfaceView renderNew(Context context, int n) {
        return ZmfVideo.surfaceView(context, n);
    }

    public static SurfaceView surfaceView(Context context, int n) {
        ZmfVideo.trace("renderNew: " + n);
        if (n >= 131072) {
            return new GLES2View(context);
        }
        return new GLES1View(context);
    }

    public static SurfaceView renderNew(Context context) {
        return ZmfVideo.surfaceView(context);
    }

    public static SurfaceView surfaceView(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return ZmfVideo.surfaceView(context, configurationInfo.reqGlEsVersion);
    }

    public static TextureView textureView(Context context) {
        ZmfVideo.trace("textureView: ");
        if (Build.VERSION.SDK_INT < 14) {
            return null;
        }
        return new ZmfTextureView(context);
    }

    public static int renderStart(View view) {
        ZmfVideo.trace("renderStart: ");
        if (view instanceof Render) {
            ZmfVideo.enableRotation(true, true, false);
            Render render = (Render)view;
            sRenders.add(render);
            return render.videoRenderStart();
        }
        ZmfVideo.logError("renderStart: not child of Zmf.Render");
        return -1;
    }

    public static int renderStop(View view) {
        ZmfVideo.trace("renderStop: ");
        if (view instanceof Render && sRenders.contains(view)) {
            ZmfVideo.enableRotation(false, true, false);
            Render render = (Render)view;
            int n = render.videoRenderStop();
            if (!render.isActive()) {
                sRenders.remove(view);
            }
            return n;
        }
        return 0;
    }

    public static int renderAdd(Object object, String string, int n, int n2) {
        if (string == null) {
            ZmfVideo.logError("render source is null");
            return -1;
        }
        ZmfVideo.trace("renderAdd: " + string + "," + n + "," + n2);
        if (object instanceof Render) {
            Render render = (Render)object;
            sRenders.add(render);
            return render.videoRenderAdd(string, n, n2);
        }
        if (sSupportNativeRender && object instanceof Surface) {
            return RenderNative.renderAdd((Surface)object, string);
        }
        ZmfVideo.logError("renderAdd:not child of Zmf.Render");
        return -1;
    }

    public static int renderSnapshot(String string, int n, int n2, String string2) {
        if (string == null || string2 == null) {
            ZmfVideo.logError("Snapshot param invalid is null");
            return -1;
        }
        return Zmf.videoRenderSnapshot(string, n, n2, string2);
    }

    public static int renderFillMode(View view, String string, int n) {
        if (string == null) {
            ZmfVideo.logError("render source is null");
            return -1;
        }
        ZmfVideo.trace("renderFillMode: " + string + "," + n);
        if (view instanceof Render) {
            Render render = (Render)view;
            return render.videoRenderFillMode(string, n);
        }
        ZmfVideo.logError("renderFillMode: not child of Zmf.Render");
        return -1;
    }

    public static int renderReplace(View view, String string, String string2) {
        if (string == null || string2 == null) {
            ZmfVideo.logError("render source is null");
            return -1;
        }
        ZmfVideo.trace("renderReplace: " + string + "," + string2);
        if (view instanceof Render) {
            Render render = (Render)view;
            return render.videoRenderReplace(string, string2);
        }
        ZmfVideo.logError("renderReplace: not child of Zmf.Render");
        return -1;
    }

    public static int renderRemove(View view, String string) {
        if (string == null) {
            ZmfVideo.logError("render source is null");
            return -1;
        }
        ZmfVideo.trace("renderRemove: " + string);
        if (view != null && view instanceof Render) {
            Render render = (Render)view;
            int n = render.videoRenderRemove(string);
            if (!render.isActive()) {
                sRenders.remove(view);
            }
            return n;
        }
        if (sSupportNativeRender && string != null) {
            return RenderNative.renderRemove(string);
        }
        ZmfVideo.logError("renderRemove: not child of Zmf.Render");
        return -1;
    }

    public static int renderRemoveAll(View view) {
        ZmfVideo.trace("renderRemoveAll");
        if (view instanceof Render) {
            Render render = (Render)view;
            int n = render.videoRenderRemoveAll();
            if (!render.isActive()) {
                sRenders.remove(view);
            }
            return n;
        }
        ZmfVideo.logError("renderRemoveAll: not child of Zmf.Render");
        return -1;
    }

    public static int renderMove(View view, String string, float f, float f2, float f3, float f4) {
        ZmfVideo.trace("renderMove: " + string + "," + f + "," + f2 + "," + f3 + "," + f4);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            return render.videoRenderMove(string, f, f2, f3, f4);
        }
        ZmfVideo.logError("renderMove: not child of Zmf.Render");
        return -1;
    }

    public static int renderEffect(View view, String string, int n, String string2, Object[] objectArray) {
        ZmfVideo.trace("renderEffect: " + string + "," + n + "," + string2);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            JSONObject jSONObject = null;
            if (string2 != null) {
                JSONTokener jSONTokener = new JSONTokener(string2);
                try {
                    jSONObject = (JSONObject)jSONTokener.nextValue();
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    ZmfVideo.logError("invalid:" + string2);
                    jSONObject = null;
                    objectArray = null;
                    return -1;
                }
            }
            return render.videoRenderEffect(string, n, jSONObject, objectArray);
        }
        ZmfVideo.logError("renderEffect: not child of Zmf.Render");
        return -1;
    }

    public static int renderMatch(View view, String string, int n, String string2, Object[] objectArray) {
        ZmfVideo.trace("renderMatch: " + string + "," + n + "," + string2);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            JSONObject jSONObject = null;
            if (string2 != null) {
                JSONTokener jSONTokener = new JSONTokener(string2);
                try {
                    jSONObject = (JSONObject)jSONTokener.nextValue();
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    ZmfVideo.logError("invalid:" + string2);
                    jSONObject = null;
                    objectArray = null;
                    return -1;
                }
            }
            return render.videoRenderMatch(string, n, jSONObject, objectArray);
        }
        ZmfVideo.logError("renderMatch: not child of Zmf.Render");
        return -1;
    }

    public static int renderGetLocation(View view, String string, float[] fArray) {
        ZmfVideo.trace("renderMatch: " + string);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            return render.videoRenderGetLocation(string, fArray);
        }
        ZmfVideo.logError("renderGetLocation: not child of Zmf.Render");
        return -1;
    }

    public static int renderMirror(View view, String string, int n) {
        ZmfVideo.trace("renderMirror: " + string + "," + n);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            return render.videoRenderMirror(string, n);
        }
        ZmfVideo.logError("renderMirror: not child of Zmf.Render");
        return -1;
    }

    public static int renderFreeze(View view, String string, boolean bl) {
        ZmfVideo.trace("renderFreeze: " + string + "," + bl);
        if (view instanceof Render) {
            if (string == null) {
                ZmfVideo.logError("render source is null");
                return -1;
            }
            Render render = (Render)view;
            return render.videoRenderFreeze(string, bl);
        }
        ZmfVideo.logError("renderFreeze: not child of Zmf.Render");
        return -1;
    }

    public static int renderRotate(View view, int n) {
        ZmfVideo.trace("renderRotate: " + n);
        if (view instanceof Render) {
            Render render = (Render)view;
            sCamAngle = n;
            return render.videoRenderRotate(n);
        }
        ZmfVideo.logError("renderRotate: not child of Zmf.Render");
        return -1;
    }

    public static int captureGetOrient(String string, int[] nArray) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return sCapture.getOrient(string, nArray);
    }

    public static int captureGetIndex(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return sCapture.getIndexById(string);
    }

    public static void onCapture(String string, int n, int n2, int n3, int[] nArray, ByteBuffer byteBuffer) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        Zmf.onVideoCapture(string, n, n2, n3, nArray, byteBuffer, null, null);
    }

    public static void onCapture(String string, int n, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        Zmf.onVideoCapture(string, n, n2, n3, new int[]{n4, n5}, byteBuffer, null, null);
    }

    public static void onVideoCapture(String string, int n, int n2, int n3, int[] nArray, ByteBuffer byteBuffer, String string2, int[] nArray2) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        Zmf.onVideoCapture(string, n, n2, n3, nArray, byteBuffer, string2, nArray2);
    }

    public static void onRender(String string, int n, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        Zmf.onVideoRender(string, n, n2, n3, n4, n5, byteBuffer);
    }

    public static void onCaptureDidStop(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        ZmfVideo.trace("onCaptureDidStop: " + string);
        Zmf.onVideoCaptureDidStop(string);
    }

    public static int renderAddCallback(RenderCallback renderCallback) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.videoRenderAddCallback(renderCallback);
    }

    public static int captureAddCallback(CaptureCallback captureCallback) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.videoCaptureAddCallback(captureCallback);
    }

    public static int renderRemoveCallback(int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.videoRenderRemoveCallback(n);
    }

    public static int captureRemoveCallback(int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.videoCaptureRemoveCallback(n);
    }

    public static int convertFromI420(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.convertFromI420(byteBuffer, n, byteBuffer2, n2, n3);
    }

    public static int convertToI420(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3, int n4, int[] nArray) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.convertToI420(byteBuffer, n, byteBuffer2, n2, n3, n4, 0, 0, nArray);
    }

    public static int convertToI420(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.convertToI420(byteBuffer, n, byteBuffer2, n2, n3, n4, n5, n6, nArray);
    }

    public static int convertToI420(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2, int n3, int n4) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return -1;
        }
        return Zmf.convertToI420(byteBuffer, n, byteBuffer2, n2, n3, n4, 0, 0, null);
    }

    public static void onRenderDidReceive(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        ZmfVideo.trace("onRenderDidReceive: " + string + "," + n2 + "," + n3);
        Zmf.videoRenderDidReceive(view, n, string, n2, n3);
    }

    public static void onRenderDidResize(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        ZmfVideo.trace("onRenderDidResize: " + string + "," + n2 + "," + n3);
        Zmf.videoRenderDidResize(view, n, string, n2, n3);
    }

    public static void onRenderDidStart(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        ZmfVideo.trace("onRenderDidStart: " + string + "," + n2 + "," + n3);
        Zmf.videoRenderDidStart(view, n, string, n2, n3);
    }

    public static void onRenderRequestRemove(View view, int n, String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        ZmfVideo.trace("onRenderRequestRemove: " + string);
        Zmf.onVideoRenderRequestRemove(view, n, string);
    }

    public static void onErrorOccurred(String string) {
        Zmf.videoErrorOccurred(string);
    }

    static int[] getCamParam(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return null;
        }
        return sCapture.getCamParam(string);
    }

    static void captureRequestStart(String string, int n, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.captureRequestStart(string, n, n2, n3);
        }
    }

    static void captureRequestChange(String string, int n, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.captureRequestChange(string, n, n2, n3);
        }
    }

    static void captureRequestStop(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.captureRequestStop(string);
        }
    }

    static void captureDidStart(String string, int n, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.captureDidStart(string, n, n2, n3, 0);
        }
    }

    static void captureStatus(String string, int n, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.captureStatus(string, n2);
        }
    }

    static void renderRequestAdd(String string, int n) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.renderRequestAdd(string, n);
        }
    }

    static void renderRequestRemove(View view, int n, String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.renderRequestRemove(view, n, string);
        }
    }

    static void renderRequestRemove(int n, String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Render render : sRenders) {
            if (!render.has(string)) continue;
            Zmf.onVideoRenderRequestRemove((View)render, n, string);
        }
    }

    static void renderDidReceive(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.renderDidReceive(view, n, string, n2, n3);
        }
    }

    static void renderDidResize(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.renderDidResize(view, n, string, n2, n3);
        }
    }

    static void renderDidStart(View view, int n, String string, int n2, int n3) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.renderDidStart(view, n, string, n2, n3);
        }
    }

    static void videoErrorOccurred(String string) {
        if (sCapture == null) {
            ZmfVideo.logError("video not initialized");
            return;
        }
        for (Callback callback : sCallbacks) {
            callback.videoErrorOccurred(string);
        }
    }

    static void onDeviceRotation(int n) {
        int n2 = 1 << n / 90;
        if ((_videoCaptureRotationMask & n2) != 0) {
            _videoCaptureFixedAngle = n;
        }
        if ((_videoRenderRotationMask & n2) != 0) {
            _videoRenderFixedAngle = n;
        }
        _deviceOrientation = n;
    }

    private static synchronized void enableRotation(boolean bl, boolean bl2, boolean bl3) {
        if (sOrientationListener == null) {
            return;
        }
        if (bl) {
            if (bl2) {
                ++sOrientRenderCount;
            } else {
                ++sOrientCaptureCount;
            }
            if (sOrientRenderCount + sOrientCaptureCount == 1) {
                ZmfVideo.trace("start listening rotation");
                sOrientationListener.enable();
            }
        } else {
            if (sOrientRenderCount + sOrientCaptureCount == 0) {
                return;
            }
            if (bl2) {
                if (bl3) {
                    sOrientRenderCount = 0;
                } else if (sOrientRenderCount > 0) {
                    --sOrientRenderCount;
                }
            } else if (bl3) {
                sOrientCaptureCount = 0;
            } else if (sOrientCaptureCount > 0) {
                --sOrientCaptureCount;
            }
            if (sOrientRenderCount + sOrientCaptureCount == 0) {
                ZmfVideo.trace("stop listening rotation");
                sOrientationListener.disable();
            }
        }
    }

    public static int handleFocusMetering(String string, View view, float f, float f2) {
        if (view instanceof Render && string != null && sCapture != null) {
            float[] fArray = ((Render)view).videoRenderRectPara(string);
            int n = ((Render)view).videoRenderActualFillMode(string);
            if (fArray != null && n != -1) {
                ZmfVideo.trace("videoRenderRectPara\uff1a " + fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + fArray[3]);
                ZmfVideo.trace("videorenderMode\uff1a " + n);
                float f3 = 0.0f;
                float f4 = 0.0f;
                ZmfVideo.trace("sScreenOrient\uff1a " + sScreenOrient);
                switch (sScreenOrient) {
                    case 0: {
                        f3 = f;
                        f4 = f2;
                        break;
                    }
                    case 90: {
                        f3 = f2;
                        f4 = 1.0f - f;
                        break;
                    }
                    case 180: {
                        f3 = 1.0f - f;
                        f4 = 1.0f - f2;
                        break;
                    }
                    case 270: {
                        f3 = 1.0f - f2;
                        f4 = f;
                    }
                }
                return sCapture.focusAtPoint(string, fArray, n, f3, f4);
            }
            ZmfVideo.logError("para of render rect is null");
            return -1;
        }
        ZmfVideo.logError("handleFocusMetering error");
        return -1;
    }

    static int captureOrientation() {
        return _videoCaptureFixedAngle;
    }

    static int renderOrientation() {
        return _videoRenderFixedAngle;
    }

    private static void trace(String string) {
        ZmfVideo.logInfo(string);
    }

    public static void logError(String string) {
        Zmf.zmfLog(3, string);
    }

    public static void logWarn(String string) {
        Zmf.zmfLog(2, string);
    }

    public static void logInfo(String string) {
        Zmf.zmfLog(1, string);
    }

    public static void logDebug(String string) {
        Zmf.zmfLog(0, string);
    }

    static {
        sCamAngle = 0;
        _videoCaptureRotationMask = 15;
        _videoCaptureFixedAngle = 0;
        _videoRenderRotationMask = 15;
        _videoRenderFixedAngle = 0;
        _deviceOrientation = 0;
        sScreenOrient = 0;
        sOrientCaptureCount = 0;
        sOrientRenderCount = 0;
        sSupportNativeRender = false;
        sRenders = new HashSet<Render>();
        sCallbacks = new HashSet<Callback>();
    }

    public static interface CaptureCallback {
        public boolean onFrame(String var1, int var2, int var3, int var4, int[] var5, ByteBuffer var6);
    }

    public static interface RenderCallback {
        public boolean onFrame(String var1, int var2, int var3, int var4, int var5, int var6, ByteBuffer var7, int var8);
    }

    public static interface Callback {
        public void captureRequestStart(String var1, int var2, int var3, int var4);

        public void captureRequestChange(String var1, int var2, int var3, int var4);

        public void captureRequestStop(String var1);

        public void captureDidStart(String var1, int var2, int var3, int var4, int var5);

        public void captureStatus(String var1, int var2);

        public void renderRequestAdd(String var1, int var2);

        public void renderDidReceive(View var1, int var2, String var3, int var4, int var5);

        public void renderDidResize(View var1, int var2, String var3, int var4, int var5);

        public void renderDidStart(View var1, int var2, String var3, int var4, int var5);

        public void renderRequestRemove(View var1, int var2, String var3);

        public void videoErrorOccurred(String var1);
    }
}

