/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.JCUtils;
import com.juphoon.cloud.MtcWrapOperation;
import com.justalk.cloud.avatar.ZpandTimer;
import com.justalk.cloud.lemon.MtcBuddy;
import com.justalk.cloud.lemon.MtcCall;
import com.justalk.cloud.lemon.MtcCallConstants;
import com.justalk.cloud.lemon.MtcCallDb;
import com.justalk.cloud.lemon.MtcCallExt;
import com.justalk.cloud.lemon.MtcCli;
import com.justalk.cloud.lemon.MtcCliCfg;
import com.justalk.cloud.lemon.MtcCliConstants;
import com.justalk.cloud.lemon.MtcCliDb;
import com.justalk.cloud.lemon.MtcConf;
import com.justalk.cloud.lemon.MtcConfConstants;
import com.justalk.cloud.lemon.MtcConstants;
import com.justalk.cloud.lemon.MtcFs;
import com.justalk.cloud.lemon.MtcFs2;
import com.justalk.cloud.lemon.MtcGroup;
import com.justalk.cloud.lemon.MtcGroupConstants;
import com.justalk.cloud.lemon.MtcIm;
import com.justalk.cloud.lemon.MtcImConstants;
import com.justalk.cloud.lemon.MtcImDb;
import com.justalk.cloud.lemon.MtcProf;
import com.justalk.cloud.lemon.MtcSgw;
import com.justalk.cloud.lemon.MtcUe;
import com.justalk.cloud.lemon.MtcUeConstants;
import com.justalk.cloud.lemon.MtcUeDb;
import com.justalk.cloud.lemon.MtcUser;
import com.justalk.cloud.lemon.MtcUserConstants;
import com.justalk.cloud.lemon.MtcUtil;
import com.justalk.cloud.lemon.MtcVer;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MtcEngine
implements MtcConstants,
MtcCliConstants,
MtcCallConstants,
MtcConfConstants,
MtcUserConstants,
MtcImConstants,
MtcUeConstants,
MtcGroupConstants {
    static final String TAG = MtcEngine.class.getSimpleName();
    static final String JCSDK = "JCSDK";
    protected boolean hasCalls = false;
    protected boolean hasMediaChannel = false;
    private boolean mForeground = true;
    private Set<MtcNotifyListener> mMtcNotifyListeners;
    private boolean mHasInit = false;
    private Context mContext;
    private JCParam.Login mLoginParam;
    private int mCookie = 0;
    private boolean mHasNet = true;
    private ScheduledExecutorService mScheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture mLoginScheduled;
    private ScheduledFuture mLogoutScheduled;
    private Set<MtcWrapOperation> mWrapOperations;

    private MtcEngine() {
    }

    static MtcEngine getInstance() {
        return MtcEngineHolder.INSTANCE;
    }

    private static int notified(String name, int cookie, String info) {
        MtcEngine.getInstance().dealNotify(name, cookie, info);
        return 0;
    }

    int genCookie() {
        return ++this.mCookie;
    }

    JCResult initialize(JCParam.Init param) {
        this.mContext = param.context;
        if (this.isSupport()) {
            try {
                System.loadLibrary("zmf");
                System.loadLibrary("mtc");
            }
            catch (UnsatisfiedLinkError error) {
                JCLog.error(TAG, "\u94fe\u63a5\u9519\u8bef", new Object[0]);
                return new JCResult(false);
            }
        } else {
            JCLog.error(TAG, "\u4e0d\u652f\u6301", new Object[0]);
            return new JCResult(false);
        }
        if (TextUtils.isEmpty((CharSequence)param.sdkInfoDir)) {
            param.sdkInfoDir = JCUtils.getSdkInfoDir(this.mContext);
        }
        String applicationName = this.mContext.getPackageName();
        MtcCliCfg.Mtc_CliCfgSetLogLevel((int)3);
        MtcCliCfg.Mtc_CliCfgSetAppVer((String)JCUtils.getAppVersion(this.mContext));
        String logDir = TextUtils.isEmpty((CharSequence)param.sdkLogDir) ? param.sdkInfoDir + "/log" : param.sdkLogDir;
        new File(logDir).mkdirs();
        MtcCliCfg.Mtc_CliCfgSetLogDir((String)logDir);
        MtcCliCfg.Mtc_CliCfgSetAppVer((String)JCUtils.getAppVersion(this.mContext));
        MtcCliCfg.Mtc_CliCfgSetContext((Object)this.mContext);
        ZpandTimer.init((Context)this.mContext, (String)applicationName);
        String profilesDir = param.sdkInfoDir + "/profiles";
        new File(profilesDir).mkdirs();
        if (MtcCli.Mtc_CliInit((String)profilesDir, null) != ZOK) {
            JCLog.error(TAG, "\u521d\u59cb\u5316\u9519\u8bef", new Object[0]);
            return new JCResult(false);
        }
        String notifyClassName = MtcEngine.class.getName();
        notifyClassName = notifyClassName.replace('.', '/');
        MtcCli.Mtc_CliSetJavaNotify((String)notifyClassName, (String)"notified");
        this.mHasInit = true;
        return new JCResult(true);
    }

    void uninitialize() {
        if (this.mHasInit) {
            MtcCli.Mtc_CliDestroy();
            this.mHasInit = !this.mHasInit;
        }
    }

    void netChange(JCParam.Net param) {
        if (param.type == 0) {
            MtcCli.Mtc_CliNetworkChanged((int)param.newNetType);
            boolean bl = this.mHasNet = param.newNetType != -2;
            if (MtcCli.Mtc_CliGetState() == 2) {
                // empty if block
            }
            this.dealActive();
        }
    }

    void setForeground(boolean foreground) {
        this.mForeground = foreground;
        this.dealActive();
    }

    String getDeviceId() {
        return MtcCli.Mtc_CliGetDevId();
    }

    JCResult login(JCParam.Login param) {
        this.mLoginParam = param;
        MtcCli.Mtc_CliOpen((String)param.username);
        MtcUeDb.Mtc_UeDbSetUserName((String)param.username);
        MtcUeDb.Mtc_UeDbSetNetwork((String)param.server);
        MtcUeDb.Mtc_UeDbSetAppKey((String)param.appkey);
        MtcUeDb.Mtc_UeDbSetPassword((String)param.password);
        MtcUeDb.Mtc_UeDbSetIdType((int)3);
        MtcImDb.Mtc_ImDbSetAutoRecv((boolean)true);
        MtcCliDb.Mtc_CliDbApplyAll();
        MtcProf.Mtc_ProfSaveProvision();
        MtcCli.Mtc_CliStart();
        MtcImDb.Mtc_ImDbSetAutoRecv((boolean)true);
        MtcCli.Mtc_CliSetDevInfo((String)"DeviceInfo.terminal_sw_version", (String)Build.VERSION.RELEASE);
        MtcCli.Mtc_CliSetDevInfo((String)"DeviceInfo.terminal_model", (String)Build.MODEL);
        MtcCli.Mtc_CliSetDevInfo((String)"DeviceInfo.terminal_vendor", (String)Build.MANUFACTURER);
        MtcCli.Mtc_CliSetDevInfo((String)"DeviceInfo.client_version", (String)MtcVer.Mtc_GetLemonVersion());
        MtcCli.Mtc_CliSetDevInfo((String)"DeviceInfo.lang", (String)Locale.getDefault().toString());
        MtcCallDb.Mtc_CallDbSetTtoRecv((boolean)false);
        MtcCallDb.Mtc_CallDbSetTtoSend((boolean)false);
        if (ZOK == MtcCli.Mtc_CliLogin((int)1, null)) {
            this.startLoginTimer(param.timeout);
            return new JCResult(true);
        }
        return new JCResult(false);
    }

    JCResult logout(JCParam.Logout param) {
        this.stopLoginTimer();
        if (MtcCli.Mtc_CliLogout() != ZOK) {
            this.forceLogout();
        } else {
            this.startLogoutTimer(param.timeout);
        }
        return new JCResult(true);
    }

    JCResult queryUserStatus(JCParam.queryUserStatus param) {
        ++this.mCookie;
        JSONArray jsonArray = new JSONArray();
        for (String userId : param.userIdList) {
            if (TextUtils.isEmpty((CharSequence)userId)) continue;
            String userUri = MtcUser.Mtc_UserFormUri((int)3, (String)userId);
            if (MtcUser.Mtc_UserIsValidUri((String)userUri)) {
                jsonArray.put((Object)userUri.toLowerCase());
                continue;
            }
            JCLog.error(TAG, "invalid user id:" + userId, new Object[0]);
        }
        int ret = MtcBuddy.Mtc_BuddyQueryUsersStatus((long)this.mCookie, (String)jsonArray.toString(), null);
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult addPushInfo(JCParam.Push param) {
        int ret = MtcCli.Mtc_CliSetPushParm((String)param.data);
        return new JCResult(ret == ZOK);
    }

    JCResult sendMessage(JCParam.Message param) {
        String userUri = !TextUtils.isEmpty((CharSequence)param.groupId) ? param.groupId : MtcUser.Mtc_UserFormUri((int)3, (String)param.userId);
        int ret = ZFAILED;
        try {
            JSONObject object = new JSONObject();
            object.put("MtcImDisplayNameKey", (Object)param.displayName);
            object.put("MtcImUserDataKey", (Object)param.messageInfo);
            ret = MtcIm.Mtc_ImSendInfo((long)(++this.mCookie), (String)userUri, (String)param.messageType, (String)param.messageContent, (String)object.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult fetchMessage(JCParam.MessageFetch param) {
        int ret;
        return new JCResult((ret = MtcIm.Mtc_ImRefresh((long)(++this.mCookie), null, (long)0L)) == ZOK, this.mCookie, 0);
    }

    JCResult dealFile(JCParam.FileDeal param) {
        int ret = ZFALSE;
        if (param.type == 0) {
            return new JCResult((long)(ret = MtcFs2.Mtc_Fs2Upload((long)(++this.mCookie), (String)MtcUe.Mtc_UeGetUid(), (String)param.path, (long)param.expireTime)) != ZINVALIDID, this.mCookie, ret);
        }
        if (param.type == 1) {
            return new JCResult((long)(ret = MtcFs2.Mtc_Fs2Download((long)(++this.mCookie), (String)param.uri, (String)param.path, (long)0L)) != ZINVALIDID, this.mCookie, ret);
        }
        if (param.type == 2) {
            ret = MtcFs.Mtc_FsCancel((int)param.sessId);
        }
        return new JCResult(ret == ZOK);
    }

    JCResult call(JCParam.Call param) {
        try {
            JSONObject object = new JSONObject();
            object.put("MtcCallInfoHasVideoKey", param.video);
            object.put("MtcCallInfoDisplayNameKey", (Object)param.displayName);
            object.put("MtcCallInfoUserDataKey", (Object)param.extraParam);
            String userUri = MtcUser.Mtc_UserFormUri((int)3, (String)param.userId);
            int callId = MtcCall.Mtc_CallJ((String)userUri, (long)0L, (String)object.toString());
            if ((long)callId != ZMAXUINT) {
                return new JCResult(true, (long)callId, MtcCall.Mtc_CallGetName((int)callId));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(false);
    }

    JCResult term(JCParam.Term param) {
        if (MtcCall.Mtc_CallTerm((int)((int)param.callId), (int)((int)param.reason), (String)param.desc) == ZOK) {
            return new JCResult(true);
        }
        return new JCResult(false);
    }

    JCResult answer(JCParam.Answer param) {
        if (MtcCall.Mtc_CallAnswer((int)((int)param.callId), (long)0L, (boolean)true, (boolean)param.video) == ZOK) {
            return new JCResult(true);
        }
        return new JCResult(false);
    }

    JCResult callMedia(JCParam.CallMedia param) {
        int ret = ZFAILED;
        if (param.type == 0) {
            ret = param.enable ? MtcCall.Mtc_CallCameraAttach((int)((int)param.callId), (String)param.optionalValue) : MtcCall.Mtc_CallCameraDetach((int)((int)param.callId));
        } else if (param.type == 1) {
            ret = MtcCall.Mtc_CallSetMicMute((int)((int)param.callId), (boolean)param.enable);
        } else if (param.type == 3) {
            ret = MtcCall.Mtc_CallSetMixVoice((int)((int)param.callId), (boolean)param.enable);
        } else if (param.type == 2) {
            ret = MtcCall.Mtc_CallSetSpkMute((int)((int)param.callId), (boolean)param.enable);
        } else if (param.type == 4) {
            ret = MtcCall.Mtc_CallVideoSetSend((int)((int)param.callId), (int)(param.enable ? 1852992876 : 0x636F6666));
        } else if (param.type == 5) {
            ret = param.enable ? MtcCall.Mtc_CallRecCallStart((int)((int)param.callId), (String)param.optionalValue, (short)2) : MtcCall.Mtc_CallRecCallStop((int)((int)param.callId));
        } else if (param.type == 6) {
            try {
                JSONObject videoJsonParam = new JSONObject();
                videoJsonParam.put("MtcMediaFileTypeKey", 12);
                videoJsonParam.put("MtcMediaVideoRecordOptionKey", 1);
                videoJsonParam.put("MtcMediaVideoQualityKey", 2);
                videoJsonParam.put("MtcMediaVideoFillModeKey", 0);
                videoJsonParam.put("MtcMediaVideoFrameRateKey", 30);
                ret = param.remote ? (param.enable ? MtcCall.Mtc_CallRecRecvVideoStart((int)((int)param.callId), (String)param.optionalValue, (int)param.videoRecordWidth, (int)param.videoRecordHeight, (String)videoJsonParam.toString()) : MtcCall.Mtc_CallRecRecvVideoStop((int)((int)param.callId))) : (param.enable ? MtcCall.Mtc_CallRecSendVideoStart((int)((int)param.callId), (String)param.optionalValue, (int)param.videoRecordWidth, (int)param.videoRecordHeight, (String)videoJsonParam.toString()) : MtcCall.Mtc_CallRecSendVideoStop((int)((int)param.callId)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JCResult(ret == ZOK);
    }

    JCResult callStreamData(JCParam.CallMessage param) {
        int ret = MtcCall.Mtc_CallSendStreamData((int)((int)param.callId), (boolean)true, (String)param.messageType, (String)param.content);
        return new JCResult(ret == ZOK);
    }

    JCResult callMessage(JCParam.CallMessage param) {
        int ret = MtcCall.Mtc_CallInfo((int)((int)param.callId), (String)param.content);
        return new JCResult(ret == ZOK);
    }

    JCResult fetchCalls(JCParam.CallFetch param) {
        int ret = MtcCallExt.Mtc_CallQueryMissed();
        return new JCResult(ret == ZOK);
    }

    JCResult callStatistics(JCParam.CallStatistics param) {
        try {
            JSONObject object = new JSONObject();
            String content = MtcCall.Mtc_CallGetAudioStat((int)((int)param.callId));
            if (TextUtils.isEmpty((CharSequence)content)) {
                content = "";
            }
            object.put("Audio", (Object)content);
            content = MtcCall.Mtc_CallGetVideoStat((int)((int)param.callId));
            if (TextUtils.isEmpty((CharSequence)content)) {
                content = "";
            }
            object.put("Video", (Object)content);
            content = MtcCall.Mtc_CallGetMptStat((int)((int)param.callId));
            if (TextUtils.isEmpty((CharSequence)content)) {
                content = "";
            }
            object.put("Mtp", (Object)content);
            return new JCResult(true, object.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JCResult(true, "");
        }
    }

    JCResult fetchGroup(JCParam.GroupFetch parms) {
        int ret = MtcGroup.Mtc_GroupRefresh((long)(++this.mCookie), (String)parms.groupId, (long)parms.updateTime);
        if (!TextUtils.isEmpty((CharSequence)parms.groupId) && ret == ZOK) {
            MtcWrapOperation wrapOperation = new MtcWrapOperation();
            wrapOperation.groupFetchParms = parms;
            wrapOperation.cookie = this.mCookie;
            wrapOperation.type = 0;
            this.addWrapOperation(wrapOperation);
        }
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult createGroup(JCParam.GroupCreate parms) {
        int ret = ZFAILED;
        ++this.mCookie;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("PropertyControl", 2);
            JSONArray jsonArray = new JSONArray();
            for (JCParam.GroupCreateMember groupCreateMember : parms.members) {
                JSONObject memberJson = new JSONObject();
                memberJson.put("UserUri", (Object)this.userIdToUserUri(groupCreateMember.userId));
                memberJson.put("RelationType", groupCreateMember.memberType);
                memberJson.put("DisplayName", (Object)groupCreateMember.displayName);
                memberJson.put("Tag", (Object)groupCreateMember.tag);
                jsonArray.put((Object)memberJson);
            }
            ret = MtcGroup.Mtc_GroupCreate((long)this.mCookie, (int)0, (String)parms.groupName, (String)jsonObject.toString(), (String)jsonArray.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(true);
    }

    JCResult updateGroup(JCParam.GroupUpdate parms) {
        int ret = ZFAILED;
        ++this.mCookie;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Name", (Object)parms.groupName);
            jsonObject.put("PropertyControl", 2);
            ret = MtcGroup.Mtc_GroupSetProperties((long)this.mCookie, (String)parms.groupId, (String)jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult dissolveGroup(JCParam.GroupDissolve parms) {
        int ret;
        return new JCResult((ret = MtcGroup.Mtc_GroupRemove((long)(++this.mCookie), (String)parms.groupId)) == ZOK, this.mCookie, 0);
    }

    JCResult leaveGroup(JCParam.GroupLeave parms) {
        int ret;
        String uri = this.userIdToUserUri(parms.userId);
        if ((ret = MtcGroup.Mtc_GroupRemoveRelation((long)(++this.mCookie), (String)parms.groupId, (String)uri)) == ZOK) {
            // empty if block
        }
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult updateSelf(JCParam.GroupUpdateSelf parms) {
        int ret;
        String uri = this.userIdToUserUri(parms.userId);
        return new JCResult((ret = MtcGroup.Mtc_GroupUpdateRelation((long)(++this.mCookie), (String)parms.groupId, (int)parms.memberType, (String)uri, (String)parms.displayName, (String)parms.tag)) == ZOK, this.mCookie, 0);
    }

    JCResult dealGroupMembers(JCParam.GroupDealMembers parms) {
        int ret = ZFAILED;
        ++this.mCookie;
        try {
            JSONArray addArray = new JSONArray();
            JSONArray updateArray = new JSONArray();
            JSONArray removeArray = new JSONArray();
            for (JCParam.GroupDealMember dealMember : parms.dealMembers) {
                if (dealMember.dealType == 1) {
                    removeArray.put((Object)this.userIdToUserUri(dealMember.userId));
                    continue;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("UserUri", (Object)this.userIdToUserUri(dealMember.userId));
                jsonObject.put("RelationType", dealMember.memberType);
                jsonObject.put("DisplayName", (Object)dealMember.displayName);
                jsonObject.put("Tag", (Object)dealMember.tag);
                if (dealMember.dealType == 0) {
                    addArray.put((Object)jsonObject);
                    continue;
                }
                updateArray.put((Object)jsonObject);
            }
            JSONObject result = new JSONObject();
            result.put("ListToAdd", (Object)addArray);
            result.put("ListToRemove", (Object)removeArray);
            result.put("ListToUpdate", (Object)updateArray);
            ret = MtcGroup.Mtc_GroupSetRelations((long)this.mCookie, (String)parms.groupId, (String)result.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    JCResult log(JCParam.Log param) {
        if (param.type == 0) {
            if (this.mHasInit) {
                MtcUtil.Mtc_AnyLogInfoStr((String)JCSDK, (String)param.log);
            } else {
                Log.i((String)JCSDK, (String)param.log);
            }
        } else if (param.type == 1) {
            if (this.mHasInit) {
                MtcUtil.Mtc_AnyLogErrStr((String)JCSDK, (String)param.log);
            } else {
                Log.e((String)JCSDK, (String)param.log);
            }
        }
        return new JCResult(true);
    }

    JCResult queryConf(JCParam.ConfQuery param) {
        int ret;
        return new JCResult((ret = MtcConf.Mtc_ConfQueryRoom((int)0, (String)param.channelId, (long)(++this.mCookie))) == ZOK, this.mCookie, 0);
    }

    JCResult joinConf(JCParam.ConfJoin param) {
        int state = 0;
        state += 2;
        ++state;
        if (param.localAudio) {
            state += 8;
        }
        if (param.localVideo) {
            state += 4;
        }
        try {
            int confId;
            JSONObject object = new JSONObject();
            object.put("MtcConfStateKey", state);
            object.put("MtcConfCapacityKey", param.capacity);
            if (!TextUtils.isEmpty((CharSequence)param.webCastingUri)) {
                object.put("MtcConfWebCastingUriKey", (Object)param.webCastingUri);
            }
            if (!TextUtils.isEmpty((CharSequence)param.password)) {
                object.put("MtcConfPasswordKey", (Object)param.password);
            }
            object.put("MtcConfQualityGradeKey", param.maxResolution);
            if (param.smoothMode) {
                object.put("MtcConfSmoothModeKey", true);
            }
            if ((long)(confId = MtcConf.Mtc_ConfJoinRoom((int)param.regionId, (String)param.channelId, (long)(++this.mCookie), (String)param.displayName, (boolean)true, (String)object.toString())) != ZMAXUINT) {
                return new JCResult(true, confId);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(false);
    }

    JCResult leaveConf(JCParam.ConfLeave param) {
        int ret = ZFAILED;
        if (param.type == 0) {
            ret = MtcConf.Mtc_ConfLeave((int)param.confId);
        } else if (param.type == 1) {
            ret = MtcConf.Mtc_ConfCancelReservation((long)0L, (int)param.confId);
        }
        return new JCResult(ret == ZOK);
    }

    JCResult sendConfMessage(JCParam.ConfMessage param) {
        int ret = ZFAILED;
        if (TextUtils.isEmpty((CharSequence)param.toUserID)) {
            ret = param.content.length() > 4096 ? MtcConf.Mtc_ConfSendBypassData((int)param.confId, (String)param.type, (String)param.content) : (param.type.contains("\"text\"") ? MtcConf.Mtc_ConfSendText((int)param.confId, null, (String)param.content) : MtcConf.Mtc_ConfSendData((int)param.confId, null, (String)param.type, (String)param.content));
        } else {
            String uri = MtcUser.Mtc_UserFormUri((int)3, (String)param.toUserID);
            ret = param.type.contains("\"text\"") ? MtcConf.Mtc_ConfSendText((int)param.confId, (String)uri, (String)param.content) : MtcConf.Mtc_ConfSendData((int)param.confId, (String)uri, (String)param.type, (String)param.content);
        }
        return new JCResult(ret == ZOK);
    }

    JCResult confSendCmd(JCParam.ConfCommand param) {
        int ret = ZFAILED;
        ret = MtcConf.Mtc_ConfCommand((int)param.confId, (String)("MtcConfCmd" + param.name), (String)param.param);
        return new JCResult(ret == ZOK);
    }

    JCResult confMedia(JCParam.ConfMedia param) {
        int ret = ZFALSE;
        if (param.type == 2) {
            ret = param.on ? MtcConf.Mtc_ConfStartSend((int)param.confId, (int)3) : MtcConf.Mtc_ConfStopSend((int)param.confId, (int)3);
        } else if (param.type == 0) {
            ret = param.on ? MtcConf.Mtc_ConfStartSend((int)param.confId, (int)1) : MtcConf.Mtc_ConfStopSend((int)param.confId, (int)1);
        } else if (param.type == 1) {
            ret = param.on ? MtcConf.Mtc_ConfStartSend((int)param.confId, (int)2) : MtcConf.Mtc_ConfStopSend((int)param.confId, (int)2);
        } else if (param.type == 5) {
            ret = MtcConf.Mtc_ConfSubscribeAudio((int)param.confId, (boolean)param.on);
        } else if (param.type == 3) {
            try {
                JSONObject object = new JSONObject();
                object.put("MtcConfUserUriKey", (Object)param.uri);
                object.put("MtcConfPictureSizeKey", param.pictureSize);
                object.put("MtcConfFrameRateKey", param.frameRate);
                ret = MtcConf.Mtc_ConfCommand((int)param.confId, (String)"MtcConfCmdRequestVideo", (String)object.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (param.type == 4) {
            ret = MtcConf.Mtc_ConfSetVideoCapture((int)param.confId, (String)param.camera);
        } else if (param.type == 6) {
            ret = param.on ? MtcConf.Mtc_ConfStartCdn((int)param.confId) : MtcConf.Mtc_ConfStopCdn((int)param.confId);
        } else if (param.type == 7) {
            ret = param.on ? MtcConf.Mtc_ConfCommand((int)param.confId, (String)"MtcConfCmdReplayStartRecord", (String)param.recordParam) : MtcConf.Mtc_ConfCommand((int)param.confId, (String)"MtcConfCmdReplayStopRecord", (String)param.recordParam);
        } else if (param.type == 8) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfSetScreenCapture((int)param.confId, (String)param.camera);
                if (ret == ZOK) {
                    ret = MtcConf.Mtc_ConfSetScreenUser((int)param.confId, (String)MtcUe.Mtc_UeGetUri());
                }
            } else {
                ret = MtcConf.Mtc_ConfSetScreenUser((int)param.confId, null);
            }
        }
        return new JCResult(ret == ZOK);
    }

    JCResult confStatistics(JCParam.ConfStatistics param) {
        try {
            JSONObject object = new JSONObject();
            String temp = MtcConf.Mtc_ConfGetStatistics((int)param.confId, (String)"MtcConfStsConfig", null);
            if (TextUtils.isEmpty((CharSequence)temp)) {
                temp = "";
            }
            object.put("Config", (Object)temp);
            temp = MtcConf.Mtc_ConfGetStatistics((int)param.confId, (String)"MtcConfStsNetwork", null);
            if (TextUtils.isEmpty((CharSequence)temp)) {
                temp = "";
            }
            object.put("Network", (Object)temp);
            temp = MtcConf.Mtc_ConfGetStatistics((int)param.confId, (String)"MtcConfStsTransport", null);
            if (TextUtils.isEmpty((CharSequence)temp)) {
                temp = "";
            }
            object.put("Transport", (Object)temp);
            JSONArray array = new JSONArray();
            for (String userId : param.parts) {
                temp = MtcConf.Mtc_ConfGetStatistics((int)param.confId, (String)"MtcConfStsParticipant", (String)MtcUser.Mtc_UserFormUri((int)3, (String)userId));
                if (TextUtils.isEmpty((CharSequence)temp)) continue;
                JSONObject part = new JSONObject();
                part.put(userId, (Object)temp);
                array.put((Object)part);
            }
            object.put("Participants", (Object)array);
            return new JCResult(true, object.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JCResult(true, "");
        }
    }

    JCResult confUpdateCustomProperty(JCParam.ConfCustomProperty param) {
        JSONObject obj = new JSONObject();
        Set<Map.Entry<String, String>> set = param.mapCustomProperty.entrySet();
        for (Map.Entry<String, String> m : set) {
            try {
                obj.put(m.getKey(), (Object)m.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        int ret = MtcConf.Mtc_ConfSetProp((int)param.confId, (String)"MtcConfDataKey", (String)obj.toString());
        return new JCResult(ret == ZOK, 0, 0);
    }

    JCResult confInviteSipUser(JCParam.ConfInviteSipUser param) {
        int ret = MtcSgw.Mtc_SgwDeliSipInvite((long)(++this.mCookie), (String)String.valueOf(param.channelNumber), (String)param.password, (String)param.userId, (String)(TextUtils.isEmpty((CharSequence)param.callerNum) ? null : param.callerNum), (String)(TextUtils.isEmpty((CharSequence)param.coreNetId) ? null : param.coreNetId));
        return new JCResult(ret == ZOK, this.mCookie, 0);
    }

    void addMtcNotifyListener(MtcNotifyListener listener) {
        if (this.mMtcNotifyListeners == null) {
            this.mMtcNotifyListeners = new HashSet<MtcNotifyListener>();
        }
        this.mMtcNotifyListeners.add(listener);
    }

    void removeMtcNotifyListener(MtcNotifyListener listener) {
        if (this.mMtcNotifyListeners != null) {
            this.mMtcNotifyListeners.remove(listener);
        }
    }

    private boolean isSupport() {
        if (Build.VERSION.SDK_INT < 21) {
            return TextUtils.equals((CharSequence)Build.CPU_ABI, (CharSequence)"armeabi-v7a") || TextUtils.equals((CharSequence)Build.CPU_ABI2, (CharSequence)"armeabi-v7a") || TextUtils.equals((CharSequence)Build.CPU_ABI, (CharSequence)"x86") || TextUtils.equals((CharSequence)Build.CPU_ABI2, (CharSequence)"x86");
        }
        for (String abi : Build.SUPPORTED_ABIS) {
            if (!TextUtils.equals((CharSequence)abi, (CharSequence)"armeabi-v7a") && !TextUtils.equals((CharSequence)abi, (CharSequence)"x86")) continue;
            return true;
        }
        return false;
    }

    private void forceLogout() {
        MtcCli.Mtc_CliStop();
        MtcCli.Mtc_CliClose();
        JSONObject object = new JSONObject();
        try {
            object.put("MtcCliStatusCodeKey", 57600);
            MtcEngine.notified("MtcCliServerDidLogoutNotification", 0, object.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void dealActive() {
        if (MtcCli.Mtc_CliGetState() <= 0) {
            JCLog.info(TAG, "dealActive not logined %d", MtcCli.Mtc_CliGetState());
            return;
        }
        if (this.mForeground && this.mHasNet) {
            JCLog.info(TAG, "\u6d3b\u8dc3", new Object[0]);
            MtcCli.Mtc_CliWakeup((boolean)true);
            MtcCli.Mtc_CliRefresh();
            if (MtcCli.Mtc_CliGetState() == 2) {
                MtcIm.Mtc_ImRefresh((long)0L, null, (long)0L);
                MtcCallExt.Mtc_CallQueryMissed();
            }
        } else if (!this.hasCalls && !this.hasMediaChannel) {
            JCLog.info(TAG, "\u975e\u6d3b\u8dc3", new Object[0]);
            MtcCli.Mtc_CliWakeup((boolean)false);
        } else {
            JCLog.info(TAG, "\u4e0d\u5904\u7406\u6d3b\u8dc3", new Object[0]);
        }
    }

    private void startLoginTimer(int interval) {
        this.stopLoginTimer();
        this.mLoginScheduled = this.mScheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                JCClientThreadImpl.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        JCLog.error(TAG, "\u767b\u9646\u8d85\u65f6", new Object[0]);
                        MtcCli.Mtc_CliStop();
                        MtcCli.Mtc_CliClose();
                        MtcEngine.this.mLoginScheduled = null;
                        MtcEngine.notified("MtcCliServerLoginDidFailNotification", 0, String.format(Locale.getDefault(), "{\"%s\":%d}", "MtcCliStatusCodeKey", 57605));
                    }
                });
            }
        }, (long)interval, TimeUnit.SECONDS);
    }

    private void stopLoginTimer() {
        if (this.mLoginScheduled != null) {
            this.mLoginScheduled.cancel(true);
            this.mLoginScheduled = null;
        }
    }

    private void startLogoutTimer(int interval) {
        this.stopLogoutTimer();
        this.mLogoutScheduled = this.mScheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                JCClientThreadImpl.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        JCLog.error(TAG, "\u767b\u51fa\u8d85\u65f6", new Object[0]);
                        MtcEngine.this.forceLogout();
                        MtcEngine.this.mLogoutScheduled = null;
                    }
                });
            }
        }, (long)interval, TimeUnit.SECONDS);
    }

    private void stopLogoutTimer() {
        if (this.mLogoutScheduled != null) {
            this.mLogoutScheduled.cancel(true);
            this.mLogoutScheduled = null;
        }
    }

    private void dealNotify(String name, int mCookie, String info) {
        if (this.mMtcNotifyListeners != null) {
            if (!TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfVolumeChangedNotification")) {
                JCLog.info("MtcEngine", "name=%s mCookie:%d info=%s", name, mCookie, info == null ? "" : info);
            }
            MtcWrapOperation wrapOperation = this.dealWrapOperation(name, mCookie, info);
            JCNotify notify = null;
            if (wrapOperation != null) {
                if (wrapOperation.finish) {
                    notify = wrapOperation.notify;
                    this.removeWrapOperation(wrapOperation);
                }
            } else {
                notify = JCNotify.create(name, mCookie, info);
                if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcCliServerLoginOkNotification")) {
                    this.stopLoginTimer();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcCliServerLoginDidFailNotification")) {
                    if (notify.cliNotify.loginFail.statusCode == 57604 && this.mLoginParam.autoCreate) {
                        JCLog.info(TAG, "\u81ea\u52a8\u521b\u5efa\u8d26\u53f7", new Object[0]);
                        if (MtcUe.Mtc_UeCreate((long)0L, (String)this.mLoginParam.username, (String)this.mLoginParam.password) == ZOK) {
                            return;
                        }
                    }
                    this.stopLoginTimer();
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcCliServerDidLogoutNotification")) {
                    this.stopLogoutTimer();
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcCliServerLogoutedNotification")) {
                    JCLog.info(TAG, "\u8d26\u53f7\u88ab\u5f3a\u5236\u767b\u51fa", new Object[0]);
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcUeCreateOkNotification")) {
                    JCLog.info(TAG, "\u8d26\u53f7\u521b\u5efa\u6210\u529f", new Object[0]);
                    MtcCli.Mtc_CliLogin((int)1, (String)"0.0.0.0");
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcUeCreateDidFailNotification")) {
                    JCLog.info(TAG, "\u8d26\u53f7\u521b\u5efa\u5931\u8d25", new Object[0]);
                    notify = JCNotify.create("MtcCliServerLoginDidFailNotification", mCookie, String.format(Locale.getDefault(), "{\"%s\":%d}", "MtcCliStatusCodeKey", 57604));
                    this.stopLoginTimer();
                } else if (!TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfJoinOkNotification") && !TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfJoinDidFailNotification")) {
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcImInfoDidReceiveNotification")) {
                        if (notify != null) {
                            final String label = notify.messageNotify.recvMessage.messageLabel;
                            final long id = notify.messageNotify.recvMessage.messageId;
                            JCClientThreadImpl.getInstance().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MtcIm.Mtc_ImNotifyEnd((String)label, (long)id);
                                }
                            }, 200L);
                        }
                    } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcCallIncomingNotification")) {
                        if (this.hasCalls) {
                            MtcCall.Mtc_CallAlert((int)((int)notify.callNotify.incoming.callId), (long)0L, (int)2002, (boolean)false);
                        } else {
                            MtcCall.Mtc_CallAlert((int)((int)notify.callNotify.incoming.callId), (long)0L, (int)2001, (boolean)false);
                        }
                    }
                }
            }
            if (notify != null) {
                for (MtcNotifyListener listener : MtcEngine.getInstance().mMtcNotifyListeners) {
                    listener.onNotify(notify);
                }
            }
        }
    }

    private void addWrapOperation(MtcWrapOperation wrapOperation) {
        if (this.mWrapOperations == null) {
            this.mWrapOperations = new HashSet<MtcWrapOperation>();
        }
        this.mWrapOperations.add(wrapOperation);
    }

    private void removeWrapOperation(MtcWrapOperation wrapOperation) {
        if (this.mWrapOperations != null) {
            this.mWrapOperations.remove(wrapOperation);
        }
    }

    private MtcWrapOperation dealWrapOperation(String name, int mCookie, String info) {
        if (this.mWrapOperations != null && !this.mWrapOperations.isEmpty()) {
            for (MtcWrapOperation operation : this.mWrapOperations) {
                if (!operation.deal(mCookie, name, info)) continue;
                return operation;
            }
        }
        return null;
    }

    private String userIdToUserUri(String userId) {
        return MtcUser.Mtc_UserFormUriX((String)"username", (String)userId);
    }

    private static final class MtcEngineHolder {
        private static final MtcEngine INSTANCE = new MtcEngine();

        private MtcEngineHolder() {
        }
    }

    static interface MtcNotifyListener {
        public void onNotify(JCNotify var1);
    }
}

