/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import com.justalk.cloud.lemon.MtcBuddyConstants;
import com.justalk.cloud.lemon.MtcCall;
import com.justalk.cloud.lemon.MtcCallConstants;
import com.justalk.cloud.lemon.MtcCallExt;
import com.justalk.cloud.lemon.MtcCliConstants;
import com.justalk.cloud.lemon.MtcConf;
import com.justalk.cloud.lemon.MtcConfConstants;
import com.justalk.cloud.lemon.MtcFs2Constants;
import com.justalk.cloud.lemon.MtcFsConstants;
import com.justalk.cloud.lemon.MtcGroupConstants;
import com.justalk.cloud.lemon.MtcImConstants;
import com.justalk.cloud.lemon.MtcSgwConstants;
import com.justalk.cloud.lemon.MtcUe;
import com.justalk.cloud.lemon.MtcUser;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JCNotify {
    static final int STORAGE_NONE = 0;
    public static final int STORAGE_PROGRESS = 1;
    public static final int STORAGE_SEND_OK = 2;
    public static final int STORAGE_SEND_FAIL = 3;
    public static final int STORAGE_RECV_OK = 4;
    public static final int STORAGE_RECV_FAIL = 5;
    public static final int MESSAGE_NONE = 0;
    public static final int MESSAGE_SEND_OK = 1;
    public static final int MESSAGE_SEND_FAIL = 2;
    public static final int MESSAGE_RECV_MESSAGE = 3;
    public static final int CONF_NONE = 0;
    public static final int CONF_JOIN_OK = 1;
    public static final int CONF_JOIN_FAIL = 2;
    public static final int CONF_LEAVE = 3;
    public static final int CONF_QUERY_OK = 4;
    public static final int CONF_QUERY_FAIL = 5;
    public static final int CONF_ADD_PARTICIPANT = 6;
    public static final int CONF_REMOVE_PARTICIPANT = 7;
    public static final int CONF_PARTICIPANT_CNANGED = 8;
    public static final int CONF_VOLUME_CHANGED = 9;
    public static final int CONF_ERROR_EVENT = 10;
    public static final int CONF_PROP_CNANGED = 11;
    public static final int CONF_MESSAGE_RECEIVED = 12;
    public static final int CONF_SIP_INVITE_OK = 13;
    public static final int CONF_SIP_INVITE_FAIL = 14;
    public static final int CONF_CANCEL_RESERVATION_Ok = 15;
    public static final int CONF_CANCEL_RESERVATION_FAIL = 16;
    public static final int CLI_NONE = 0;
    public static final int CLI_LOGIN_OK = 1;
    public static final int CLI_LOGIN_FAIL = 2;
    public static final int CLI_DID_LOGOUT = 3;
    public static final int CLI_LOGOUTED = 4;
    public static final int CLI_RECONNECTING = 5;
    public static final int CLI_RECONNECT_OK = 6;
    public static final int CALL_NONE = 0;
    public static final int CALL_DIDTERM = 1;
    public static final int CALL_TERMED = 2;
    public static final int CALL_INCOMING = 3;
    public static final int CALL_TALKING = 4;
    public static final int CALL_CONNECTING = 5;
    public static final int CALL_ALERTED = 6;
    public static final int CALL_MESSAGE = 7;
    public static final int CALL_OTHER_VIDEO_STATUS = 8;
    public static final int CALL_MISS_CALL = 9;
    public static final int CALL_NET_STATUS = 10;
    public static final int CALL_TRYING = 11;
    public static final int CALL_MESSAGE_TYPE_INFO = 0;
    public static final int CALL_MESSAGE_TYPE_STREAM_DATA = 1;
    static final int GROUP_TYPE_NONE = 0;
    static final int GROUP_TYPE_CREATE_OK = 1;
    static final int GROUP_TYPE_CREATE_FAIL = 2;
    static final int GROUP_TYPE_FETCH_GROUP_OK = 3;
    static final int GROUP_TYPE_FETCH_GROUP_FAIL = 4;
    static final int GROUP_TYPE_GROUP_LIST_CHANGE = 5;
    static final int GROUP_TYPE_FETCH_GROUP_INFO_OK = 6;
    static final int GROUP_TYPE_FETCH_GROUP_INFO_FAIL = 7;
    static final int GROUP_TYPE_GROUP_INFO_CHANGE = 8;
    static final int GROUP_TYPE_LEAVE_OK = 9;
    static final int GROUP_TYPE_LEAVE_FAIL = 10;
    static final int GROUP_TYPE_DISSOLVE_OK = 11;
    static final int GROUP_TYPE_DISSOLVE_FAIL = 12;
    static final int GROUP_TYPE_DEAL_MEMBERS_OK = 13;
    static final int GROUP_TYPE_DEAL_MEMBERS_FAIL = 14;
    static final int GROUP_TYPE_CHANGE_GROUP_PROP_OK = 15;
    static final int GROUP_TYPE_CHANGE_GROUP_PROP_FAIL = 16;
    static final int GROUP_CHANGE_TYPE_ADD = 0;
    static final int GROUP_CHANGE_TYPE_REMOVE = 1;
    static final int GROUP_CHANGE_TYPE_UPDATE = 2;
    public static final int ACCOUNT_NONE = 0;
    public static final int ACCOUNT_QUERY_USER_STATUS_OK = 1;
    public static final int ACCOUNT_QUERY_USER_STATUS_FAIL = 2;
    public static final int CLI = 0;
    public static final int CONF = 1;
    public static final int CALL = 2;
    public static final int MESSAGE = 3;
    public static final int STORAGE = 4;
    public static final int GROUP = 5;
    public static final int ACCOUNT = 6;
    public int type;
    public int cookie;
    public Cli cliNotify;
    public Call callNotify;
    public Conf confNotify;
    public Message messageNotify;
    public Storage storageNotify;
    public Group groupNotify;
    public Account accountNotify;
    private static final String TAG_CLI = "MtcCli";
    private static final String TAG_CONF = "MtcConf";
    private static final String TAG_CALL = "MtcCall";
    private static final String TAG_IM = "MtcIm";
    private static final String TAG_FS2 = "MtcFs2";
    private static final String TAG_GROUP = "MtcGroup";
    private static final String TAG_SGW = "MtcSgw";
    private static final String TAG_BUDDY = "MtcBuddy";

    JCNotify() {
    }

    public static JCNotify create(String name, int cookie, String info) {
        JCNotify notify = null;
        if (name.startsWith(TAG_CLI)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 0;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.cliNotify = jCNotify.new Cli(name, info);
        } else if (name.startsWith(TAG_CONF) || name.startsWith(TAG_SGW)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 1;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.confNotify = jCNotify.new Conf(name, info);
        } else if (name.startsWith(TAG_CALL)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 2;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.callNotify = jCNotify.new Call(name, info);
        } else if (name.startsWith(TAG_IM)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 3;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.messageNotify = jCNotify.new Message(name, info);
        } else if (name.startsWith(TAG_FS2)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 4;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.storageNotify = jCNotify.new Storage(name, info);
        } else if (name.startsWith(TAG_GROUP)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 5;
            notify.cookie = cookie;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.groupNotify = jCNotify.new Group(name, info);
        } else if (name.startsWith(TAG_BUDDY)) {
            notify = new JCNotify();
            notify.cookie = cookie;
            notify.type = 6;
            JCNotify jCNotify = notify;
            jCNotify.getClass();
            notify.accountNotify = jCNotify.new Account(name, info);
        }
        return notify;
    }

    public class Account
    implements MtcBuddyConstants {
        int type = 0;
        public QueryUserStatus queryUserStatus;

        public Account(String name, String info) {
            if (name.equals("MtcBuddyQueryUsersStatusOkNotification")) {
                try {
                    this.queryUserStatus = new QueryUserStatus();
                    this.type = 1;
                    JSONArray jsonArray = new JSONArray(info);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        this.queryUserStatus.resultList.add(new QueryUserStatusItem(jsonArray.optJSONObject(i)));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if (name.equals("MtcBuddyQueryUsersStatusDidFailNotification")) {
                this.type = 2;
            }
        }

        public class QueryUserStatus {
            public List<QueryUserStatusItem> resultList = new ArrayList<QueryUserStatusItem>();
        }

        public class QueryUserStatusItem {
            public String userId;
            public int status;

            public QueryUserStatusItem(JSONObject jsonObject) {
                this.userId = MtcUser.Mtc_UserGetId((String)jsonObject.optString("UserUri"));
                this.status = jsonObject.optInt("Status");
            }
        }
    }

    class Group
    implements MtcGroupConstants {
        int type = 0;
        CreateOk createOk;
        CreateFail createFail;
        FetchGroupOk fetchGroupOk;
        FetchGroupFail fetchGroupFail;
        FetchGroupInfoOk fetchGroupInfoOk;
        FetchGroupInfoFail fetchGroupInfoFail;
        LeaveOk leaveOk;
        LeaveFail leaveFail;
        DissolveOk dissolveOk;
        DissolveFail dissolveFail;
        DealMembersOk dealMembersOk;
        DealMembersFail dealMembersFail;
        GroupListChange groupListChange;
        GroupInfoChange groupInfoChange;
        ChangeGroupPropOk changeGroupPropOk;
        ChangeGroupPropFail changeGroupPropFail;

        Group(String name, String info) {
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (object == null) {
                return;
            }
            if ("MtcGroupCreateOkNotification".equals(name)) {
                this.type = 1;
                this.createOk = new CreateOk();
                this.createOk.groupId = object.optString("Rid");
                JSONObject jsonObject = object.optJSONObject("Properties");
                this.createOk.name = jsonObject.optString("Name");
            } else if ("MtcGroupCreateDidFailNotification".equals(name)) {
                this.type = 2;
                this.createFail = new CreateFail();
                this.createFail.reason = object.optInt("ReasonCode");
                this.createFail.detail = object.optString("ReasonDetail");
            } else if ("MtcGroupRefreshOkNotification".equals(name)) {
                int type = object.optInt("RidType");
                if (type == 0) {
                    this.type = 6;
                    this.fetchGroupInfoOk = new FetchGroupInfoOk();
                    this.fetchGroupInfoOk.groupId = object.optString("Rid");
                    this.fetchGroupInfoOk.name = object.optString("DisplayName");
                    this.fetchGroupInfoOk.updateTime = object.optLong("UpdateTime");
                    this.fetchGroupInfoOk.fullUpdate = !object.optBoolean("IsPartialUpdate");
                    this.fetchGroupInfoOk.members = new HashSet<NotifyMember>();
                    if (this.fetchGroupInfoOk.fullUpdate) {
                        JSONArray jsonArray = object.optJSONArray("RelationList");
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyMember notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt("RelationType");
                                notifyMember.uid = jsonObject.optString("Rid");
                                notifyMember.displayName = jsonObject.optString("DisplayName");
                                notifyMember.changeType = 0;
                                notifyMember.tag = jsonObject.optString("Tag");
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                    } else {
                        NotifyMember notifyMember;
                        JSONObject jsonObject;
                        int i;
                        JSONArray jsonArray = object.optJSONArray("AddedRelationList");
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                jsonObject = jsonArray.optJSONObject(i);
                                notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt("RelationType");
                                notifyMember.uid = jsonObject.optString("Rid");
                                notifyMember.displayName = jsonObject.optString("DisplayName");
                                notifyMember.changeType = 0;
                                notifyMember.tag = jsonObject.optString("Tag");
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                        if ((jsonArray = object.optJSONArray("UpdatedRelationList")) != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                jsonObject = jsonArray.optJSONObject(i);
                                notifyMember = new NotifyMember();
                                notifyMember.memberType = jsonObject.optInt("RelationType");
                                notifyMember.uid = jsonObject.optString("Rid");
                                notifyMember.displayName = jsonObject.optString("DisplayName");
                                notifyMember.changeType = 2;
                                notifyMember.tag = jsonObject.optString("Tag");
                                this.fetchGroupInfoOk.members.add(notifyMember);
                            }
                        }
                        if ((jsonArray = object.optJSONArray("RemovedRelationList")) != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                NotifyMember notifyMember2 = new NotifyMember();
                                notifyMember2.uid = jsonArray.optString(i);
                                notifyMember2.changeType = 1;
                                this.fetchGroupInfoOk.members.add(notifyMember2);
                            }
                        }
                    }
                } else {
                    this.type = 3;
                    this.fetchGroupOk = new FetchGroupOk();
                    this.fetchGroupOk.updateTime = object.optLong("UpdateTime");
                    this.fetchGroupOk.fullUpdate = !object.optBoolean("IsPartialUpdate");
                    this.fetchGroupOk.groupItems = new HashSet<NotifyItem>();
                    if (this.fetchGroupOk.fullUpdate) {
                        JSONArray jsonArray = object.optJSONArray("RelationList");
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject jsonObject = jsonArray.optJSONObject(i);
                                NotifyItem notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString("Rid");
                                notifyItem.name = jsonObject.optString("DisplayName");
                                notifyItem.changeType = 0;
                                notifyItem.tag = jsonObject.optString("Tag");
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }
                    } else {
                        NotifyItem notifyItem;
                        JSONObject jsonObject;
                        int i;
                        JSONArray jsonArray = object.optJSONArray("AddedRelationList");
                        if (jsonArray != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                jsonObject = jsonArray.optJSONObject(i);
                                notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString("Rid");
                                notifyItem.name = jsonObject.optString("DisplayName");
                                notifyItem.changeType = 0;
                                notifyItem.tag = jsonObject.optString("Tag");
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }
                        if ((jsonArray = object.optJSONArray("UpdatedRelationList")) != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                jsonObject = jsonArray.optJSONObject(i);
                                notifyItem = new NotifyItem();
                                notifyItem.groupId = jsonObject.optString("Rid");
                                notifyItem.name = jsonObject.optString("DisplayName");
                                notifyItem.changeType = 2;
                                notifyItem.tag = jsonObject.optString("Tag");
                                this.fetchGroupOk.groupItems.add(notifyItem);
                            }
                        }
                        if ((jsonArray = object.optJSONArray("RemovedRelationList")) != null && jsonArray.length() > 0) {
                            for (i = 0; i < jsonArray.length(); ++i) {
                                NotifyItem notifyItem2 = new NotifyItem();
                                notifyItem2.groupId = jsonArray.optString(i);
                                notifyItem2.changeType = 1;
                                this.fetchGroupOk.groupItems.add(notifyItem2);
                            }
                        }
                    }
                }
            } else if ("MtcGroupRefreshDidFailNotification".equals(name)) {
                int type = object.optInt("RidType");
                if (type == 0) {
                    this.type = 7;
                    this.fetchGroupInfoFail = new FetchGroupInfoFail();
                    this.fetchGroupInfoFail.groupId = object.optString("Rid");
                    this.fetchGroupInfoFail.reason = object.optInt("ReasonCode");
                    this.fetchGroupInfoFail.details = object.optString("ReasonDetail");
                } else {
                    this.type = 4;
                    this.fetchGroupFail = new FetchGroupFail();
                    this.fetchGroupFail.groupId = object.optString("Rid");
                    this.fetchGroupFail.reason = object.optInt("ReasonCode");
                    this.fetchGroupFail.details = object.optString("ReasonDetail");
                }
            } else if ("MtcGroupRemoveOkNotification".equals(name)) {
                int type = object.optInt("RidType");
                if (type == 0) {
                    this.type = 11;
                    this.dissolveOk = new DissolveOk();
                    this.dissolveOk.groupId = object.optString("Rid");
                }
            } else if ("MtcGroupRemoveDidFailNotification".equals(name)) {
                int type = object.optInt("RidType");
                if (type == 0) {
                    this.type = 12;
                    this.dissolveFail = new DissolveFail();
                    this.dissolveFail.groupId = object.optString("Rid");
                    this.dissolveFail.reason = object.optInt("ReasonCode");
                    this.dissolveFail.details = object.optString("ReasonDetail");
                }
            } else if ("MtcGroupRemoveRelationOkNotification".equals(name)) {
                this.type = 9;
                this.leaveOk = new LeaveOk();
                this.leaveOk.groupId = object.optString("Rid");
            } else if ("MtcGroupRemoveRelationDidFailNotification".equals(name)) {
                this.type = 10;
                this.leaveFail = new LeaveFail();
                this.leaveFail.groupId = object.optString("Rid");
                this.leaveFail.reason = object.optInt("ReasonCode");
                this.leaveFail.details = object.optString("ReasonDetail");
            } else if ("MtcGroupChangedNotification".equals(name)) {
                int type = object.optInt("RidType");
                if (type == 0) {
                    this.type = 8;
                    this.groupInfoChange = new GroupInfoChange();
                    this.groupInfoChange.groupId = object.optString("Rid");
                } else {
                    this.type = 5;
                    this.groupListChange = new GroupListChange();
                }
            } else if ("MtcGroupSetRelationsOkNotification".equals(name)) {
                this.type = 13;
                this.dealMembersOk = new DealMembersOk();
            } else if ("MtcGroupSetRelationsDidFailNotification".equals(name)) {
                this.type = 14;
                this.dealMembersFail = new DealMembersFail();
                this.dealMembersFail.reason = object.optInt("ReasonCode");
                this.dealMembersFail.details = object.optString("ReasonDetail");
            } else if ("MtcGroupSetPropertiesOkNotification".equals(name)) {
                this.type = 15;
                this.changeGroupPropOk = new ChangeGroupPropOk();
                this.changeGroupPropOk.groupId = object.optString("Rid");
            } else if ("MtcGroupSetPropertiesDidFailNotification".equals(name)) {
                this.type = 16;
                this.changeGroupPropFail = new ChangeGroupPropFail();
                this.changeGroupPropFail.groupId = object.optString("Rid");
                this.changeGroupPropFail.reason = object.optInt("ReasonCode");
                this.changeGroupPropFail.details = object.optString("ReasonDetail");
            }
        }

        class ChangeGroupPropFail {
            String groupId;
            int reason;
            String details;

            ChangeGroupPropFail() {
            }
        }

        class ChangeGroupPropOk {
            String groupId;

            ChangeGroupPropOk() {
            }
        }

        class GroupInfoChange {
            String groupId;

            GroupInfoChange() {
            }
        }

        class GroupListChange {
            GroupListChange() {
            }
        }

        class DealMembersFail {
            int reason;
            String details;

            DealMembersFail() {
            }
        }

        class DealMembersOk {
            DealMembersOk() {
            }
        }

        class DissolveFail {
            String groupId;
            int reason;
            String details;

            DissolveFail() {
            }
        }

        class DissolveOk {
            String groupId;

            DissolveOk() {
            }
        }

        class LeaveFail {
            String groupId;
            int reason;
            String details;

            LeaveFail() {
            }
        }

        class LeaveOk {
            String groupId;

            LeaveOk() {
            }
        }

        class FetchGroupInfoFail {
            String groupId;
            int reason;
            String details;

            FetchGroupInfoFail() {
            }
        }

        class FetchGroupInfoOk {
            String groupId;
            String name;
            Collection<NotifyMember> members;
            long updateTime;
            boolean fullUpdate;

            FetchGroupInfoOk() {
            }
        }

        class FetchGroupFail {
            String groupId;
            int reason;
            String details;

            FetchGroupFail() {
            }
        }

        class FetchGroupOk {
            Collection<NotifyItem> groupItems;
            long updateTime;
            boolean fullUpdate;

            FetchGroupOk() {
            }
        }

        class CreateFail {
            int reason;
            String detail;

            CreateFail() {
            }
        }

        class CreateOk {
            String groupId;
            String name;

            CreateOk() {
            }
        }

        class NotifyMember {
            int memberType;
            String uid;
            String displayName;
            int changeType;
            String tag;

            NotifyMember() {
            }
        }

        class NotifyItem {
            String groupId;
            String name;
            String tag;
            int changeType;

            NotifyItem() {
            }
        }
    }

    public class Call
    implements MtcCallConstants {
        public int type = 0;
        public DidTerm didTerm;
        public Termed termed;
        public Incoming incoming;
        public Connecting connecting;
        public Talking talking;
        public Alerted alerted;
        public Message message;
        public OtherVideoStatus otherVideoStatus;
        public MissCall missCall;
        public NetStatus netStatus;
        public Trying trying;

        public Call(String name, String info) {
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (name.equals("MtcCallDidTermNotification")) {
                this.type = 1;
                this.didTerm = new DidTerm();
                this.didTerm.callId = object.optLong("MtcCallIdKey");
                this.didTerm.statusCode = object.optInt("MtcCallStatusCodeKey");
            } else if (name.equals("MtcCallTermedNotification")) {
                this.type = 2;
                this.termed = new Termed();
                this.termed.callId = object.optLong("MtcCallIdKey");
                this.termed.statusCode = object.optInt("MtcCallStatusCodeKey");
                this.termed.desc = object.optString("MtcCallDescriptionKey");
            } else if (name.equals("MtcCallIncomingNotification")) {
                this.type = 3;
                this.incoming = new Incoming();
                this.incoming.callId = object.optLong("MtcCallIdKey");
                this.incoming.video = MtcCall.Mtc_CallHasVideo((int)((int)this.incoming.callId));
                this.incoming.renderId = MtcCall.Mtc_CallGetName((int)((int)this.incoming.callId));
                this.incoming.serverCallId = MtcCallExt.Mtc_CallGetServerCallId((int)((int)this.incoming.callId));
                this.incoming.extraParam = object.optString("MtcUserDataKey");
                String uri = MtcCall.Mtc_CallGetPeerUri((int)((int)this.incoming.callId));
                String displayName = MtcCall.Mtc_CallGetPeerDisplayName((int)((int)this.incoming.callId));
                if (!TextUtils.isEmpty((CharSequence)uri)) {
                    this.incoming.uri = uri;
                    this.incoming.userId = MtcUser.Mtc_UserGetId((String)this.incoming.uri);
                    this.incoming.displayName = !TextUtils.isEmpty((CharSequence)displayName) ? displayName : this.incoming.userId;
                } else {
                    this.incoming.uri = "";
                    this.incoming.displayName = "";
                }
            } else if (name.equals("MtcCallTryingNotification")) {
                this.type = 11;
                this.trying = new Trying();
                this.trying.callId = object.optLong("MtcCallIdKey");
                this.trying.serverCallId = MtcCallExt.Mtc_CallGetServerCallId((int)((int)this.trying.callId));
            } else if (name.equals("MtcCallTalkingNotification")) {
                this.type = 4;
                this.talking = new Talking();
                this.talking.callId = object.optLong("MtcCallIdKey");
            } else if (name.equals("MtcCallConnectingNotification")) {
                this.type = 5;
                this.connecting = new Connecting();
                this.connecting.callId = object.optLong("MtcCallIdKey");
                this.connecting.video = MtcCall.Mtc_CallHasVideo((int)((int)this.connecting.callId));
            } else if (name.equals("MtcCallAlertedNotification")) {
                this.type = 6;
                this.alerted = new Alerted();
                this.alerted.callId = object.optLong("MtcCallIdKey");
                this.alerted.type = object.optInt("MtcCallAlertTypeKey");
            } else if (name.equals("MtcCallInfoReceivedNotification")) {
                this.type = 7;
                this.message = new Message();
                this.message.tunnel = 0;
                this.message.callId = object.optLong("MtcCallIdKey");
                this.message.content = object.optString("MtcCallBodyKey");
            } else if (name.equals("MtcCallStreamDataReceivedNotification")) {
                this.type = 7;
                this.message = new Message();
                this.message.tunnel = 1;
                this.message.callId = object.optLong("MtcCallIdKey");
                this.message.type = object.optString("MtcCallDataNameKey");
                this.message.content = object.optString("MtcCallDataValueKey");
            } else if (name.equals("MtcCallVideoReceiveStatusChangedNotification")) {
                this.type = 8;
                this.otherVideoStatus = new OtherVideoStatus();
                this.otherVideoStatus.callId = object.optLong("MtcCallIdKey");
                this.otherVideoStatus.status = object.optInt("MtcCallVideoStatusKey");
            } else if (name.equals("MtcCallMissedNotification")) {
                this.type = 9;
                this.missCall = new MissCall();
                this.missCall.serverCallId = object.optString("MtcCallServerIdKey");
                this.missCall.video = object.optBoolean("MtcCallIsVideoKey");
                this.missCall.time = object.optLong("MtcCallStartTimeKey");
                this.missCall.uri = object.optString("MtcCallPeerUriKey");
                this.missCall.userId = MtcUser.Mtc_UserGetId((String)this.missCall.uri);
                this.missCall.displayName = object.optString("MtcCallPeerNameKey");
                if (TextUtils.isEmpty((CharSequence)this.missCall.displayName)) {
                    this.missCall.displayName = this.missCall.userId;
                }
            } else if (name.equals("MtcCallNetworkStatusChangedNotification")) {
                this.type = 10;
                this.netStatus = new NetStatus();
                this.netStatus.callId = object.optLong("MtcCallIdKey");
                this.netStatus.send = object.optBoolean("MtcCallIsSendKey");
                this.netStatus.video = object.optBoolean("MtcCallIsVideoKey");
                this.netStatus.status = object.optInt("MtcCallNetworkStatusKey");
                this.netStatus.receiveRtt = object.optInt("MtcCallReceiveRttKey");
                this.netStatus.receiveJitter = object.optInt("MtcCallReceiveJitterKey");
                this.netStatus.receiveLostRate = object.optInt("MtcCallReceiveLostRatioKey");
                this.netStatus.receiveCurBitRate = object.optInt("MtcCallReceiveCurBitRateKey");
            }
        }

        public class NetStatus {
            public long callId;
            public boolean video;
            public boolean send;
            public int status;
            public int receiveRtt;
            public int receiveJitter;
            public int receiveLostRate;
            public int receiveCurBitRate;
        }

        public class MissCall {
            public String serverCallId;
            public boolean video;
            public long time;
            public String userId;
            public String uri;
            public String displayName;
        }

        public class OtherVideoStatus {
            public long callId;
            public int status;
        }

        public class Message {
            public long callId;
            public int tunnel;
            public String type;
            public String content;
        }

        public class Alerted {
            public long callId;
            public int type;
        }

        public class Talking {
            public long callId;
        }

        public class Connecting {
            public long callId;
            public boolean video;
        }

        public class Trying {
            public long callId;
            public String serverCallId;
        }

        public class Incoming {
            public long callId;
            public String userId;
            public String uri;
            public String renderId;
            public String displayName;
            public boolean video;
            public String serverCallId;
            public String extraParam;
        }

        public class Termed {
            public long callId;
            public String desc;
            public int statusCode;
        }

        public class DidTerm {
            public long callId;
            public int statusCode;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallMessageTunnel {
    }

    public class Cli
    implements MtcCliConstants {
        public int type;
        public LoginOk loginOk;
        public LoginFail loginFail;
        public DidLogout didLogout;
        public Logouted logouted;

        public Cli() {
        }

        public Cli(String name, String info) {
            this.type = 0;
            JSONObject object = null;
            if (info != null) {
                try {
                    object = new JSONObject(info);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (name.equals("MtcCliServerLoginOkNotification")) {
                this.type = 1;
                this.loginOk = new LoginOk();
                this.loginOk.uid = MtcUe.Mtc_UeGetUid();
            } else if (name.equals("MtcCliServerLoginDidFailNotification")) {
                this.type = 2;
                this.loginFail = new LoginFail();
                this.loginFail.statusCode = object.optInt("MtcCliStatusCodeKey");
            } else if (name.equals("MtcCliServerDidLogoutNotification")) {
                this.type = 3;
                this.didLogout = new DidLogout();
                this.didLogout.statusCode = object.optInt("MtcCliStatusCodeKey");
            } else if (name.equals("MtcCliServerLogoutedNotification")) {
                this.type = 4;
                this.logouted = new Logouted();
                this.logouted.statusCode = object.optInt("MtcCliStatusCodeKey");
            } else if (name.equals("MtcCliReconnectingNotification")) {
                this.type = 5;
            } else if (name.equals("MtcCliReconnectOkNotification")) {
                this.type = 6;
            }
        }

        public class Logouted {
            public int statusCode;
        }

        public class DidLogout {
            public int statusCode;
        }

        public class LoginFail {
            public int statusCode;
        }

        public class LoginOk {
            public String uid;
        }
    }

    public class Conf
    implements MtcConfConstants,
    MtcSgwConstants {
        public int type;
        public JoinOk joinOk;
        public JoinFail joinFail;
        public Leave leave;
        public Stop stop;
        public QueryOk queryOk;
        public QueryFail queryFail;
        public AddParticipant addParticipant;
        public RemoveParticipant removeParticipant;
        public ParticipantChanged participantChanged;
        public VolumeChanged volumeChanged;
        public ErrorEvent errorEvent;
        public PropChange propChange;
        public MessageReceived messageReceived;

        public Conf(String name, String info) {
            block36: {
                this.type = 0;
                try {
                    JSONObject object = new JSONObject(TextUtils.isEmpty((CharSequence)info) ? "{}" : info);
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfQueryOkNotification")) {
                        this.type = 4;
                        this.queryOk = new QueryOk();
                        this.queryOk.number = object.optInt("MtcConfNumberKey");
                        this.queryOk.capacity = object.optInt("MtcConfCapacityKey");
                        this.queryOk.title = object.optString("MtcConfTitleKey");
                        this.queryOk.video = object.optBoolean("MtcConfIsVideoKey");
                        this.queryOk.region = new Region();
                        this.queryOk.region.rid = object.optInt("MtcRegionIdKey");
                        this.queryOk.region.name = object.optString("MtcRegionNameKey");
                        this.queryOk.region.desc = object.optString("MtcRegionDescKey");
                        this.queryOk.clientCount = object.optInt("MtcConfClientCountKey");
                        JSONArray memberArray = object.getJSONArray("MtcConfMemberListKey");
                        for (int i = 0; i < memberArray.length(); ++i) {
                            this.queryOk.mMembers.add(MtcUser.Mtc_UserGetId((String)memberArray.getString(i)));
                        }
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfQueryDidFailNotification")) {
                        this.type = 5;
                        this.queryFail = new QueryFail();
                        this.queryFail.reason = object.optInt("MtcConfReasonKey");
                        this.queryFail.detailReason = object.optString("MtcConfDetailReasonKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfJoinOkNotification")) {
                        this.type = 1;
                        this.joinOk = new JoinOk();
                        this.joinOk.confId = object.optInt("MtcConfIdKey");
                        this.joinOk.number = object.optInt("MtcConfNumberKey");
                        this.joinOk.viewMode = object.optInt("MtcConfViewModeKey");
                        this.joinOk.qualityGrade = object.optInt("MtcConfQualityGradeKey");
                        this.joinOk.videoSquare = object.optBoolean("MtcConfVideoSquareKey");
                        this.joinOk.title = object.optString("MtcConfTitleKey");
                        this.joinOk.screenUserUri = object.optString("MtcConfScreenUserKey");
                        if (!TextUtils.isEmpty((CharSequence)this.joinOk.screenUserUri)) {
                            this.joinOk.screenUserId = MtcUser.Mtc_UserGetId((String)this.joinOk.screenUserUri);
                            this.joinOk.screenRenderId = MtcConf.Mtc_ConfGetProp((int)this.joinOk.confId, (String)"ScreenURI");
                        }
                        this.joinOk.region = new Region();
                        this.joinOk.region.rid = object.optInt("MtcRegionIdKey");
                        this.joinOk.region.name = object.optString("MtcRegionNameKey");
                        this.joinOk.region.desc = object.optString("MtcRegionDescKey");
                        this.joinOk.data = object.optString("MtcConfDataKey");
                        this.joinOk.partps = new ArrayList<Partp>();
                        this.joinOk.deliveryUri = MtcConf.Mtc_ConfGetProp((int)this.joinOk.confId, (String)"DeliveryURI");
                        JSONArray partpArray = object.getJSONArray("MtcConfPartpLstKey");
                        for (int i = 0; i < partpArray.length(); ++i) {
                            JSONObject subObject = partpArray.getJSONObject(i);
                            Partp partp = new Partp();
                            partp.uri = subObject.optString("MtcConfUserUriKey");
                            partp.userId = MtcUser.Mtc_UserGetId((String)partp.uri);
                            partp.displayName = subObject.optString("MtcConfDisplayNameKey");
                            partp.state = subObject.optInt("MtcConfStateKey");
                            partp.role = subObject.optInt("MtcConfRoleKey");
                            if (TextUtils.equals((CharSequence)partp.displayName, (CharSequence)partp.uri)) {
                                partp.displayName = partp.userId;
                            }
                            this.joinOk.partps.add(partp);
                        }
                        try {
                            String propData = object.getString("MtcConfDataKey");
                            JSONObject props = new JSONObject(propData);
                            Iterator iterator = props.keys();
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                this.joinOk.customProperty.put(key, (String)props.get(key));
                            }
                            break block36;
                        }
                        catch (JSONException propData) {
                            break block36;
                        }
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfJoinDidFailNotification")) {
                        this.type = 2;
                        this.joinFail = new JoinFail();
                        this.joinFail.confId = object.optInt("MtcConfIdKey");
                        this.joinFail.number = object.optInt("MtcConfNumberKey");
                        this.joinFail.event = object.optInt("MtcConfEventKey");
                        this.joinFail.reason = object.optInt("MtcConfReasonKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfJoinedNotification")) {
                        this.type = 6;
                        this.addParticipant = new AddParticipant();
                        this.addParticipant.partp = new Partp();
                        this.addParticipant.confId = object.optInt("MtcConfIdKey");
                        this.addParticipant.number = object.optInt("MtcConfNumberKey");
                        this.addParticipant.partp.uri = object.optString("MtcConfUserUriKey");
                        this.addParticipant.partp.userId = MtcUser.Mtc_UserGetId((String)this.addParticipant.partp.uri);
                        this.addParticipant.partp.displayName = object.optString("MtcConfDisplayNameKey");
                        this.addParticipant.partp.state = object.optInt("MtcConfStateKey");
                        this.addParticipant.partp.role = object.optInt("MtcConfRoleKey");
                        if (TextUtils.equals((CharSequence)this.addParticipant.partp.displayName, (CharSequence)this.addParticipant.partp.uri)) {
                            this.addParticipant.partp.displayName = this.addParticipant.partp.userId;
                        }
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfDidLeaveNotification")) {
                        this.type = 3;
                        this.leave = new Leave();
                        this.leave.confId = object.optInt("MtcConfIdKey");
                        this.leave.number = object.optInt("MtcConfNumberKey");
                        this.leave.event = object.optInt("MtcConfEventKey");
                        this.leave.reason = object.optInt("MtcConfReasonKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfCancelReservationOkNotification")) {
                        this.type = 15;
                        this.stop = new Stop();
                        this.stop.number = object.optInt("MtcConfNumberKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfCancelReservationDidFailNotification")) {
                        this.type = 16;
                        this.stop = new Stop();
                        this.stop.number = object.optInt("MtcConfNumberKey");
                        this.stop.reason = object.optInt("MtcConfReasonKey");
                        this.stop.reasonDescription = object.optString("MtcConfDetailReasonKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfLeavedNotification")) {
                        this.type = 7;
                        this.removeParticipant = new RemoveParticipant();
                        this.removeParticipant.partp = new Partp();
                        this.removeParticipant.confId = object.optInt("MtcConfIdKey");
                        this.removeParticipant.number = object.optInt("MtcConfNumberKey");
                        this.removeParticipant.partp.uri = object.optString("MtcConfUserUriKey");
                        this.removeParticipant.partp.userId = MtcUser.Mtc_UserGetId((String)this.removeParticipant.partp.uri);
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfParticipantChangedNotification")) {
                        this.type = 8;
                        this.participantChanged = new ParticipantChanged();
                        this.participantChanged.confId = object.optInt("MtcConfIdKey");
                        this.participantChanged.number = object.optInt("MtcConfNumberKey");
                        this.participantChanged.uri = object.optString("MtcConfUserUriKey");
                        this.participantChanged.userId = MtcUser.Mtc_UserGetId((String)this.participantChanged.uri);
                        this.participantChanged.displayName = object.optString("MtcConfDisplayNameKey");
                        this.participantChanged.state = object.optInt("MtcConfStateKey");
                        this.participantChanged.role = object.optInt("MtcConfRoleKey");
                        if (TextUtils.equals((CharSequence)this.participantChanged.displayName, (CharSequence)this.participantChanged.uri)) {
                            this.participantChanged.displayName = this.participantChanged.userId;
                        }
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfVolumeChangedNotification")) {
                        this.type = 9;
                        this.volumeChanged = new VolumeChanged();
                        this.volumeChanged.confId = object.optInt("MtcConfIdKey");
                        this.volumeChanged.number = object.optInt("MtcConfNumberKey");
                        this.volumeChanged.mapVolume = new HashMap<String, Integer>();
                        JSONArray volumeArray = object.optJSONArray("MtcConfPartpVolumeLstKey");
                        for (int i = 0; i < volumeArray.length(); ++i) {
                            JSONObject subObject = volumeArray.getJSONObject(i);
                            this.volumeChanged.mapVolume.put(MtcUser.Mtc_UserGetId((String)subObject.optString("MtcConfUserUriKey")), subObject.optInt("MtcConfVolumeKey"));
                        }
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfErrorNotification")) {
                        this.type = 10;
                        this.errorEvent = new ErrorEvent();
                        this.errorEvent.confId = object.optInt("MtcConfIdKey");
                        this.errorEvent.number = object.optInt("MtcConfNumberKey");
                        this.errorEvent.event = object.optInt("MtcConfEventKey");
                        this.errorEvent.reason = object.optInt("MtcConfReasonKey");
                        break block36;
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfPropertyChangedNotfication")) {
                        this.type = 11;
                        this.propChange = new PropChange();
                        this.propChange.confId = object.optInt("MtcConfIdKey");
                        this.propChange.number = object.optInt("MtcConfNumberKey");
                        this.propChange.title = object.optString("MtcConfTitleKey");
                        this.propChange.screenUserUri = object.optString("MtcConfScreenUserKey");
                        if (!TextUtils.isEmpty((CharSequence)this.propChange.screenUserUri)) {
                            this.propChange.screenUserId = MtcUser.Mtc_UserGetId((String)this.propChange.screenUserUri);
                            this.propChange.screenRenderId = MtcConf.Mtc_ConfGetProp((int)this.propChange.confId, (String)"ScreenURI");
                        }
                        try {
                            String propData = object.getString("MtcConfDataKey");
                            JSONObject props = new JSONObject(propData);
                            Iterator iterator = props.keys();
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                this.propChange.customProperty.put(key, (String)props.get(key));
                            }
                            break block36;
                        }
                        catch (JSONException jSONException) {
                            break block36;
                        }
                    }
                    if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfDataReceivedNotification") || TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfBypassDataReceivedNotification") || TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfTextReceivedNotification")) {
                        this.type = 12;
                        this.messageReceived = new MessageReceived();
                        this.messageReceived.confId = object.optInt("MtcConfIdKey");
                        if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcConfTextReceivedNotification")) {
                            this.messageReceived.type = "text";
                            this.messageReceived.fromUserId = MtcUser.Mtc_UserGetId((String)object.optString("MtcConfUserUriKey"));
                            this.messageReceived.content = object.optString("MtcConfTextKey");
                        } else {
                            this.messageReceived.type = object.optString("MtcConfDataTypeKey");
                            this.messageReceived.content = object.optString("MtcConfDataContentKey");
                        }
                    } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcSgwDeliInviteOkNotification")) {
                        this.type = 13;
                    } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcSgwDeliInviteDidFailNotification")) {
                        this.type = 14;
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        public class MessageReceived {
            public int confId;
            public String type;
            public String fromUserId;
            public String content;
        }

        public class PropChange {
            public int confId;
            public int number;
            public String title;
            public String screenUserUri;
            public String screenUserId;
            public String screenRenderId;
            public Map<String, String> customProperty = new HashMap<String, String>();
        }

        public class ErrorEvent {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class VolumeChanged {
            public int confId;
            public int number;
            public Map<String, Integer> mapVolume;
        }

        public class ParticipantChanged {
            public int confId;
            public int number;
            public String uri;
            public String userId;
            public int state;
            public int role;
            public String displayName;
        }

        public class RemoveParticipant {
            public int confId;
            public int number;
            public Partp partp;
        }

        public class AddParticipant {
            public int confId;
            public int number;
            public Partp partp;
        }

        public class QueryFail {
            public int reason;
            public String detailReason;
        }

        public class QueryOk {
            public int number;
            public int capacity;
            public String title;
            public boolean video;
            public Region region;
            public int clientCount;
            public List<String> mMembers = new ArrayList<String>();
        }

        public class Stop {
            public int number;
            public int reason;
            public String reasonDescription;
        }

        public class Leave {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class JoinFail {
            public int confId;
            public int number;
            public int event;
            public int reason;
        }

        public class JoinOk {
            public int confId;
            public int number;
            public int viewMode;
            public int qualityGrade;
            public boolean videoSquare;
            public String title;
            public String deliveryUri;
            public String screenUserUri;
            public String screenUserId;
            public String screenRenderId;
            public Region region;
            public String data;
            public List<Partp> partps;
            public Map<String, String> customProperty = new HashMap<String, String>();
        }

        public class Partp {
            public String userId;
            public String uri;
            public String displayName;
            public int state;
            public int role;
            public String screenRenderId;
        }

        public class Region {
            public int rid;
            public String name;
            public String desc;
        }
    }

    public class Message
    implements MtcImConstants {
        public int type = 0;
        public SendOk sendOk;
        public SendFail sendFail;
        public Recv recvMessage;

        public Message(String name, String info) {
            try {
                JSONObject object = new JSONObject(TextUtils.isEmpty((CharSequence)info) ? "{}" : info);
                if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcImSendInfoOkNotification")) {
                    this.type = 1;
                    this.sendOk = new SendOk();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcImSendInfoDidFailNotification")) {
                    this.type = 2;
                    this.sendFail = new SendFail();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcImInfoDidReceiveNotification")) {
                    this.type = 3;
                    this.recvMessage = new Recv();
                    this.recvMessage.userId = MtcUser.Mtc_UserGetId((String)object.optString("MtcImUserUriKey"));
                    this.recvMessage.messageContent = object.optString("MtcImInfoContentKey");
                    this.recvMessage.time = object.optLong("MtcImTimeKey");
                    this.recvMessage.displayName = object.optString("MtcImDisplayNameKey");
                    this.recvMessage.messageType = object.optString("MtcImInfoTypeKey");
                    this.recvMessage.messageInfo = object.optString("MtcImUserDataKey");
                    this.recvMessage.category = object.optInt("MtcImCategoryKey");
                    this.recvMessage.groupId = this.recvMessage.category == 2 ? object.optString("MtcImLabelKey") : null;
                    this.recvMessage.messageLabel = object.optString("MtcImLabelKey");
                    this.recvMessage.messageId = object.optLong("MtcImMsgIdKey");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public class Recv {
            public String userId;
            public String groupId;
            public long time;
            public int category;
            public String messageType;
            public String messageContent;
            public String displayName;
            public String messageInfo;
            public String messageLabel;
            public long messageId;
        }

        public class SendFail {
        }

        public class SendOk {
        }
    }

    public class Storage
    implements MtcFs2Constants,
    MtcFsConstants {
        public int type = 0;
        public Progress storageProgress;
        public SendOk sendOk;
        public SendFail sendFail;
        public RecvOk recvOk;
        public RecvFail recvFail;

        public Storage(String name, String info) {
            try {
                JSONObject object = new JSONObject(TextUtils.isEmpty((CharSequence)info) ? "{}" : info);
                if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2UploadProgressNotification")) {
                    this.type = 1;
                    this.storageProgress = new Progress();
                    this.storageProgress.progress = object.optInt("MtcFsProgressKey");
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2UploadOkNotification")) {
                    this.type = 2;
                    this.sendOk = new SendOk();
                    this.sendOk.uri = object.optString("MtcFsLinkUriKey");
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2UploadDidFailNotification")) {
                    this.type = 3;
                    this.sendFail = new SendFail();
                    this.sendFail.statusCode = object.optInt("MtcFsStatusCodeKey");
                }
                if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2DownloadProgressNotification")) {
                    this.type = 1;
                    this.storageProgress = new Progress();
                    this.storageProgress.progress = object.optInt("MtcFsProgressKey");
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2DownloadOkNotification")) {
                    this.type = 4;
                    this.recvOk = new RecvOk();
                } else if (TextUtils.equals((CharSequence)name, (CharSequence)"MtcFs2DownloadDidFailNotification")) {
                    this.type = 5;
                    this.recvFail = new RecvFail();
                    this.recvFail.statusCode = object.optInt("MtcFsStatusCodeKey");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public class RecvFail {
            public int statusCode;
        }

        public class RecvOk {
        }

        public class SendFail {
            public int statusCode;
        }

        public class SendOk {
            public String uri;
        }

        public class Progress {
            public int progress;
        }
    }
}

