/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCMessageChannel;
import com.juphoon.cloud.JCMessageChannelCallback;
import com.juphoon.cloud.JCMessageChannelItem;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.JCUtils;
import com.juphoon.cloud.MtcEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class JCMessageChannelImpl
extends JCMessageChannel
implements MtcEngine.MtcNotifyListener,
JCClientCallback {
    static final String TAG = JCMessageChannelImpl.class.getSimpleName();
    private JCClient mClient;
    private List<JCMessageChannelCallback> mCallbacks = new ArrayList<JCMessageChannelCallback>();
    private SparseArray<JCMessageChannelItem> mMessages = new SparseArray();

    public JCMessageChannelImpl(JCClient client, JCMessageChannelCallback callback) {
        if (callback == null) {
            throw new RuntimeException("JCMessageChannel callback cannot be null!");
        }
        this.thumbDir = JCUtils.getSdkInfoDir(client.getContext()) + "thumb";
        new File(this.thumbDir).mkdirs();
        this.mCallbacks.add(callback);
        this.mClient = client;
        this.mClient.addCallback(this);
        MtcEngine.getInstance().addMtcNotifyListener(this);
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        this.mClient = null;
    }

    @Override
    public JCMessageChannelItem sendMessage(int type, String keyId, String messageType, String text, Map<String, String> extraParams) {
        if (text == null || text.length() == 0) {
            JCLog.error(TAG, "\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            return null;
        }
        if (text.length() > 10240) {
            JCLog.error(TAG, "\u6587\u672c\u5185\u5bb9\u8d85\u8fc710k", new Object[0]);
            return null;
        }
        JCMessageChannelItem item = new JCMessageChannelItem();
        item.messageId = UUID.randomUUID().toString();
        item.messageType = messageType;
        item.text = text;
        item.extraParams = extraParams;
        item.userId = type == 0 ? keyId : this.mClient.getUserId();
        item.groupId = type == 1 ? keyId : null;
        item.time = System.currentTimeMillis();
        item.direction = 0;
        item.type = type;
        item.displayName = TextUtils.isEmpty((CharSequence)this.mClient.displayName) ? this.mClient.getUserId() : this.mClient.displayName;
        JCParam.Message param = new JCParam.Message();
        param.userId = item.userId;
        param.messageType = messageType;
        param.messageContent = text;
        param.displayName = item.displayName;
        param.groupId = item.groupId;
        try {
            JSONObject object = new JSONObject();
            object.put("MessageId", (Object)item.messageId);
            if (extraParams != null) {
                JSONObject extra = new JSONObject();
                for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                    extra.put(entry.getKey(), (Object)entry.getValue());
                }
                object.put("ExtraData", (Object)extra);
            }
            param.messageInfo = object.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JCResult result = MtcEngine.getInstance().sendMessage(param);
        if (result.succ) {
            this.mMessages.put(result.cookie, (Object)item);
            item.state = 1;
            this.notifySendUpdate(item);
        } else {
            JCLog.error(TAG, "\u8c03\u7528\u53d1\u9001\u5931\u8d25", new Object[0]);
            item.state = 3;
            this.notifySendUpdate(item);
        }
        return item;
    }

    @Override
    public JCMessageChannelItem sendFile(int type, String keyId, String messageType, String fileUri, String thumbPath, int size, int duration, Map<String, String> extraParams) {
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            JCLog.error(TAG, "sendMessage \u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            return null;
        }
        byte[] thumbData = null;
        if (!TextUtils.isEmpty((CharSequence)thumbPath)) {
            if (JCUtils.isFileExist(thumbPath) && JCUtils.getFileSize(thumbPath) <= 6144L) {
                thumbData = JCUtils.getBytes(thumbPath);
            } else {
                JCLog.error(TAG, "sendMessage \u7f29\u7565\u56fe\u4e0d\u5b58\u5728\u6216\u8005\u8d85\u8fc76k\u9650\u5236", new Object[0]);
                return null;
            }
        }
        JCMessageChannelItem item = new JCMessageChannelItem();
        item.messageId = UUID.randomUUID().toString();
        item.messageType = messageType;
        item.fileUri = fileUri;
        item.thumbPath = thumbPath;
        item.fileSize = size;
        item.duration = duration;
        item.extraParams = extraParams;
        item.userId = type == 0 ? keyId : null;
        item.groupId = type == 1 ? keyId : null;
        item.time = System.currentTimeMillis();
        item.direction = 0;
        item.type = type;
        item.displayName = TextUtils.isEmpty((CharSequence)this.mClient.displayName) ? this.mClient.getUserId() : this.mClient.displayName;
        JCParam.Message param = new JCParam.Message();
        param.userId = keyId;
        param.messageType = messageType;
        param.displayName = item.displayName;
        param.messageContent = "file";
        param.groupId = item.groupId;
        try {
            JSONObject object = new JSONObject();
            object.put("MessageId", (Object)item.messageId);
            object.put("FileUri", (Object)item.fileUri);
            if (thumbData != null && thumbData.length > 0) {
                object.put("ThumbData", (Object)Base64.encodeToString((byte[])thumbData, (int)2));
            }
            object.put("FileSize", item.fileSize);
            object.put("Duration", item.duration);
            if (extraParams != null) {
                JSONObject extra = new JSONObject();
                for (Map.Entry<String, String> entry : extraParams.entrySet()) {
                    extra.put(entry.getKey(), (Object)entry.getValue());
                }
                object.put("ExtraData", (Object)extra);
            }
            param.messageInfo = object.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JCResult result = MtcEngine.getInstance().sendMessage(param);
        if (result.succ) {
            this.mMessages.put(result.cookie, (Object)item);
            item.state = 1;
            this.notifySendUpdate(item);
        } else {
            JCLog.error(TAG, "\u8c03\u7528\u53d1\u9001\u5931\u8d25", new Object[0]);
            item.state = 3;
            this.notifySendUpdate(item);
        }
        return item;
    }

    @Override
    protected void addCallback(JCMessageChannelCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCMessageChannelCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    public void onLogin(boolean result, int reason) {
        if (result) {
            JCLog.info(TAG, "\u767b\u9646\u6210\u529f\uff0c\u62c9\u53d6\u6d88\u606f", new Object[0]);
            MtcEngine.getInstance().fetchMessage(new JCParam.MessageFetch());
        }
    }

    @Override
    public void onLogout(int reason) {
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type == 3) {
            if (notify.messageNotify.type == 1) {
                JCMessageChannelItem item = this.getMessageItem(notify.cookie);
                if (item != null) {
                    item.state = 2;
                    item.sentTime = System.currentTimeMillis();
                    this.notifySendUpdate(item);
                    this.removeMessageItem(notify.cookie);
                }
            } else if (notify.messageNotify.type == 2) {
                JCMessageChannelItem item = this.getMessageItem(notify.cookie);
                if (item != null) {
                    item.state = 3;
                    this.notifySendUpdate(item);
                    this.removeMessageItem(notify.cookie);
                }
            } else if (notify.messageNotify.type == 3) {
                JCNotify.Message.Recv recv = notify.messageNotify.recvMessage;
                if (TextUtils.equals((CharSequence)this.mClient.getUserId(), (CharSequence)recv.userId)) {
                    return;
                }
                JCMessageChannelItem item = new JCMessageChannelItem();
                item.userId = recv.userId;
                item.displayName = recv.displayName;
                item.groupId = recv.groupId;
                item.messageType = recv.messageType;
                item.text = recv.messageContent;
                item.time = System.currentTimeMillis();
                item.sentTime = recv.time;
                if (!TextUtils.isEmpty((CharSequence)recv.messageInfo)) {
                    try {
                        JSONObject object = new JSONObject(recv.messageInfo);
                        item.messageId = object.optString("MessageId");
                        item.fileUri = object.optString("FileUri");
                        String thumb = object.optString("ThumbData");
                        if (!TextUtils.isEmpty((CharSequence)thumb)) {
                            byte[] thumbData = Base64.decode((String)thumb, (int)2);
                            item.thumbPath = JCUtils.genFilePath(this.thumbDir, "thumb");
                            JCUtils.writeToFile(thumbData, item.thumbPath);
                        }
                        item.fileSize = object.optInt("FileSize");
                        item.duration = object.optInt("Duration");
                        JSONObject extra = object.optJSONObject("ExtraData");
                        if (extra != null) {
                            item.extraParams = new HashMap<String, String>(16);
                            Iterator iterator = extra.keys();
                            while (iterator.hasNext()) {
                                String key = (String)iterator.next();
                                item.extraParams.put(key, extra.getString(key));
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                item.state = 4;
                item.direction = 1;
                item.type = this.translateFromMtcCategory(recv.category);
                this.notifyRecv(item);
            }
        }
    }

    private void notifySendUpdate(final JCMessageChannelItem item) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u53d1\u9001\u72b6\u6001\u66f4\u65b0", new Object[0]);
                for (JCMessageChannelCallback callback : JCMessageChannelImpl.this.mCallbacks) {
                    callback.onMessageSendUpdate(item);
                }
            }
        });
    }

    private void notifyRecv(final JCMessageChannelItem item) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u6536\u5230\u6d88\u606f", new Object[0]);
                for (JCMessageChannelCallback callback : JCMessageChannelImpl.this.mCallbacks) {
                    callback.onMessageRecv(item);
                }
            }
        });
    }

    private int translateFromMtcCategory(int category) {
        switch (category) {
            case 1: {
                return 0;
            }
        }
        return 1;
    }

    private JCMessageChannelItem getMessageItem(int cookie) {
        JCMessageChannelItem item = (JCMessageChannelItem)this.mMessages.get(cookie);
        if (item == null) {
            JCLog.error(TAG, "\u672a\u627e\u5230\u8be5\u53d1\u9001\u6d88\u606f", new Object[0]);
        }
        return item;
    }

    private void removeMessageItem(int cookie) {
        this.mMessages.remove(cookie);
    }
}

