/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientImpl;
import com.juphoon.cloud.JCClientThreadImpl;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public abstract class JCClient {
    static final String TAG = JCClient.class.getSimpleName();
    public static final int STATE_NOT_INIT = 0;
    public static final int STATE_IDLE = 1;
    public static final int STATE_LOGINING = 2;
    public static final int STATE_LOGINED = 3;
    public static final int STATE_LOGOUTING = 4;
    public static final int REASON_NONE = 0;
    public static final int REASON_SDK_NOT_INIT = 1;
    public static final int REASON_INVALID_PARAM = 2;
    public static final int REASON_CALL_FUNCTION_ERROR = 3;
    public static final int REASON_STATE_CANNOT_LOGIN = 4;
    public static final int REASON_TIMEOUT = 5;
    public static final int REASON_NETWORK = 6;
    public static final int REASON_APPKEY = 7;
    public static final int REASON_AUTH = 8;
    public static final int REASON_NOUSER = 9;
    public static final int REASON_SERVER_LOGOUT = 10;
    public static final int REASON_OTHER = 100;
    public static final String CONFIG_KEY_SERVER_ADDRESS = "config_key_server_address";
    public static final String CONFIG_KEY_DEVICE_ID = "config_key_device_id";
    public static final String CREATE_EXTRA_SDK_INFO_DIR = "create_extra_sdk_info_dir";
    public static final String CREATE_EXTRA_SDK_LOG_DIR = "create_extra_sdk_log_dir";
    private static JCClient sClient;
    public String displayName;

    public static JCClient create(Context context, String appKey, JCClientCallback callback, Map<String, String> extraParams) {
        if (sClient != null) {
            return sClient;
        }
        sClient = new JCClientImpl(context, appKey, callback, extraParams);
        return sClient;
    }

    public static void destroy() {
        if (sClient != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sClient.destroyObj();
                    sClient = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract void setForeground(boolean var1);

    public abstract String getUserId();

    public abstract int getState();

    public abstract boolean login(String var1, String var2);

    public abstract boolean logout();

    public abstract boolean setConfig(String var1, String var2);

    public abstract String getConfig(String var1);

    protected abstract Context getContext();

    protected abstract void addCallback(JCClientCallback var1);

    protected abstract void removeCallback(JCClientCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreateExtra {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ClientState {
    }
}

