/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import com.juphoon.cloud.JCCall;
import com.juphoon.cloud.JCCallCallback;
import com.juphoon.cloud.JCCallItem;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCMediaDevice;
import com.juphoon.cloud.JCMediaDeviceCallback;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.MtcEngine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class JCCallImpl
extends JCCall
implements MtcEngine.MtcNotifyListener,
JCClientCallback,
JCMediaDeviceCallback {
    private static final String COMMANDKEY = "CommandKey";
    private static final String COMMAND_HOLDKEY = "CommandType_HoldKey";
    private static final String COMMAND_HOLD = "CommandType_Hold";
    private JCClient mClient;
    private JCMediaDevice mMediaDevice;
    private List<JCCallCallback> mCallbacks = new ArrayList<JCCallCallback>();
    private boolean mConference;
    private List<JCCallItem> mCallItems = new ArrayList<JCCallItem>();
    private static final long NETWORK_TIMEOUT = 0L;
    private boolean mHasPostNetStatusRunnable = false;
    private Runnable mNetStatusRunnable = new Runnable(){

        @Override
        public void run() {
            long nextPost = Long.MAX_VALUE;
            for (JCCallItem item : JCCallImpl.this.mCallItems) {
                if (item.netStatus != -3) continue;
                long internal = System.currentTimeMillis() - item.netStatusUpdateTime;
                if (internal > 0L) {
                    JCCallImpl.this.term(item, 4, "");
                    continue;
                }
                if (internal >= nextPost) continue;
                nextPost = internal;
            }
            if (nextPost != Long.MAX_VALUE) {
                JCClientThreadImpl.getInstance().postDelayed(JCCallImpl.this.mNetStatusRunnable, nextPost);
            } else {
                JCCallImpl.this.mHasPostNetStatusRunnable = false;
            }
        }
    };

    JCCallImpl(JCClient client, JCMediaDevice mediaDevice, JCCallCallback callback) {
        if (callback == null) {
            throw new RuntimeException("JCCallCallback cannot be null!");
        }
        this.mCallbacks.add(callback);
        this.mClient = client;
        this.mMediaDevice = mediaDevice;
        this.mConference = false;
        this.mClient.addCallback(this);
        this.mMediaDevice.addCallback(this);
        MtcEngine.getInstance().addMtcNotifyListener(this);
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type == 2) {
            JCCallItem item;
            JCNotify.Call callNotify = notify.callNotify;
            if (callNotify.type == 1) {
                this.notifyCallItemRemove(callNotify.didTerm.callId, 6, "");
            } else if (callNotify.type == 2) {
                this.notifyCallItemRemove(callNotify.termed.callId, this.translateFromMtcReason(callNotify.termed.statusCode), callNotify.termed.desc);
            } else if (callNotify.type == 3) {
                boolean canAnswer = true;
                int reason = 0;
                JCCallItem sameCallItem = this.getCallByUserId(callNotify.incoming.userId);
                if (sameCallItem != null) {
                    JCLog.info(TAG, "\u540c\u4e00\u7528\u6237\u547c\u53eb\u8fdb\u6765", new Object[0]);
                    this.mCallItems.remove(sameCallItem);
                }
                if (this.mCallItems.size() > 0 && callNotify.incoming.video) {
                    canAnswer = false;
                    JCLog.info(TAG, "\u5df2\u6709\u901a\u8bdd\uff0c%s\u89c6\u9891\u547c\u53eb\u62d2\u7edd", callNotify.incoming.userId);
                    reason = 12;
                } else if (this.mCallItems.size() >= this.maxCallNum) {
                    canAnswer = false;
                    JCLog.info(TAG, "\u901a\u8bdd\u8d85\u8fc7\u4e2a\u6570\u9650\u5236\uff0c%s\u547c\u53eb\u62d2\u7edd", callNotify.incoming.userId);
                    reason = 5;
                }
                JCCallItem item2 = new JCCallItem();
                item2.callId = callNotify.incoming.callId;
                item2.userId = callNotify.incoming.userId;
                item2.displayName = callNotify.incoming.displayName;
                item2.renderId = callNotify.incoming.uri;
                item2.video = callNotify.incoming.video;
                item2.renderId = callNotify.incoming.renderId;
                item2.direction = 0;
                item2.active = this.mCallItems.size() == 0;
                item2.uploadVideoStreamSelf = true;
                item2.uploadVideoStreamOther = callNotify.incoming.video;
                item2.serverCallId = callNotify.incoming.serverCallId;
                item2.extraParam = callNotify.incoming.extraParam;
                this.mCallItems.add(item2);
                if (!canAnswer) {
                    JCParam.Term param = new JCParam.Term();
                    param.callId = callNotify.incoming.callId;
                    param.reason = this.translateToMtcReason(8);
                    if (MtcEngine.getInstance().term((JCParam.Term)param).succ) {
                        JCLog.info(TAG, "term %s", callNotify.incoming.userId);
                    }
                    item2.state = 7;
                    this.notifyCallItemRemove(item2.callId, reason, "");
                } else {
                    item2.state = 1;
                    this.notifyCallItemAdd(item2);
                }
            } else if (callNotify.type == 11) {
                JCCallItem item3 = this.getCallItem(callNotify.trying.callId);
                if (item3 != null) {
                    item3.serverCallId = callNotify.trying.serverCallId;
                    this.notifyCallItemUpdate(item3);
                }
            } else if (callNotify.type == 4) {
                JCCallItem item4 = this.getCallItem(callNotify.talking.callId);
                if (item4 != null) {
                    item4.state = 3;
                    item4.talkingBeginTime = System.currentTimeMillis() / 1000L;
                    this.notifyCallItemUpdate(item4);
                    if (this.mConference) {
                        this.updateVoiceMix(item4);
                    }
                }
            } else if (callNotify.type == 5) {
                JCCallItem item5 = this.getCallItem(callNotify.connecting.callId);
                if (item5 != null) {
                    this.mMediaDevice.startAudio();
                    item5.state = 2;
                    item5.video = callNotify.connecting.video;
                    this.notifyCallItemUpdate(item5);
                    this.startSendMediaIfNeed();
                }
            } else if (callNotify.type == 6) {
                JCCallItem item6 = this.getCallItem(callNotify.alerted.callId);
                if (item6 != null) {
                    item6.state = 1;
                    this.notifyCallItemUpdate(item6);
                }
            } else if (callNotify.type == 7) {
                this.dealMessage(callNotify.message);
            } else if (callNotify.type == 8) {
                JCCallItem item7 = this.getCallItem(callNotify.otherVideoStatus.callId);
                if (item7 != null) {
                    item7.uploadVideoStreamOther = this.isOtherUploadVideo(callNotify.otherVideoStatus.status);
                    this.notifyCallItemUpdate(item7);
                }
            } else if (callNotify.type == 9) {
                JCCallItem item8 = new JCCallItem();
                item8.userId = callNotify.missCall.userId;
                item8.state = 7;
                item8.video = callNotify.missCall.video;
                item8.displayName = callNotify.missCall.displayName;
                item8.direction = 0;
                item8.beginTime = callNotify.missCall.time;
                item8.serverCallId = callNotify.missCall.serverCallId;
                this.mCallItems.add(item8);
                this.notifyCallItemRemove(item8.callId, 0, "");
            } else if (callNotify.type == 10 && (item = this.getCallItem(callNotify.netStatus.callId)) != null && !callNotify.netStatus.send && !callNotify.netStatus.video) {
                item.netStatus = callNotify.netStatus.status;
                item.netStatusUpdateTime = System.currentTimeMillis();
                this.notifyCallItemUpdate(item);
                if (callNotify.netStatus.status == -3 && !this.mHasPostNetStatusRunnable) {
                    this.mHasPostNetStatusRunnable = true;
                    JCClientThreadImpl.getInstance().postDelayed(this.mNetStatusRunnable, 0L);
                }
            }
        }
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        this.mMediaDevice.removeCallback(this);
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        this.mMediaDevice = null;
        this.mClient = null;
    }

    @Override
    public boolean call(String userId, boolean video, String extraParam) {
        if (this.mClient.getState() != 3) {
            JCLog.error(TAG, "call \u672a\u767b\u9646", new Object[0]);
            return false;
        }
        if (this.mCallItems.size() > 0) {
            if (video) {
                JCLog.error(TAG, "call \u5df2\u6709\u901a\u8bdd\u4e0d\u80fd\u518d\u53d1\u8d77\u89c6\u9891\u547c\u53eb", new Object[0]);
                return false;
            }
            if (this.mCallItems.get(0).getVideo()) {
                JCLog.error(TAG, "call \u5df2\u6709\u89c6\u9891\u901a\u8bdd\u4e0d\u80fd\u518d\u53d1\u8d77\u547c\u53eb", new Object[0]);
                return false;
            }
        }
        if (this.getCallByUserId(userId) != null) {
            JCLog.error(TAG, "call \u5df2\u6709\u8be5\u7528\u6237\u547c\u53eb", new Object[0]);
            return false;
        }
        if (userId.equals(this.mClient.getUserId())) {
            JCLog.error(TAG, "call \u65e0\u6cd5\u62e8\u6253\u81ea\u5df1", new Object[0]);
            return false;
        }
        if (this.mCallItems.size() >= this.maxCallNum) {
            JCLog.error(TAG, "call \u8d85\u8fc7\u6700\u5927\u901a\u8bdd\u6570", new Object[0]);
            return false;
        }
        final JCCallItem item = new JCCallItem();
        item.userId = userId;
        item.displayName = userId;
        item.video = video;
        item.direction = 1;
        item.uploadVideoStreamSelf = video;
        item.uploadVideoStreamOther = video;
        this.mCallItems.add(item);
        if (this.mCallItems.size() > 1) {
            this.becomeActive(item);
        } else {
            item.active = true;
        }
        this.notifyCallItemAdd(item);
        JCParam.Call param = new JCParam.Call();
        param.userId = userId;
        param.video = video;
        param.displayName = TextUtils.isEmpty((CharSequence)this.mClient.displayName) ? this.mClient.getUserId() : this.mClient.displayName;
        param.extraParam = extraParam;
        JCResult result = MtcEngine.getInstance().call(param);
        if (result.succ) {
            item.callId = result.longValue;
            item.renderId = result.strValue;
            JCLog.info(TAG, "call %s", userId);
        } else {
            item.state = 8;
            JCLog.error(TAG, "call \u8c03\u7528\u5931\u8d25", new Object[0]);
            int finalReason = 2;
            JCClientThreadImpl.getInstance().postDelayed(new Runnable(){

                @Override
                public void run() {
                    JCCallImpl.this.notifyCallItemRemove(item.callId, 2, "");
                }
            }, 1000L);
        }
        return true;
    }

    @Override
    public boolean term(JCCallItem item, int reason, String description) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "term \u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", new Object[0]);
            return false;
        }
        JCParam.Term param = new JCParam.Term();
        param.callId = item.callId;
        param.reason = this.translateToMtcReason(reason);
        String string = param.desc = description == null ? "" : description;
        if (MtcEngine.getInstance().term((JCParam.Term)param).succ) {
            JCLog.info(TAG, "term %s", item.getUserId());
        } else {
            JCLog.info(TAG, "term %s \u8c03\u7528\u5931\u8d25\u5f3a\u884cterm", item.getUserId());
        }
        this.notifyCallItemRemove(item.callId, 6, "");
        return true;
    }

    @Override
    public boolean answer(JCCallItem item, boolean video) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "answer %s \u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", item.getUserId());
            return false;
        }
        item.uploadVideoStreamSelf = video;
        JCParam.Answer param = new JCParam.Answer();
        param.callId = item.callId;
        param.video = video;
        if (MtcEngine.getInstance().answer((JCParam.Answer)param).succ) {
            if (!item.getActive() && !this.mConference) {
                this.becomeActive(item);
            }
            JCLog.info(TAG, "answer %s", item.getUserId());
            return true;
        }
        JCLog.error(TAG, "answer %s \u5931\u8d25", item.getUserId());
        this.notifyCallItemRemove(item.callId, 7, "");
        return false;
    }

    @Override
    public boolean mute(JCCallItem item) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "mute %s \u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", item.getUserId());
            return false;
        }
        if (item.getState() != 3) {
            JCLog.error(TAG, "\u901a\u8bdd\u4e2d\u624d\u80fdmute", new Object[0]);
            return false;
        }
        if (this.mConference) {
            for (JCCallItem iteSubm : this.mCallItems) {
                iteSubm.mute = !iteSubm.getMute();
                this.internalMute(iteSubm);
            }
            this.notifyCallItemUpdate(null);
        } else {
            item.mute = !item.getMute();
            this.internalMute(item);
            this.notifyCallItemUpdate(item);
        }
        return true;
    }

    @Override
    public boolean hold(JCCallItem item) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "hold \u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", new Object[0]);
            return false;
        }
        if (item.getHeld()) {
            JCLog.error(TAG, "\u88abhold\uff0c\u65e0\u6cd5\u64cd\u4f5c", new Object[0]);
            return false;
        }
        if (item.getState() != 3) {
            JCLog.error(TAG, "\u901a\u8bdd\u4e2d\u624d\u80fdhold", new Object[0]);
            return false;
        }
        if (this.mConference && !item.getHold()) {
            JCLog.error(TAG, "\u4f1a\u8bae\u4e2d\u53ea\u80fdunhold", new Object[0]);
            return false;
        }
        item.hold = !item.getHold();
        this.internalMute(item);
        this.sendHoldCommand(item);
        this.notifyCallItemUpdate(item);
        JCLog.info(TAG, "hold %s %b", item.getUserId(), item.getHold());
        return true;
    }

    @Override
    public boolean audioRecord(JCCallItem item, boolean enable, String filePath) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "mute %s \u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", item.getUserId());
            return false;
        }
        if (enable) {
            if (item.audioRecord) {
                JCLog.error(TAG, "\u4e0e %s \u6b63\u5728\u5f55\u97f3\u4e2d", item.getUserId());
                return false;
            }
            for (JCCallItem items : this.mCallItems) {
                if (!items.getAudioRecord()) continue;
                this.audioRecord(item, false, "");
            }
        } else if (!item.audioRecord) {
            JCLog.error(TAG, "\u4e0e %s \u672a\u5728\u5f55\u97f3 ", item.getUserId());
            return false;
        }
        JCParam.CallMedia param = new JCParam.CallMedia();
        param.type = 5;
        param.callId = item.callId;
        param.enable = enable;
        param.optionalValue = filePath;
        if (MtcEngine.getInstance().callMedia((JCParam.CallMedia)param).succ) {
            JCLog.info(TAG, "audioRecord", new Object[0]);
            item.audioRecord = enable;
            item.audioRecordFilePath = enable ? filePath : "";
            this.notifyCallItemUpdate(item);
            return true;
        }
        JCLog.error(TAG, "audioRecord \u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public boolean videoRecord(JCCallItem item, boolean enable, boolean remote, int width, int height, String filePath) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "\u4e0e %s \u89c6\u9891\u5f55\u5236\u627e\u4e0d\u5230\u901a\u8bdd\u5bf9\u8c61", item.getUserId());
            return false;
        }
        if (enable) {
            if (remote && item.getRemoteVideoRecord()) {
                JCLog.error(TAG, "\u6b63\u5728\u5f55\u5236 %s \u7684\u89c6\u9891", item.getUserId());
                return false;
            }
            if (!remote && item.getLocalVideoRecord()) {
                JCLog.error(TAG, "\u6b63\u5728\u5f55\u5236\u672c\u7aef\u89c6\u9891", new Object[0]);
                return false;
            }
            for (JCCallItem items : this.mCallItems) {
                if ((!remote || !items.getRemoteVideoRecord()) && (remote || !items.getLocalVideoRecord())) continue;
                this.videoRecord(item, false, remote, 0, 0, "");
            }
        } else {
            if (remote && !item.getRemoteVideoRecord()) {
                JCLog.error(TAG, "\u4e0e %s \u672a\u5728\u5f55\u5236\u89c6\u9891\uff0c\u5173\u95ed\u89c6\u9891\u5f55\u5236\u5931\u8d25 ", item.getUserId());
                return false;
            }
            if (!remote && !item.getLocalVideoRecord()) {
                JCLog.error(TAG, "\u672c\u7aef\u89c6\u9891\u672a\u5728\u5f55\u5236\uff0c\u5173\u95ed\u89c6\u9891\u5f55\u5236\u5931\u8d25 ", new Object[0]);
                return false;
            }
        }
        JCParam.CallMedia param = new JCParam.CallMedia();
        param.callId = item.callId;
        param.type = 6;
        param.remote = remote;
        param.enable = enable;
        param.optionalValue = filePath;
        param.videoRecordWidth = width;
        param.videoRecordHeight = height;
        if (MtcEngine.getInstance().callMedia((JCParam.CallMedia)param).succ) {
            JCLog.info(TAG, "videoRecord", new Object[0]);
            if (remote) {
                item.remoteVideoRecord = enable;
                item.remoteVideoRecordFilePath = enable ? filePath : "";
            } else {
                item.localVideoRecord = enable;
                item.localVideoRecordFilePath = enable ? filePath : "";
            }
            this.notifyCallItemUpdate(item);
            return true;
        }
        return false;
    }

    @Override
    public boolean becomeActive(JCCallItem item) {
        if (item == null) {
            return false;
        }
        if (this.mConference) {
            JCLog.info(TAG, "switchActive \u4f1a\u8bae\u6a21\u5f0f\u65e0\u6cd5\u5207\u6362", new Object[0]);
            return false;
        }
        if (item.getActive()) {
            JCLog.info(TAG, "switchActive \u5df2\u7ecf\u4e3a\u6fc0\u6d3b\u72b6\u6001", new Object[0]);
            return true;
        }
        JCCallItem activeItem = this.getActiveCallItem();
        activeItem.active = false;
        if (!activeItem.hold) {
            this.hold(activeItem);
        }
        this.notifyCallItemUpdate(activeItem);
        item.active = true;
        if (item.hold) {
            this.hold(item);
        }
        this.notifyCallItemUpdate(item);
        return true;
    }

    @Override
    public boolean enableUploadVideoStream(JCCallItem item) {
        if (item == null) {
            return false;
        }
        if (!item.getVideo()) {
            JCLog.error(TAG, "enableUploadVideoStream \u8bed\u97f3\u901a\u8bdd\u65e0\u6cd5\u64cd\u4f5c", new Object[0]);
            return false;
        }
        JCParam.CallMedia param = new JCParam.CallMedia();
        param.type = 4;
        param.callId = item.callId;
        boolean bl = param.enable = !item.getUploadVideoStreamSelf();
        if (MtcEngine.getInstance().callMedia((JCParam.CallMedia)param).succ) {
            item.uploadVideoStreamSelf = !item.getUploadVideoStreamSelf();
            JCLog.info(TAG, "enableUploadVideoStream", new Object[0]);
            this.notifyCallItemUpdate(item);
            return true;
        }
        JCLog.error(TAG, "enableUploadVideoStream \u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public void setConference(boolean conference) {
        this.mConference = conference;
        for (JCCallItem item : this.mCallItems) {
            if (this.mConference) {
                if (item.getHold()) {
                    this.hold(item);
                }
                item.mute = false;
            }
            this.updateVoiceMix(item);
            this.internalMute(item);
        }
        if (this.mCallItems.size() > 0) {
            this.notifyCallItemUpdate(null);
        }
    }

    @Override
    public boolean getConference() {
        return this.mConference;
    }

    @Override
    public List<JCCallItem> getCallItems() {
        return this.mCallItems;
    }

    @Override
    public boolean sendMessage(JCCallItem item, String type, String content) {
        if (item == null) {
            return false;
        }
        if (!this.mCallItems.contains(item)) {
            JCLog.error(TAG, "sendMessage \u5931\u8d25\uff1a\u65e0\u6b64\u901a\u8bdd", new Object[0]);
        }
        JCParam.CallMessage param = new JCParam.CallMessage();
        param.callId = item.callId;
        param.messageType = type;
        param.content = content;
        return MtcEngine.getInstance().callStreamData((JCParam.CallMessage)param).succ;
    }

    @Override
    public String getStatistics() {
        JCCallItem item = this.getActiveCallItem();
        if (item != null) {
            JCParam.CallStatistics param = new JCParam.CallStatistics();
            param.callId = item.callId;
            return MtcEngine.getInstance().callStatistics((JCParam.CallStatistics)param).strValue;
        }
        return "";
    }

    @Override
    protected void addCallback(JCCallCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCCallCallback callback) {
        this.mCallbacks.remove(callback);
    }

    private JCCallItem getCallByUserId(String userId) {
        for (JCCallItem item : this.mCallItems) {
            if (!item.getUserId().equals(userId)) continue;
            return item;
        }
        return null;
    }

    private JCCallItem getCallItem(long callId) {
        for (JCCallItem item : this.mCallItems) {
            if (item.callId != callId) continue;
            return item;
        }
        JCLog.error(TAG, "\u672a\u627e\u5230\u901a\u8bdd\u5bf9\u8c61", new Object[0]);
        return null;
    }

    private void autoChooseActive() {
        Iterator<JCCallItem> iterator = this.mCallItems.iterator();
        if (iterator.hasNext()) {
            JCCallItem item = iterator.next();
            item.active = true;
            if (item.getHold()) {
                this.hold(item);
            } else {
                this.notifyCallItemUpdate(item);
            }
            return;
        }
    }

    void internalMute(JCCallItem item) {
        JCParam.CallMedia param = new JCParam.CallMedia();
        param.callId = item.callId;
        param.type = 1;
        param.enable = item.getHeld() || item.getHold() || item.getMute();
        MtcEngine.getInstance().callMedia(param);
        param.type = 2;
        param.enable = item.getHeld() || item.getHold();
        MtcEngine.getInstance().callMedia(param);
    }

    void sendHoldCommand(JCCallItem item) {
        try {
            JSONObject object = new JSONObject();
            object.put(COMMANDKEY, (Object)COMMAND_HOLD);
            object.put(COMMAND_HOLDKEY, item.getHold());
            JCParam.CallMessage param = new JCParam.CallMessage();
            param.callId = item.callId;
            param.content = object.toString();
            if (MtcEngine.getInstance().callMessage((JCParam.CallMessage)param).succ) {
                JCLog.info(TAG, "\u53d1\u9001hold\u547d\u4ee4", new Object[0]);
            } else {
                JCLog.error(TAG, "\u53d1\u9001hold\u547d\u4ee4\u5931\u8d25", new Object[0]);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private JCCallItem getActiveCallItem() {
        for (JCCallItem item : this.mCallItems) {
            if (!item.getActive()) continue;
            return item;
        }
        JCLog.error(TAG, "\u672a\u627e\u5230\u6d3b\u8dc3\u901a\u8bdd\u5bf9\u8c61", new Object[0]);
        return null;
    }

    private boolean updateVoiceMix(JCCallItem item) {
        JCParam.CallMedia param = new JCParam.CallMedia();
        param.type = 3;
        param.callId = item.callId;
        param.enable = this.mConference;
        if (MtcEngine.getInstance().callMedia((JCParam.CallMedia)param).succ) {
            JCLog.info(TAG, "%s \u6df7\u97f3", item.getUserId());
            return true;
        }
        JCLog.info(TAG, "%s \u6df7\u97f3\u5931\u8d25", item.getUserId());
        return false;
    }

    private void dealMessage(JCNotify.Call.Message message) {
        JCCallItem item = this.getCallItem(message.callId);
        if (item != null) {
            try {
                if (message.tunnel == 0) {
                    JSONObject object = new JSONObject(message.content);
                    String command = object.optString(COMMANDKEY);
                    if (TextUtils.equals((CharSequence)command, (CharSequence)COMMAND_HOLD)) {
                        JCLog.info(TAG, "\u5904\u7406hold\u547d\u4ee4", new Object[0]);
                        item.held = object.optBoolean(COMMAND_HOLDKEY);
                        this.internalMute(item);
                        this.notifyCallItemUpdate(item);
                    }
                } else {
                    this.notifyCallMessageReceived(item, message.type, message.content);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyCallItemAdd(final JCCallItem item) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCCall.TAG, "notifyCallItemAdd, userId:%s", item.getUserId());
                for (JCCallCallback callback : JCCallImpl.this.mCallbacks) {
                    callback.onCallItemAdd(item);
                }
            }
        });
    }

    private void notifyCallItemRemove(long callId, final int reason, final String description) {
        final JCCallItem item = this.getCallItem(callId);
        if (item != null) {
            int state;
            this.mCallItems.remove(item);
            if (item.getActive()) {
                this.autoChooseActive();
            }
            if ((state = item.getState()) <= 1 && item.getDirection() == 0) {
                item.state = 7;
            } else if (state != 8 && state != 7) {
                item.state = state >= 2 ? 4 : (reason == 6 ? 5 : 6);
            }
            item.reason = reason;
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    JCLog.info(JCCall.TAG, "\u901a\u8bdd\u7ed3\u675f %s \u539f\u56e0:%d", item.getUserId(), reason);
                    for (JCCallCallback callback : JCCallImpl.this.mCallbacks) {
                        callback.onCallItemRemove(item, reason, description);
                    }
                    if (JCCallImpl.this.mCallItems.size() == 0) {
                        if (JCCallImpl.this.mMediaDevice != null) {
                            JCCallImpl.this.mMediaDevice.stopAudio();
                            JCCallImpl.this.mMediaDevice.enableSpeaker(false);
                        } else {
                            JCLog.info(JCCall.TAG, "\u5df2\u9500\u6bc1", new Object[0]);
                        }
                        MtcEngine.getInstance().hasCalls = false;
                    }
                }
            });
        } else {
            JCLog.info(TAG, "notifyCallItemRemove, \u672a\u627e\u5230 item", new Object[0]);
        }
    }

    private void notifyCallItemUpdate(final JCCallItem item) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCCall.TAG, "notifyCallItemUpdate, userId:%s", item.getUserId());
                for (JCCallCallback callback : JCCallImpl.this.mCallbacks) {
                    callback.onCallItemUpdate(item);
                }
            }
        });
    }

    private void notifyCallMessageReceived(final JCCallItem item, final String type, final String content) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(JCCall.TAG, "notifyCallMessageReceived, from:%s, type:%s, content:%s", item.getUserId(), type, content);
                for (JCCallCallback callback : JCCallImpl.this.mCallbacks) {
                    callback.onMessageReceive(type, content, item);
                }
            }
        });
    }

    private int translateToMtcReason(int reason) {
        switch (reason) {
            case 8: {
                return 1001;
            }
            case 9: {
                return 1002;
            }
        }
        return 1000;
    }

    private int translateFromMtcReason(int reason) {
        switch (reason) {
            case 1000: {
                return 0;
            }
            case 1001: {
                return 8;
            }
            case 1002: {
                return 9;
            }
            case 1100: {
                return 3;
            }
            case 1101: {
                return 10;
            }
            case 1102: {
                return 11;
            }
        }
        return 100;
    }

    private boolean isOtherUploadVideo(int status) {
        return status == 1852992876;
    }

    @Override
    public void onLogin(boolean result, int reason) {
        if (result) {
            JCLog.info(TAG, "\u62c9\u53d6\u672a\u63a5\u6765\u7535", new Object[0]);
            MtcEngine.getInstance().fetchCalls(new JCParam.CallFetch());
        }
    }

    @Override
    public void onLogout(int reason) {
        for (JCCallItem item : this.mCallItems) {
            this.notifyCallItemRemove(item.callId, 1, "");
        }
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    @Override
    public void onCameraUpdate() {
        this.startSendMediaIfNeed();
    }

    @Override
    public void onAudioOutputTypeChange(boolean speaker) {
    }

    private void startSendMediaIfNeed() {
        JCCallItem item = this.getActiveCallItem();
        if (item != null && item.video && this.mMediaDevice.isCameraOpen() && item.uploadVideoStreamSelf && item.getState() >= 2 && item.getState() <= 3) {
            JCParam.CallMedia param = new JCParam.CallMedia();
            param.type = 0;
            param.callId = item.callId;
            param.enable = true;
            param.optionalValue = this.mMediaDevice.getCamera();
            MtcEngine.getInstance().callMedia(param);
        }
    }
}

