/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.GaussianBlur;
import com.justalk.cloud.zmf.GreyRender;
import com.justalk.cloud.zmf.MagnifierRender;
import com.justalk.cloud.zmf.MatchParam;
import com.justalk.cloud.zmf.YuvMaskRender;
import com.justalk.cloud.zmf.YuvRender;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONException;
import org.json.JSONObject;

class GLES2View
extends GLView
implements GLSurfaceView.Renderer {
    int[] _texEffect = new int[]{0, 0};
    int[] _fboEffect = new int[]{0, 0};
    EffectFx[] _effects = new EffectFx[10];
    private int _viewWidth;
    private int _viewHeight;

    public GLES2View(Context context) {
        super(context);
        this.getHolder().setFormat(-3);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 0, 0);
        this.setRenderer(this);
        this.setRenderMode(0);
    }

    private boolean fillEffectSlot(EffectParam effectParam, Class<?>[] classArray) {
        EffectFx[] effectFxArray = new EffectFx[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            int n = -1;
            for (int j = 0; j < this._effects.length; ++j) {
                if (this._effects[j] == null) {
                    if (n >= 0) continue;
                    n = j;
                    continue;
                }
                if (this._effects[j].getClass() != classArray[i]) continue;
                effectFxArray[i] = this._effects[j].ref();
                break;
            }
            if (effectFxArray[i] != null) continue;
            if (n < 0) {
                return false;
            }
            try {
                this._effects[n] = (EffectFx)classArray[i].newInstance();
                effectFxArray[i] = this._effects[n].ref();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }
        if (effectParam.effect != null) {
            for (EffectFx effectFx : effectParam.effect) {
                if (effectFx == null || !effectFx.unref()) continue;
                effectFx.release();
            }
        }
        effectParam.effect = effectFxArray;
        return true;
    }

    @Override
    public int videoRenderEffect(String string, final int n, final JSONObject jSONObject, final Object[] objectArray) {
        final GLView.Layer layer = (GLView.Layer)this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES2View.this.setupEffectFxList(layer, n, jSONObject, objectArray);
            }
        });
        return 0;
    }

    @Override
    public int videoRenderMatch(String string, int n, JSONObject jSONObject, Object[] objectArray) {
        GLView.Layer layer = (GLView.Layer)this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        try {
            if (layer.match_param == null) {
                layer.match_param = new MatchParam();
            }
            layer.match_param.timeStampMs = jSONObject.getInt("timeStamp");
            layer.match_param.matchType = n;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int videoRenderGetLocation(String string, float[] fArray) {
        GLView.Layer layer = (GLView.Layer)this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        int n = ZmfVideo.sCamAngle;
        int n2 = layer.angle;
        n2 = (n + n2) % 360;
        float f = layer.sxRatio;
        float f2 = layer.syRatio;
        float f3 = (1.0f - f) / 2.0f;
        float f4 = (1.0f - f2) / 2.0f;
        float f5 = fArray[0];
        float f6 = fArray[1];
        float f7 = fArray[2];
        float f8 = fArray[3];
        float f9 = fArray[4];
        f5 = (f5 - f3) / f;
        f6 = (f6 - f4) / f2;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        } else if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        } else if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        f7 = f7 / f / f9;
        f8 = f8 / f2 / f9;
        if (n2 == 270) {
            float f10 = f6;
            f6 = f5;
            f5 = 1.0f - f10;
            f10 = f8;
            f8 = f7;
            f7 = -f10;
        } else if (n2 == 90) {
            float f11 = f6;
            f6 = 1.0f - f5;
            f5 = f11;
            f11 = f8;
            f8 = -f7;
            f7 = f11;
        } else if (n2 == 180) {
            f5 = 1.0f - f5;
            f6 = 1.0f - f6;
            f7 = -f7;
            f8 = -f8;
        }
        fArray[0] = f5;
        fArray[1] = f6;
        fArray[2] = f7;
        fArray[3] = f8;
        return 0;
    }

    private boolean setupEffectFxList(GLView.Layer layer, int n, JSONObject jSONObject, Object[] objectArray) {
        Object object;
        if (layer.effect_param == null) {
            layer.effect_param = new EffectParam();
            layer.effectType = -1;
        }
        EffectParam effectParam = layer.effect_param;
        if (layer.effectType != n) {
            effectParam.argc = 0;
            object = null;
            switch (n) {
                case 1: {
                    object = new Class[]{YuvRender.class, GaussianBlur.class};
                    break;
                }
                case 2: {
                    object = new Class[]{GreyRender.class};
                    break;
                }
                case 3: {
                    object = new Class[]{YuvMaskRender.class};
                    break;
                }
                case 0: {
                    object = new Class[]{YuvRender.class};
                    break;
                }
                case 4: {
                    object = new Class[]{MagnifierRender.class};
                    break;
                }
                default: {
                    return false;
                }
            }
            if (object == null || !this.fillEffectSlot(effectParam, (Class<?>[])object)) {
                layer.effectType = -1;
                return false;
            }
            layer.effectType = n;
            this.requestRender();
        }
        if (jSONObject != null) {
            effectParam.argc = 0;
            effectParam.objects = objectArray;
            effectParam.name = new String[jSONObject.length()];
            effectParam.value = new float[jSONObject.length()];
            try {
                object = jSONObject.keys();
                while (object.hasNext()) {
                    String string;
                    effectParam.name[effectParam.argc] = string = (String)object.next();
                    effectParam.value[effectParam.argc] = (float)jSONObject.getDouble(string);
                    ++effectParam.argc;
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                ZmfVideo.logError("invalid: json");
                effectParam.name = null;
                effectParam.value = null;
                effectParam.argc = 0;
            }
        }
        return true;
    }

    @Override
    protected void onLayerPrepare(GLView.Layer layer, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (bl2) {
            if (layer.texId != null) {
                GLES10.glDeleteTextures((int)layer.texId.length, (int[])layer.texId, (int)0);
            }
            layer.texId = new int[3];
            GLES20.glGenTextures((int)3, (int[])layer.texId, (int)0);
            this.checkGlError("glGenTextures");
            for (n2 = 0; n2 < 3; ++n2) {
                GLES20.glActiveTexture((int)(33984 + n2));
                GLES20.glBindTexture((int)3553, (int)layer.texId[n2]);
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
                GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
                if (n2 == 0) {
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)layer.texWidth, (int)layer.texHeight, (int)0, (int)6409, (int)5121, null);
                    continue;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(layer.texWidth / 2), (int)(layer.texHeight / 2), (int)0, (int)6409, (int)5121, null);
            }
        }
        if (bl) {
            n2 = layer.bufWidth * layer.bufHeight * 3 / 2;
            if (layer.texBuf == null || layer.texBuf.capacity() < n2) {
                try {
                    layer.texBuf = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
                }
                catch (Throwable throwable) {
                    ZmfVideo.logError("Failed to allocateDirect()");
                    return;
                }
            }
            if (0 != ZmfVideo.convertFromI420(layer.texBuf, 1, layer.yuvBuf, layer.bufWidth, layer.bufHeight)) {
                ZmfVideo.logError("convert failed");
                return;
            }
            for (n = 0; n < 3; ++n) {
                GLES20.glActiveTexture((int)(33984 + n));
                GLES20.glBindTexture((int)3553, (int)layer.texId[n]);
                if (n == 0) {
                    GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)layer.width, (int)layer.height, (int)6409, (int)5121, (Buffer)layer.texBuf.position(0));
                    continue;
                }
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)(layer.width / 2), (int)(layer.height / 2), (int)6409, (int)5121, (Buffer)layer.texBuf.position(layer.width * layer.height * (3 + n) / 4));
            }
            this.checkGlError("glTexSubImage2D");
        }
        if (layer.effect_param == null && !this.setupEffectFxList(layer, 0, null, null)) {
            ZmfVideo.logError("none effect fatel error, can't restore");
            layer.effectType = -1;
            return;
        }
        EffectParam effectParam = layer.effect_param;
        for (n = 0; n < effectParam.effect.length; ++n) {
            effectParam.effect[n].prepare(layer);
        }
    }

    private void prepareFramebuffer(int n) {
        if (this._fboEffect[n] == 0) {
            GLES20.glGenFramebuffers((int)1, (int[])this._fboEffect, (int)n);
        }
        if (this._texEffect[n] == 0) {
            GLES20.glGenTextures((int)1, (int[])this._texEffect, (int)n);
            GLES20.glBindFramebuffer((int)36160, (int)this._fboEffect[n]);
            GLES20.glBindTexture((int)3553, (int)this._texEffect[n]);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this._viewWidth, (int)this._viewHeight, (int)0, (int)6408, (int)5121, null);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this._texEffect[n], (int)0);
            if (GLES20.glCheckFramebufferStatus((int)36160) != 36053) {
                ZmfVideo.logError("failed to make complete framebuffer object");
            }
        } else {
            GLES20.glBindFramebuffer((int)36160, (int)this._fboEffect[n]);
        }
    }

    @Override
    protected void onLayerDraw(GLView.Layer layer) {
        EffectParam effectParam = layer.effect_param;
        if (layer.effectType < 0 || effectParam == null) {
            return;
        }
        int n = 0;
        if (effectParam.effect.length > 1) {
            this.prepareFramebuffer(n);
        } else {
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
        int n2 = 0;
        while (!effectParam.effect[n2].bind(0, 0, this._transform, layer)) {
            if (layer.effectType == 0) {
                ZmfVideo.logError("none effect fatel error, can't restore");
                layer.effectType = -1;
                return;
            }
            this.setupEffectFxList(layer, 0, null, null);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.checkGlError("glDrawArrays");
        effectParam.effect[n2].unbind();
        ++n2;
        while (n2 < effectParam.effect.length) {
            EffectFx effectFx = effectParam.effect[n2];
            int n3 = 0;
            while (effectFx.bind(n3, this._texEffect[n], this._transform, layer)) {
                if (++n3 == effectFx.iterate()) {
                    ++n2;
                }
                if (n2 == effectParam.effect.length) {
                    GLES20.glBindFramebuffer((int)36160, (int)0);
                } else {
                    ++n;
                    this.prepareFramebuffer(n %= 2);
                }
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                this.checkGlError("glDrawArrays");
                effectFx.unbind();
            }
            if (n3 == 0) {
                this.setupEffectFxList(layer, 0, null, null);
                break;
            }
            if (n3 <= 1) continue;
            this.requestRender();
        }
    }

    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this._viewWidth = n;
        this._viewHeight = n2;
        for (int i = 0; i < this._texEffect.length; ++i) {
            if (this._texEffect[i] == 0) continue;
            GLES10.glDeleteTextures((int)1, (int[])this._texEffect, (int)i);
            this._texEffect[i] = 0;
            this.checkGlError("glDeleteTextures");
        }
        this.allocateGL();
    }

    @Override
    protected void releaseGL() {
        int n;
        for (n = 0; n < this._texEffect.length; ++n) {
            if (this._texEffect[n] == 0) continue;
            GLES10.glDeleteTextures((int)1, (int[])this._texEffect, (int)n);
            this._texEffect[n] = 0;
            this.checkGlError("glDeleteTextures");
        }
        for (n = 0; n < this._fboEffect.length; ++n) {
            if (this._fboEffect[n] == 0) continue;
            GLES20.glDeleteFramebuffers((int)1, (int[])this._fboEffect, (int)n);
            this._fboEffect[n] = 0;
            this.checkGlError("glDeleteFramebuffers");
        }
        for (n = 0; n < this._effects.length; ++n) {
            if (this._effects[n] == null) continue;
            this._effects[n].release();
        }
        super.releaseGL();
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.releaseGL();
        this._surfaceCreated = true;
    }
}

