package com.juphoon.cloud;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import com.justalk.cloud.avatar.ZpandTimer;
import com.justalk.cloud.lemon.MtcBuddy;
import com.justalk.cloud.lemon.MtcCall;
import com.justalk.cloud.lemon.MtcCallConstants;
import com.justalk.cloud.lemon.MtcCallDb;
import com.justalk.cloud.lemon.MtcCallExt;
import com.justalk.cloud.lemon.MtcCli;
import com.justalk.cloud.lemon.MtcCliCfg;
import com.justalk.cloud.lemon.MtcCliCfgConstants;
import com.justalk.cloud.lemon.MtcCliConstants;
import com.justalk.cloud.lemon.MtcCliDb;
import com.justalk.cloud.lemon.MtcConf;
import com.justalk.cloud.lemon.MtcConfConstants;
import com.justalk.cloud.lemon.MtcConstants;
import com.justalk.cloud.lemon.MtcFs;
import com.justalk.cloud.lemon.MtcFs2;
import com.justalk.cloud.lemon.MtcGroup;
import com.justalk.cloud.lemon.MtcGroupConstants;
import com.justalk.cloud.lemon.MtcIm;
import com.justalk.cloud.lemon.MtcImConstants;
import com.justalk.cloud.lemon.MtcImDb;
import com.justalk.cloud.lemon.MtcMedia;
import com.justalk.cloud.lemon.MtcMediaConstants;
import com.justalk.cloud.lemon.MtcProf;
import com.justalk.cloud.lemon.MtcSgw;
import com.justalk.cloud.lemon.MtcUe;
import com.justalk.cloud.lemon.MtcUeConstants;
import com.justalk.cloud.lemon.MtcUeDb;
import com.justalk.cloud.lemon.MtcUser;
import com.justalk.cloud.lemon.MtcUserConstants;
import com.justalk.cloud.lemon.MtcUtil;
import com.justalk.cloud.lemon.MtcVer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class MtcEngine implements MtcConstants, MtcCliConstants, MtcCallConstants, MtcConfConstants,
        MtcUserConstants, MtcImConstants, MtcUeConstants, MtcGroupConstants {

    interface MtcNotifyListener {
        /**
         * 回调通知
         *
         * @param notify 通知对象
         */
        void onNotify(JCNotify notify);
    }

    static final String TAG = MtcEngine.class.getSimpleName();
    static final String JCSDK = "JCSDK";
    protected boolean hasCalls = false;
    protected boolean hasMediaChannel = false;
    private boolean mForeground = true;
    private Set<MtcNotifyListener> mMtcNotifyListeners;
    private boolean mHasInit = false;
    private Context mContext;
    private JCParam.Login mLoginParam;
    private int mCookie = 0;
    private boolean mHasNet = true;
    private ScheduledExecutorService mScheduledExecutor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture mLoginScheduled;
    private ScheduledFuture mLogoutScheduled;

    private MtcEngine() {
    }
    private Set<MtcWrapOperation> mWrapOperations;

    static MtcEngine getInstance() {
        return MtcEngineHolder.INSTANCE;
    }

    /*********** sdk回调 *************/

    @SuppressWarnings("unused")
    private static int notified(String name, int cookie, String info) {
        getInstance().dealNotify(name, cookie, info);
        return 0;
    }

    int genCookie() {
        return ++mCookie;
    }

    JCResult initialize(JCParam.Init param) {
        mContext = param.context;
        if (isSupport()) {
            try {
                System.loadLibrary("zmf");
                System.loadLibrary("mtc");
            } catch (UnsatisfiedLinkError error) {
                JCLog.error(TAG, "链接错误");
                return new JCResult(false);
            }
        } else {
            JCLog.error(TAG, "不支持");
            return new JCResult(false);
        }

        if (TextUtils.isEmpty(param.sdkInfoDir)) {
            param.sdkInfoDir = JCUtils.getSdkInfoDir(mContext);
        }
        String applicationName = mContext.getPackageName();
        MtcCliCfg.Mtc_CliCfgSetLogLevel(MtcCliCfgConstants.EN_MTC_LOG_LEVEL_DEBUG);
        MtcCliCfg.Mtc_CliCfgSetAppVer(JCUtils.getAppVersion(mContext));
        String logDir = TextUtils.isEmpty(param.sdkLogDir) ? param.sdkInfoDir + "/log" : param.sdkLogDir;
        new File(logDir).mkdirs();
        MtcCliCfg.Mtc_CliCfgSetLogDir(logDir);
        MtcCliCfg.Mtc_CliCfgSetAppVer(JCUtils.getAppVersion(mContext));
        MtcCliCfg.Mtc_CliCfgSetContext(mContext);
        ZpandTimer.init(mContext, applicationName);
        String profilesDir = param.sdkInfoDir + "/profiles";
        new File(profilesDir).mkdirs();
        if (MtcCli.Mtc_CliInit(profilesDir, null) != ZOK) {
            JCLog.error(TAG, "初始化错误");
            return new JCResult(false);
        }
        String notifyClassName = MtcEngine.class.getName();
        notifyClassName = notifyClassName.replace('.', '/');
        MtcCli.Mtc_CliSetJavaNotify(notifyClassName, "notified");
        mHasInit = true;
        return new JCResult(true);
    }

    void uninitialize() {
        if (mHasInit) {
            MtcCli.Mtc_CliDestroy();
            mHasInit = !mHasInit;
        }
    }

    void netChange(JCParam.Net param) {
        if (param.type == JCParam.Net.CHANGE) {
            MtcCli.Mtc_CliNetworkChanged(param.newNetType);
            mHasNet = param.newNetType != MTC_ANET_UNAVAILABLE;
            if (MtcCli.Mtc_CliGetState() == MtcCliConstants.EN_MTC_CLI_STATE_LOGINED) {
                // 登陆状态由 SDK 控制
//                if (!mHasNet) {
//                    dealNotify(MtcCliReconnectingNotification, 0, null);
//                } else {
//                    dealNotify(MtcCliReconnectOkNotification, 0, null);
//                }
            }
            dealActive();
        }
    }

    void setForeground(boolean foreground) {
        mForeground = foreground;
        dealActive();
    }

    String getDeviceId() {
        return MtcCli.Mtc_CliGetDevId();
    }

    JCResult login(JCParam.Login param) {
        mLoginParam = param;

        MtcCli.Mtc_CliOpen(param.username);
        MtcUeDb.Mtc_UeDbSetUserName(param.username);
        MtcUeDb.Mtc_UeDbSetNetwork(param.server);
        MtcUeDb.Mtc_UeDbSetAppKey(param.appkey);
        MtcUeDb.Mtc_UeDbSetPassword(param.password);
        MtcUeDb.Mtc_UeDbSetIdType(MtcUserConstants.EN_MTC_USER_ID_USERNAME);
        MtcImDb.Mtc_ImDbSetAutoRecv(true);
        MtcCliDb.Mtc_CliDbApplyAll();
        MtcProf.Mtc_ProfSaveProvision();
        MtcCli.Mtc_CliStart();
        MtcImDb.Mtc_ImDbSetAutoRecv(true);

        MtcCli.Mtc_CliSetDevInfo(MTC_INFO_TERMINAL_VERSION_KEY, Build.VERSION.RELEASE);
        MtcCli.Mtc_CliSetDevInfo(MTC_INFO_TERMINAL_MODEL_KEY, Build.MODEL);
        MtcCli.Mtc_CliSetDevInfo(MTC_INFO_TERMINAL_VENDOR_KEY, Build.MANUFACTURER);
        MtcCli.Mtc_CliSetDevInfo(MTC_INFO_SOFTWARE_VERSION_KEY, MtcVer.Mtc_GetLemonVersion());
        MtcCli.Mtc_CliSetDevInfo(MTC_INFO_TERMINAL_LANGUAGE_KEY, Locale.getDefault().toString());

        MtcCallDb.Mtc_CallDbSetTtoRecv(false);
        MtcCallDb.Mtc_CallDbSetTtoSend(false);

        if (ZOK == MtcCli.Mtc_CliLogin(MTC_LOGIN_OPTION_PREEMPTIVE, null)) {
            startLoginTimer(param.timeout);
            return new JCResult(true);
        } else {
            return new JCResult(false);
        }
    }

    JCResult logout(JCParam.Logout param) {
        stopLoginTimer();
        if (MtcCli.Mtc_CliLogout() != ZOK) {
            forceLogout();
        } else {
            startLogoutTimer(param.timeout);
        }
        return new JCResult(true);

    }

    /*********** account *************/

    JCResult queryUserStatus(JCParam.queryUserStatus param) {
        ++mCookie;
        JSONArray jsonArray = new JSONArray();
        for (String userId : param.userIdList) {
            if (!TextUtils.isEmpty(userId)) {
                String userUri = MtcUser.Mtc_UserFormUri(EN_MTC_USER_ID_USERNAME, userId);
                if (MtcUser.Mtc_UserIsValidUri(userUri)) {
                    jsonArray.put(userUri.toLowerCase());
                } else {
                    JCLog.error(TAG, "invalid user id:" + userId);
                }
            }
        }
        int ret = MtcBuddy.Mtc_BuddyQueryUsersStatus(mCookie, jsonArray.toString(), null);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    /*********** push *************/

    JCResult addPushInfo(JCParam.Push param) {
        int ret = MtcCli.Mtc_CliSetPushParm(param.data);
        return new JCResult(ret == ZOK);
    }

    /*********** message *************/

    JCResult sendMessage(JCParam.Message param) {
        String userUri;
        if (!TextUtils.isEmpty(param.groupId)) {
            userUri = param.groupId;
        } else {
            userUri = MtcUser.Mtc_UserFormUri(EN_MTC_USER_ID_USERNAME, param.userId);
        }

        int ret = ZFAILED;
        try {
            JSONObject object = new JSONObject();
            object.put(MtcImDisplayNameKey, param.displayName);
            object.put(MtcImUserDataKey, param.messageInfo);
            ret = MtcIm.Mtc_ImSendInfo(++mCookie, userUri, param.messageType, param.messageContent, object.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult fetchMessage(JCParam.MessageFetch param) {
        int ret = MtcIm.Mtc_ImRefresh(++mCookie, null, 0);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    /*********** file *************/

    JCResult dealFile(JCParam.FileDeal param) {
        int ret = ZFALSE;
        if (param.type == JCParam.FileDeal.UPLOAD) {
            ret = MtcFs2.Mtc_Fs2Upload(++mCookie, MtcUe.Mtc_UeGetUid(), param.path, param.expireTime);
            return new JCResult(ret != ZINVALIDID, mCookie, ret);
        } else if (param.type == JCParam.FileDeal.DOWNLOAD) {
            ret = MtcFs2.Mtc_Fs2Download(++mCookie, param.uri, param.path, 0);
            return new JCResult(ret != ZINVALIDID, mCookie, ret);
        } else if (param.type == JCParam.FileDeal.CANCEL) {
            ret = MtcFs.Mtc_FsCancel(param.sessId);
        }
        return new JCResult(ret == ZOK);
    }

    /*********** call *************/

    JCResult call(JCParam.Call param) {
        try {
            JSONObject object = new JSONObject();
            object.put(MtcCallConstants.MtcCallInfoHasVideoKey, param.video);
            object.put(MtcCallConstants.MtcCallInfoDisplayNameKey, param.displayName);
            object.put(MtcCallConstants.MtcCallInfoUserDataKey, param.extraParam);
            String userUri = MtcUser.Mtc_UserFormUri(MtcUserConstants.EN_MTC_USER_ID_USERNAME, param.userId);
            int callId = MtcCall.Mtc_CallJ(userUri, 0, object.toString());
            if (callId != ZMAXUINT) {
                return new JCResult(true, callId, MtcCall.Mtc_CallGetName(callId));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(false);
    }

    JCResult term(JCParam.Term param) {
        if (MtcCall.Mtc_CallTerm((int) param.callId, (int) param.reason, param.desc) == ZOK) {
            return new JCResult(true);
        }
        return new JCResult(false);
    }

    JCResult answer(JCParam.Answer param) {
        if (MtcCall.Mtc_CallAnswer((int) param.callId, 0, true, param.video) == ZOK) {
            return new JCResult(true);
        }
        return new JCResult(false);
    }

    JCResult callMedia(JCParam.CallMedia param) {
        int ret = ZFAILED;
        if (param.type == JCParam.CallMedia.ATTACH_CAMERA) {
            if (param.enable) {
                ret = MtcCall.Mtc_CallCameraAttach((int) param.callId, param.optionalValue);
            } else {
                ret = MtcCall.Mtc_CallCameraDetach((int) param.callId);
            }
        } else if (param.type == JCParam.CallMedia.MUTE) {
            ret = MtcCall.Mtc_CallSetMicMute((int) param.callId, param.enable);
        } else if (param.type == JCParam.CallMedia.MIX) {
            ret = MtcCall.Mtc_CallSetMixVoice((int) param.callId, param.enable);
        } else if (param.type == JCParam.CallMedia.SPEAKER_MUTE) {
            ret = MtcCall.Mtc_CallSetSpkMute((int) param.callId, param.enable);
        } else if (param.type == JCParam.CallMedia.UPLOAD_VIDEO_STREAM) {
            ret = MtcCall.Mtc_CallVideoSetSend((int) param.callId, param.enable ?
                    MtcCallConstants.EN_MTC_CALL_TRANSMISSION_NORMAL : MtcCallConstants.EN_MTC_CALL_TRANSMISSION_CAMOFF);
        } else if (param.type == JCParam.CallMedia.AUDIO_RECORD) {
            ret = param.enable ? MtcCall.Mtc_CallRecCallStart((int) param.callId, param.optionalValue, (short) MtcMedia.EN_MTC_MFILE_WAV) : MtcCall.Mtc_CallRecCallStop((int) param.callId);
        } else if (param.type == JCParam.CallMedia.VIDEO_RECORD) {
            try {
                JSONObject videoJsonParam = new JSONObject();
                videoJsonParam.put(MtcMediaConstants.MtcMediaFileTypeKey, MtcMediaConstants.EN_MTC_MFILE_MP4_H264);
                videoJsonParam.put(MtcMediaConstants.MtcMediaVideoRecordOptionKey, MtcMediaConstants.EN_MTC_VIDEO_RECORD_MATCH_VIDEO);
                videoJsonParam.put(MtcMediaConstants.MtcMediaVideoQualityKey, MtcMediaConstants.EN_MTC_VIDEO_QUALITY_HIGH);
                videoJsonParam.put(MtcMediaConstants.MtcMediaVideoFillModeKey, MtcMediaConstants.EN_MTC_VIDEO_FILL_MODE_AUTO);
                videoJsonParam.put(MtcMediaConstants.MtcMediaVideoFrameRateKey, 30);
                if (param.remote) {
                    ret = param.enable ? MtcCall.Mtc_CallRecRecvVideoStart((int) param.callId, param.optionalValue, param.videoRecordWidth, param.videoRecordHeight, videoJsonParam.toString()) : MtcCall.Mtc_CallRecRecvVideoStop((int) param.callId);
                } else {
                    ret = param.enable ? MtcCall.Mtc_CallRecSendVideoStart((int) param.callId, param.optionalValue, param.videoRecordWidth, param.videoRecordHeight, videoJsonParam.toString()) : MtcCall.Mtc_CallRecSendVideoStop((int) param.callId);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JCResult(ret == ZOK);
    }

    JCResult callStreamData(JCParam.CallMessage param) {
        int ret = MtcCall.Mtc_CallSendStreamData((int) param.callId, true, param.messageType, param.content);
        return new JCResult(ret == ZOK);
    }

    JCResult callMessage(JCParam.CallMessage param) {
        int ret = MtcCall.Mtc_CallInfo((int) param.callId, param.content);
        return new JCResult(ret == ZOK);
    }

    JCResult fetchCalls(JCParam.CallFetch param) {
        int ret = MtcCallExt.Mtc_CallQueryMissed();
        return new JCResult(ret == ZOK);
    }

    JCResult callStatistics(JCParam.CallStatistics param) {
        try {
            JSONObject object = new JSONObject();
            String content = MtcCall.Mtc_CallGetAudioStat((int)param.callId);
            if (TextUtils.isEmpty(content)) {
                content = "";
            }
            object.put("Audio", content);
            content = MtcCall.Mtc_CallGetVideoStat((int)param.callId);
            if(TextUtils.isEmpty(content)) {
                content = "";
            }
            object.put("Video", content);
            content = MtcCall.Mtc_CallGetMptStat((int)param.callId);
            if(TextUtils.isEmpty(content)) {
                content = "";
            }
            object.put("Mtp", content);
            return new JCResult(true, object.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new JCResult(true, "");
    }

    /*********** group *************/

    JCResult fetchGroup(JCParam.GroupFetch parms) {
        int ret = MtcGroup.Mtc_GroupRefresh(++mCookie, parms.groupId, parms.updateTime);
        if (!TextUtils.isEmpty(parms.groupId) && ret == ZOK) {
            MtcWrapOperation wrapOperation = new MtcWrapOperation();
            wrapOperation.groupFetchParms = parms;
            wrapOperation.cookie = mCookie;
            wrapOperation.type = MtcWrapOperation.OPERATION_TYPE_GROUP_INFO;
            addWrapOperation(wrapOperation);
        }
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult createGroup(JCParam.GroupCreate parms) {
        int ret = ZFAILED;
        ++mCookie;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MtcGroupPropControlKey, EN_MTC_GROUP_PROPERTY_CONTROL_MEMBER);
            JSONArray jsonArray = new JSONArray();
            for (JCParam.GroupCreateMember groupCreateMember : parms.members) {
                JSONObject memberJson = new JSONObject();
                memberJson.put(MtcGroupUserUriKey, userIdToUserUri(groupCreateMember.userId));
                memberJson.put(MtcGroupRelationTypeKey, groupCreateMember.memberType);
                memberJson.put(MtcGroupDisplayNameKey, groupCreateMember.displayName);
                memberJson.put(MtcGroupTagKey, groupCreateMember.tag);
                jsonArray.put(memberJson);
            }
            ret = MtcGroup.Mtc_GroupCreate(mCookie, EN_MTC_GROUP_DISCUSSION, parms.groupName,
                    jsonObject.toString(), jsonArray.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(true);
    }

    JCResult updateGroup(JCParam.GroupUpdate parms) {
        int ret = ZFAILED;
        ++mCookie;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(MtcGroupPropNameKey, parms.groupName);
            jsonObject.put(MtcGroupPropControlKey, EN_MTC_GROUP_PROPERTY_CONTROL_MEMBER);
            ret = MtcGroup.Mtc_GroupSetProperties(mCookie, parms.groupId, jsonObject.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult dissolveGroup(JCParam.GroupDissolve parms) {
        int ret = MtcGroup.Mtc_GroupRemove(++mCookie, parms.groupId);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult leaveGroup(JCParam.GroupLeave parms) {
        String uri = userIdToUserUri(parms.userId);
        int ret = MtcGroup.Mtc_GroupRemoveRelation(++mCookie, parms.groupId, uri);
        if (ret == ZOK) {
        }
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult updateSelf(JCParam.GroupUpdateSelf parms) {
        String uri = userIdToUserUri(parms.userId);
        int ret = MtcGroup.Mtc_GroupUpdateRelation(++mCookie, parms.groupId, parms.memberType, uri,
                parms.displayName, parms.tag);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult dealGroupMembers(JCParam.GroupDealMembers parms) {
        int ret = ZFAILED;
        ++mCookie;
        try {
            JSONArray addArray = new JSONArray();
            JSONArray updateArray = new JSONArray();
            JSONArray removeArray = new JSONArray();
            for (JCParam.GroupDealMember dealMember : parms.dealMembers) {
                if (dealMember.dealType == JCParam.GroupDealMember.DEAL_MEMBER_REMOVE) {
                    removeArray.put(userIdToUserUri(dealMember.userId));
                } else {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put(MtcGroupUserUriKey, userIdToUserUri(dealMember.userId));
                    jsonObject.put(MtcGroupRelationTypeKey, dealMember.memberType);
                    jsonObject.put(MtcGroupDisplayNameKey, dealMember.displayName);
                    jsonObject.put(MtcGroupTagKey, dealMember.tag);
                    if (dealMember.dealType == JCParam.GroupDealMember.DEAL_MEMBER_ADD) {
                        addArray.put(jsonObject);
                    } else {
                        updateArray.put(jsonObject);
                    }
                }
            }
            JSONObject result = new JSONObject();
            result.put(MtcGroupListToAddKey, addArray);
            result.put(MtcGroupListToRemoveKey, removeArray);
            result.put(MtcGroupListToUpdateKey, updateArray);
            ret = MtcGroup.Mtc_GroupSetRelations(mCookie, parms.groupId, result.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    /*********** log *************/

    JCResult log(JCParam.Log param) {
        if (param.type == JCParam.Log.INFO) {
            if (mHasInit) {
                MtcUtil.Mtc_AnyLogInfoStr(JCSDK, param.log);
            } else {
                Log.i(JCSDK, param.log);
            }
        } else if (param.type == JCParam.Log.ERROR) {
            if (mHasInit) {
                MtcUtil.Mtc_AnyLogErrStr(JCSDK, param.log);
            } else {
                Log.e(JCSDK, param.log);
            }
        }
        return new JCResult(true);
    }

    /*********** conf *************/

    JCResult queryConf(JCParam.ConfQuery param) {
        int ret = MtcConf.Mtc_ConfQueryRoom(0, param.channelId, ++mCookie);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    JCResult joinConf(JCParam.ConfJoin param) {
        int state = 0;
        state += MTC_CONF_STATE_FWD_AUDIO;
        state += MTC_CONF_STATE_FWD_VIDEO;
        if (param.localAudio) {
            state += MTC_CONF_STATE_AUDIO;
        }
        if (param.localVideo) {
            state += MTC_CONF_STATE_VIDEO;
        }

        try {
            JSONObject object = new JSONObject();
            object.put(MtcConfStateKey, state);
            object.put(MtcConfCapacityKey, param.capacity);
            if (!TextUtils.isEmpty(param.webCastingUri)) {
                object.put(MtcConfWebCastingUriKey, param.webCastingUri);
            }
            if (!TextUtils.isEmpty(param.password)) {
                object.put(MtcConfPasswordKey, param.password);
            }
            object.put(MtcConfQualityGradeKey, param.maxResolution);
            if (param.smoothMode) {
                object.put(MtcConfSmoothModeKey, true);
            }
            int confId = MtcConf.Mtc_ConfJoinRoom(param.regionId, param.channelId, ++mCookie, param.displayName, true, object.toString());
            if (confId != ZMAXUINT) {
                return new JCResult(true, confId);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return new JCResult(false);
    }

    JCResult leaveConf(JCParam.ConfLeave param) {
        int ret = ZFAILED;
        if (param.type == JCParam.ConfLeave.LEAVE) {
            ret = MtcConf.Mtc_ConfLeave((int)param.confId);
        } else if (param.type == JCParam.ConfLeave.TERMINATE) {
            ret = MtcConf.Mtc_ConfCancelReservation(0, param.confId);
        }
        return new JCResult(ret == ZOK);
    }

    JCResult sendConfMessage(JCParam.ConfMessage param)
    {
        int ret = ZFAILED;
        if(TextUtils.isEmpty(param.toUserID)) {
            if (param.content.length() > 4096) {
                ret = MtcConf.Mtc_ConfSendBypassData(param.confId, param.type, param.content);
            } else {
                if (param.type.contains("\"text\"")) { // 兼容WebRtc
                    ret = MtcConf.Mtc_ConfSendText(param.confId, null, param.content);
                } else {
                    ret = MtcConf.Mtc_ConfSendData(param.confId, null, param.type, param.content);
                }
            }
        } else {
            String uri = MtcUser.Mtc_UserFormUri(EN_MTC_USER_ID_USERNAME, param.toUserID);
            if (param.type.contains("\"text\"")) { // 兼容WebRtc
                ret = MtcConf.Mtc_ConfSendText(param.confId, uri, param.content);
            } else {
                ret = MtcConf.Mtc_ConfSendData(param.confId, uri, param.type, param.content);
            }
        }
        return new JCResult(ret == ZOK);

    }

    JCResult confSendCmd(JCParam.ConfCommand param)
    {
        int ret = ZFAILED;
        ret = MtcConf.Mtc_ConfCommand(param.confId, "MtcConfCmd" + param.name, param.param);
        return new JCResult(ret == ZOK);
    }

    JCResult confMedia(JCParam.ConfMedia param) {
        int ret = ZFALSE;
        if (param.type == JCParam.ConfMedia.LOCAL_ALL) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfStartSend(param.confId, MTC_CONF_MEDIA_ALL);
            } else {
                ret = MtcConf.Mtc_ConfStopSend(param.confId, MTC_CONF_MEDIA_ALL);
            }
        } else if (param.type == JCParam.ConfMedia.LOCAL_AUDIO) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfStartSend(param.confId, MTC_CONF_MEDIA_AUDIO);
            } else {
                ret = MtcConf.Mtc_ConfStopSend(param.confId, MTC_CONF_MEDIA_AUDIO);
            }
        } else if (param.type == JCParam.ConfMedia.LOCAL_VIDEO) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfStartSend(param.confId, MTC_CONF_MEDIA_VIDEO);
            } else {
                ret = MtcConf.Mtc_ConfStopSend(param.confId, MTC_CONF_MEDIA_VIDEO);
            }
        } else if (param.type == JCParam.ConfMedia.LOCAL_AUDIO_OUT) {
            ret = MtcConf.Mtc_ConfSubscribeAudio(param.confId, param.on);
        } else if (param.type == JCParam.ConfMedia.REQUEST_VIDEO) {
            try {
                JSONObject object = new JSONObject();
                object.put(MtcConfUserUriKey, param.uri);
                object.put(MtcConfPictureSizeKey, param.pictureSize);
                object.put(MtcConfFrameRateKey, param.frameRate);
                ret = MtcConf.Mtc_ConfCommand(param.confId, MtcConfCmdRequestVideo, object.toString());
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (param.type == JCParam.ConfMedia.BIND_CAMERA) {
            ret = MtcConf.Mtc_ConfSetVideoCapture(param.confId, param.camera);
        } else if (param.type == JCParam.ConfMedia.CDN) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfStartCdn(param.confId);
            } else {
                ret = MtcConf.Mtc_ConfStopCdn(param.confId);
            }
        } else if (param.type == JCParam.ConfMedia.RECORD) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfCommand(param.confId, MtcConfCmdReplayStartRecord, param.recordParam);
            } else {
                ret = MtcConf.Mtc_ConfCommand(param.confId, MtcConfCmdReplayStopRecord, param.recordParam);
            }
        } else if (param.type == JCParam.ConfMedia.SCREEN_SHARE) {
            if (param.on) {
                ret = MtcConf.Mtc_ConfSetScreenCapture(param.confId, param.camera);
                if (ret == ZOK) {
                    ret = MtcConf.Mtc_ConfSetScreenUser(param.confId, MtcUe.Mtc_UeGetUri());
                }
            } else {
                ret = MtcConf.Mtc_ConfSetScreenUser(param.confId, null);
            }
        }
        return new JCResult(ret == ZOK);
    }

    JCResult confStatistics(JCParam.ConfStatistics param) {
        try {
            JSONObject object = new JSONObject();
            String temp = MtcConf.Mtc_ConfGetStatistics(param.confId, MTC_CONF_STS_CONFIG, null);
            if (TextUtils.isEmpty(temp)) {
                temp = "";
            }
            object.put("Config", temp);
            temp = MtcConf.Mtc_ConfGetStatistics(param.confId, MTC_CONF_STS_NETWORK, null);
            if (TextUtils.isEmpty(temp)) {
                temp = "";
            }
            object.put("Network", temp);
            temp = MtcConf.Mtc_ConfGetStatistics(param.confId, MTC_CONF_STS_TRANSPORT, null);
            if (TextUtils.isEmpty(temp)) {
                temp = "";
            }
            object.put("Transport", temp);
            JSONArray array = new JSONArray();
            for (String userId : param.parts) {
                temp = MtcConf.Mtc_ConfGetStatistics(param.confId, MTC_CONF_STS_PARTICIPANT, MtcUser.Mtc_UserFormUri(EN_MTC_USER_ID_USERNAME, userId));
                if (!TextUtils.isEmpty(temp)) {
                    JSONObject part = new JSONObject();
                    part.put(userId, temp);
                    array.put(part);
                }
            }
            object.put("Participants", array);
            return new JCResult(true, object.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return new JCResult(true, "");
    }

    JCResult confUpdateCustomProperty(JCParam.ConfCustomProperty param) {
        JSONObject obj = new JSONObject();
        Set<Map.Entry<String, String>> set = param.mapCustomProperty.entrySet();
        for (Map.Entry<String, String> m : set) {
            try {
                obj.put(m.getKey(), m.getValue());
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        int ret = MtcConf.Mtc_ConfSetProp(param.confId, MtcConfPropUserDefined, obj.toString());
        return new JCResult(ret == ZOK, 0, 0);
    }

    JCResult confInviteSipUser(JCParam.ConfInviteSipUser param) {
        int ret = MtcSgw.Mtc_SgwDeliSipInvite(++mCookie, String.valueOf(param.channelNumber),
                param.password, param.userId,
                TextUtils.isEmpty(param.callerNum) ? null : param.callerNum,
                TextUtils.isEmpty(param.coreNetId) ? null : param.coreNetId);
        return new JCResult(ret == ZOK, mCookie, 0);
    }

    /*********** protected *************/

    void addMtcNotifyListener(MtcNotifyListener listener) {
        if (mMtcNotifyListeners == null) {
            mMtcNotifyListeners = new HashSet<>();
        }
        mMtcNotifyListeners.add(listener);
    }

    void removeMtcNotifyListener(MtcNotifyListener listener) {
        if (mMtcNotifyListeners != null) {
            mMtcNotifyListeners.remove(listener);
        }
    }

    /*********** private *************/

    private boolean isSupport() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            return TextUtils.equals(Build.CPU_ABI, "armeabi-v7a") || TextUtils.equals(Build.CPU_ABI2, "armeabi-v7a") || TextUtils.equals(Build.CPU_ABI, "x86") || TextUtils.equals(Build.CPU_ABI2, "x86");
        } else {
            for (String abi : Build.SUPPORTED_ABIS) {
                if (TextUtils.equals(abi, "armeabi-v7a") || TextUtils.equals(abi, "x86")) {
                    return true;
                }
            }
        }
        return false;
    }

    private void forceLogout() {
        MtcCli.Mtc_CliStop();
        MtcCli.Mtc_CliClose();

        JSONObject object = new JSONObject();
        try {
            object.put(MtcCliStatusCodeKey, MTC_CLI_ERR_NO);
            notified(MtcCliServerDidLogoutNotification, 0, object.toString());
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void dealActive() {
        if (MtcCli.Mtc_CliGetState() <= EN_MTC_CLI_STATE_IDLE) {
            JCLog.info(TAG, "dealActive not logined %d", MtcCli.Mtc_CliGetState());
            return;
        }
        if (mForeground && mHasNet) {
            JCLog.info(TAG, "活跃");
            MtcCli.Mtc_CliWakeup(true);
            MtcCli.Mtc_CliRefresh();
            if (MtcCli.Mtc_CliGetState() == EN_MTC_CLI_STATE_LOGINED) {
                MtcIm.Mtc_ImRefresh(0, null, 0);
                MtcCallExt.Mtc_CallQueryMissed();
            }
        } else {
            if (!hasCalls && !hasMediaChannel) {
                JCLog.info(TAG, "非活跃");
                MtcCli.Mtc_CliWakeup(false);
            } else {
                JCLog.info(TAG, "不处理活跃");
            }
        }
    }

    private void startLoginTimer(int interval) {
        stopLoginTimer();
        mLoginScheduled = mScheduledExecutor.schedule(new Runnable() {
            @Override
            public void run() {
                JCClientThreadImpl.getInstance().post(new Runnable() {
                    @Override
                    public void run() {
                        JCLog.error(TAG, "登陆超时");
                        MtcCli.Mtc_CliStop();
                        MtcCli.Mtc_CliClose();
                        mLoginScheduled = null;
                        notified(MtcCliServerLoginDidFailNotification, 0,
                                String.format(Locale.getDefault(), "{\"%s\":%d}", MtcCliStatusCodeKey, MTC_CLI_REG_ERR_TIMEOUT));
                    }
                });
            }
        }, interval, TimeUnit.SECONDS);
    }

    private void stopLoginTimer() {
        if (mLoginScheduled != null) {
            mLoginScheduled.cancel(true);
            mLoginScheduled = null;
        }
    }

    private void startLogoutTimer(int interval) {
        stopLogoutTimer();
        mLogoutScheduled = mScheduledExecutor.schedule(new Runnable() {
            @Override
            public void run() {
                JCClientThreadImpl.getInstance().post(new Runnable() {
                    @Override
                    public void run() {
                        JCLog.error(TAG, "登出超时");
                        forceLogout();
                        mLogoutScheduled = null;
                    }
                });
            }
        }, interval, TimeUnit.SECONDS);
    }

    private void stopLogoutTimer() {
        if (mLogoutScheduled != null) {
            mLogoutScheduled.cancel(true);
            mLogoutScheduled = null;
        }
    }

    private void dealNotify(String name, int mCookie, String info) {
        if (mMtcNotifyListeners != null) {
            // MtcConfVolumeChangedNotification通知太频繁
            if (!TextUtils.equals(name, MtcConfVolumeChangedNotification)) {
                JCLog.info("MtcEngine", "name=%s mCookie:%d info=%s", name, mCookie, info == null ? "" : info);
            }
            MtcWrapOperation wrapOperation = dealWrapOperation(name, mCookie, info);
            JCNotify notify = null;
            if (wrapOperation != null) {
                if (wrapOperation.finish) {
                    notify = wrapOperation.notify;
                    removeWrapOperation(wrapOperation);
                }
            } else {
                notify = JCNotify.create(name, mCookie, info);
                // 内部对一些回调的处理
                if (TextUtils.equals(name, MtcCliServerLoginOkNotification)) {
                    stopLoginTimer();
                } else if (TextUtils.equals(name, MtcCliServerLoginDidFailNotification)) {
                    if (notify.cliNotify.loginFail.statusCode == MTC_CLI_REG_ERR_INVALID_USER) {
                        if (mLoginParam.autoCreate) {
                            JCLog.info(TAG, "自动创建账号");
                            if (MtcUe.Mtc_UeCreate(0, mLoginParam.username, mLoginParam.password) == ZOK) {
                                // 成功调用创建账号则不需要将通知回调到上层
                                return;
                            }
                        }
                    }
                    stopLoginTimer();
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals(name, MtcCliServerDidLogoutNotification)) {
                    stopLogoutTimer();
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals(name, MtcCliServerLogoutedNotification)) {
                    JCLog.info(TAG, "账号被强制登出");
                    MtcCli.Mtc_CliStop();
                } else if (TextUtils.equals(name, MtcUeCreateOkNotification)) {
                    JCLog.info(TAG, "账号创建成功");
                    MtcCli.Mtc_CliLogin(MTC_LOGIN_OPTION_PREEMPTIVE, "0.0.0.0");
                } else if (TextUtils.equals(name, MtcUeCreateDidFailNotification)) {
                    JCLog.info(TAG, "账号创建失败");
                    // 构造登陆失败通知
                    notify = JCNotify.create(MtcCliServerLoginDidFailNotification, mCookie,
                            String.format(Locale.getDefault(), "{\"%s\":%d}", MtcCliStatusCodeKey, MTC_CLI_REG_ERR_INVALID_USER));
                    stopLoginTimer();
                } else if (TextUtils.equals(name, MtcConfJoinOkNotification)
                        || TextUtils.equals(name, MtcConfJoinDidFailNotification)) {
                } else if (TextUtils.equals(name, MtcImInfoDidReceiveNotification)) {
                    // 告诉服务器收到消息，不用再发push
                    if (notify != null) {
                        final String label = notify.messageNotify.recvMessage.messageLabel;
                        final long id = notify.messageNotify.recvMessage.messageId;
                        JCClientThreadImpl.getInstance().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                MtcIm.Mtc_ImNotifyEnd(label, id);
                            }
                        }, 200);
                    }
                } else if (TextUtils.equals(name, MtcCallIncomingNotification)) {
                    if (hasCalls) {
                        MtcCall.Mtc_CallAlert((int) notify.callNotify.incoming.callId, 0, MtcCallConstants.EN_MTC_CALL_ALERT_QUEUED, false);
                    } else {
                        MtcCall.Mtc_CallAlert((int) notify.callNotify.incoming.callId, 0, MtcCallConstants.EN_MTC_CALL_ALERT_RING, false);
                    }
                }
            }

            if (notify != null) {
                for (MtcNotifyListener listener : getInstance().mMtcNotifyListeners) {
                    listener.onNotify(notify);
                }
            }
        }
    }

    private void addWrapOperation(MtcWrapOperation wrapOperation) {
        if (mWrapOperations == null) {
            mWrapOperations = new HashSet<>();
        }
        mWrapOperations.add(wrapOperation);
    }

    private void removeWrapOperation(MtcWrapOperation wrapOperation) {
        if (mWrapOperations != null) {
            mWrapOperations.remove(wrapOperation);
        }
    }

    private MtcWrapOperation dealWrapOperation(String name, int mCookie, String info) {
        if (mWrapOperations != null && !mWrapOperations.isEmpty()) {
            for (MtcWrapOperation operation : mWrapOperations) {
                if (operation.deal(mCookie, name, info)) {
                    return operation;
                }
            }
        }
        return null;
    }

    private String userIdToUserUri(String userId) {
        return MtcUser.Mtc_UserFormUriX(MTC_USER_ID_USERNAME, userId);
    }

    private static final class MtcEngineHolder {
        private static final MtcEngine INSTANCE = new MtcEngine();
    }
}
