package com.juphoon.cloud;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import android.view.SurfaceView;

import com.justalk.cloud.zmf.ZmfAudio;
import com.justalk.cloud.zmf.ZmfVideo;

import java.util.ArrayList;
import java.util.List;

/**
 * ZmfEngine
 */

class ZmfEngine {

    static ZmfEngine getInstance() {
        return ZmfEngineHolder.INSTANCE;
    }

    private Context context;

    public JCResult initialize(JCParam.Init param) {
        context = param.context;

        ZmfAudio.initialize(context);
        ZmfVideo.initialize(context);

        return new JCResult(true);
    }

    public void uninitialize() {
        ZmfAudio.terminate();
        ZmfVideo.terminate();
    }

    public SurfaceView createView() {
        return ZmfVideo.renderNew(context);
    }

    public List<String> getCameras() {
        List<String> cameras = new ArrayList<>();
        int count = ZmfVideo.cameraGetCount();
        String[] cameraInfo = new String[2];
        int[] cameraOrient = new int[4];
        for (int i = 0; i < count; i++) {
            ZmfVideo.cameraGetName(i, cameraInfo);
            String cameraId = cameraInfo[0];
            ZmfVideo.captureGetOrient(cameraId, cameraOrient);
            if (cameraOrient[0] == ZmfVideo.FACE_FRONT) {
                cameras.add(0, cameraId);
            } else {
                cameras.add(cameraId);
            }
        }
        return cameras;
    }

    public JCResult dealCamera(JCParam.CameraDeal param) {
        if (param.type == JCParam.CameraDeal.SWITCH) {
            ZmfVideo.captureStop(param.switchedCamera);
            ZmfVideo.captureStart(param.camera, param.width, param.height, param.framerate);
        } else if (param.type == JCParam.CameraDeal.START) {
            ZmfVideo.captureStart(param.camera, param.width, param.height, param.framerate);
        } else if (param.type == JCParam.CameraDeal.STOP) {
                ZmfVideo.captureStop(param.camera);
        }
        return new JCResult(true);
    }

    public JCResult dealAudio(final JCParam.AudioDeal param) {
        if (param.start) {
            new AsyncTask<Void, Void, Void>() {

                @Override
                protected Void doInBackground(Void... params) {
                    synchronized (ZmfEngine.this) {
                        String outputDevice = getAudioOutput();
                        int ret = 0;
                        if (param.watch) {
                            ret = ZmfAudio.outputStart(outputDevice, 8000, 0);
                            if (ret == 0) {
                                ret = ZmfAudio.inputStart(getAudioInput(), 8000, 0,
                                        param.os ? ZmfAudio.AEC_ON : ZmfAudio.AEC_OFF,
                                        ZmfAudio.AGC_OFF);
                            }
                        } else {
                            ret = ZmfAudio.outputStart(outputDevice, 16000, 0);
                            if (ret != 0) {
                                ret = ZmfAudio.outputStart(outputDevice, 44100, 0);
                            }

                            if (ret == 0) {
                                ret = ZmfAudio.inputStart(getAudioInput(), 16000, 0,
                                        param.os ? ZmfAudio.AEC_ON : ZmfAudio.AEC_OFF,
                                        ZmfAudio.AGC_OFF);
                                if (ret != 0) {
                                    ret = ZmfAudio.inputStart(getAudioInput(), 44100, 0,
                                            param.os ? ZmfAudio.AEC_ON : ZmfAudio.AEC_OFF,
                                            ZmfAudio.AGC_OFF);
                                }
                            }
                        }
                        if (ret != 0) {
                            ZmfAudio.inputStopAll();
                            ZmfAudio.outputStopAll();
                        }
                    }
                    return null;
                }
            }.execute();

        } else {
            new AsyncTask<Void, Void, Void>() {

                @Override
                protected Void doInBackground(Void... params) {
                    synchronized (ZmfEngine.this) {
                        ZmfAudio.inputStopAll();
                        ZmfAudio.outputStopAll();
                    }
                    return null;
                }
            }.execute();
        }
        return new JCResult(true);
    }

    public JCResult dealRender(JCParam.RenderDeal param) {
        if (param.type == JCParam.RenderDeal.START) {
            ZmfVideo.renderStart(param.view);
            ZmfVideo.renderAdd(param.view, param.videoSource, 0, param.renderType);
            ZmfVideo.renderRotate(param.view, param.autoRotate ? ZmfVideo.ROTATION_AUTO_SCREEN : ZmfVideo.ROTATION_FIXED_SCREEN);
        } else if (param.type == JCParam.RenderDeal.STOP) {
            ZmfVideo.renderStop(param.view);
            ZmfVideo.renderRemoveAll(param.view);
        } else if (param.type == JCParam.RenderDeal.REPLACE) {
            ZmfVideo.renderReplace(param.view, param.oldVideoSource, param.videoSource);
        } else if (param.type == JCParam.RenderDeal.ROTATE) {
            ZmfVideo.renderRotate(param.view, param.angle);
        }
        return new JCResult(true);
    }

    public JCResult videoSnapshot(JCParam.Snapshot param) {
        int result = ZmfVideo.renderSnapshot(param.videoSource, param.width, param.height, param.filePath);
        return new JCResult(result == 0);
    }

    private static final class ZmfEngineHolder {
        private static final ZmfEngine INSTANCE = new ZmfEngine();
    }

    private static String getAudioOutput() {
        return ZmfAudio.OUTPUT_VOICE_CALL;
    }

    private static String getAudioInput() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB) {
            return ZmfAudio.INPUT_MIC;
        }
        return ZmfAudio.INPUT_VOICE_COMMUNICATION;
    }

}
