package com.juphoon.cloud;

/**
 * 媒体频道成员
 *
 * @author juphoon
 */
public class JCMediaChannelParticipant {

    String userId;
    String renderId;
    String displayName;
    @JCMediaChannel.VolumeStatus
    int volumeStatus;
    boolean audio;
    boolean video;
    boolean talking;
    @JCMediaChannel.PictureSize
    int pictureSize;
    long lastUpdateTime;
    @JCMediaChannel.ParticipantType
    int type;

    JCMediaChannelParticipant() {
        volumeStatus = JCMediaChannel.VOLUME_STATUS_NONE;
        lastUpdateTime = 0;
    }

    /**
     * 获得用户标识
     *
     * @return 用户标识
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 获得渲染标识，用于 JCMediaDevice 中 startVideo 渲染视频使用
     *
     * @return 渲染标识
     */
    public String getRenderId() {
        return renderId;
    }

    /**
     * 获得昵称
     *
     * @return 昵称
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * 获取音量状态
     *
     * @return 音量状态
     */
    @JCMediaChannel.VolumeStatus
    public int getVolumeStatus() {
        return volumeStatus;
    }

    /**
     * 获得是否开启了语音
     *
     * @return 是否开启了语音
     */
    public boolean isAudio() {
        return audio;
    }

    /**
     * 获得是否开启了视频
     *
     * @return 是否开启了视频
     */
    public boolean isVideo() {
        return video;
    }

    /**
     * 成员对象是否是sip用户
     *
     * @return 是否通过sip接通
     */
    public boolean isTalking() {
        return talking;
    }

    /**
     * 获得成员类型
     *
     * @return 成员类型
     */
    public int getType() {
        return type;
    }

    /**
     * 获得图像尺寸
     *
     * @return 图像尺寸
     */
    @JCMediaChannel.PictureSize
    public int getPictureSize() {
        return pictureSize;
    }

}
