package com.juphoon.cloud;

import com.justalk.cloud.lemon.MtcCallDb;
import com.justalk.cloud.lemon.MtcCallDbConstants;

import static com.justalk.cloud.lemon.MtcConstants.ZOK;

public class JCConfigImpl extends JCConfig {

    static final String TAG = JCConfigImpl.class.getSimpleName();

    class CallImpl implements Call {
        @Override
        public boolean setVideoArs(boolean enable) {
            int result;
            if (enable) {
                result = MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate(0);
            } else {
                result = MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate(500);
            }
            return result == ZOK;
        }

        @Override
        public boolean getVideoArs() {
            return MtcCallDb.Mtc_CallDbGetVideoArsFixBitrate() == 0;
        }

        @Override
        public boolean setVideoSmoothMode(boolean enable) {
            int result = enable ? MtcCallDb.Mtc_CallDbSetResolutionControlMode(MtcCallDbConstants.EN_MTC_RESCTRL_MODE_SMOOTH)
                    : MtcCallDb.Mtc_CallDbSetResolutionControlMode(MtcCallDbConstants.EN_MTC_RESCTRL_MODE_NORMAL);
            return result == ZOK;
        }

        @Override
        public boolean getVideoSmoothMode() {
            return MtcCallDb.Mtc_CallDbGetResolutionControlMode()
                    == MtcCallDbConstants.EN_MTC_RESCTRL_MODE_SMOOTH;
        }
    }

    JCConfigImpl() {
        call = new CallImpl();
    }

}
