package com.juphoon.cloud;

import com.justalk.cloud.lemon.MtcD2;

public class DoodleEngine {

    public static DoodleEngine getInstance() {
        return DoodleEngineHolder.INSTANCE;
    }

    private DoodleEngine() {
    }

    public long createAction() {
        return MtcD2.Mtc_D2CreateAction();
    }

    public int addActionPosition(long action, float x, float y, int interval) {
        return MtcD2.Mtc_D2AddActionPositionX(action, x, y, interval);
    }

    public int setActionParms(long action, String parms) {
        return MtcD2.Mtc_D2SetActionParms(action, parms);
    }

    public String printAction(long action) {
        return MtcD2.Mtc_D2PrintAction(action);
    }

    public void deleteAction(long action) {
        MtcD2.Mtc_D2DeleteAction(action);
    }

    public long parseAction(String content) {
        return MtcD2.Mtc_D2ParseAction(content);
    }

    public String getActionParms(long action) {
        return MtcD2.Mtc_D2GetActionParms(action);
    }

    public String getActionPath(long action) {
        return MtcD2.Mtc_D2GetActionPath(action);
    }

    private static final class DoodleEngineHolder {
        private static final DoodleEngine INSTANCE = new DoodleEngine();
    }
}
