/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCAccount;
import com.juphoon.cloud.JCAccountCallback;
import com.juphoon.cloud.JCAccountItem;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.MtcEngine;
import java.util.ArrayList;
import java.util.List;

public class JCAccountImpl
extends JCAccount
implements MtcEngine.MtcNotifyListener {
    private List<JCAccountCallback> mCallbacks = new ArrayList<JCAccountCallback>();

    JCAccountImpl(JCAccountCallback callback) {
        if (callback == null) {
            throw new RuntimeException("JCAccountCallback cannot be null!");
        }
        this.mCallbacks.add(callback);
        MtcEngine.getInstance().addMtcNotifyListener(this);
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        MtcEngine.getInstance().removeMtcNotifyListener(this);
    }

    @Override
    public int queryUserStatus(List<String> userIdList) {
        JCParam.queryUserStatus param = new JCParam.queryUserStatus();
        param.userIdList = userIdList;
        JCResult result = MtcEngine.getInstance().queryUserStatus(param);
        if (result.succ) {
            JCLog.info(TAG, "\u67e5\u8be2\u7528\u6237\u72b6\u6001\uff0c\u64cd\u4f5c\u53f7:%d", result.cookie);
        } else {
            JCLog.error(TAG, "\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff0c\u64cd\u4f5c\u53f7:%d", result.cookie);
            this.notifyQueryUserStatus(result.cookie, false, null);
        }
        return result.cookie;
    }

    @Override
    protected void addCallback(JCAccountCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCAccountCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type != 6) {
            return;
        }
        JCNotify.Account accountNotify = notify.accountNotify;
        if (accountNotify.type == 1) {
            ArrayList<JCAccountItem> accountItemList = new ArrayList<JCAccountItem>();
            for (JCNotify.Account.QueryUserStatusItem queryUserStatusItem : accountNotify.queryUserStatus.resultList) {
                JCAccountItem jcAccountItem = new JCAccountItem();
                jcAccountItem.userId = queryUserStatusItem.userId;
                jcAccountItem.status = this.translateFromMtcStatus(queryUserStatusItem.status);
                accountItemList.add(jcAccountItem);
            }
            this.notifyQueryUserStatus(notify.cookie, true, accountItemList);
        } else if (accountNotify.type == 2) {
            this.notifyQueryUserStatus(notify.cookie, false, null);
        }
    }

    private void notifyQueryUserStatus(final int operationId, final boolean queryResult, final List<JCAccountItem> accountItemList) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                for (JCAccountCallback callback : JCAccountImpl.this.mCallbacks) {
                    callback.onQueryUserStatusResult(operationId, queryResult, accountItemList);
                }
            }
        });
    }

    private int translateFromMtcStatus(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }
}

