/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCMessageChannelCallback;
import com.juphoon.cloud.JCMessageChannelImpl;
import com.juphoon.cloud.JCMessageChannelItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public abstract class JCMessageChannel {
    public static final int TYPE_1TO1 = 0;
    public static final int TYPE_GROUP = 1;
    public static final int REASON_NONE = 0;
    public static final int REASON_NOT_LOGIN = 1;
    public static final int REASON_TOO_LONG = 2;
    public static final int REASON_OTHER = 100;
    public static final int ITEM_STATE_INIT = 0;
    public static final int ITEM_STATE_SENDING = 1;
    public static final int ITEM_STATE_SENDOK = 2;
    public static final int ITEM_STATE_SENDFAIL = 3;
    public static final int ITEM_STATE_RECEIVED = 4;
    public static final int DIRECTION_SEND = 0;
    public static final int DIRECTION_RECEIVE = 1;
    static final String ITEM_MESSAGE_ID = "MessageId";
    static final String ITEM_FILE_URI = "FileUri";
    static final String ITEM_THUMB_DATA = "ThumbData";
    static final String ITEM_FILE_SIZE = "FileSize";
    static final String ITEM_DURATION = "Duration";
    static final String ITEM_EXTRA_DATA = "ExtraData";
    static final int ITEM_MAX_THUMB_SIZE = 6144;
    static final int ITEM_MAX_TEXT_SIZE = 10240;
    private static JCMessageChannel sMessageChannel;
    public String thumbDir;

    public static JCMessageChannel create(JCClient client, JCMessageChannelCallback callback) {
        if (sMessageChannel != null) {
            return sMessageChannel;
        }
        sMessageChannel = new JCMessageChannelImpl(client, callback);
        return sMessageChannel;
    }

    public static void destroy() {
        if (sMessageChannel != null) {
            JCClientThreadImpl.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    sMessageChannel.destroyObj();
                    sMessageChannel = null;
                }
            });
        }
    }

    protected abstract void destroyObj();

    public abstract JCMessageChannelItem sendMessage(int var1, String var2, String var3, String var4, Map<String, String> var5);

    public abstract JCMessageChannelItem sendFile(int var1, String var2, String var3, String var4, String var5, int var6, int var7, Map<String, String> var8);

    protected abstract void addCallback(JCMessageChannelCallback var1);

    protected abstract void removeCallback(JCMessageChannelCallback var1);

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ItemLimit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ItemData {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ItemDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ItemState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessageChannelReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

