/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.text.TextUtils;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCMediaChannel;
import com.juphoon.cloud.JCMediaChannelCallback;
import com.juphoon.cloud.JCMediaChannelParticipant;
import com.juphoon.cloud.JCMediaChannelQueryInfo;
import com.juphoon.cloud.JCMediaDevice;
import com.juphoon.cloud.JCMediaDeviceCallback;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.JCResult;
import com.juphoon.cloud.MtcEngine;
import com.justalk.cloud.zmf.ZmfVideo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class JCMediaChannelImpl
extends JCMediaChannel
implements MtcEngine.MtcNotifyListener,
JCClientCallback,
JCMediaDeviceCallback {
    private static final String TAG = JCMediaChannelImpl.class.getSimpleName();
    private static final int PART_UPDATE_MIN_INTERNAL = 2000;
    private static final int MIN_CAPACITY = 0;
    private static final int MAX_CAPACITY = 16;
    private static final int VOLUME_ZERO = 1;
    private static final int VOLUME_LOW = 30;
    private static final int VOLUME_MID = 60;
    private static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    private static final String MESSAGE_SENDER = "MESSAGE_SENDER";
    private static final String DEFAULT_PASSWORD = "123456";
    private JCClient mClient;
    private JCMediaDevice mMediaDevice;
    private List<JCMediaChannelCallback> mCallbacks = new ArrayList<JCMediaChannelCallback>();
    private int mConfId;
    private String mDeliveryUri;
    private List<JCMediaChannelParticipant> mParticipants = new ArrayList<JCMediaChannelParticipant>();
    private JCMediaChannelParticipant mSelfParticipant;
    private String mChannelId;
    private int mChannelNumber;
    private String mTitle;
    private int mState;
    private boolean mUploadLocalAudio;
    private boolean mUploadLocalVideo;
    private boolean mAudioOutput;
    private String mScreenRenderId;
    private String mScreenUserId;
    private int mRecordState;
    private int mCdnState;
    private String mCdnUri;
    private String mRecordParam;
    private String mCapacity = "6";
    private String mSipCallerNum = null;
    private String mSipCoreNetwork = null;
    private String mPassword = "123456";
    private boolean mNotifyVolumeChange = true;
    private Map<Integer, String> mMapQuery = new HashMap<Integer, String>();
    private Map<String, String> mMapCustomProperty = new HashMap<String, String>();

    JCMediaChannelImpl(JCClient client, JCMediaDevice mediaDevice, JCMediaChannelCallback eventHandler) {
        if (client == null) {
            throw new RuntimeException("JCMediaChannel client cannot be null!");
        }
        if (mediaDevice == null) {
            throw new RuntimeException("JCMediaChannel mediaDevice cannot be null!");
        }
        if (eventHandler == null) {
            throw new RuntimeException("JCMediaChannel eventHandler cannot be null!");
        }
        this.mCallbacks.add(eventHandler);
        this.mClient = client;
        this.mMediaDevice = mediaDevice;
        this.mClient.addCallback(this);
        this.mMediaDevice.addCallback(this);
        MtcEngine.getInstance().addMtcNotifyListener(this);
        this.mTitle = "";
        this.mUploadLocalVideo = true;
        this.mUploadLocalAudio = false;
        this.mAudioOutput = true;
    }

    @Override
    public void onCameraUpdate() {
        if (this.mState == 2 && this.mSelfParticipant != null && this.mSelfParticipant.isVideo() && this.mMediaDevice.isCameraOpen()) {
            JCParam.ConfMedia param = new JCParam.ConfMedia();
            param.type = 4;
            param.confId = this.mConfId;
            param.camera = this.mMediaDevice.getCamera();
            MtcEngine.getInstance().confMedia(param);
        }
    }

    @Override
    public void onAudioOutputTypeChange(boolean speaker) {
    }

    @Override
    public void onLogin(boolean result, int reason) {
    }

    @Override
    public void onLogout(int reason) {
        if (this.mState != 0) {
            this.notifyLeave(1);
            this.setState(0);
        }
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    @Override
    protected void destroyObj() {
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        this.mMediaDevice.removeCallback(this);
        MtcEngine.getInstance().removeMtcNotifyListener(this);
        this.mMediaDevice = null;
        this.mClient = null;
    }

    @Override
    public String getChannelId() {
        return this.mChannelId;
    }

    @Override
    public int getChannelNumber() {
        return this.mChannelNumber;
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public List<JCMediaChannelParticipant> getParticipants() {
        return this.mParticipants;
    }

    @Override
    public boolean getUploadLocalAudio() {
        return this.mUploadLocalAudio;
    }

    @Override
    public boolean getUploadLocalVideo() {
        return this.mUploadLocalVideo;
    }

    @Override
    public boolean getAudioOutput() {
        return this.mAudioOutput;
    }

    @Override
    public String getScreenRenderId() {
        return this.mScreenRenderId;
    }

    @Override
    public String getScreenUserId() {
        return this.mScreenUserId;
    }

    @Override
    public int getRecordState() {
        return this.mRecordState;
    }

    @Override
    public int getCdnState() {
        return this.mCdnState;
    }

    @Override
    public boolean setConfig(String key, String value) {
        boolean ret = true;
        if (TextUtils.equals((CharSequence)key, (CharSequence)"config_capacity")) {
            if (!TextUtils.isEmpty((CharSequence)value) && Integer.valueOf(this.mCapacity) > 0 && Integer.valueOf(this.mCapacity) < 16) {
                this.mCapacity = value;
            } else {
                ret = false;
            }
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)"config_sip_caller_number")) {
            this.mSipCallerNum = value;
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)"config_sip_core_network")) {
            this.mSipCoreNetwork = value;
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)"config_notify_volume_change")) {
            this.mNotifyVolumeChange = Integer.valueOf(value) > 0;
        } else {
            ret = false;
        }
        return ret;
    }

    @Override
    public String getConfig(String key) {
        if (TextUtils.equals((CharSequence)key, (CharSequence)"config_capacity")) {
            return this.mCapacity;
        }
        if (TextUtils.equals((CharSequence)key, (CharSequence)"config_sip_caller_number")) {
            return this.mSipCallerNum;
        }
        if (TextUtils.equals((CharSequence)key, (CharSequence)"config_sip_core_network")) {
            return this.mSipCoreNetwork;
        }
        if (TextUtils.equals((CharSequence)key, (CharSequence)"config_notify_volume_change")) {
            return this.mNotifyVolumeChange ? "1" : "0";
        }
        return null;
    }

    @Override
    public int query(String channelId) {
        JCParam.ConfQuery param = new JCParam.ConfQuery();
        param.channelId = channelId;
        JCResult result = MtcEngine.getInstance().queryConf(param);
        if (result.succ) {
            JCLog.info(TAG, "\u67e5\u8be2\u5904\u7406 \u64cd\u4f5c\u53f7:%d", result.cookie);
            this.mMapQuery.put(result.cookie, channelId);
        } else {
            JCLog.error(TAG, "\u67e5\u8be2\u8c03\u7528\u5931\u8d25", new Object[0]);
            JCMediaChannelQueryInfo queryInfo = new JCMediaChannelQueryInfo(channelId, -1, -1, null);
            this.notifyQuery(result.cookie, false, 4, queryInfo);
        }
        return result.cookie;
    }

    @Override
    public boolean join(String channelId, Map<String, String> params) {
        if (this.mClient.getState() != 3) {
            this.notifyJoin(false, 1);
        } else if (this.mState == 0) {
            int region = 0;
            int maxResolution = 0;
            boolean smoothMode = true;
            if (params != null) {
                if (params.containsKey("cdn")) {
                    this.mCdnUri = params.get("cdn");
                    JCLog.info(TAG, "param cdn=%s", this.mCdnUri);
                }
                if (params.containsKey("record")) {
                    this.mRecordParam = params.get("record");
                    JCLog.info(TAG, "param record=%s", this.mRecordParam);
                }
                if (params.containsKey("region")) {
                    region = Integer.valueOf(params.get("region"));
                    JCLog.info(TAG, "param region=%d", region);
                }
                if (params.containsKey("password")) {
                    this.mPassword = params.get("password");
                    JCLog.info(TAG, "param password set", new Object[0]);
                } else {
                    this.mPassword = DEFAULT_PASSWORD;
                }
                if (params.containsKey("maxResolution")) {
                    maxResolution = Integer.valueOf(params.get("maxResolution"));
                    JCLog.info(TAG, "param maxResolution=%d set", maxResolution);
                }
                if (params.containsKey("smoothMode")) {
                    smoothMode = Boolean.parseBoolean(params.get("smoothMode"));
                    JCLog.info(TAG, "param smoothMode= " + smoothMode, new Object[0]);
                }
            }
            JCParam.ConfJoin param = new JCParam.ConfJoin();
            param.channelId = channelId;
            param.displayName = TextUtils.isEmpty((CharSequence)this.mClient.displayName) ? this.mClient.getUserId() : this.mClient.displayName;
            param.video = true;
            param.localAudio = this.mUploadLocalAudio;
            param.localVideo = this.mUploadLocalVideo;
            param.regionId = this.translateToMtcRegion(region);
            param.capacity = Integer.valueOf(this.mCapacity);
            param.password = this.mPassword;
            param.maxResolution = maxResolution;
            param.smoothMode = smoothMode;
            if (!TextUtils.isEmpty((CharSequence)this.mCdnUri)) {
                param.webCastingUri = this.mCdnUri;
            } else if (!TextUtils.isEmpty((CharSequence)this.mRecordParam)) {
                param.webCastingUri = "http://record/";
            }
            JCResult result = MtcEngine.getInstance().joinConf(param);
            if (result.succ) {
                this.mConfId = (int)result.longValue;
                this.mChannelId = channelId;
                this.setState(1);
                JCLog.info(TAG, "join", new Object[0]);
                return true;
            }
            JCLog.error(TAG, "join \u8c03\u7528\u5931\u8d25", new Object[0]);
            this.notifyJoin(false, 4);
        } else {
            JCLog.error(TAG, "\u5df2\u6709\u4f1a\u8bae\u52a0\u5165", new Object[0]);
            this.notifyJoin(false, 5);
        }
        return false;
    }

    @Override
    public boolean leave() {
        if (this.mState == 2) {
            JCParam.ConfLeave param = new JCParam.ConfLeave();
            param.confId = this.mConfId;
            param.type = 0;
            if (MtcEngine.getInstance().leaveConf((JCParam.ConfLeave)param).succ) {
                JCLog.info(TAG, "leave \u79bb\u5f00\u4f1a\u8bae", new Object[0]);
            } else {
                JCLog.error(TAG, "leave \u8c03\u7528\u5931\u8d25", new Object[0]);
                this.notifyLeave(4);
            }
        } else {
            JCLog.error(TAG, "leave \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.mState != 0) {
            JCParam.ConfLeave param = new JCParam.ConfLeave();
            param.confId = this.mChannelNumber;
            param.type = 1;
            if (MtcEngine.getInstance().leaveConf((JCParam.ConfLeave)param).succ) {
                JCLog.info(TAG, "stop", new Object[0]);
            } else {
                JCLog.error(TAG, "stop \u8c03\u7528\u5931\u8d25", new Object[0]);
                this.notifyLeave(4);
            }
        } else {
            JCLog.error(TAG, "stop \u65e0\u4f1a\u8bae", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean enableUploadAudioStream(boolean enable) {
        if (this.mState == 2) {
            if (this.mSelfParticipant != null) {
                JCParam.ConfMedia param = new JCParam.ConfMedia();
                param.type = 0;
                param.confId = this.mConfId;
                param.on = enable;
                if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
                    this.mUploadLocalAudio = enable;
                    this.mSelfParticipant.audio = enable;
                    this.notifyMediaChannelPropertyChange();
                    JCLog.info(TAG, "enableLocalAudioStream %b", enable);
                    return true;
                }
                JCLog.error(TAG, "enableLocalAudioStream \u8c03\u7528\u5931\u8d25", new Object[0]);
            } else {
                JCLog.error(TAG, "enableLocalAudioStream \u65e0\u81ea\u8eab\u5bf9\u8c61", new Object[0]);
            }
        } else {
            JCLog.info(TAG, "enableLocalAudioStream \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
            this.mUploadLocalAudio = enable;
            return true;
        }
        return false;
    }

    @Override
    public boolean enableUploadVideoStream(boolean enable) {
        if (this.mState == 2) {
            if (this.mSelfParticipant != null) {
                JCParam.ConfMedia param = new JCParam.ConfMedia();
                param.type = 1;
                param.confId = this.mConfId;
                param.on = enable;
                if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
                    this.mUploadLocalVideo = enable;
                    this.mSelfParticipant.video = enable;
                    this.notifyMediaChannelPropertyChange();
                    JCLog.info(TAG, "enableLocalVideoStream %b", enable);
                    return true;
                }
                JCLog.error(TAG, "enableLocalVideoStream \u8c03\u7528\u5931\u8d25", new Object[0]);
            } else {
                JCLog.error(TAG, "enableLocalVideoStream \u65e0\u81ea\u8eab\u5bf9\u8c61", new Object[0]);
            }
        } else {
            JCLog.info(TAG, "enableLocalVideoStream \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
            this.mUploadLocalVideo = enable;
            return true;
        }
        return false;
    }

    @Override
    public boolean enableAudioOutput(boolean enable) {
        if (this.mState == 2) {
            if (this.mSelfParticipant != null) {
                JCParam.ConfMedia param = new JCParam.ConfMedia();
                param.type = 5;
                param.confId = this.mConfId;
                param.on = enable;
                if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
                    this.mAudioOutput = enable;
                    this.notifyMediaChannelPropertyChange();
                    JCLog.info(TAG, "enableAudioOutput", new Object[0]);
                    return true;
                }
                JCLog.error(TAG, "enableAudioOutput \u8c03\u7528\u5931\u8d25", new Object[0]);
            } else {
                JCLog.error(TAG, "enableAudioOutput \u65e0\u81ea\u8eab\u5bf9\u8c61", new Object[0]);
            }
            return false;
        }
        JCLog.info(TAG, "enableAudioOutput \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        this.mAudioOutput = enable;
        return true;
    }

    @Override
    public boolean requestVideo(JCMediaChannelParticipant participant, int pictureSize) {
        if (this.mState == 2) {
            if (participant.isVideo()) {
                JCParam.ConfMedia param = new JCParam.ConfMedia();
                param.type = 3;
                param.confId = this.mConfId;
                param.uri = participant.getRenderId();
                param.pictureSize = this.translateToMtcPictureSize(pictureSize);
                param.frameRate = 30;
                if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
                    participant.pictureSize = pictureSize;
                    this.notifyParticipantUpdate(participant);
                    JCLog.info(TAG, "requestVideo", new Object[0]);
                    return true;
                }
                JCLog.error(TAG, "requestVideo \u8c03\u7528\u5931\u8d25", new Object[0]);
            } else {
                JCLog.error(TAG, "requestVideo \u5bf9\u65b9\u672a\u5f00\u542f\u89c6\u9891", new Object[0]);
            }
        } else {
            JCLog.error(TAG, "requestVideo \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        }
        return false;
    }

    @Override
    public boolean requestScreenVideo(String screenUri, int pictureSize) {
        if (this.mState == 2) {
            JCParam.ConfMedia param = new JCParam.ConfMedia();
            param.type = 3;
            param.confId = this.mConfId;
            param.uri = screenUri;
            param.pictureSize = this.translateToMtcPictureSize(pictureSize);
            param.frameRate = 30;
            if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
                JCLog.info(TAG, "requestScreenVideo", new Object[0]);
                return true;
            }
            JCLog.error(TAG, "requestScreenVideo \u8c03\u7528\u5931\u8d25", new Object[0]);
        } else {
            JCLog.error(TAG, "requestVideo \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        }
        return false;
    }

    @Override
    public boolean enableCdn(boolean enable) {
        if (this.mCdnState == 0) {
            JCLog.error(TAG, "\u65e0\u6cd5\u4f7f\u7528Cdn\u63a8\u6d41", new Object[0]);
            return false;
        }
        if (enable && this.mCdnState == 2) {
            JCLog.error(TAG, "\u5df2\u7ecf\u5f00\u542fCdn\u63a8\u6d41", new Object[0]);
            return false;
        }
        if (!enable && this.mCdnState == 1) {
            JCLog.error(TAG, "\u5df2\u7ecf\u5173\u95edCdn\u63a8\u6d41", new Object[0]);
            return false;
        }
        JCParam.ConfMedia param = new JCParam.ConfMedia();
        param.type = 6;
        param.confId = this.mConfId;
        param.on = enable;
        if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
            JCLog.info(TAG, "enableCdn", new Object[0]);
            this.mCdnState = this.mCdnState == 1 ? 2 : 1;
            this.notifyMediaChannelPropertyChange();
            return true;
        }
        JCLog.error(TAG, "enableCdn \u8c03\u7528\u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public boolean enableRecord(boolean enable) {
        if (this.mRecordState == 0) {
            JCLog.error(TAG, "\u65e0\u6cd5\u4f7f\u7528\u89c6\u9891\u5f55\u5236", new Object[0]);
            return false;
        }
        if (enable && this.mRecordState == 2) {
            JCLog.error(TAG, "\u5df2\u7ecf\u5f00\u542f\u5c4f\u5e55\u5f55\u5236", new Object[0]);
            return false;
        }
        if (!enable && this.mRecordState == 1) {
            JCLog.error(TAG, "\u5df2\u7ecf\u5173\u95ed\u5c4f\u5e55\u5f55\u5236", new Object[0]);
            return false;
        }
        JCParam.ConfMedia param = new JCParam.ConfMedia();
        param.type = 7;
        param.confId = this.mConfId;
        param.on = enable;
        param.recordParam = this.mRecordParam;
        if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
            JCLog.info(TAG, "enableRecord", new Object[0]);
            this.mRecordState = this.mRecordState == 1 ? 2 : 1;
            this.notifyMediaChannelPropertyChange();
            return true;
        }
        JCLog.error(TAG, "enableRecord \u8c03\u7528\u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public boolean enableScreenShare(boolean enable) {
        if (this.mState != 2) {
            JCLog.error(TAG, "\u5f53\u524d\u672a\u52a0\u5165\u4f1a\u8bae", new Object[0]);
            return false;
        }
        if (enable) {
            if (!TextUtils.isEmpty((CharSequence)this.mScreenUserId)) {
                JCLog.error(TAG, "enableScreenShare \u5df2\u6709\u5c4f\u5e55\u5206\u4eab", new Object[0]);
                return false;
            }
        } else {
            if (TextUtils.isEmpty((CharSequence)this.mScreenUserId)) {
                JCLog.error(TAG, "enableScreenShare \u6ca1\u6709\u5f00\u542f\u5c4f\u5e55\u5206\u4eab", new Object[0]);
                return false;
            }
            if (!TextUtils.equals((CharSequence)this.mScreenUserId, (CharSequence)this.mClient.getUserId())) {
                JCLog.error(TAG, "\u4e0d\u80fd\u5173\u95ed\u975e\u81ea\u5df1\u7684\u5c4f\u5e55\u5171\u4eab", new Object[0]);
                return false;
            }
        }
        JCParam.ConfMedia param = new JCParam.ConfMedia();
        param.type = 8;
        param.confId = this.mConfId;
        param.on = enable;
        param.camera = ZmfVideo.CaptureScreen;
        if (MtcEngine.getInstance().confMedia((JCParam.ConfMedia)param).succ) {
            this.mMediaDevice.enableScreenCapture(enable);
            JCLog.info(TAG, "enableScreenShare " + enable, new Object[0]);
            return true;
        }
        JCLog.error(TAG, "enableScreenShare\u8c03\u7528\u5931\u8d25", new Object[0]);
        return false;
    }

    @Override
    public JCMediaChannelParticipant getParticipant(String userId) {
        for (JCMediaChannelParticipant participant : this.mParticipants) {
            if (!TextUtils.equals((CharSequence)participant.getUserId(), (CharSequence)userId)) continue;
            return participant;
        }
        return null;
    }

    @Override
    public String getStatistics() {
        if (this.mState == 2) {
            JCParam.ConfStatistics param = new JCParam.ConfStatistics();
            param.confId = this.mConfId;
            for (JCMediaChannelParticipant participant : this.mParticipants) {
                param.parts.add(participant.getUserId());
            }
            return MtcEngine.getInstance().confStatistics((JCParam.ConfStatistics)param).strValue;
        }
        JCLog.error(TAG, "getStatistics \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        return "";
    }

    @Override
    public boolean setCustomProperty(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.mMapCustomProperty.remove(key);
        } else {
            this.mMapCustomProperty.put(key, value);
        }
        JCParam.ConfCustomProperty param = new JCParam.ConfCustomProperty();
        param.confId = this.mConfId;
        param.mapCustomProperty = this.mMapCustomProperty;
        return MtcEngine.getInstance().confUpdateCustomProperty((JCParam.ConfCustomProperty)param).succ;
    }

    @Override
    public String getCustomProperty(String key) {
        return this.mMapCustomProperty.get(key);
    }

    @Override
    public boolean sendMessage(String type, String content, String toUserId) {
        if (this.mState == 2) {
            if (TextUtils.isEmpty((CharSequence)content)) {
                JCLog.error(TAG, "\u53d1\u9001\u4fe1\u606f\u5931\u8d25\uff0c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
                return false;
            }
            JCParam.ConfMessage param = new JCParam.ConfMessage();
            param.confId = this.mConfId;
            try {
                JSONObject object = new JSONObject();
                object.put(MESSAGE_TYPE, (Object)type);
                object.put(MESSAGE_SENDER, (Object)this.mClient.getUserId());
                param.type = object.toString();
                param.toUserID = toUserId;
                param.content = content;
                if (MtcEngine.getInstance().sendConfMessage((JCParam.ConfMessage)param).succ) {
                    return true;
                }
                JCLog.error(TAG, "\u53d1\u9001\u4fe1\u606f\u5931\u8d25", new Object[0]);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            JCLog.error(TAG, "sendMessage \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        }
        return false;
    }

    @Override
    public boolean sendCommand(String name, String param) {
        if (this.mState == 2) {
            JCParam.ConfCommand paramCommand = new JCParam.ConfCommand();
            paramCommand.confId = this.mConfId;
            paramCommand.name = name;
            paramCommand.param = param;
            if (MtcEngine.getInstance().confSendCmd((JCParam.ConfCommand)paramCommand).succ) {
                JCLog.info(TAG, "\u53d1\u9001\u6307\u4ee4\u6210\u529f", new Object[0]);
                return true;
            }
            JCLog.error(TAG, "\u53d1\u9001\u6307\u4ee4\u5931\u8d25", new Object[0]);
            return false;
        }
        JCLog.error(TAG, "\u672a\u5728\u4f1a\u8bae\u4e2d,\u65e0\u6cd5\u53d1\u9001\u6307\u4ee4", new Object[0]);
        return false;
    }

    @Override
    public int inviteSipUser(String userId) {
        if (this.mState == 2) {
            JCParam.ConfInviteSipUser param = new JCParam.ConfInviteSipUser();
            param.channelNumber = this.mChannelNumber;
            param.userId = userId;
            param.password = this.mPassword;
            param.callerNum = this.mSipCallerNum;
            param.coreNetId = this.mSipCoreNetwork;
            JCResult result = MtcEngine.getInstance().confInviteSipUser(param);
            if (result.succ) {
                return result.cookie;
            }
            JCLog.error(TAG, "inviteSipUser \u5931\u8d25", new Object[0]);
        } else {
            JCLog.error(TAG, "inviteSipUser \u672a\u5728\u4f1a\u8bae\u4e2d", new Object[0]);
        }
        return -1;
    }

    @Override
    public void onNotify(JCNotify notify) {
        if (notify.type == 1) {
            if (notify.confNotify.type == 1) {
                JCNotify.Conf.JoinOk joinOk = notify.confNotify.joinOk;
                this.mChannelNumber = joinOk.number;
                this.mScreenUserId = joinOk.screenUserId;
                this.mScreenRenderId = joinOk.screenRenderId;
                this.mDeliveryUri = joinOk.deliveryUri;
                this.mTitle = joinOk.title;
                for (JCNotify.Conf.Partp partp : joinOk.partps) {
                    if (TextUtils.equals((CharSequence)partp.uri, (CharSequence)this.mDeliveryUri)) {
                        JCLog.info(TAG, "\u8fc7\u6ee4delivery", new Object[0]);
                        this.dealDeliveryJoin();
                        continue;
                    }
                    JCMediaChannelParticipant participant = new JCMediaChannelParticipant();
                    participant.userId = partp.userId;
                    participant.displayName = partp.displayName;
                    participant.renderId = partp.uri;
                    participant.audio = this.hasAudioFromMtcRoleState(partp.state);
                    participant.video = this.hasVideoFromMtcRoleState(partp.state);
                    participant.talking = this.hasSipTalking(partp.state);
                    participant.type = this.translateFromMtcRole(partp.role);
                    this.mParticipants.add(participant);
                    if (TextUtils.equals((CharSequence)participant.getUserId(), (CharSequence)this.mClient.getUserId())) {
                        this.mSelfParticipant = participant;
                    }
                    this.mMapCustomProperty = joinOk.customProperty;
                }
                this.notifyJoin(true, 0);
            } else if (notify.confNotify.type == 2) {
                this.notifyJoin(false, this.translateFromMtcReason(notify.confNotify.joinFail.reason));
            } else if (notify.confNotify.type == 3) {
                this.notifyLeave(this.translateFromMtcReason(notify.confNotify.leave.reason));
            } else if (notify.confNotify.type == 15) {
                this.notifyStop(true, 0);
            } else if (notify.confNotify.type == 16) {
                this.notifyStop(false, this.translateFromMtcReason(notify.confNotify.stop.reason));
            } else if (notify.confNotify.type == 4) {
                String channelId = this.getQueryChannelId(notify.cookie);
                if (!TextUtils.isEmpty((CharSequence)channelId)) {
                    JCMediaChannelQueryInfo queryInfo = new JCMediaChannelQueryInfo(channelId, notify.confNotify.queryOk.number, notify.confNotify.queryOk.clientCount, notify.confNotify.queryOk.mMembers);
                    this.notifyQuery(notify.cookie, true, 0, queryInfo);
                }
            } else if (notify.confNotify.type == 5) {
                String channelId = this.getQueryChannelId(notify.cookie);
                if (!TextUtils.isEmpty((CharSequence)channelId)) {
                    JCMediaChannelQueryInfo queryInfo = new JCMediaChannelQueryInfo(channelId, -1, -1, null);
                    this.notifyQuery(notify.cookie, false, this.translateFromMtcReason(notify.confNotify.queryFail.reason), queryInfo);
                }
            } else if (notify.confNotify.type == 6) {
                if (notify.confNotify.addParticipant.number == this.mChannelNumber) {
                    JCNotify.Conf.Partp partp = notify.confNotify.addParticipant.partp;
                    if (TextUtils.equals((CharSequence)partp.uri, (CharSequence)this.mDeliveryUri)) {
                        JCLog.info(TAG, "\u8fc7\u6ee4delivery", new Object[0]);
                        this.dealDeliveryJoin();
                        return;
                    }
                    JCMediaChannelParticipant participant = new JCMediaChannelParticipant();
                    participant.userId = partp.userId;
                    participant.displayName = partp.displayName;
                    participant.renderId = partp.uri;
                    participant.audio = this.hasAudioFromMtcRoleState(partp.state);
                    participant.video = this.hasVideoFromMtcRoleState(partp.state);
                    participant.talking = this.hasSipTalking(partp.state);
                    participant.type = this.translateFromMtcRole(partp.role);
                    this.mParticipants.add(participant);
                    this.notifyParticipantJoin(participant);
                } else {
                    JCLog.error(TAG, "\u4f1a\u8bae\u53f7\u4e0d\u5bf9", new Object[0]);
                }
            } else if (notify.confNotify.type == 7) {
                if (notify.confNotify.removeParticipant.number == this.mChannelNumber) {
                    JCMediaChannelParticipant participant = this.getParticipant(notify.confNotify.removeParticipant.partp.userId);
                    if (participant != null) {
                        this.mParticipants.remove(participant);
                        this.notifyParticipantLeft(participant);
                    } else {
                        JCLog.error(TAG, "\u65e0\u8be5\u6210\u5458", new Object[0]);
                    }
                } else {
                    JCLog.error(TAG, "\u4f1a\u8bae\u53f7\u4e0d\u5bf9", new Object[0]);
                }
            } else if (notify.confNotify.type == 8) {
                if (notify.confNotify.participantChanged.number == this.mChannelNumber) {
                    JCNotify.Conf.ParticipantChanged partp = notify.confNotify.participantChanged;
                    JCMediaChannelParticipant participant = this.getParticipant(partp.userId);
                    if (participant != null) {
                        participant.displayName = partp.displayName;
                        participant.audio = this.hasAudioFromMtcRoleState(partp.state);
                        participant.video = this.hasVideoFromMtcRoleState(partp.state);
                        participant.talking = this.hasSipTalking(partp.state);
                        participant.type = this.translateFromMtcRole(partp.role);
                        this.notifyParticipantUpdate(participant);
                    } else {
                        JCLog.error(TAG, "\u65e0\u8be5\u6210\u5458", new Object[0]);
                    }
                } else {
                    JCLog.error(TAG, "\u4f1a\u8bae\u53f7\u4e0d\u5bf9", new Object[0]);
                }
            } else if (notify.confNotify.type == 9) {
                if (notify.confNotify.volumeChanged.number == this.mChannelNumber) {
                    JCNotify.Conf.VolumeChanged volumeChanged = notify.confNotify.volumeChanged;
                    for (String userId : volumeChanged.mapVolume.keySet()) {
                        JCMediaChannelParticipant participant = this.getParticipant(userId);
                        if (participant != null) {
                            int newStatus = this.translateFromMtcVolumeStatus(volumeChanged.mapVolume.get(userId));
                            if (participant.getVolumeStatus() == newStatus) continue;
                            participant.volumeStatus = newStatus;
                            if (!this.mNotifyVolumeChange) continue;
                            this.notifyParticipantUpdate(participant);
                            continue;
                        }
                        JCLog.error(TAG, "\u65e0\u8be5\u6210\u5458", new Object[0]);
                    }
                } else {
                    JCLog.error(TAG, "\u4f1a\u8bae\u53f7\u4e0d\u5bf9", new Object[0]);
                }
            } else if (notify.confNotify.type != 10) {
                if (notify.confNotify.type == 11) {
                    this.mScreenRenderId = notify.confNotify.propChange.screenRenderId;
                    this.mScreenUserId = notify.confNotify.propChange.screenUserId;
                    this.mTitle = notify.confNotify.propChange.title;
                    this.mMapCustomProperty = notify.confNotify.propChange.customProperty;
                    this.notifyMediaChannelPropertyChange();
                } else if (notify.confNotify.type == 12) {
                    try {
                        JSONObject object = new JSONObject(notify.confNotify.messageReceived.type);
                        String type = object.optString(MESSAGE_TYPE);
                        String sender = object.optString(MESSAGE_SENDER);
                        this.notifyMessageReceived(type, notify.confNotify.messageReceived.content, sender);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        if (!TextUtils.isEmpty((CharSequence)notify.confNotify.messageReceived.fromUserId)) {
                            this.notifyMessageReceived("text", notify.confNotify.messageReceived.content, notify.confNotify.messageReceived.fromUserId);
                        }
                    }
                } else if (notify.confNotify.type == 13) {
                    this.notifyInviteSipUserResult(notify.cookie, true, 0);
                } else if (notify.confNotify.type == 14) {
                    this.notifyInviteSipUserResult(notify.cookie, false, 100);
                }
            }
        }
    }

    @Override
    protected void addCallback(JCMediaChannelCallback eventHandler) {
        this.mCallbacks.add(eventHandler);
    }

    @Override
    protected void removeCallback(JCMediaChannelCallback eventHandler) {
        this.mCallbacks.remove(eventHandler);
    }

    private void notifyJoin(final boolean result, final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u52a0\u5165\u7ed3\u679c:%b \u539f\u56e0:%d", result, reason);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onJoin(result, reason, JCMediaChannelImpl.this.mChannelId);
                }
            }
        });
        if (result) {
            this.setState(2);
        } else {
            this.setState(0);
        }
    }

    private void notifyStop(final boolean result, final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u89e3\u6563\u7ed3\u679c:%b \u539f\u56e0:%d", result, reason);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onStop(result, reason);
                }
            }
        });
    }

    private void notifyLeave(final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u79bb\u5f00\u539f\u56e0:%d", reason);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onLeave(reason, JCMediaChannelImpl.this.mChannelId);
                }
            }
        });
        this.setState(0);
    }

    private void notifyQuery(final int operationId, final boolean result, final int reason, final JCMediaChannelQueryInfo queryInfo) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u67e5\u8be2 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", operationId, result, reason);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onQuery(operationId, result, reason, queryInfo);
                }
            }
        });
    }

    private void notifyStateChange(final int state, final int oldState) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u72b6\u6001\u53d8\u5316 %d->%d", oldState, state);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onMediaChannelStateChange(state, oldState);
                }
            }
        });
    }

    private void notifyMediaChannelPropertyChange() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u5c5e\u6027\u53d8\u5316", new Object[0]);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onMediaChannelPropertyChange();
                }
            }
        });
    }

    private void notifyParticipantJoin(final JCMediaChannelParticipant participant) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u7528\u6237\u52a0\u5165%s", participant.getUserId());
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onParticipantJoin(participant);
                }
            }
        });
    }

    private void notifyParticipantLeft(final JCMediaChannelParticipant participant) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u7528\u6237\u79bb\u5f00%s", participant.getUserId());
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onParticipantLeft(participant);
                }
            }
        });
    }

    private void notifyParticipantUpdate(final JCMediaChannelParticipant participant) {
        if (System.currentTimeMillis() - participant.lastUpdateTime > 2000L) {
            participant.lastUpdateTime = System.currentTimeMillis();
            JCClientThreadImpl.getInstance().postDelayed(new Runnable(){

                @Override
                public void run() {
                    JCLog.info(TAG, "\u7528\u6237\u66f4\u65b0%s", participant.getUserId());
                    for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                        callback.onParticipantUpdate(participant);
                    }
                }
            }, 2000L);
        }
    }

    private void notifyMessageReceived(final String type, final String content, final String fromUserId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "\u6536\u5230%s\u53d1\u9001\u7684\u4fe1\u606f \u7c7b\u578b:%s\u5185\u5bb9:%s", fromUserId, type, content);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onMessageReceive(type, content, fromUserId);
                }
            }
        });
    }

    private void notifyInviteSipUserResult(final int operationId, final boolean result, final int reason) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "sip\u9080\u8bf7 \u64cd\u4f5c\u53f7:%d \u7ed3\u679c:%b \u539f\u56e0:%d", operationId, result, reason);
                for (JCMediaChannelCallback callback : JCMediaChannelImpl.this.mCallbacks) {
                    callback.onInviteSipUserResult(operationId, result, reason);
                }
            }
        });
    }

    private void setState(int state) {
        if (this.mState != state) {
            int oldState = this.mState;
            this.mState = state;
            if (this.mState == 0) {
                this.doWhenIdle();
            } else if (this.mState == 2) {
                this.doWhenJoin();
            }
            this.notifyStateChange(this.mState, oldState);
        }
    }

    private void doWhenJoin() {
        if (this.mSelfParticipant.isVideo() && this.mSelfParticipant.isAudio()) {
            JCParam.ConfMedia param = new JCParam.ConfMedia();
            param.type = 2;
            param.confId = this.mConfId;
            param.on = true;
            MtcEngine.getInstance().confMedia(param);
        } else if (this.mSelfParticipant.isVideo()) {
            JCParam.ConfMedia param = new JCParam.ConfMedia();
            param.type = 1;
            param.confId = this.mConfId;
            param.on = true;
            MtcEngine.getInstance().confMedia(param);
        } else if (this.mSelfParticipant.isAudio()) {
            JCParam.ConfMedia param = new JCParam.ConfMedia();
            param.type = 0;
            param.confId = this.mConfId;
            param.on = true;
            MtcEngine.getInstance().confMedia(param);
        }
        this.enableAudioOutput(this.mAudioOutput);
        if (this.mMediaDevice != null) {
            this.onCameraUpdate();
            this.mMediaDevice.startAudio();
        } else {
            JCLog.error(TAG, "\u5df2\u9500\u6bc1", new Object[0]);
        }
        MtcEngine.getInstance().hasMediaChannel = true;
    }

    private void doWhenIdle() {
        this.mChannelId = "";
        this.mTitle = "";
        this.mScreenUserId = null;
        this.mScreenRenderId = null;
        this.mDeliveryUri = null;
        this.mRecordState = 0;
        this.mCdnState = 0;
        this.mCdnUri = null;
        this.mRecordParam = null;
        this.mParticipants.clear();
        if (this.mMediaDevice != null) {
            this.mMediaDevice.stopAudio();
            this.mMediaDevice.enableSpeaker(false);
        } else {
            JCLog.error(TAG, "\u5df2\u9500\u6bc1", new Object[0]);
        }
        MtcEngine.getInstance().hasMediaChannel = false;
        this.mMapCustomProperty.clear();
        this.mMapQuery.clear();
    }

    private int translateToMtcPictureSize(int pictureSize) {
        if (pictureSize == 1) {
            return 256;
        }
        if (pictureSize == 2) {
            return 512;
        }
        if (pictureSize == 3) {
            return 768;
        }
        if (pictureSize == 4) {
            return 1024;
        }
        return 0;
    }

    private void dealDeliveryJoin() {
        if (!TextUtils.isEmpty((CharSequence)this.mRecordParam)) {
            this.mRecordState = 1;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCdnUri)) {
            this.mCdnState = 1;
        }
        this.notifyMediaChannelPropertyChange();
    }

    private boolean hasAudioFromMtcRoleState(int state) {
        return (state & 8) > 0;
    }

    private boolean hasVideoFromMtcRoleState(int state) {
        return (state & 4) > 0;
    }

    private boolean hasSipTalking(int state) {
        return (state & 0x1000000) > 0;
    }

    private int translateFromMtcRole(int role) {
        if ((role & 0x400) > 0) {
            return 1;
        }
        if ((role & 0x200) > 0) {
            return 2;
        }
        return 0;
    }

    private int translateFromMtcReason(int reason) {
        switch (reason) {
            case 2001: {
                return 8;
            }
            case 2002: {
                return 6;
            }
            case 2003: {
                return 7;
            }
            case 2005: {
                return 9;
            }
            case 2103: {
                return 2;
            }
            case 2106: {
                return 10;
            }
            case 2104: {
                return 11;
            }
        }
        return 100;
    }

    private int translateFromMtcVolumeStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == 1) {
            return 1;
        }
        if (status > 1 && status <= 30) {
            return 2;
        }
        if (status > 30 && status <= 60) {
            return 3;
        }
        return 4;
    }

    private int translateToMtcRegion(int region) {
        if (region == 0) {
            return 10;
        }
        return 30;
    }

    private String getQueryChannelId(int cookie) {
        if (this.mMapQuery.containsKey(cookie)) {
            return this.mMapQuery.get(cookie);
        }
        JCLog.error(TAG, "\u627e\u4e0d\u5230\u4f1a\u8bae\u67e5\u8be2id", new Object[0]);
        return null;
    }
}

