/*
 * Decompiled with CFR 0.152.
 */
package com.juanimoli.strictmodenotifier;

import com.juanimoli.strictmodenotifier.commons.ViolationType;
import com.juanimoli.strictmodenotifier.detector.ClassInstanceLimitDetector;
import com.juanimoli.strictmodenotifier.detector.CleartextNetworkDetector;
import com.juanimoli.strictmodenotifier.detector.CustomSlowCallDetector;
import com.juanimoli.strictmodenotifier.detector.Detector;
import com.juanimoli.strictmodenotifier.detector.FileUriExposureDetector;
import com.juanimoli.strictmodenotifier.detector.LeakedClosableObjectsDetector;
import com.juanimoli.strictmodenotifier.detector.NetworkDetector;
import com.juanimoli.strictmodenotifier.detector.ResourceMismatchDetector;

public enum ViolationTypeInfo {
    CUSTOM_SLOW_CALL("Custom Slow Call", ViolationType.CUSTOM_SLOW_CALL, 11, new CustomSlowCallDetector()),
    NETWORK("Network", ViolationType.NETWORK, 9, new NetworkDetector()),
    RESOURCE_MISMATCHES("Resource Mismatches", ViolationType.RESOURCE_MISMATCHES, 23, new ResourceMismatchDetector()),
    CLASS_INSTANCE_LIMIT("Class Instance Limit", ViolationType.CLASS_INSTANCE_LIMIT, 11, new ClassInstanceLimitDetector()),
    CLEARTEXT_NETWORK("Cleartext Network", ViolationType.CLEARTEXT_NETWORK, 23, new CleartextNetworkDetector()),
    FILE_URI_EXPOSURE("File Uri Exposure", ViolationType.FILE_URI_EXPOSURE, 18, new FileUriExposureDetector()),
    LEAKED_CLOSABLE_OBJECTS("Leaked Closable Objects", ViolationType.LEAKED_CLOSABLE_OBJECTS, 11, new LeakedClosableObjectsDetector()),
    ACTIVITY_LEAKS("Activity Leaks", ViolationType.ACTIVITY_LEAKS, 11, null),
    LEAKED_REGISTRATION_OBJECTS("Leaked Registration_Objects", ViolationType.LEAKED_REGISTRATION_OBJECTS, 16, null),
    LEAKED_SQL_LITE_OBJECTS("Leaked Sql Lite Objects", ViolationType.LEAKED_SQL_LITE_OBJECTS, 9, null),
    UNKNOWN("UNKNOWN", ViolationType.UNKNOWN, 0, null);

    public final ViolationType violationType;
    public final int minSdkVersion;
    public final Detector detector;
    private String name;

    private ViolationTypeInfo(String name, ViolationType violationType, int minSdkVersion, Detector detector) {
        this.name = name;
        this.violationType = violationType;
        this.minSdkVersion = minSdkVersion;
        this.detector = detector != null ? detector : log -> false;
    }

    public static ViolationTypeInfo convert(ViolationType type) {
        for (ViolationTypeInfo info : ViolationTypeInfo.values()) {
            if (info.violationType != type) continue;
            return info;
        }
        return UNKNOWN;
    }

    public String violationName() {
        return this.name + " Violation";
    }
}

