/*
 * Decompiled with CFR 0.152.
 */
package com.juanimoli.strictmodenotifier;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;
import com.juanimoli.strictmodenotifier.R;
import com.juanimoli.strictmodenotifier.ReportActivityUtils;
import com.juanimoli.strictmodenotifier.ViolationStore;
import com.juanimoli.strictmodenotifier.ViolationTypeInfo;
import com.juanimoli.strictmodenotifier.commons.StrictModeViolation;
import java.io.Serializable;

public class StrictModeReportDetailActivity
extends Activity {
    private static final String EXTRA_REPORT = "EXTRA_REPORT";
    private ViolationStore violationStore;
    private StrictModeViolation report;

    public static void start(Context context, StrictModeViolation report) {
        context.startActivity(StrictModeReportDetailActivity.createIntent(context, report));
    }

    public static Intent createIntent(Context context, StrictModeViolation report) {
        Intent intent = new Intent(context, StrictModeReportDetailActivity.class);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.strictmode_notifier_activity_report_detail);
        this.violationStore = new ViolationStore((Context)this);
        this.report = (StrictModeViolation)this.getIntent().getSerializableExtra(EXTRA_REPORT);
        TextView stackTreace = (TextView)this.findViewById(R.id.__stacktrace_text);
        String stacktraceText = this.report.getStacktraceText();
        SpannableString span = new SpannableString((CharSequence)stacktraceText);
        this.setColor((Spannable)span, stacktraceText, this.getPackageName(), -1);
        stackTreace.setText((CharSequence)span);
        if (this.report.violationType != null) {
            ReportActivityUtils.setTitle(this, ViolationTypeInfo.convert(this.report.violationType).violationName());
            ReportActivityUtils.setDisplayHomeAsUpEnabled(this, true);
        }
        this.findViewById(R.id.__delete_button).setOnClickListener(v -> {
            this.violationStore.remove(this.report);
            this.finish();
        });
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.strictmode_notifier_menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.__menu_copy) {
            this.copy();
            return true;
        }
        if (itemId == R.id.__menu_share) {
            this.share();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @TargetApi(value=11)
    private void copy() {
        ClipData clip = ClipData.newPlainText((CharSequence)"info", (CharSequence)this.shareText());
        ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
        clipboard.setPrimaryClip(clip);
        Toast.makeText((Context)this, (int)R.string.strictmode_notifier_copyped, (int)1).show();
    }

    private void share() {
        Intent sendIntent = new Intent();
        sendIntent.setAction("android.intent.action.SEND");
        sendIntent.putExtra("android.intent.extra.TEXT", this.shareText());
        sendIntent.setType("text/plain");
        try {
            this.startActivity(Intent.createChooser((Intent)sendIntent, (CharSequence)this.getResources().getText(R.string.strictmode_notifier_menu_share)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String shareText() {
        String shareText;
        if (this.report.violationType != null) {
            shareText = ViolationTypeInfo.convert(this.report.violationType).violationName();
            shareText = shareText + "\n\n" + this.report.getStacktraceText();
        } else {
            shareText = this.report.getStacktraceText();
        }
        return shareText;
    }

    public void setColor(Spannable span, String stacktraceText, String hilight, int color) {
        int index;
        int length = hilight.length();
        int start = 0;
        while ((index = stacktraceText.indexOf(hilight, start)) >= 0) {
            span.setSpan((Object)new StyleSpan(1), index, index + length, 18);
            span.setSpan((Object)new ForegroundColorSpan(color), index, index + length, 18);
            start = index + length;
        }
    }
}

