/*
 * Decompiled with CFR 0.152.
 */
package com.juanimoli.strictmodenotifier;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ToggleButton;
import com.juanimoli.strictmodenotifier.R;
import com.juanimoli.strictmodenotifier.ReportActivityUtils;
import com.juanimoli.strictmodenotifier.ReportAdapter;
import com.juanimoli.strictmodenotifier.StrictModeReportDetailActivity;
import com.juanimoli.strictmodenotifier.StringModeConfig;
import com.juanimoli.strictmodenotifier.ViolationStore;
import com.juanimoli.strictmodenotifier.commons.StrictModeViolation;
import java.io.Serializable;
import java.util.ArrayList;

public class StrictModeReportActivity
extends Activity {
    private static final String EXTRA_REPORT = "EXTRA_REPORT";
    private ReportAdapter adapter;
    private ViolationStore violationStore;

    public static Intent createIntent(Context context, StrictModeViolation report) {
        Intent intent = new Intent(context, StrictModeReportActivity.class);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        return intent;
    }

    public static PendingIntent createPendingIntent(Context context, StrictModeViolation report) {
        Intent intent = StrictModeReportActivity.createIntent(context, report);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }

    protected void onCreate(Bundle savedInstanceState) {
        StrictModeViolation report;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.strictmode_notifier_activity_report);
        ReportActivityUtils.setTitle(this, this.getString(R.string.strictmode_notifier_title, new Object[]{this.getPackageName()}));
        this.adapter = new ReportAdapter(this);
        ListView listView = (ListView)this.findViewById(R.id.__list_view);
        listView.setAdapter((ListAdapter)this.adapter);
        this.violationStore = new ViolationStore((Context)this);
        listView.setOnItemClickListener((parent, view, position, id2) -> {
            StrictModeViolation report = this.adapter.getItem(position);
            StrictModeReportDetailActivity.start((Context)this, report);
        });
        ToggleButton toggleButton = (ToggleButton)this.findViewById(R.id.__enable_button);
        toggleButton.setChecked(StringModeConfig.from((Context)this).isEnabled());
        toggleButton.setOnCheckedChangeListener((buttonView, isChecked) -> StringModeConfig.from((Context)this).toggle());
        this.findViewById(R.id.__delete_button).setOnClickListener(v -> {
            this.violationStore.clear();
            this.adapter.clear();
            this.adapter.notifyDataSetChanged();
        });
        if (savedInstanceState == null && (report = (StrictModeViolation)this.getIntent().getSerializableExtra(EXTRA_REPORT)) != null) {
            StrictModeReportDetailActivity.start((Context)this, report);
        }
    }

    protected void onResume() {
        super.onResume();
        ArrayList<StrictModeViolation> reports = this.violationStore.getAll();
        this.adapter.clear();
        this.adapter.addAll(reports);
        this.adapter.notifyDataSetChanged();
    }
}

