/*
 * Decompiled with CFR 0.152.
 */
package com.juanimoli.strictmodenotifier;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import com.juanimoli.strictmodenotifier.LogWatchService;
import com.juanimoli.strictmodenotifier.R;
import com.juanimoli.strictmodenotifier.StrictModeNotifierSingleThreadFactory;
import com.juanimoli.strictmodenotifier.StrictModeReportActivity;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

final class StrictModeNotifierInternals {
    private static final Executor fileIoExecutor = StrictModeNotifierInternals.newSingleThreadExecutor("File-IO");
    private static final String CHANNEL_ID = "strict_mode_notifier_channel";
    private static final String CHANNEL_NAME = "Strict Mode Notifier Notification";
    private static final int NOTIFICATION_ID = 1;

    StrictModeNotifierInternals() {
    }

    public static void enableReportActivity(Context context) {
        StrictModeNotifierInternals.setEnabled(context, StrictModeReportActivity.class, true);
    }

    public static void startLogWatchService(Context context, Class<? extends LogWatchService> serviceClass) {
        Intent intent = new Intent(context, serviceClass);
        context.startService(intent);
    }

    public static void setEnabled(Context context, Class<?> componentClass, boolean enabled) {
        Context appContext = context.getApplicationContext();
        StrictModeNotifierInternals.executeOnFileIoThread(() -> StrictModeNotifierInternals.setEnabledBlocking(appContext, componentClass, enabled));
    }

    public static void setEnabledBlocking(Context appContext, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(appContext, componentClass);
        PackageManager packageManager = appContext.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    public static void executeOnFileIoThread(Runnable runnable) {
        fileIoExecutor.execute(runnable);
    }

    public static Executor newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new StrictModeNotifierSingleThreadFactory(threadName));
    }

    public static void showNotification(Context context, CharSequence contentTitle, CharSequence contentText, boolean headupEnabled, PendingIntent pendingIntent) {
        if (Build.VERSION.SDK_INT < 16) {
            StrictModeNotifierInternals.showNotificationFor11(context, contentTitle, contentText, pendingIntent);
        } else if (Build.VERSION.SDK_INT < 26) {
            StrictModeNotifierInternals.showNotificationFor16(context, contentTitle, contentText, headupEnabled, pendingIntent);
        } else {
            StrictModeNotifierInternals.showNotificationFor26(context, contentTitle, contentText, headupEnabled, pendingIntent);
        }
    }

    @TargetApi(value=11)
    private static void showNotificationFor11(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent pendingIntent) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(R.drawable.strictmode_notifier_ic_notification).setWhen(System.currentTimeMillis()).setContentTitle(contentTitle).setContentText(contentText).setAutoCancel(true).setContentIntent(pendingIntent);
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, builder.getNotification());
    }

    @TargetApi(value=16)
    private static void showNotificationFor16(Context context, CharSequence contentTitle, CharSequence contentText, boolean headupEnabled, PendingIntent pendingIntent) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(R.drawable.strictmode_notifier_ic_notification).setWhen(System.currentTimeMillis()).setContentTitle(contentTitle).setContentText(contentText).setAutoCancel(true).setContentIntent(pendingIntent);
        if (Build.VERSION.SDK_INT >= 21 && headupEnabled) {
            builder.setFullScreenIntent(pendingIntent, true);
        }
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, builder.build());
    }

    @TargetApi(value=26)
    private static void showNotificationFor26(Context context, CharSequence contentTitle, CharSequence contentText, boolean headupEnabled, PendingIntent pendingIntent) {
        NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 3);
        StrictModeNotifierInternals.getNotificationManager(context).createNotificationChannel(channel);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context.getApplicationContext(), CHANNEL_ID).setPriority(2).setContentTitle(contentTitle).setContentIntent(pendingIntent).setSmallIcon(R.drawable.strictmode_notifier_ic_notification).setContentText(contentText).setChannelId(CHANNEL_ID);
        if (headupEnabled) {
            builder = builder.setFullScreenIntent(pendingIntent, true);
        }
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, builder.build());
    }

    private static NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }
}

