/*
 * Decompiled with CFR 0.152.
 */
package com.juanimoli.strictmodenotifier;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.juanimoli.strictmodenotifier.R;
import com.juanimoli.strictmodenotifier.StrictModeReportActivity;
import com.juanimoli.strictmodenotifier.ViolationTypeInfo;
import com.juanimoli.strictmodenotifier.commons.StrictModeViolation;
import java.util.ArrayList;
import java.util.List;

class ReportAdapter
extends BaseAdapter {
    private List<StrictModeViolation> reports = new ArrayList<StrictModeViolation>();
    private StrictModeReportActivity reportActivity;

    public ReportAdapter(StrictModeReportActivity reportActivity) {
        this.reportActivity = reportActivity;
    }

    public int getCount() {
        return this.reports.size();
    }

    public StrictModeViolation getItem(int position) {
        return this.reports.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        StrictModeViolation report = this.getItem(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.reportActivity).inflate(R.layout.strictmode_notifier_row, parent, false);
            convertView.setTag((Object)new ViewHolder(convertView));
        }
        ViewHolder holder = (ViewHolder)convertView.getTag();
        holder.numberText.setText((CharSequence)parent.getContext().getString(R.string.strictmode_notifier_count, new Object[]{this.getCount() - position}));
        holder.dateText.setText((CharSequence)report.getDateText((Context)this.reportActivity));
        if (report.violationType != null) {
            holder.violationTypeText.setText((CharSequence)ViolationTypeInfo.convert(report.violationType).violationName());
        } else {
            holder.violationTypeText.setText((CharSequence)report.message);
        }
        return convertView;
    }

    public void addAll(List<StrictModeViolation> reports) {
        this.reports.addAll(reports);
    }

    public void clear() {
        this.reports.clear();
    }

    private class ViewHolder {
        final TextView numberText;
        final TextView violationTypeText;
        final TextView dateText;

        public ViewHolder(View convertView) {
            this.numberText = (TextView)convertView.findViewById(R.id.__number);
            this.violationTypeText = (TextView)convertView.findViewById(R.id.__violation_type);
            this.dateText = (TextView)convertView.findViewById(R.id.__date);
        }
    }
}

