/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRecord
implements Serializable {
    private static final int MAJOR = 1;
    private static final int MINOR = 4;
    private static long currentSequenceNumber = 0L;
    private static ThreadLocal<Integer> currentThreadId = new ThreadLocal();
    private static int initThreadId = 0;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient ResourceBundle resourceBundle;
    private transient Object[] parameters;
    private transient boolean sourceInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level level, String msg) {
        if (level == null) {
            throw new NullPointerException("level == null");
        }
        this.level = level;
        this.message = msg;
        this.millis = System.currentTimeMillis();
        Class<LogRecord> clazz = LogRecord.class;
        synchronized (LogRecord.class) {
            this.sequenceNumber = currentSequenceNumber++;
            Integer id = currentThreadId.get();
            if (id == null) {
                this.threadID = initThreadId;
                currentThreadId.set(initThreadId++);
            } else {
                this.threadID = id;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.sourceClassName = null;
            this.sourceMethodName = null;
            this.loggerName = null;
            this.parameters = null;
            this.resourceBundle = null;
            this.resourceBundleName = null;
            this.thrown = null;
            return;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level == null");
        }
        this.level = level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSourceClassName() {
        this.initSource();
        return this.sourceClassName;
    }

    private void initSource() {
        if (this.sourceInitialized) {
            return;
        }
        boolean sawLogger = false;
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            String current = element.getClassName();
            if (current.startsWith(Logger.class.getName())) {
                sawLogger = true;
                continue;
            }
            if (!sawLogger) continue;
            this.sourceClassName = element.getClassName();
            this.sourceMethodName = element.getMethodName();
            break;
        }
        this.sourceInitialized = true;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceInitialized = true;
        this.sourceClassName = sourceClassName;
    }

    public String getSourceMethodName() {
        this.initSource();
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceInitialized = true;
        this.sourceMethodName = sourceMethodName;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int threadID) {
        this.threadID = threadID;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeByte(1);
        out.writeByte(4);
        if (this.parameters == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.parameters.length);
            for (Object element : this.parameters) {
                out.writeObject(element == null ? null : element.toString());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte major = in.readByte();
        byte minor = in.readByte();
        if (major != 1) {
            throw new IOException("Different version " + major + "." + minor);
        }
        int length = in.readInt();
        if (length >= 0) {
            this.parameters = new Object[length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = in.readObject();
            }
        }
        if (this.resourceBundleName != null) {
            try {
                this.resourceBundle = Logger.loadResourceBundle(this.resourceBundleName);
            }
            catch (MissingResourceException e) {
                this.resourceBundle = null;
            }
        }
    }
}

