/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    private static final List<Level> levels = new ArrayList<Level>(9);
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient ResourceBundle rb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Level parse(String name) throws IllegalArgumentException {
        boolean isNameAnInt;
        int nameAsInt;
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        try {
            nameAsInt = Integer.parseInt(name);
            isNameAnInt = true;
        }
        catch (NumberFormatException e) {
            nameAsInt = 0;
            isNameAnInt = false;
        }
        List<Level> list = levels;
        synchronized (list) {
            for (Level level : levels) {
                if (!name.equals(level.getName())) continue;
                return level;
            }
            if (isNameAnInt) {
                for (Level level : levels) {
                    if (nameAsInt != level.intValue()) continue;
                    return level;
                }
            }
        }
        if (!isNameAnInt) {
            throw new IllegalArgumentException("Cannot parse name '" + name + "'");
        }
        return new Level(name, nameAsInt);
    }

    protected Level(String name, int level) {
        this(name, level, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String name, int level, String resourceBundleName) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.name = name;
        this.value = level;
        this.resourceBundleName = resourceBundleName;
        if (resourceBundleName != null) {
            try {
                this.rb = ResourceBundle.getBundle(resourceBundleName, Locale.getDefault());
            }
            catch (MissingResourceException e) {
                this.rb = null;
            }
        }
        List<Level> list = levels;
        synchronized (list) {
            levels.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        List<Level> list = levels;
        synchronized (list) {
            for (Level level : levels) {
                if (this.value != level.value || !this.name.equals(level.name) || !Objects.equals(this.resourceBundleName, level.resourceBundleName)) continue;
                return level;
            }
            levels.add(this);
            return this;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.resourceBundleName != null) {
            try {
                this.rb = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException e) {
                this.rb = null;
            }
        }
    }

    public String getLocalizedName() {
        if (this.rb == null) {
            return this.name;
        }
        try {
            return this.rb.getString(this.name);
        }
        catch (MissingResourceException e) {
            return this.name;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Level)) {
            return false;
        }
        return ((Level)o).intValue() == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.name;
    }
}

