/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicInteger
extends Number
implements Serializable {
    private volatile int value;

    public AtomicInteger(int initialValue) {
        this.value = initialValue;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int newValue) {
        this.value = newValue;
    }

    public final void lazySet(int newValue) {
        this.value = newValue;
    }

    public final int getAndSet(int newValue) {
        int old = this.value;
        this.value = newValue;
        return old;
    }

    private int _setAndSet(int newValue) {
        this.value = newValue;
        return this.value;
    }

    public final boolean compareAndSet(int expect, int update) {
        if (this.value == expect) {
            this.value = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(int expect, int update) {
        return this.compareAndSet(expect, update);
    }

    public final int getAndIncrement() {
        return this.getAndSet(this.value + 1);
    }

    public final int getAndDecrement() {
        return this.getAndSet(this.value - 1);
    }

    public final int getAndAdd(int delta) {
        return this.getAndSet(this.value + delta);
    }

    public final int incrementAndGet() {
        return this._setAndSet(this.value + 1);
    }

    public final int decrementAndGet() {
        return this._setAndSet(this.value - 1);
    }

    public final int addAndGet(int delta) {
        return this._setAndSet(this.value + delta);
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

