/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.jtransc.internal.JTranscExceptions;
import java.text.CharacterIterator;
import java.util.Objects;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int begin;
    private int end;
    private int pos;

    public StringCharacterIterator(String text) {
        this(text, 0);
    }

    public StringCharacterIterator(String text, int pos) {
        this(text, 0, text.length(), pos);
    }

    public StringCharacterIterator(String text, int begin, int end, int pos) {
        Objects.requireNonNull(text);
        this.text = text;
        this.begin = begin;
        this.end = end;
        this.pos = pos;
    }

    public void setText(String text) {
        Objects.requireNonNull(text);
        this.text = text;
        this.begin = 0;
        this.end = text.length();
        this.pos = 0;
    }

    @Override
    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    @Override
    public char last() {
        this.pos = this.end != this.begin ? this.end - 1 : this.end;
        return this.current();
    }

    @Override
    public char setIndex(int p) {
        if (p < this.begin || p > this.end) {
            JTranscExceptions.invalidIndex();
        }
        this.pos = p;
        return this.current();
    }

    @Override
    public char current() {
        return this.pos >= this.begin && this.pos < this.end ? this.text.charAt(this.pos) : (char)'\uffff';
    }

    @Override
    public char next() {
        if (this.pos >= this.end - 1) {
            this.pos = this.end;
            return '\uffff';
        }
        ++this.pos;
        return this.text.charAt(this.pos);
    }

    @Override
    public char previous() {
        if (this.pos <= this.begin) {
            return '\uffff';
        }
        --this.pos;
        return this.text.charAt(this.pos);
    }

    @Override
    public int getBeginIndex() {
        return this.begin;
    }

    @Override
    public int getEndIndex() {
        return this.end;
    }

    @Override
    public int getIndex() {
        return this.pos;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator l = this;
        StringCharacterIterator r = (StringCharacterIterator)that;
        return l.hashCode() == r.hashCode() && Objects.equals(l.text, r.text) && l.pos == r.pos && l.begin == r.begin && l.end == r.end;
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.pos ^ this.begin ^ this.end;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

