/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import libcore.io.Memory;

public final class Inet4Address
extends InetAddress {
    public static final InetAddress ANY = new Inet4Address(new byte[]{0, 0, 0, 0}, null);
    public static final InetAddress ALL = new Inet4Address(new byte[]{-1, -1, -1, -1}, null);
    public static final InetAddress LOOPBACK = new Inet4Address(new byte[]{127, 0, 0, 1}, "localhost");

    Inet4Address(byte[] ipaddress, String hostName) {
        super(0, ipaddress, hostName);
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0;
    }

    @Override
    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 169 && (this.ipaddress[1] & 0xFF) == 254;
    }

    @Override
    public boolean isLoopbackAddress() {
        return (this.ipaddress[0] & 0xFF) == 127;
    }

    @Override
    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        int address = Memory.peekInt(this.ipaddress, 0, ByteOrder.BIG_ENDIAN);
        if (address >>> 8 < 0xE00001) {
            return false;
        }
        return address >>> 24 <= 238;
    }

    @Override
    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 224 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0;
    }

    @Override
    public boolean isMCNodeLocal() {
        return false;
    }

    @Override
    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 239 && (this.ipaddress[1] & 0xFC) == 192;
    }

    @Override
    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 239 && (this.ipaddress[1] & 0xFF) == 255;
    }

    @Override
    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xF0) == 224;
    }

    @Override
    public boolean isSiteLocalAddress() {
        if ((this.ipaddress[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.ipaddress[0] & 0xFF) == 172 && (this.ipaddress[1] & 0xF0) == 16) {
            return true;
        }
        return (this.ipaddress[0] & 0xFF) == 192 && (this.ipaddress[1] & 0xFF) == 168;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new Inet4Address(this.ipaddress, this.hostName);
    }
}

