/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public class SoftReference<T>
extends Reference<T> {
    private long time = SoftReference.getTime();

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public SoftReference(T referent) {
        super(referent);
    }

    public SoftReference(T referent, ReferenceQueue<? super T> q) {
        super(referent, q);
    }

    @Override
    public T get() {
        Object o = super.get();
        long current = SoftReference.getTime();
        if (o != null && this.time != current) {
            this.time = current;
        }
        return o;
    }
}

